/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public class ECDHECryptography {
    protected static final Logger LOGGER = Logger.getLogger(ECDHECryptography.class.getCanonicalName());
    private static final String KEYPAIR_GENERATOR_INSTANCE = "EC";
    private static final String KEY_AGREEMENT_INSTANCE = "ECDH";
    public static final String[] NAMED_CURVE_TABLE = new String[]{null, "sect163k1", "sect163r1", "sect163r2", "sect193r1", "sect193r2", "sect233k1", "sect233r1", "sect239k1", "sect283k1", "sect283r1", "sect409k1", "sect409r1", "sect571k1", "sect571r1", "secp160k1", "secp160r1", "secp160r2", "secp192k1", "secp192r1", "secp224k1", "secp224r1", "secp256k1", "secp256r1", "secp384r1", "secp521r1"};
    private ECPrivateKey privateKey;
    private ECPublicKey publicKey;

    public ECDHECryptography(int namedCurveId) {
        try {
            String namedCurve = NAMED_CURVE_TABLE[namedCurveId];
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(KEYPAIR_GENERATOR_INSTANCE);
            ECGenParameterSpec params = new ECGenParameterSpec(namedCurve);
            kpg.initialize(params, new SecureRandom());
            KeyPair kp = kpg.generateKeyPair();
            this.privateKey = (ECPrivateKey)kp.getPrivate();
            this.publicKey = (ECPublicKey)kp.getPublic();
        }
        catch (GeneralSecurityException e) {
            LOGGER.log(Level.SEVERE, "Could not generate the ECDHE keypair.", e);
        }
    }

    public ECDHECryptography(ECParameterSpec params) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEYPAIR_GENERATOR_INSTANCE);
            keyPairGenerator.initialize(params, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.privateKey = (ECPrivateKey)keyPair.getPrivate();
            this.publicKey = (ECPublicKey)keyPair.getPublic();
        }
        catch (GeneralSecurityException e) {
            LOGGER.log(Level.SEVERE, "Could not generate the ECDHE keypair.", e);
        }
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(ECPrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(ECPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public SecretKey getSecret(byte[] encodedPoint) {
        SecretKey secretKey = null;
        try {
            ECParameterSpec params = this.publicKey.getParams();
            ECPoint point = ECDHECryptography.decodePoint(encodedPoint, params.getCurve());
            KeyFactory keyFactory = KeyFactory.getInstance(KEYPAIR_GENERATOR_INSTANCE);
            ECPublicKeySpec keySpec = new ECPublicKeySpec(point, params);
            PublicKey peerPublicKey = keyFactory.generatePublic(keySpec);
            secretKey = this.getSecret(peerPublicKey);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not generate the premaster secret.", e);
        }
        return secretKey;
    }

    public SecretKey getSecret(PublicKey peerPublicKey) {
        SecretKey secretKey = null;
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance(KEY_AGREEMENT_INSTANCE);
            keyAgreement.init(this.privateKey);
            keyAgreement.doPhase(peerPublicKey, true);
            secretKey = keyAgreement.generateSecret("TlsPremasterSecret");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not generate the premaster secret.", e);
        }
        return secretKey;
    }

    public static ECPoint decodePoint(byte[] encoded, EllipticCurve curve) {
        if (encoded.length == 0 || encoded[0] != 4) {
            LOGGER.severe("Only uncompressed point format supported.");
            return null;
        }
        int fieldSize = (curve.getField().getFieldSize() + 7) / 8;
        if (encoded.length != fieldSize * 2 + 1) {
            LOGGER.severe("Point does not match field size.");
            return null;
        }
        byte[] xb = new byte[fieldSize];
        byte[] yb = new byte[fieldSize];
        System.arraycopy(encoded, 1, xb, 0, fieldSize);
        System.arraycopy(encoded, fieldSize + 1, yb, 0, fieldSize);
        return new ECPoint(new BigInteger(1, xb), new BigInteger(1, yb));
    }

    public static byte[] encodePoint(ECPoint point, EllipticCurve curve) {
        int fieldSize = (curve.getField().getFieldSize() + 7) / 8;
        byte[] xb = ByteArrayUtils.trimZeroes(point.getAffineX().toByteArray());
        byte[] yb = ByteArrayUtils.trimZeroes(point.getAffineY().toByteArray());
        if (xb.length > fieldSize || yb.length > fieldSize) {
            LOGGER.severe("Point coordinates do not match field size.");
            return null;
        }
        byte[] encoded = new byte[1 + fieldSize * 2];
        encoded[0] = 4;
        System.arraycopy(xb, 0, encoded, fieldSize - xb.length + 1, xb.length);
        System.arraycopy(yb, 0, encoded, encoded.length - yb.length, yb.length);
        return encoded;
    }
}

