/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.util.ByteArrayUtils;
import org.eclipse.californium.scandium.util.DatagramWriter;

public final class CCMBlockCipher {
    private static final Logger LOGGER = Logger.getLogger(CCMBlockCipher.class.getCanonicalName());
    private static final int BLOCK_SIZE = 16;
    private static final String BLOCK_CIPHER = "AES";

    public static byte[] decrypt(byte[] key, byte[] nonce, byte[] a, byte[] c, int numAuthenticationBytes) throws HandshakeException {
        byte[] mac;
        byte[] T;
        byte[] m;
        try {
            long lengthM = c.length - numAuthenticationBytes;
            Cipher cipher = Cipher.getInstance(BLOCK_CIPHER);
            cipher.init(1, new SecretKeySpec(key, BLOCK_CIPHER));
            List<byte[]> S_i = CCMBlockCipher.generateKeyStreamBlocks(lengthM, nonce, cipher);
            byte[] S_0 = S_i.get(0);
            byte[] concatenatedS_i = CCMBlockCipher.generateConcatenatedKeyStream(S_i, lengthM);
            byte[] encryptedM = ByteArrayUtils.truncate(c, (int)lengthM);
            m = ByteArrayUtils.xorArrays(encryptedM, concatenatedS_i);
            byte[] encryptedT = new byte[numAuthenticationBytes];
            System.arraycopy(c, (int)lengthM, encryptedT, 0, numAuthenticationBytes);
            T = ByteArrayUtils.xorArrays(encryptedT, ByteArrayUtils.truncate(S_0, numAuthenticationBytes));
            mac = CCMBlockCipher.computeCbcMac(nonce, m, a, cipher, numAuthenticationBytes);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not decrypt the message.", e);
            return new byte[0];
        }
        if (Arrays.equals(T, mac)) {
            return m;
        }
        String message = "The encrypted message could not be authenticated:\nExpected: " + ByteArrayUtils.toHexString(T) + "\nActual:   " + ByteArrayUtils.toHexString(mac);
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_RECORD_MAC);
        throw new HandshakeException(message, alert);
    }

    public static byte[] encrypt(byte[] key, byte[] nonce, byte[] a, byte[] m, int numAuthenticationBytes) {
        try {
            long lengthM = m.length;
            Cipher cipher = Cipher.getInstance(BLOCK_CIPHER);
            cipher.init(1, new SecretKeySpec(key, BLOCK_CIPHER));
            byte[] T = CCMBlockCipher.computeCbcMac(nonce, m, a, cipher, numAuthenticationBytes);
            List<byte[]> S_i = CCMBlockCipher.generateKeyStreamBlocks(lengthM, nonce, cipher);
            byte[] S_0 = S_i.get(0);
            byte[] concatenatedS_i = CCMBlockCipher.generateConcatenatedKeyStream(S_i, lengthM);
            byte[] encryptedMessage = ByteArrayUtils.xorArrays(m, concatenatedS_i);
            byte[] U = ByteArrayUtils.xorArrays(T, ByteArrayUtils.truncate(S_0, numAuthenticationBytes));
            byte[] c = ByteArrayUtils.concatenate(encryptedMessage, U);
            return c;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not encrypt the message.", e);
            return new byte[0];
        }
    }

    private static byte[] computeCbcMac(byte[] nonce, byte[] m, byte[] a, Cipher cipher, int authenticationBytes) throws Exception {
        long lengthM = m.length;
        long lengthA = a.length;
        int L = 15 - nonce.length;
        byte[] b0 = new byte[16];
        int adata = 0;
        if (lengthA > 0L) {
            adata = 1;
        }
        int mPrime = (authenticationBytes - 2) / 2;
        int lPrime = L - 1;
        b0[0] = (byte)(64 * adata + 8 * mPrime + lPrime);
        System.arraycopy(nonce, 0, b0, 1, nonce.length);
        b0[14] = (byte)(lengthM >> 8);
        b0[15] = (byte)lengthM;
        ArrayList<byte[]> blocks = new ArrayList<byte[]>();
        if (lengthA > 0L) {
            int field;
            int first = 65280;
            long second = 0x100000000L;
            DatagramWriter writer = new DatagramWriter();
            if (lengthA > 0L && lengthA < 65280L) {
                writer.writeLong(lengthA, 16);
            } else if (lengthA >= 65280L && lengthA < 0x100000000L) {
                field = 65534;
                writer.write(field, 16);
                writer.writeLong(lengthA, 32);
            } else {
                field = 65535;
                writer.write(field, 16);
                writer.writeLong(lengthA, 64);
            }
            writer.writeBytes(a);
            byte[] aEncoded = writer.toByteArray();
            blocks.addAll(ByteArrayUtils.splitAndPad(aEncoded, 16));
        }
        blocks.addAll(ByteArrayUtils.splitAndPad(m, 16));
        byte[] X_i = ByteArrayUtils.truncate(cipher.doFinal(b0), 16);
        for (byte[] block : blocks) {
            byte[] xor = ByteArrayUtils.xorArrays(block, X_i);
            X_i = ByteArrayUtils.truncate(cipher.doFinal(xor), 16);
        }
        byte[] T = ByteArrayUtils.truncate(X_i, authenticationBytes);
        return T;
    }

    private static List<byte[]> generateKeyStreamBlocks(long lengthM, byte[] nonce, Cipher cipher) throws Exception {
        int L = 15 - nonce.length;
        ArrayList<byte[]> S_i = new ArrayList<byte[]>();
        int numRounds = (int)(Math.ceil((double)lengthM / 16.0) + 1.0);
        for (int i = 0; i < numRounds; ++i) {
            DatagramWriter writer = new DatagramWriter();
            int flag = L - 1;
            writer.write(flag, 8);
            writer.writeBytes(nonce);
            writer.writeLong(i, L * 8);
            byte[] S = writer.toByteArray();
            S_i.add(ByteArrayUtils.truncate(cipher.doFinal(S), 16));
        }
        return S_i;
    }

    private static byte[] generateConcatenatedKeyStream(List<byte[]> S_i, long lengthM) {
        byte[] concatenatedS_i = new byte[]{};
        int numRounds = (int)Math.ceil((double)lengthM / 16.0);
        for (int i = 1; i <= numRounds; ++i) {
            concatenatedS_i = ByteArrayUtils.concatenate(concatenatedS_i, S_i.get(i));
        }
        return concatenatedS_i;
    }
}

