/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.List;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.ByteArrayUtils;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class ServerHello
extends HandshakeMessage {
    private static final int VERSION_BITS = 8;
    private static final int RANDOM_BYTES = 32;
    private static final int SESSION_ID_LENGTH_BITS = 8;
    private static final int CIPHER_SUITE_BITS = 16;
    private static final int COMPRESSION_METHOD_BITS = 8;
    private ProtocolVersion serverVersion;
    private Random random;
    private SessionId sessionId;
    private CipherSuite cipherSuite;
    private CompressionMethod compressionMethod;
    private HelloExtensions extensions = null;

    public ServerHello(ProtocolVersion version, Random random, SessionId sessionId, CipherSuite cipherSuite, CompressionMethod compressionMethod, HelloExtensions extensions) {
        this.serverVersion = version;
        this.random = random;
        this.sessionId = sessionId;
        this.cipherSuite = cipherSuite;
        this.compressionMethod = compressionMethod;
        this.extensions = extensions;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.serverVersion.getMajor(), 8);
        writer.write(this.serverVersion.getMinor(), 8);
        writer.writeBytes(this.random.getRandomBytes());
        writer.write(this.sessionId.length(), 8);
        writer.writeBytes(this.sessionId.getSessionId());
        writer.write(this.cipherSuite.getCode(), 16);
        writer.write(this.compressionMethod.getCode(), 8);
        if (this.extensions != null) {
            writer.writeBytes(this.extensions.toByteArray());
        }
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray) throws HandshakeException {
        DatagramReader reader = new DatagramReader(byteArray);
        int major = reader.read(8);
        int minor = reader.read(8);
        ProtocolVersion version = new ProtocolVersion(major, minor);
        Random random = new Random(reader.readBytes(32));
        int sessionIdLength = reader.read(8);
        SessionId sessionId = new SessionId(reader.readBytes(sessionIdLength));
        CipherSuite cipherSuite = CipherSuite.getTypeByCode(reader.read(16));
        CompressionMethod compressionMethod = CompressionMethod.getMethodByCode(reader.read(8));
        byte[] bytesLeft = reader.readBytesLeft();
        HelloExtensions extensions = null;
        if (bytesLeft.length > 0) {
            extensions = HelloExtensions.fromByteArray(bytesLeft);
        }
        return new ServerHello(version, random, sessionId, cipherSuite, compressionMethod, extensions);
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.SERVER_HELLO;
    }

    @Override
    public int getMessageLength() {
        int extensionsLength = this.extensions != null ? 2 + this.extensions.getLength() : 0;
        return 38 + this.sessionId.length() + extensionsLength;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(ProtocolVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(SessionId sessionId) {
        this.sessionId = sessionId;
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public void setCipherSuite(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(CompressionMethod compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public HelloExtensions getExtensions() {
        return this.extensions;
    }

    public void setExtensions(HelloExtensions extensions) {
        this.extensions = extensions;
    }

    public ClientCertificateTypeExtension getClientCertificateTypeExtension() {
        if (this.extensions != null) {
            List<HelloExtension> exts = this.extensions.getExtensions();
            for (HelloExtension helloExtension : exts) {
                if (!(helloExtension instanceof ClientCertificateTypeExtension)) continue;
                return (ClientCertificateTypeExtension)helloExtension;
            }
        }
        return null;
    }

    public ServerCertificateTypeExtension getServerCertificateTypeExtension() {
        if (this.extensions != null) {
            List<HelloExtension> exts = this.extensions.getExtensions();
            for (HelloExtension helloExtension : exts) {
                if (!(helloExtension instanceof ServerCertificateTypeExtension)) continue;
                return (ServerCertificateTypeExtension)helloExtension;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\tServer Version: " + this.serverVersion.getMajor() + ", " + this.serverVersion.getMinor() + "\n");
        sb.append("\t\tRandom: \n" + this.random.toString());
        sb.append("\t\tSession ID Length: " + this.sessionId.length() + "\n");
        if (this.sessionId.length() > 0) {
            sb.append("\t\tSession ID: " + ByteArrayUtils.toHexString(this.sessionId.getSessionId()) + "\n");
        }
        sb.append("\t\tCipher Suite: " + this.cipherSuite.toString() + "\n");
        sb.append("\t\tCompression Method: " + this.compressionMethod.toString() + "\n");
        if (this.extensions != null) {
            sb.append(this.extensions.toString());
        }
        return sb.toString();
    }
}

