/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.californium.scandium.DTLSConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.Cookie;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.FragmentedHandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.HelloRequest;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.NULLClientKeyExchange;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ByteArrayUtils;

public class ServerHandshaker
extends Handshaker {
    private boolean clientAuthenticationRequired = false;
    private PublicKey clientPublicKey;
    private List<CipherSuite> supportedCipherSuites = new ArrayList<CipherSuite>();
    protected CertificateMessage clientCertificate = null;
    protected ClientKeyExchange clientKeyExchange;
    protected CertificateVerify certificateVerify = null;
    protected final PskStore pskStore;

    public ServerHandshaker(InetSocketAddress endpointAddress, DTLSSession session, Certificate[] rootCerts, DTLSConnectorConfig config) {
        super(endpointAddress, false, session, rootCerts);
        this.supportedCipherSuites.add(CipherSuite.SSL_NULL_WITH_NULL_NULL);
        this.supportedCipherSuites.add(CipherSuite.TLS_PSK_WITH_AES_128_CCM_8);
        this.supportedCipherSuites.add(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8);
        this.pskStore = config.pskStore;
        this.privateKey = config.privateKey;
        this.certificates = config.certChain;
        this.clientAuthenticationRequired = config.requireClientAuth;
    }

    @Override
    public synchronized DTLSFlight processMessage(Record record) throws HandshakeException {
        if (this.lastFlight != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Received client's (" + this.endpointAddress.toString() + ") finished message again, retransmit the last flight.");
            }
            return this.lastFlight;
        }
        DTLSFlight flight = null;
        if (!this.processMessageNext(record)) {
            return flight;
        }
        block0 : switch (record.getType()) {
            case CHANGE_CIPHER_SPEC: {
                record.getFragment();
                this.setCurrentReadState();
                this.session.incrementReadEpoch();
                break;
            }
            case HANDSHAKE: {
                HandshakeMessage fragment = (HandshakeMessage)record.getFragment();
                if (fragment instanceof FragmentedHandshakeMessage) {
                    if ((fragment = this.handleFragmentation((FragmentedHandshakeMessage)fragment)) == null) break;
                    record.setFragment(fragment);
                }
                switch (fragment.getMessageType()) {
                    case CLIENT_HELLO: {
                        flight = this.receivedClientHello((ClientHello)fragment);
                        break block0;
                    }
                    case CERTIFICATE: {
                        this.receivedClientCertificate((CertificateMessage)fragment);
                        break block0;
                    }
                    case CLIENT_KEY_EXCHANGE: {
                        switch (this.keyExchange) {
                            case PSK: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((PSKClientKeyExchange)fragment);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            case EC_DIFFIE_HELLMAN: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((ECDHClientKeyExchange)fragment);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            case NULL: {
                                byte[] premasterSecret = this.receivedClientKeyExchange((NULLClientKeyExchange)fragment);
                                this.generateKeys(premasterSecret);
                                break;
                            }
                            default: {
                                AlertMessage alertMessage = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
                                throw new HandshakeException("Unknown key exchange algorithm: " + (Object)((Object)this.keyExchange), alertMessage);
                            }
                        }
                        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.clientKeyExchange.getRawMessage());
                        break block0;
                    }
                    case CERTIFICATE_VERIFY: {
                        this.receivedCertificateVerify((CertificateVerify)fragment);
                        break block0;
                    }
                    case FINISHED: {
                        flight = this.receivedClientFinished((Finished)fragment);
                        break block0;
                    }
                }
                AlertMessage alertMessage = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE);
                throw new HandshakeException("Server received unexpected handshake message:\n" + fragment.toString(), alertMessage);
            }
            default: {
                AlertMessage alertMessage = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
                throw new HandshakeException("Server received not supported record:\n" + record.toString(), alertMessage);
            }
        }
        if (flight == null) {
            Record nextMessage = null;
            for (Record queuedMessage : this.queuedMessages) {
                if (!this.processMessageNext(queuedMessage)) continue;
                nextMessage = queuedMessage;
                break;
            }
            if (nextMessage != null) {
                flight = this.processMessage(nextMessage);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("DTLS Message processed (" + this.endpointAddress.toString() + "):\n" + record.toString());
        }
        return flight;
    }

    private void receivedClientCertificate(CertificateMessage message) throws HandshakeException {
        if (this.clientCertificate != null && this.clientCertificate.getMessageSeq() == message.getMessageSeq()) {
            return;
        }
        this.clientCertificate = message;
        this.clientCertificate.verifyCertificate(this.rootCertificates);
        this.clientPublicKey = this.clientCertificate.getPublicKey();
        this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, this.clientCertificate.getRawMessage());
    }

    private void receivedCertificateVerify(CertificateVerify message) throws HandshakeException {
        this.certificateVerify = message;
        message.verifySignature(this.clientPublicKey, this.handshakeMessages);
    }

    private DTLSFlight receivedClientFinished(Finished message) throws HandshakeException {
        if (this.lastFlight != null) {
            return null;
        }
        if (this.keyExchange == CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN && this.clientAuthenticationRequired && (this.clientCertificate == null || this.certificateVerify == null)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
            throw new HandshakeException("Client did not send required authentication messages.", alert);
        }
        DTLSFlight flight = new DTLSFlight();
        if (this.clientCertificate != null) {
            this.md.update(this.clientCertificate.getRawMessage());
        }
        this.md.update(this.clientKeyExchange.getRawMessage());
        if (this.certificateVerify != null) {
            this.md.update(this.certificateVerify.getRawMessage());
        }
        MessageDigest mdWithClientFinished = null;
        try {
            mdWithClientFinished = (MessageDigest)this.md.clone();
            mdWithClientFinished.update(message.toByteArray());
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.SEVERE, "Cannot compute digest for server's Finish handshake message", e);
        }
        byte[] handshakeHash = this.md.digest();
        message.verifyData(this.getMasterSecret(), true, handshakeHash);
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage();
        flight.addMessage(this.wrapMessage(changeCipherSpecMessage));
        this.setCurrentWriteState();
        this.session.incrementWriteEpoch();
        handshakeHash = mdWithClientFinished.digest();
        Finished finished = new Finished(this.getMasterSecret(), this.isClient, handshakeHash);
        flight.addMessage(this.wrapMessage(finished));
        this.state = HandshakeType.FINISHED.getCode();
        this.session.setActive(true);
        flight.setRetransmissionNeeded(false);
        this.lastFlight = flight;
        return flight;
    }

    private DTLSFlight receivedClientHello(ClientHello message) throws HandshakeException {
        DTLSFlight flight = new DTLSFlight();
        if (message.getCookie().length() > 0 && this.isValidCookie(message)) {
            ServerCertificateTypeExtension serverCertificateTypeExtension;
            this.md.update(message.getRawMessage());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, message.getRawMessage());
            ProtocolVersion serverVersion = this.negotiateProtocolVersion(message.getClientVersion());
            this.clientRandom = message.getRandom();
            this.serverRandom = new Random(new SecureRandom());
            SessionId sessionId = new SessionId();
            this.session.setSessionIdentifier(sessionId);
            CipherSuite cipherSuite = this.negotiateCipherSuite(message.getCipherSuites());
            this.setCipherSuite(cipherSuite);
            CompressionMethod compressionMethod = CompressionMethod.NULL;
            this.setCompressionMethod(compressionMethod);
            HelloExtensions extensions = null;
            ClientCertificateTypeExtension clientCertificateTypeExtension = message.getClientCertificateTypeExtension();
            if (clientCertificateTypeExtension != null) {
                CertificateTypeExtension.CertificateType certType = this.negotiateCertificateType(clientCertificateTypeExtension);
                extensions = new HelloExtensions();
                ClientCertificateTypeExtension ext1 = new ClientCertificateTypeExtension(false);
                ext1.addCertificateType(certType);
                extensions.addExtension(ext1);
                if (certType == CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY) {
                    this.session.setReceiveRawPublicKey(true);
                }
            }
            if ((serverCertificateTypeExtension = message.getServerCertificateTypeExtension()) != null) {
                CertificateTypeExtension.CertificateType certType = this.negotiateCertificateType(serverCertificateTypeExtension);
                if (extensions == null) {
                    extensions = new HelloExtensions();
                }
                ServerCertificateTypeExtension ext2 = new ServerCertificateTypeExtension(false);
                ext2.addCertificateType(certType);
                extensions.addExtension(ext2);
                if (certType == CertificateTypeExtension.CertificateType.RAW_PUBLIC_KEY) {
                    this.session.setSendRawPublicKey(true);
                }
            }
            if (this.keyExchange == CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN) {
                List<SupportedPointFormatsExtension.ECPointFormat> formats = Arrays.asList(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED);
                if (extensions == null) {
                    extensions = new HelloExtensions();
                }
                SupportedPointFormatsExtension ext3 = new SupportedPointFormatsExtension(formats);
                extensions.addExtension(ext3);
            }
            ServerHello serverHello = new ServerHello(serverVersion, this.serverRandom, sessionId, cipherSuite, compressionMethod, extensions);
            flight.addMessage(this.wrapMessage(serverHello));
            this.md.update(serverHello.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, serverHello.toByteArray());
            CertificateMessage certificateMessage = null;
            switch (this.keyExchange) {
                case EC_DIFFIE_HELLMAN: {
                    certificateMessage = new CertificateMessage(this.certificates, this.session.sendRawPublicKey());
                    break;
                }
            }
            if (certificateMessage != null) {
                flight.addMessage(this.wrapMessage(certificateMessage));
                this.md.update(certificateMessage.toByteArray());
                this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, certificateMessage.toByteArray());
            }
            HandshakeMessage serverKeyExchange = null;
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
            switch (this.keyExchange) {
                case EC_DIFFIE_HELLMAN: {
                    signatureAndHashAlgorithm = new SignatureAndHashAlgorithm(CertificateRequest.HashAlgorithm.SHA256, CertificateRequest.SignatureAlgorithm.ECDSA);
                    int namedCurveId = this.negotiateNamedCurve(message.getSupportedEllipticCurvesExtension());
                    this.ecdhe = new ECDHECryptography(namedCurveId);
                    serverKeyExchange = new ECDHServerKeyExchange(signatureAndHashAlgorithm, this.ecdhe, this.privateKey, this.clientRandom, this.serverRandom, namedCurveId);
                    break;
                }
                case PSK: {
                    break;
                }
            }
            if (serverKeyExchange != null) {
                flight.addMessage(this.wrapMessage(serverKeyExchange));
                this.md.update(serverKeyExchange.toByteArray());
                this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, serverKeyExchange.toByteArray());
            }
            if (this.clientAuthenticationRequired && signatureAndHashAlgorithm != null) {
                CertificateRequest certificateRequest = new CertificateRequest();
                certificateRequest.addCertificateType(CertificateRequest.ClientCertificateType.ECDSA_SIGN);
                certificateRequest.addSignatureAlgorithm(new SignatureAndHashAlgorithm(signatureAndHashAlgorithm.getHash(), signatureAndHashAlgorithm.getSignature()));
                certificateRequest.addCertificateAuthorities(this.rootCertificates);
                flight.addMessage(this.wrapMessage(certificateRequest));
                this.md.update(certificateRequest.toByteArray());
                this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, certificateRequest.toByteArray());
            }
            ServerHelloDone serverHelloDone = new ServerHelloDone();
            flight.addMessage(this.wrapMessage(serverHelloDone));
            this.md.update(serverHelloDone.toByteArray());
            this.handshakeMessages = ByteArrayUtils.concatenate(this.handshakeMessages, serverHelloDone.toByteArray());
        } else {
            HelloVerifyRequest helloVerifyRequest = new HelloVerifyRequest(new ProtocolVersion(), this.generateCookie(message));
            flight.addMessage(this.wrapMessage(helloVerifyRequest));
            flight.setRetransmissionNeeded(false);
        }
        return flight;
    }

    private byte[] receivedClientKeyExchange(ECDHClientKeyExchange message) {
        this.clientKeyExchange = message;
        byte[] premasterSecret = this.ecdhe.getSecret(message.getEncodedPoint()).getEncoded();
        return premasterSecret;
    }

    private byte[] receivedClientKeyExchange(PSKClientKeyExchange message) throws HandshakeException {
        this.clientKeyExchange = message;
        String identity = message.getIdentity();
        this.session.setPskIdentity(identity);
        byte[] psk = this.pskStore.getKey(identity);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Client " + this.endpointAddress.toString() + " used PSK identity: " + identity);
        }
        if (psk == null) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
            throw new HandshakeException("No preshared secret found for identity: " + identity, alert);
        }
        return this.generatePremasterSecretFromPSK(psk);
    }

    private byte[] receivedClientKeyExchange(NULLClientKeyExchange message) {
        this.clientKeyExchange = message;
        return new byte[0];
    }

    private Cookie generateCookie(ClientHello clientHello) {
        byte[] cookie = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] secret = "generate cookie".getBytes();
            md.update(this.endpointAddress.toString().getBytes());
            md.update((byte)clientHello.getClientVersion().getMajor());
            md.update((byte)clientHello.getClientVersion().getMinor());
            md.update(clientHello.getRandom().getRandomBytes());
            md.update(clientHello.getSessionId().getSessionId());
            md.update(CipherSuite.listToByteArray(clientHello.getCipherSuites()));
            md.update(CompressionMethod.listToByteArray(clientHello.getCompressionMethods()));
            byte[] data = md.digest();
            cookie = Handshaker.doHMAC(md, secret, data);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, "Could not instantiate message digest algorithm.", e);
        }
        if (cookie == null) {
            return new Cookie(new Random(new SecureRandom()).getRandomBytes());
        }
        return new Cookie(cookie);
    }

    private boolean isValidCookie(ClientHello clientHello) {
        Cookie expected = this.generateCookie(clientHello);
        Cookie actual = clientHello.getCookie();
        boolean valid = Arrays.equals(expected.getCookie(), actual.getCookie());
        if (!valid && LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Client's (" + this.endpointAddress.toString() + ") cookie did not match expected cookie:\n" + "Expected: " + ByteArrayUtils.toHexString(expected.getCookie()) + "\n" + "Actual: " + ByteArrayUtils.toHexString(actual.getCookie()));
        }
        return valid;
    }

    @Override
    public DTLSFlight getStartHandshakeMessage() {
        HelloRequest helloRequest = new HelloRequest();
        DTLSFlight flight = new DTLSFlight();
        flight.addMessage(this.wrapMessage(helloRequest));
        return flight;
    }

    private ProtocolVersion negotiateProtocolVersion(ProtocolVersion clientVersion) throws HandshakeException {
        ProtocolVersion version = new ProtocolVersion();
        if (clientVersion.compareTo(version) >= 0) {
            return new ProtocolVersion();
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.PROTOCOL_VERSION);
        throw new HandshakeException("The server only supports DTLS v1.2", alert);
    }

    private CipherSuite negotiateCipherSuite(List<CipherSuite> cipherSuites) throws HandshakeException {
        for (CipherSuite cipherSuite : cipherSuites) {
            if (!this.supportedCipherSuites.contains((Object)cipherSuite) || cipherSuite == CipherSuite.SSL_NULL_WITH_NULL_NULL) continue;
            return cipherSuite;
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
        throw new HandshakeException("No supported cipher suite proposed by the client", alert);
    }

    private int negotiateNamedCurve(SupportedEllipticCurvesExtension extension) throws HandshakeException {
        if (extension != null) {
            for (Integer curveID : extension.getEllipticCurveList()) {
                if (ECDHServerKeyExchange.NAMED_CURVE_PARAMETERS.get(curveID) == null) continue;
                return curveID;
            }
        } else {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
            throw new HandshakeException("The client did not provide the supported elliptic curves extension although ECC cipher suite chosen.", alert);
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
        throw new HandshakeException("No proposed elliptic curve supported.", alert);
    }

    private CertificateTypeExtension.CertificateType negotiateCertificateType(CertificateTypeExtension extension) {
        CertificateTypeExtension.CertificateType certType = CertificateTypeExtension.CertificateType.X_509;
        Iterator<CertificateTypeExtension.CertificateType> iterator = extension.getCertificateTypes().iterator();
        if (iterator.hasNext()) {
            CertificateTypeExtension.CertificateType type = iterator.next();
            return type;
        }
        return certType;
    }
}

