/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.util.ByteArrayUtils;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class RawPublicKey {
    private static final Logger LOGGER = Logger.getLogger(RawPublicKey.class.getCanonicalName());
    private static final int BIT_STRING_TAG = 3;
    private static final int NULL_TAG = 5;
    private static final int OBJECT_IDENTIFIER_TAG = 6;
    private static final int SEQUENCE_TAG = 48;
    private static final int OCTET_BITS = 8;
    private int[] algorithmOID;
    private int[] parametersOID;
    private byte[] subjectPublicKey;

    public RawPublicKey() {
        this.subjectPublicKey = null;
        this.algorithmOID = null;
        this.parametersOID = null;
    }

    public RawPublicKey(byte[] subjectPublicKey, int[] algorithmOID, int[] parametersOID) {
        this.subjectPublicKey = subjectPublicKey;
        this.algorithmOID = algorithmOID;
        this.parametersOID = parametersOID;
    }

    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter();
        byte[] algorithmBytes = this.writeTLV(6, RawPublicKey.encodeOID(this.algorithmOID));
        byte[] parametersBytes = this.parametersOID != null ? this.writeTLV(6, RawPublicKey.encodeOID(this.parametersOID)) : this.writeTLV(5, new byte[0]);
        byte[] algorithmIdentifierBytes = this.writeTLV(48, ByteArrayUtils.concatenate(algorithmBytes, parametersBytes));
        byte[] subjectPublicKeyBytes = this.writeTLV(3, this.subjectPublicKey);
        byte[] subjectPublicKeyInfo = this.writeTLV(48, ByteArrayUtils.concatenate(algorithmIdentifierBytes, subjectPublicKeyBytes));
        writer.writeBytes(subjectPublicKeyInfo);
        return writer.toByteArray();
    }

    public static RawPublicKey fromByteArray(byte[] byteArray) {
        RawPublicKey rawPublicKey = new RawPublicKey();
        RawPublicKey.readTLV(byteArray, rawPublicKey);
        return rawPublicKey;
    }

    private static void readTLV(byte[] byteArray, RawPublicKey rawPublicKey) {
        DatagramReader reader = new DatagramReader(byteArray);
        block6: while (reader.bytesAvailable()) {
            int tag = reader.read(8);
            int length = reader.read(8);
            if (length > 127) {
                int additionalBytes = length & 0x7F;
                length = reader.read(additionalBytes * 8);
            }
            byte[] fragment = reader.readBytes(length);
            switch (tag) {
                case 48: {
                    RawPublicKey.readTLV(fragment, rawPublicKey);
                    continue block6;
                }
                case 6: {
                    int[] oid = RawPublicKey.decodeOID(fragment);
                    rawPublicKey.setObjectIdentifier(oid);
                    continue block6;
                }
                case 3: {
                    byte[] subjectPublicKey = new byte[fragment.length - 1];
                    System.arraycopy(fragment, 1, subjectPublicKey, 0, fragment.length - 1);
                    rawPublicKey.setBitString(subjectPublicKey);
                    continue block6;
                }
                case 5: {
                    continue block6;
                }
            }
            if (!LOGGER.isLoggable(Level.WARNING)) continue;
            LOGGER.warning("Unknown DER tag: " + tag);
        }
    }

    private byte[] writeTLV(int tag, byte[] value) {
        DatagramWriter writer = new DatagramWriter();
        writer.write(tag, 8);
        switch (tag) {
            case 3: {
                byte[] unusedByte = new byte[]{0};
                value = ByteArrayUtils.concatenate(unusedByte, value);
                break;
            }
        }
        int length = value.length;
        if (length > 127) {
            int additionalBytes = 0;
            additionalBytes = length >= 0x1000000 ? 4 : (length >= 65536 ? 3 : (length >= 256 ? 2 : 1));
            int lengthField = 128;
            writer.write(lengthField += additionalBytes, 8);
            writer.write(length, additionalBytes * 8);
        } else {
            writer.write(length, 8);
        }
        writer.writeBytes(value);
        return writer.toByteArray();
    }

    public static int[] decodeOID(byte[] encoded) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        byte value = encoded[0];
        int first = value / 40;
        int second = value % 40;
        list.add(first);
        list.add(second);
        value = 0;
        ArrayList<Byte> values = new ArrayList<Byte>();
        for (int i = 1; i < encoded.length; ++i) {
            byte b = encoded[i];
            values.add(b);
            if ((b & 0x80) > 0) continue;
            Collections.reverse(values);
            int length = values.size();
            int v = 0;
            for (int j = length - 1; j >= 0; --j) {
                if (j > 0) {
                    v += ((Byte)values.get(j) & 0x7F) << 7 * j;
                    continue;
                }
                v += ((Byte)values.get(j)).byteValue();
            }
            list.add(v);
            values.clear();
        }
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }

    public static byte[] encodeOID(int[] oid) {
        byte[] encoded = new byte[]{};
        byte[] firstTwo = new byte[]{(byte)(40 * oid[0] + oid[1])};
        encoded = ByteArrayUtils.concatenate(encoded, firstTwo);
        for (int i = 2; i < oid.length; ++i) {
            int value = oid[i];
            int length = value >= 0x10000000 ? 5 : (value >= 0x200000 ? 4 : (value >= 16384 ? 3 : (value >= 128 ? 2 : 1)));
            for (int j = length - 1; j >= 0; --j) {
                byte[] b = new byte[]{j > 0 ? (byte)(value >> 7 * j & 0x7F | 0x80) : (byte)(value & 0x7F)};
                encoded = ByteArrayUtils.concatenate(encoded, b);
            }
        }
        return encoded;
    }

    public void setObjectIdentifier(int[] oid) {
        if (this.algorithmOID != null) {
            this.parametersOID = oid;
        } else {
            this.algorithmOID = oid;
        }
    }

    public void setBitString(byte[] bitString) {
        this.subjectPublicKey = bitString;
    }

    public byte[] getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public int[] getAlgorithmOID() {
        return this.algorithmOID;
    }

    public int[] getParametersOID() {
        return this.parametersOID;
    }
}

