/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.util.DatagramWriter;

public abstract class HelloExtension {
    private static final int TYPE_BITS = 16;
    protected static final int LENGTH_BITS = 16;
    private HelloExtensions.ExtensionType type;

    public HelloExtension(HelloExtensions.ExtensionType type) {
        this.type = type;
    }

    public abstract int getLength();

    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.type.getId(), 16);
        return writer.toByteArray();
    }

    public static HelloExtension fromByteArray(byte[] byteArray, HelloExtensions.ExtensionType type) throws HandshakeException {
        switch (type) {
            case ELLIPTIC_CURVES: {
                return SupportedEllipticCurvesExtension.fromByteArray(byteArray);
            }
            case EC_POINT_FORMATS: {
                return SupportedPointFormatsExtension.fromByteArray(byteArray);
            }
            case CLIENT_CERT_TYPE: {
                return ClientCertificateTypeExtension.fromByteArray(byteArray);
            }
            case SERVER_CERT_TYPE: {
                return ServerCertificateTypeExtension.fromByteArray(byteArray);
            }
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_EXTENSION);
        throw new HandshakeException("Unsupported extension type received: " + type.toString(), alert);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\t\tExtension: " + this.type.toString() + " (" + this.type.getId() + ")\n");
        return sb.toString();
    }
}

