/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.ServerKeyExchange;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.ECDHECryptography;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class ECDHServerKeyExchange
extends ServerKeyExchange {
    private static final Logger LOGGER = Logger.getLogger(ECDHServerKeyExchange.class.getCanonicalName());
    private static final int CURVE_TYPE_BITS = 8;
    private static final int NAMED_CURVE_BITS = 16;
    private static final int PUBLIC_LENGTH_BITS = 8;
    private static final int HASH_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_ALGORITHM_BITS = 8;
    private static final int SIGNATURE_LENGTH_BITS = 16;
    private static final String KEYPAIR_GENERATOR_INSTANCE = "EC";
    private static final int EXPLICIT_PRIME = 1;
    private static final int EXPLICIT_CHAR2 = 2;
    private static final int NAMED_CURVE = 3;
    private ECPublicKey publicKey = null;
    private ECPoint point = null;
    private byte[] pointEncoded = null;
    private int curveId;
    private byte[] signatureEncoded = null;
    private SignatureAndHashAlgorithm signatureAndHashAlgorithm;
    private int curveType = 3;
    public static final Map<String, Integer> NAMED_CURVE_INDEX = new HashMap<String, Integer>();
    public static final Map<Integer, ECParameterSpec> NAMED_CURVE_PARAMETERS;

    public ECDHServerKeyExchange(SignatureAndHashAlgorithm signatureAndHashAlgorithm, ECDHECryptography ecdhe, PrivateKey serverPrivateKey, Random clientRandom, Random serverRandom, int namedCurveId) {
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
        try {
            this.publicKey = ecdhe.getPublicKey();
            ECParameterSpec parameters = this.publicKey.getParams();
            this.curveId = namedCurveId;
            this.point = this.publicKey.getW();
            this.pointEncoded = ECDHECryptography.encodePoint(this.point, parameters.getCurve());
            Signature signature = Signature.getInstance(this.signatureAndHashAlgorithm.toString());
            signature.initSign(serverPrivateKey);
            this.updateSignature(signature, clientRandom, serverRandom);
            this.signatureEncoded = signature.sign();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ECDHServerKeyExchange(SignatureAndHashAlgorithm signatureAndHashAlgorithm, int curveId, byte[] pointEncoded, byte[] signatureEncoded) {
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
        this.curveId = curveId;
        this.pointEncoded = pointEncoded;
        this.signatureEncoded = signatureEncoded;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        switch (this.curveType) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                writer.write(3, 8);
                writer.write(this.curveId, 16);
                writer.write(this.pointEncoded.length, 8);
                writer.writeBytes(this.pointEncoded);
                if (this.signatureEncoded == null) break;
                writer.write(this.signatureAndHashAlgorithm.getHash().getCode(), 8);
                writer.write(this.signatureAndHashAlgorithm.getSignature().getCode(), 8);
                writer.write(this.signatureEncoded.length, 16);
                writer.writeBytes(this.signatureEncoded);
                break;
            }
            default: {
                LOGGER.severe("Unknown curve type: " + this.curveId);
            }
        }
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray) throws HandshakeException {
        DatagramReader reader = new DatagramReader(byteArray);
        int curveType = reader.read(8);
        switch (curveType) {
            case 1: 
            case 2: {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
                throw new HandshakeException("Not supported curve type in ServerKeyExchange message", alert);
            }
            case 3: {
                int curveId = reader.read(16);
                int length = reader.read(8);
                byte[] pointEncoded = reader.readBytes(length);
                byte[] bytesLeft = reader.readBytesLeft();
                SignatureAndHashAlgorithm signAndHash = new SignatureAndHashAlgorithm(CertificateRequest.HashAlgorithm.SHA256, CertificateRequest.SignatureAlgorithm.ECDSA);
                byte[] signatureEncoded = null;
                if (bytesLeft.length > 0) {
                    reader = new DatagramReader(bytesLeft);
                    int hashAlgorithm = reader.read(8);
                    int signatureAlgorithm = reader.read(8);
                    signAndHash = new SignatureAndHashAlgorithm(hashAlgorithm, signatureAlgorithm);
                    length = reader.read(16);
                    signatureEncoded = reader.readBytes(length);
                }
                return new ECDHServerKeyExchange(signAndHash, curveId, pointEncoded, signatureEncoded);
            }
        }
        LOGGER.severe("Unknown curve type: " + curveType);
        return null;
    }

    @Override
    public int getMessageLength() {
        int length = 0;
        switch (this.curveType) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                int signatureLength = this.signatureEncoded == null ? 0 : 4 + this.signatureEncoded.length;
                length = 4 + this.pointEncoded.length + signatureLength;
                break;
            }
            default: {
                LOGGER.severe("Unknown curve type: " + this.curveType);
            }
        }
        return length;
    }

    public void verifySignature(PublicKey serverPublicKey, Random clientRandom, Random serverRandom) throws HandshakeException {
        if (this.signatureEncoded == null) {
            return;
        }
        boolean verified = false;
        try {
            Signature signature = Signature.getInstance(this.signatureAndHashAlgorithm.toString());
            signature.initVerify(serverPublicKey);
            this.updateSignature(signature, clientRandom, serverRandom);
            verified = signature.verify(this.signatureEncoded);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not verify the server's signature.", e);
        }
        if (!verified) {
            String message = "The server's ECDHE key exchange message's signature could not be verified.";
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
            throw new HandshakeException(message, alert);
        }
    }

    private void updateSignature(Signature signature, Random clientRandom, Random serverRandom) throws SignatureException {
        signature.update(clientRandom.getRandomBytes());
        signature.update(serverRandom.getRandomBytes());
        switch (this.curveType) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                signature.update((byte)3);
                signature.update((byte)(this.curveId >> 8));
                signature.update((byte)this.curveId);
                signature.update((byte)this.pointEncoded.length);
                signature.update(this.pointEncoded);
                break;
            }
            default: {
                LOGGER.severe("Unknown curve type: " + this.curveId);
            }
        }
    }

    public ECPublicKey getPublicKey(ECParameterSpec params) {
        if (this.publicKey == null) {
            try {
                this.point = ECDHECryptography.decodePoint(this.pointEncoded, params.getCurve());
                KeyFactory keyFactory = KeyFactory.getInstance(KEYPAIR_GENERATOR_INSTANCE);
                this.publicKey = (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec(this.point, params));
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not reconstruct the server's ephemeral public key.", e);
            }
        }
        return this.publicKey;
    }

    private ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public int getCurveId() {
        return this.curveId;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\t" + this.getPublicKey().toString() + "\n");
        return sb.toString();
    }

    private static void addParameterSpec(int namedCurveId, String p, String a, String b, String x, String y, String n, int h) {
        ECFieldFp field = new ECFieldFp(new BigInteger(p, 16));
        EllipticCurve curve = new EllipticCurve(field, new BigInteger(a, 16), new BigInteger(b, 16));
        ECPoint g = new ECPoint(new BigInteger(x, 16), new BigInteger(y, 16));
        ECParameterSpec params = new ECParameterSpec(curve, g, new BigInteger(n, 16), h);
        NAMED_CURVE_PARAMETERS.put(namedCurveId, params);
    }

    static {
        for (int i = 1; i < ECDHECryptography.NAMED_CURVE_TABLE.length; ++i) {
            NAMED_CURVE_INDEX.put(ECDHECryptography.NAMED_CURVE_TABLE[i], i);
        }
        NAMED_CURVE_PARAMETERS = new HashMap<Integer, ECParameterSpec>();
        ECDHServerKeyExchange.addParameterSpec(20, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFE56D", "00000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000000005", "A1455B334DF099DF30FC28A169A467E9E47075A90F7E650EB6B7A45C", "7E089FED7FBA344282CAFBD6F7E319F7C0B0BD59E2CA4BDB556D61A5", "010000000000000000000000000001DCE8D2EC6184CAF0A971769FB1F7", 1);
        ECDHServerKeyExchange.addParameterSpec(21, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000001", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFE", "B4050A850C04B3ABF54132565044B0B7D7BFD8BA270B39432355FFB4", "B70E0CBD6BB4BF7F321390B94A03C1D356C21122343280D6115C1D21", "BD376388B5F723FB4C22DFE6CD4375A05A07476444D5819985007E34", "FFFFFFFFFFFFFFFFFFFFFFFFFFFF16A2E0B8F03E13DD29455C5C2A3D", 1);
        ECDHServerKeyExchange.addParameterSpec(22, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F", "0000000000000000000000000000000000000000000000000000000000000000", "0000000000000000000000000000000000000000000000000000000000000007", "79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798", "483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141", 1);
        ECDHServerKeyExchange.addParameterSpec(23, "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC", "5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B", "6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296", "4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5", "FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551", 1);
        ECDHServerKeyExchange.addParameterSpec(24, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC", "B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF", "AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7", "3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973", 1);
        ECDHServerKeyExchange.addParameterSpec(25, "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC", "0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00", "00C6858E06B70404E9CD9E3ECB662395B4429C648139053FB521F828AF606B4D3DBAA14B5E77EFE75928FE1DC127A2FFA8DE3348B3C1856A429BF97E7E31C2E5BD66", "011839296A789A3BC0045C8A5FB42C7D1BD998F54449579B446817AFBD17273E662C97EE72995EF42640C550B9013FAD0761353C7086A272C24088BE94769FD16650", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409", 1);
    }
}

