/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.DTLSConnectionState;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

public class DTLSSession {
    private InetSocketAddress peer = null;
    private SessionId sessionIdentifier = null;
    private X509Certificate peerCertificate = null;
    private CompressionMethod compressionMethod;
    private CipherSuite cipherSuite;
    private byte[] masterSecret = null;
    private boolean isResumable = false;
    private String pskIdentity;
    private boolean isActive = false;
    private boolean isClient;
    private DTLSConnectionState readState = new DTLSConnectionState();
    private DTLSConnectionState writeState = new DTLSConnectionState();
    private int readEpoch = 0;
    private int writeEpoch = 0;
    private Map<Integer, Integer> sequenceNumbers = new HashMap<Integer, Integer>();
    private CipherSuite.KeyExchangeAlgorithm keyExchange;
    private boolean sendRawPublicKey = false;
    private boolean receiveRawPublicKey = false;

    public DTLSSession(InetSocketAddress peerAddress, boolean isClient) {
        this.peer = peerAddress;
        this.isClient = isClient;
        this.cipherSuite = CipherSuite.SSL_NULL_WITH_NULL_NULL;
        this.compressionMethod = CompressionMethod.NULL;
        this.sequenceNumbers.put(0, 0);
    }

    public SessionId getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    public void setSessionIdentifier(SessionId sessionIdentifier) {
        this.sessionIdentifier = sessionIdentifier;
    }

    public X509Certificate getPeerCertificate() {
        return this.peerCertificate;
    }

    public void setPeerCertificate(X509Certificate peerCertificate) {
        this.peerCertificate = peerCertificate;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(CompressionMethod compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public void setCipherSuite(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    public boolean isResumable() {
        return this.isResumable;
    }

    public void setResumable(boolean isResumable) {
        this.isResumable = isResumable;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public void setClient(boolean isClient) {
        this.isClient = isClient;
    }

    public int getWriteEpoch() {
        return this.writeEpoch;
    }

    public void setWriteEpoch(int epoch) {
        this.writeEpoch = epoch;
    }

    public int getReadEpoch() {
        return this.readEpoch;
    }

    public void setReadEpoch(int epoch) {
        this.readEpoch = epoch;
    }

    public void incrementReadEpoch() {
        ++this.readEpoch;
    }

    public void incrementWriteEpoch() {
        ++this.writeEpoch;
        this.sequenceNumbers.put(this.writeEpoch, 0);
    }

    public int getSequenceNumber() {
        return this.getSequenceNumber(this.writeEpoch);
    }

    public int getSequenceNumber(int epoch) {
        int sequenceNumber = this.sequenceNumbers.get(epoch);
        this.sequenceNumbers.put(epoch, sequenceNumber + 1);
        return sequenceNumber;
    }

    public DTLSConnectionState getReadState() {
        return this.readState;
    }

    public void setReadState(DTLSConnectionState readState) {
        this.readState = readState;
    }

    public DTLSConnectionState getWriteState() {
        return this.writeState;
    }

    public void setWriteState(DTLSConnectionState writeState) {
        this.writeState = writeState;
    }

    public CipherSuite.KeyExchangeAlgorithm getKeyExchange() {
        return this.keyExchange;
    }

    public void setKeyExchange(CipherSuite.KeyExchangeAlgorithm keyExchange) {
        this.keyExchange = keyExchange;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }

    public void setMasterSecret(byte[] masterSecret) {
        if (this.masterSecret != null) {
            this.masterSecret = masterSecret;
        }
    }

    public boolean sendRawPublicKey() {
        return this.sendRawPublicKey;
    }

    public void setSendRawPublicKey(boolean sendRawPublicKey) {
        this.sendRawPublicKey = sendRawPublicKey;
    }

    public boolean receiveRawPublicKey() {
        return this.receiveRawPublicKey;
    }

    public void setReceiveRawPublicKey(boolean receiveRawPublicKey) {
        this.receiveRawPublicKey = receiveRawPublicKey;
    }

    public InetSocketAddress getPeer() {
        return this.peer;
    }

    public String getPskIdentity() {
        return this.pskIdentity;
    }

    public void setPskIdentity(String pskIdentity) {
        this.pskIdentity = pskIdentity;
    }
}

