/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class CertificateRequest
extends HandshakeMessage {
    private static final int CERTIFICATE_TYPES_LENGTH_BITS = 8;
    private static final int CERTIFICATE_TYPE_BITS = 8;
    private static final int SUPPORTED_SIGNATURE_LENGTH_BITS = 16;
    private static final int CERTIFICATE_AUTHORITIES_LENGTH_BITS = 16;
    private static final int CERTIFICATE_AUTHORITY_LENGTH_BITS = 16;
    private static final int SUPPORTED_SIGNATURE_BITS = 8;
    private List<ClientCertificateType> certificateTypes;
    private List<SignatureAndHashAlgorithm> supportedSignatureAlgorithms;
    private List<DistinguishedName> certificateAuthorities;

    public CertificateRequest() {
        this.certificateTypes = new ArrayList<ClientCertificateType>();
        this.supportedSignatureAlgorithms = new ArrayList<SignatureAndHashAlgorithm>();
        this.certificateAuthorities = new ArrayList<DistinguishedName>();
    }

    public CertificateRequest(List<ClientCertificateType> certificateTypes, List<SignatureAndHashAlgorithm> supportedSignatureAlgorithms, List<DistinguishedName> certificateAuthorities) {
        this.certificateTypes = certificateTypes;
        this.supportedSignatureAlgorithms = supportedSignatureAlgorithms;
        this.certificateAuthorities = certificateAuthorities;
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.CERTIFICATE_REQUEST;
    }

    @Override
    public int getMessageLength() {
        return 5 + this.certificateTypes.size() + this.supportedSignatureAlgorithms.size() * 2 + this.getCertificateAuthoritiesLength();
    }

    private int getCertificateAuthoritiesLength() {
        int certificateAuthLength = 0;
        for (DistinguishedName distinguishedName : this.certificateAuthorities) {
            certificateAuthLength += distinguishedName.getName().length + 2;
        }
        return certificateAuthLength;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.certificateTypes.size() > 0) {
            sb.append("\t\tClient certificate type:\n");
            for (ClientCertificateType type : this.certificateTypes) {
                sb.append("\t\t\t" + type.toString() + "\n");
            }
        }
        if (this.supportedSignatureAlgorithms.size() > 0) {
            sb.append("\t\tSignature and hash algorithm:\n");
            for (SignatureAndHashAlgorithm algo : this.supportedSignatureAlgorithms) {
                sb.append("\t\t\t" + algo.toString() + "\n");
            }
        }
        if (this.certificateAuthorities.size() > 0) {
            sb.append("\t\tCertificate authorities:\n");
            for (DistinguishedName name : this.certificateAuthorities) {
                X500Principal principal = new X500Principal(name.getName());
                sb.append("\t\t\t" + principal.getName() + "\n");
            }
        }
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.certificateTypes.size(), 8);
        for (ClientCertificateType certificateType : this.certificateTypes) {
            writer.write(certificateType.getCode(), 8);
        }
        writer.write(this.supportedSignatureAlgorithms.size() * 2, 16);
        for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : this.supportedSignatureAlgorithms) {
            writer.write(signatureAndHashAlgorithm.getHash().getCode(), 8);
            writer.write(signatureAndHashAlgorithm.getSignature().getCode(), 8);
        }
        writer.write(this.getCertificateAuthoritiesLength(), 16);
        for (DistinguishedName distinguishedName : this.certificateAuthorities) {
            writer.write(distinguishedName.getName().length, 16);
            writer.writeBytes(distinguishedName.getName());
        }
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray) {
        byte[] name;
        DatagramReader reader = new DatagramReader(byteArray);
        int length = reader.read(8);
        ArrayList<ClientCertificateType> certificateTypes = new ArrayList<ClientCertificateType>();
        for (int i = 0; i < length; ++i) {
            int code = reader.read(8);
            certificateTypes.add(ClientCertificateType.getTypeByCode(code));
        }
        length = reader.read(16);
        ArrayList<SignatureAndHashAlgorithm> supportedSignatureAlgorithms = new ArrayList<SignatureAndHashAlgorithm>();
        for (int i = 0; i < length; i += 2) {
            int codeHash = reader.read(8);
            int codeSignature = reader.read(8);
            supportedSignatureAlgorithms.add(new SignatureAndHashAlgorithm(HashAlgorithm.getAlgorithmByCode(codeHash), SignatureAlgorithm.getAlgorithmByCode(codeSignature)));
        }
        ArrayList<DistinguishedName> certificateAuthorities = new ArrayList<DistinguishedName>();
        for (length = reader.read(16); length > 0; length -= 2 + name.length) {
            int nameLength = reader.read(16);
            name = reader.readBytes(nameLength);
            certificateAuthorities.add(new DistinguishedName(name));
        }
        return new CertificateRequest(certificateTypes, supportedSignatureAlgorithms, certificateAuthorities);
    }

    public void addCertificateType(ClientCertificateType certificateType) {
        this.certificateTypes.add(certificateType);
    }

    public void addSignatureAlgorithm(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        this.supportedSignatureAlgorithms.add(signatureAndHashAlgorithm);
    }

    public void addCertificateAuthority(DistinguishedName authority) {
        this.certificateAuthorities.add(authority);
    }

    public void addCertificateAuthorities(Certificate[] certificateAuthorities) {
        for (Certificate certificate : certificateAuthorities) {
            byte[] ca = ((X509Certificate)certificate).getSubjectX500Principal().getEncoded();
            this.addCertificateAuthority(new DistinguishedName(ca));
        }
    }

    public List<ClientCertificateType> getCertificateTypes() {
        return this.certificateTypes;
    }

    public List<SignatureAndHashAlgorithm> getSupportedSignatureAlgorithms() {
        return this.supportedSignatureAlgorithms;
    }

    public List<DistinguishedName> getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    public static class DistinguishedName {
        private byte[] name;

        public DistinguishedName(byte[] name) {
            this.name = name;
        }

        public byte[] getName() {
            return this.name;
        }
    }

    public static enum SignatureAlgorithm {
        ANONYMOUS(0),
        RSA(1),
        DSA(2),
        ECDSA(3);

        private int code;

        private SignatureAlgorithm(int code) {
            this.code = code;
        }

        public static SignatureAlgorithm getAlgorithmByCode(int code) {
            switch (code) {
                case 0: {
                    return ANONYMOUS;
                }
                case 1: {
                    return RSA;
                }
                case 2: {
                    return DSA;
                }
                case 3: {
                    return ECDSA;
                }
            }
            return null;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String toString() {
            switch (this.code) {
                case 0: {
                    return "Anonymous";
                }
                case 1: {
                    return "RSA";
                }
                case 2: {
                    return "DSA";
                }
                case 3: {
                    return "ECDSA";
                }
            }
            return "";
        }
    }

    public static enum HashAlgorithm {
        NONE(0),
        MD5(1),
        SHA1(2),
        SHA224(3),
        SHA256(4),
        SHA384(5),
        SHA512(6);

        private int code;

        private HashAlgorithm(int code) {
            this.code = code;
        }

        public static HashAlgorithm getAlgorithmByCode(int code) {
            switch (code) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return MD5;
                }
                case 2: {
                    return SHA1;
                }
                case 3: {
                    return SHA224;
                }
                case 4: {
                    return SHA256;
                }
                case 5: {
                    return SHA384;
                }
                case 6: {
                    return SHA512;
                }
            }
            return null;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String toString() {
            switch (this.code) {
                case 0: {
                    return "NONE";
                }
                case 1: {
                    return "MD5";
                }
                case 2: {
                    return "SHA1";
                }
                case 3: {
                    return "SHA224";
                }
                case 4: {
                    return "SHA256";
                }
                case 5: {
                    return "SHA384";
                }
                case 6: {
                    return "SHA512";
                }
            }
            return "";
        }
    }

    public static enum ClientCertificateType {
        RSA_SIGN(1),
        DSS_SIGN(2),
        RSA_FIXED_DH(3),
        DSS_FIXED_DH(4),
        RSA_EPHEMERAL_DH_RESERVED(5),
        DSS_EPHEMERAL_DH_RESERVED(6),
        FORTEZZA_DMS_RESERVED(20),
        ECDSA_SIGN(64),
        RSA_FIXED_ECDH(65),
        ECDSA_FIXED_ECDH(66);

        private int code;

        private ClientCertificateType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ClientCertificateType getTypeByCode(int code) {
            switch (code) {
                case 1: {
                    return RSA_SIGN;
                }
                case 2: {
                    return DSS_SIGN;
                }
                case 3: {
                    return RSA_FIXED_DH;
                }
                case 4: {
                    return DSS_FIXED_DH;
                }
                case 5: {
                    return RSA_EPHEMERAL_DH_RESERVED;
                }
                case 6: {
                    return DSS_EPHEMERAL_DH_RESERVED;
                }
                case 20: {
                    return FORTEZZA_DMS_RESERVED;
                }
                case 64: {
                    return ECDSA_SIGN;
                }
                case 65: {
                    return RSA_FIXED_ECDH;
                }
                case 66: {
                    return ECDSA_FIXED_ECDH;
                }
            }
            return null;
        }
    }
}

