/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.eclipse.californium.scandium.ScandiumFormatter;

public class ScandiumLogger {
    private static final Logger SCANDIUM_LOGGER = Logger.getLogger(ScandiumLogger.class.getPackage().getName());

    public static void initialize() {
        SCANDIUM_LOGGER.setUseParentHandlers(false);
        SCANDIUM_LOGGER.addHandler(new ScandiumHandler());
    }

    public static void disable() {
        SCANDIUM_LOGGER.setLevel(Level.OFF);
    }

    public static void setLevel(Level level) {
        SCANDIUM_LOGGER.setLevel(level);
    }

    public static void setLoggerLevel(String logger, Level level) {
        Logger.getLogger(logger).setLevel(level);
    }

    private static class ScandiumHandler
    extends StreamHandler {
        public ScandiumHandler() {
            super(System.out, new ScandiumFormatter());
            this.setLevel(Level.ALL);
        }

        @Override
        public synchronized void publish(LogRecord record) {
            super.publish(record);
            super.flush();
        }
    }
}

