/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.examples;

import java.net.InetSocketAddress;
import java.util.logging.Level;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.network.CoAPEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.interceptors.MessageTracer;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.ScandiumLogger;
import org.eclipse.californium.scandium.dtls.pskstore.InMemoryPskStore;

public class SecureServer {
    public static final int DTLS_PORT = NetworkConfig.getStandard().getInt("DEFAULT_COAP_PORT");

    public static void main(String[] args) {
        CoapServer server = new CoapServer();
        server.add(new CoapResource("secure"){

            @Override
            public void handleGET(CoapExchange exchange) {
                exchange.respond(CoAP.ResponseCode.CONTENT, "hello security");
            }
        });
        InMemoryPskStore pskStore = new InMemoryPskStore();
        pskStore.setKey("My_Identity", "TheSecretKey".getBytes());
        DTLSConnector connector = new DTLSConnector(new InetSocketAddress(DTLS_PORT), null);
        connector.getConfig().setPskStore(pskStore);
        server.addEndpoint(new CoAPEndpoint(connector, NetworkConfig.getStandard()));
        server.start();
        for (Endpoint ep : server.getEndpoints()) {
            ep.addInterceptor(new MessageTracer());
        }
        System.out.println("Secure CoAP server powered by Scandium (Sc) is listening on port " + DTLS_PORT);
    }

    static {
        ScandiumLogger.initialize();
        ScandiumLogger.setLevel(Level.FINER);
    }
}

