/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.ExchangeObserver;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.deduplication.Deduplicator;
import org.eclipse.californium.core.network.deduplication.DeduplicatorFactory;
import org.eclipse.californium.core.observe.ObserveRelation;

public class Matcher {
    private static final Logger LOGGER = Logger.getLogger(Matcher.class.getCanonicalName());
    private boolean started = false;
    private ExchangeObserver exchangeObserver = new ExchangeObserverImpl();
    private ScheduledExecutorService executor;
    private AtomicInteger currendMID;
    private ConcurrentHashMap<Exchange.KeyMID, Exchange> exchangesByMID = new ConcurrentHashMap();
    private ConcurrentHashMap<Exchange.KeyToken, Exchange> exchangesByToken = new ConcurrentHashMap();
    private ConcurrentHashMap<Exchange.KeyUri, Exchange> ongoingExchanges = new ConcurrentHashMap();
    private Deduplicator deduplicator;

    public Matcher(NetworkConfig config) {
        DeduplicatorFactory factory = DeduplicatorFactory.getDeduplicatorFactory();
        this.deduplicator = factory.createDeduplicator(config);
        this.currendMID = config.getBoolean("USE_RANDOM_MID_START") ? new AtomicInteger(new Random().nextInt(65536)) : new AtomicInteger(0);
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.executor == null) {
            throw new IllegalStateException("Matcher has no executor to schedule exchnage removal");
        }
        this.deduplicator.start();
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.deduplicator.stop();
        this.clear();
    }

    public synchronized void setExecutor(ScheduledExecutorService executor) {
        this.deduplicator.setExecutor(executor);
        this.executor = executor;
    }

    public void sendRequest(Exchange exchange, Request request) {
        if (request.getMID() == -1) {
            request.setMID(this.currendMID.getAndIncrement() % 65536);
        }
        Exchange.KeyMID idByMID = new Exchange.KeyMID(request.getMID(), request.getDestination().getAddress(), request.getDestinationPort());
        Exchange.KeyToken idByTok = new Exchange.KeyToken(request.getToken(), request.getDestination().getAddress(), request.getDestinationPort());
        exchange.setObserver(this.exchangeObserver);
        LOGGER.fine("Stored open request by " + idByMID + ", " + idByTok);
        this.exchangesByMID.put(idByMID, exchange);
        this.exchangesByToken.put(idByTok, exchange);
    }

    public void sendResponse(Exchange exchange, Response response) {
        ObserveRelation relation;
        if (response.getMID() == -1) {
            response.setMID(this.currendMID.getAndIncrement() % 65536);
        }
        if (response.getDestination() == null) {
            throw new NullPointerException("Response has no destination address set");
        }
        if (response.getDestinationPort() == 0) {
            throw new NullPointerException("Response hsa no destination port set");
        }
        if ((response.getType() == CoAP.Type.CON || response.getType() == CoAP.Type.ACK) && (relation = exchange.getRelation()) != null) {
            this.removeNotificatoinsOf(relation);
        }
        if (response.getOptions().hasBlock2()) {
            Request request = exchange.getRequest();
            Exchange.KeyUri idByUri = new Exchange.KeyUri(request.getURI(), response.getDestination().getAddress(), response.getDestinationPort());
            if (exchange.getResponseBlockStatus() != null && !response.getOptions().hasObserve()) {
                LOGGER.fine("Ongoing Block2 started, storing " + idByUri + "\nOngoing " + request + "\nOngoing " + response);
                this.ongoingExchanges.put(idByUri, exchange);
            } else {
                LOGGER.fine("Ongoing Block2 completed, cleaning up " + idByUri + "\nOngoing " + request + "\nOngoing " + response);
                this.ongoingExchanges.remove(idByUri);
            }
        }
        if (response.getType() == CoAP.Type.CON || response.getType() == CoAP.Type.NON) {
            Exchange.KeyMID idByMID = new Exchange.KeyMID(response.getMID(), response.getDestination().getAddress(), response.getDestinationPort());
            this.exchangesByMID.put(idByMID, exchange);
        }
        if ((response.getType() == CoAP.Type.ACK || response.getType() == CoAP.Type.NON) && response.isLast()) {
            exchange.setComplete();
        }
    }

    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        if (message.getType() == CoAP.Type.RST && exchange != null) {
            exchange.setComplete();
        }
        if (message.getMID() == -1) {
            LOGGER.severe("Empy message " + message + " has no MID // debugging");
        }
    }

    public Exchange receiveRequest(Request request) {
        Exchange.KeyMID idByMID = new Exchange.KeyMID(request.getMID(), request.getSource().getAddress(), request.getSourcePort());
        if (!request.getOptions().hasBlock1() && !request.getOptions().hasBlock2()) {
            Exchange exchange = new Exchange(request, Exchange.Origin.REMOTE);
            Exchange previous = this.deduplicator.findPrevious(idByMID, exchange);
            if (previous == null) {
                exchange.setObserver(this.exchangeObserver);
                return exchange;
            }
            LOGGER.info("Message is a duplicate, ignore: " + request);
            request.setDuplicate(true);
            return previous;
        }
        Exchange.KeyUri idByUri = new Exchange.KeyUri(request.getURI(), request.getSource().getAddress(), request.getSourcePort());
        LOGGER.fine("Lookup ongoing exchange for " + idByUri);
        Exchange ongoing = this.ongoingExchanges.get(idByUri);
        if (ongoing != null) {
            Exchange prev = this.deduplicator.findPrevious(idByMID, ongoing);
            if (prev != null) {
                LOGGER.info("Message is a duplicate: " + request);
                request.setDuplicate(true);
            }
            return ongoing;
        }
        Exchange exchange = new Exchange(request, Exchange.Origin.REMOTE);
        Exchange previous = this.deduplicator.findPrevious(idByMID, exchange);
        LOGGER.fine("New ongoing exchange for remote Block1 request with key " + idByUri);
        if (previous == null) {
            exchange.setObserver(this.exchangeObserver);
            this.ongoingExchanges.put(idByUri, exchange);
            return exchange;
        }
        LOGGER.info("Message is a duplicate: " + request);
        request.setDuplicate(true);
        return previous;
    }

    public Exchange receiveResponse(Response response) {
        Exchange prev;
        Exchange.KeyMID idByMID = new Exchange.KeyMID(response.getMID(), response.getSource().getAddress(), response.getSourcePort());
        Exchange.KeyToken idByTok = new Exchange.KeyToken(response.getToken(), response.getSource().getAddress(), response.getSourcePort());
        Exchange exchange = this.exchangesByToken.get(idByTok);
        if (exchange != null) {
            Exchange prev2 = this.deduplicator.findPrevious(idByMID, exchange);
            if (prev2 != null) {
                LOGGER.fine("Duplicate response " + response);
                response.setDuplicate(true);
            } else {
                LOGGER.fine("Exchange got reply: Cleaning up " + idByMID);
                this.exchangesByMID.remove(idByMID);
            }
            if (response.getType() == CoAP.Type.ACK && exchange.getCurrentRequest().getMID() != response.getMID()) {
                LOGGER.warning("Token matches but not MID: Expected " + exchange.getCurrentRequest().getMID() + " but was " + response.getMID());
                return null;
            }
            return exchange;
        }
        if (response.getType() != CoAP.Type.ACK && (prev = this.deduplicator.find(idByMID)) != null) {
            response.setDuplicate(true);
            return prev;
        }
        return null;
    }

    public Exchange receiveEmptyMessage(EmptyMessage message) {
        Exchange.KeyMID idByMID = new Exchange.KeyMID(message.getMID(), message.getSource().getAddress(), message.getSourcePort());
        Exchange exchange = this.exchangesByMID.get(idByMID);
        if (exchange != null) {
            LOGGER.fine("Exchange got reply: Cleaning up " + idByMID);
            this.exchangesByMID.remove(idByMID);
            return exchange;
        }
        LOGGER.info("Matcher received empty message that does not match any exchange: " + message);
        return null;
    }

    public void clear() {
        this.exchangesByMID.clear();
        this.exchangesByToken.clear();
        this.ongoingExchanges.clear();
        this.deduplicator.clear();
    }

    private void removeNotificatoinsOf(ObserveRelation relation) {
        LOGGER.fine("Remove all remaining NON-notifications of observe relation");
        Iterator<Response> iterator = relation.getNotificationIterator();
        while (iterator.hasNext()) {
            Response previous = iterator.next();
            Exchange.KeyMID idByMID = new Exchange.KeyMID(previous.getMID(), previous.getDestination().getAddress(), previous.getDestinationPort());
            this.exchangesByMID.remove(idByMID);
            iterator.remove();
        }
    }

    private class ExchangeObserverImpl
    implements ExchangeObserver {
        private ExchangeObserverImpl() {
        }

        @Override
        public void completed(Exchange exchange) {
            if (exchange.getOrigin() == Exchange.Origin.LOCAL) {
                Request request = exchange.getRequest();
                Exchange.KeyToken idByTok = new Exchange.KeyToken(exchange.getCurrentRequest().getToken(), request.getDestination().getAddress(), request.getDestinationPort());
                Exchange.KeyMID idByMID = new Exchange.KeyMID(request.getMID(), request.getDestination().getAddress(), request.getDestinationPort());
                Matcher.this.exchangesByToken.remove(idByTok);
                Matcher.this.exchangesByMID.remove(idByMID);
            } else {
                ObserveRelation relation;
                Response response;
                Request request = exchange.getCurrentRequest();
                if (request != null) {
                    Exchange.KeyUri uriKey = new Exchange.KeyUri(request.getURI(), request.getSource().getAddress(), request.getSourcePort());
                    Matcher.this.ongoingExchanges.remove(uriKey);
                }
                if ((response = exchange.getResponse()) != null) {
                    Exchange.KeyMID midKey = new Exchange.KeyMID(response.getMID(), response.getDestination().getAddress(), response.getDestinationPort());
                    Matcher.this.exchangesByMID.remove(midKey);
                }
                if ((relation = exchange.getRelation()) != null) {
                    Matcher.this.removeNotificatoinsOf(relation);
                }
            }
        }
    }
}

