/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Pattern;

public class MediaTypeRegistry {
    public static final int TEXT_PLAIN = 0;
    public static final int TEXT_XML = 1;
    public static final int TEXT_CSV = 2;
    public static final int TEXT_HTML = 3;
    public static final int IMAGE_GIF = 21;
    public static final int IMAGE_JPEG = 22;
    public static final int IMAGE_PNG = 23;
    public static final int IMAGE_TIFF = 24;
    public static final int AUDIO_RAW = 25;
    public static final int VIDEO_RAW = 26;
    public static final int APPLICATION_LINK_FORMAT = 40;
    public static final int APPLICATION_XML = 41;
    public static final int APPLICATION_OCTET_STREAM = 42;
    public static final int APPLICATION_RDF_XML = 43;
    public static final int APPLICATION_SOAP_XML = 44;
    public static final int APPLICATION_ATOM_XML = 45;
    public static final int APPLICATION_XMPP_XML = 46;
    public static final int APPLICATION_EXI = 47;
    public static final int APPLICATION_FASTINFOSET = 48;
    public static final int APPLICATION_SOAP_FASTINFOSET = 49;
    public static final int APPLICATION_JSON = 50;
    public static final int APPLICATION_X_OBIX_BINARY = 51;
    public static final int UNDEFINED = -1;
    private static final HashMap<Integer, String[]> registry = new HashMap();

    public static Set<Integer> getAllMediaTypes() {
        return registry.keySet();
    }

    public static boolean isPrintable(int mediaType) {
        switch (mediaType) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: {
                return true;
            }
        }
        return false;
    }

    public static int parse(String type) {
        if (type == null) {
            return -1;
        }
        for (Integer key : registry.keySet()) {
            if (!registry.get(key)[0].equalsIgnoreCase(type)) continue;
            return key;
        }
        return -1;
    }

    public static Integer[] parseWildcard(String regex) {
        regex = regex.trim().substring(0, regex.indexOf(42)).trim().concat(".*");
        Pattern pattern = Pattern.compile(regex);
        LinkedList<Integer> matches = new LinkedList<Integer>();
        for (Integer mediaType : registry.keySet()) {
            String mime = registry.get(mediaType)[0];
            if (!pattern.matcher(mime).matches()) continue;
            matches.add(mediaType);
        }
        return matches.toArray(new Integer[0]);
    }

    public static String toFileExtension(int mediaType) {
        String[] texts = registry.get(mediaType);
        if (texts != null) {
            return texts[1];
        }
        return "unknown";
    }

    public static String toString(int mediaType) {
        String[] texts = registry.get(mediaType);
        if (texts != null) {
            return texts[0];
        }
        return "Unknown media type: " + mediaType;
    }

    private static void add(int mediaType, String string, String extension) {
        registry.put(mediaType, new String[]{string, extension});
    }

    static {
        MediaTypeRegistry.add(-1, "unknown", "???");
        MediaTypeRegistry.add(0, "text/plain", "txt");
        MediaTypeRegistry.add(2, "text/csv", "csv");
        MediaTypeRegistry.add(3, "text/html", "html");
        MediaTypeRegistry.add(21, "image/gif", "gif");
        MediaTypeRegistry.add(22, "image/jpeg", "jpg");
        MediaTypeRegistry.add(23, "image/png", "png");
        MediaTypeRegistry.add(24, "image/tiff", "tif");
        MediaTypeRegistry.add(40, "application/link-format", "wlnk");
        MediaTypeRegistry.add(41, "application/xml", "xml");
        MediaTypeRegistry.add(42, "application/octet-stream", "bin");
        MediaTypeRegistry.add(43, "application/rdf+xml", "rdf");
        MediaTypeRegistry.add(44, "application/soap+xml", "soap");
        MediaTypeRegistry.add(45, "application/atom+xml", "atom");
        MediaTypeRegistry.add(46, "application/xmpp+xml", "xmpp");
        MediaTypeRegistry.add(47, "application/exi", "exi");
        MediaTypeRegistry.add(48, "application/fastinfoset", "finf");
        MediaTypeRegistry.add(49, "application/soap+fastinfoset", "soap.finf");
        MediaTypeRegistry.add(50, "application/json", "json");
        MediaTypeRegistry.add(51, "application/x-obix-binary", "obix");
    }
}

