/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.network.CoAPEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.core.server.ServerInterface;
import org.eclipse.californium.core.server.ServerMessageDeliverer;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.DiscoveryResource;
import org.eclipse.californium.core.server.resources.Resource;

public class CoapServer
implements ServerInterface {
    private static final Logger LOGGER = Logger.getLogger(CoapServer.class.getCanonicalName());
    private final Resource root = this.createRoot();
    private MessageDeliverer deliverer;
    private final List<Endpoint> endpoints = new ArrayList<Endpoint>();
    private ScheduledExecutorService executor;
    private NetworkConfig config;

    public CoapServer() {
        this(NetworkConfig.getStandard(), new int[0]);
    }

    public CoapServer(int ... ports) {
        this(NetworkConfig.getStandard(), ports);
    }

    public CoapServer(NetworkConfig config, int ... ports) {
        this.config = config != null ? config : NetworkConfig.getStandard();
        this.executor = Executors.newScheduledThreadPool(config.getInt("SERVER_THRESD_NUMER"));
        this.deliverer = new ServerMessageDeliverer(this.root);
        CoapResource well_known = new CoapResource(".well-known");
        well_known.setVisible(false);
        well_known.add((CoapResource)new DiscoveryResource(this.root));
        this.root.add(well_known);
        for (int port : ports) {
            this.bind(port);
        }
    }

    private void bind(int port) {
        this.bind(new InetSocketAddress((InetAddress)null, port));
    }

    private void bind(InetSocketAddress address) {
        CoAPEndpoint endpoint = new CoAPEndpoint(address, this.config);
        this.addEndpoint(endpoint);
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
        for (Endpoint ep : this.endpoints) {
            ep.setExecutor(executor);
        }
    }

    @Override
    public void start() {
        LOGGER.info("Starting server");
        if (this.endpoints.isEmpty()) {
            int port = this.config.getInt("DEFAULT_COAP_PORT");
            LOGGER.info("No endpoints have been defined for server, setting up default endpoint at port " + port);
            this.bind(port);
        }
        int started = 0;
        for (Endpoint ep : this.endpoints) {
            try {
                ep.start();
                ++started;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Could not start endpoint", e);
            }
        }
        if (started == 0) {
            throw new IllegalStateException("None of the server's endpoints could be started");
        }
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping server");
        for (Endpoint ep : this.endpoints) {
            ep.stop();
        }
    }

    @Override
    public void destroy() {
        LOGGER.info("Destroy server");
        for (Endpoint ep : this.endpoints) {
            ep.destroy();
        }
        this.executor.shutdown();
        try {
            boolean succ = this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            if (!succ) {
                LOGGER.warning("Stack executor did not shutdown in time");
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Exception while terminating stack executor", e);
        }
    }

    public void setMessageDeliverer(MessageDeliverer deliverer) {
        this.deliverer = deliverer;
        for (Endpoint endpoint : this.endpoints) {
            endpoint.setMessageDeliverer(deliverer);
        }
    }

    public MessageDeliverer getMessageDeliverer() {
        return this.deliverer;
    }

    @Override
    public void addEndpoint(Endpoint endpoint) {
        endpoint.setMessageDeliverer(this.deliverer);
        endpoint.setExecutor(this.executor);
        this.endpoints.add(endpoint);
    }

    @Override
    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public Endpoint getEndpoint(InetSocketAddress address) {
        Endpoint endpoint = null;
        for (Endpoint ep : this.endpoints) {
            if (!ep.getAddress().equals(address)) continue;
            endpoint = ep;
            break;
        }
        return endpoint;
    }

    @Override
    public Endpoint getEndpoint(int port) {
        Endpoint endpoint = null;
        for (Endpoint ep : this.endpoints) {
            if (ep.getAddress().getPort() != port) continue;
            endpoint = ep;
        }
        return endpoint;
    }

    @Override
    public CoapServer add(Resource ... resources) {
        for (Resource r : resources) {
            this.root.add(r);
        }
        return this;
    }

    @Override
    public boolean remove(Resource resource) {
        return this.root.remove(resource);
    }

    public Resource getRoot() {
        return this.root;
    }

    protected Resource createRoot() {
        return new RootResource();
    }

    private class RootResource
    extends CoapResource {
        private static final String SPACE = "                                               ";
        private final String VERSION;
        private final String msg;

        public RootResource() {
            super("");
            this.VERSION = CoapServer.class.getPackage().getImplementationVersion() != null ? "Cf " + CoapServer.class.getPackage().getImplementationVersion() : SPACE;
            this.msg = "************************************************************\n" + "CoAP RFC 7252" + SPACE.substring(this.VERSION.length()) + this.VERSION + "\n" + "************************************************************\n" + "This server is using the Californium (Cf) CoAP framework\n" + "published by the Eclipse Foundation under EPL+EDL:\n" + "http://www.eclipse.org/californium/\n" + "\n" + "(c) 2014, Institute for Pervasive Computing, ETH Zurich\n" + "Contact: Matthias Kovatsch <kovatsch@inf.ethz.ch>\n" + "************************************************************";
        }

        @Override
        public void handleGET(CoapExchange exchange) {
            exchange.respond(CoAP.ResponseCode.CONTENT, this.msg);
        }

        @Override
        public List<Endpoint> getEndpoints() {
            return CoapServer.this.getEndpoints();
        }
    }
}

