/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cose;

import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.nio.charset.StandardCharsets;
import org.eclipse.californium.cose.Attribute;
import org.eclipse.californium.cose.CoseException;
import org.eclipse.californium.cose.Encrypt0Message;
import org.eclipse.californium.cose.MessageTag;

public abstract class Message
extends Attribute {
    protected boolean emitTag = true;
    protected boolean emitContent = true;
    protected MessageTag messageTag = MessageTag.Unknown;
    protected byte[] rgbContent = null;

    public static Message DecodeFromBytes(byte[] rgbData) throws CoseException {
        return Message.DecodeFromBytes(rgbData, MessageTag.Unknown);
    }

    public static Message DecodeFromBytes(byte[] rgbData, MessageTag defaultTag) throws CoseException {
        Encrypt0Message msg;
        CBORObject messageObject = CBORObject.DecodeFromBytes(rgbData);
        if (messageObject.getType() != CBORType.Array) {
            throw new CoseException("Message is not a COSE security Message");
        }
        if (messageObject.isTagged()) {
            if (messageObject.getTagCount() != 1) {
                throw new CoseException("Malformed message - too many tags");
            }
            if (defaultTag == MessageTag.Unknown) {
                defaultTag = MessageTag.FromInt(messageObject.getMostInnerTag().ToInt32Unchecked());
            } else if (defaultTag != MessageTag.FromInt(messageObject.getMostInnerTag().ToInt32Unchecked())) {
                throw new CoseException("Passed in tag does not match actual tag");
            }
        }
        switch (defaultTag) {
            case Unknown: {
                throw new CoseException("Message was not tagged and no default tagging option given");
            }
            case Encrypt: 
            case MAC: 
            case MAC0: 
            case Sign1: 
            case Sign: {
                throw new CoseException("Message format not supported by this library");
            }
            case Encrypt0: {
                msg = new Encrypt0Message();
                break;
            }
            default: {
                throw new CoseException("Message is not recognized as a COSE security Object");
            }
        }
        ((Message)msg).DecodeFromCBORObject(messageObject);
        return msg;
    }

    public byte[] EncodeToBytes() throws CoseException {
        return this.EncodeToCBORObject().EncodeToBytes();
    }

    protected abstract void DecodeFromCBORObject(CBORObject var1) throws CoseException;

    protected abstract CBORObject EncodeCBORObject() throws CoseException;

    public CBORObject EncodeToCBORObject() throws CoseException {
        CBORObject obj = this.EncodeCBORObject();
        if (this.emitTag) {
            obj = CBORObject.FromObjectAndTag((Object)obj, this.messageTag.value);
        }
        return obj;
    }

    public byte[] GetContent() {
        return this.rgbContent;
    }

    public boolean HasContent() {
        return this.rgbContent != null;
    }

    public void SetContent(byte[] rgbData) {
        this.rgbContent = rgbData;
    }

    public void SetContent(String strData) {
        this.rgbContent = strData.getBytes(StandardCharsets.UTF_8);
    }
}

