/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.Mac;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloHandshakeMessage;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SignatureAlgorithmsExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.util.ListUtils;
import org.eclipse.californium.scandium.util.ServerNames;

@NoPublicAPI
public final class ClientHello
extends HelloHandshakeMessage {
    private static final int COOKIE_LENGTH_BITS = 8;
    private static final int CIPHER_SUITES_LENGTH_BITS = 16;
    private static final int COMPRESSION_METHODS_LENGTH_BITS = 8;
    private byte[] cookie;
    private final List<CipherSuite> supportedCipherSuites;
    private final List<CompressionMethod> compressionMethods;

    public ClientHello(ProtocolVersion version, List<CipherSuite> supportedCipherSuites, List<SignatureAndHashAlgorithm> supportedSignatureAndHashAlgorithms, List<CertificateType> supportedClientCertificateTypes, List<CertificateType> supportedServerCertificateTypes, List<XECDHECryptography.SupportedGroup> supportedGroups) {
        this(version, SessionId.emptySessionId(), supportedCipherSuites, supportedSignatureAndHashAlgorithms, supportedClientCertificateTypes, supportedServerCertificateTypes, supportedGroups);
    }

    public ClientHello(ProtocolVersion version, DTLSSession session, List<SignatureAndHashAlgorithm> supportedSignatureAndHashAlgorithms, List<CertificateType> supportedClientCertificateTypes, List<CertificateType> supportedServerCertificateTypes, List<XECDHECryptography.SupportedGroup> supportedGroups) {
        this(version, session.getSessionIdentifier(), Arrays.asList(session.getCipherSuite()), supportedSignatureAndHashAlgorithms, supportedClientCertificateTypes, supportedServerCertificateTypes, supportedGroups);
        this.addCompressionMethod(session.getCompressionMethod());
    }

    private ClientHello(ProtocolVersion version, SessionId sessionId, List<CipherSuite> supportedCipherSuites, List<SignatureAndHashAlgorithm> supportedSignatureAndHashAlgorithms, List<CertificateType> supportedClientCertificateTypes, List<CertificateType> supportedServerCertificateTypes, List<XECDHECryptography.SupportedGroup> supportedGroups) {
        super(version, sessionId);
        this.cookie = Bytes.EMPTY;
        this.supportedCipherSuites = new ArrayList<CipherSuite>();
        if (supportedCipherSuites != null) {
            this.supportedCipherSuites.addAll(supportedCipherSuites);
        }
        this.compressionMethods = new ArrayList<CompressionMethod>();
        if (CipherSuite.containsEccBasedCipherSuite(supportedCipherSuites)) {
            this.addExtension(new SupportedEllipticCurvesExtension(supportedGroups));
            this.addExtension(SupportedPointFormatsExtension.DEFAULT_POINT_FORMATS_EXTENSION);
        }
        if (!supportedSignatureAndHashAlgorithms.isEmpty()) {
            if (this.useCertificateTypeRawPublicKeyOnly(supportedClientCertificateTypes) && this.useCertificateTypeRawPublicKeyOnly(supportedServerCertificateTypes)) {
                List<CipherSuite.CertificateKeyAlgorithm> certificateKeyAlgorithms = CipherSuite.getCertificateKeyAlgorithms(supportedCipherSuites);
                supportedSignatureAndHashAlgorithms = SignatureAndHashAlgorithm.getCompatibleSignatureAlgorithms(supportedSignatureAndHashAlgorithms, certificateKeyAlgorithms);
            }
            this.addExtension(new SignatureAlgorithmsExtension(supportedSignatureAndHashAlgorithms));
        }
        if (CipherSuite.containsCipherSuiteRequiringCertExchange(supportedCipherSuites)) {
            if (this.useCertificateTypeExtension(supportedClientCertificateTypes)) {
                ClientCertificateTypeExtension clientCertificateType = new ClientCertificateTypeExtension(supportedClientCertificateTypes);
                this.addExtension(clientCertificateType);
            }
            if (this.useCertificateTypeExtension(supportedServerCertificateTypes)) {
                ServerCertificateTypeExtension serverCertificateType = new ServerCertificateTypeExtension(supportedServerCertificateTypes);
                this.addExtension(serverCertificateType);
            }
        }
    }

    private ClientHello(DatagramReader reader) throws HandshakeException {
        super(reader);
        this.cookie = reader.readVarBytes(8);
        int cipherSuitesLength = reader.read(16);
        DatagramReader rangeReader = reader.createRangeReader(cipherSuitesLength);
        this.supportedCipherSuites = CipherSuite.listFromReader(rangeReader);
        int compressionMethodsLength = reader.read(8);
        rangeReader = reader.createRangeReader(compressionMethodsLength);
        this.compressionMethods = CompressionMethod.listFromReader(rangeReader);
        this.extensions.readFrom(reader);
        ServerNameExtension extension = this.getServerNameExtension();
        if (extension != null && extension.getServerNames() == null) {
            throw new HandshakeException("ClientHello message contains empty ServerNameExtension", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECODE_ERROR));
        }
    }

    private boolean useCertificateTypeExtension(List<CertificateType> supportedCertificateTypes) {
        if (supportedCertificateTypes != null && !supportedCertificateTypes.isEmpty()) {
            return supportedCertificateTypes.size() > 1 || !supportedCertificateTypes.contains((Object)CertificateType.X_509);
        }
        return false;
    }

    private boolean useCertificateTypeRawPublicKeyOnly(List<CertificateType> supportedCertificateTypes) {
        if (supportedCertificateTypes != null && supportedCertificateTypes.size() == 1) {
            return supportedCertificateTypes.contains((Object)CertificateType.RAW_PUBLIC_KEY);
        }
        return false;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        this.writeHeader(writer);
        writer.writeVarBytes(this.cookie, 8);
        writer.write(this.supportedCipherSuites.size() * 16 / 8, 16);
        CipherSuite.listToWriter(writer, this.supportedCipherSuites);
        writer.write(this.compressionMethods.size(), 8);
        CompressionMethod.listToWriter(writer, this.compressionMethods);
        this.extensions.writeTo(writer);
        return writer.toByteArray();
    }

    public static ClientHello fromReader(DatagramReader reader) throws HandshakeException {
        return new ClientHello(reader);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder(super.toString(indent));
        String indentation = StringUtil.indentation(indent + 1);
        String indentation2 = StringUtil.indentation(indent + 2);
        sb.append(indentation).append("Cookie Length: ").append(this.cookie.length).append(" bytes").append(StringUtil.lineSeparator());
        if (this.cookie.length > 0) {
            sb.append(indentation).append("Cookie: ").append(StringUtil.byteArray2HexString(this.cookie)).append(StringUtil.lineSeparator());
        }
        sb.append(indentation).append("Cipher Suites (").append(this.supportedCipherSuites.size()).append(" suites, ").append(this.supportedCipherSuites.size() * 16 / 8).append(" bytes)").append(StringUtil.lineSeparator());
        for (CipherSuite cipher : this.supportedCipherSuites) {
            sb.append(indentation2).append("Cipher Suite: ").append((Object)cipher).append(StringUtil.lineSeparator());
        }
        sb.append(indentation).append("Compression Methods (").append(this.compressionMethods.size()).append(" methods, ").append(this.compressionMethods.size()).append(" bytes)").append(StringUtil.lineSeparator());
        for (CompressionMethod method : this.compressionMethods) {
            sb.append(indentation2).append("Compression Method: ").append((Object)method).append(StringUtil.lineSeparator());
        }
        sb.append(this.extensions.toString(indent + 1));
        return sb.toString();
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.CLIENT_HELLO;
    }

    @Override
    public int getMessageLength() {
        return 39 + this.sessionId.length() + this.cookie.length + this.supportedCipherSuites.size() * 16 / 8 + this.compressionMethods.size() + this.extensions.getLength();
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public boolean hasCookie() {
        return this.cookie.length > 0;
    }

    public void setCookie(byte[] cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie must not be null!");
        }
        if (cookie.length == 0) {
            throw new IllegalArgumentException("cookie must not be empty!");
        }
        this.cookie = Arrays.copyOf(cookie, cookie.length);
        this.fragmentChanged();
    }

    public void updateForCookie(Mac hmac) {
        byte[] rawMessage = this.toByteArray();
        int head = this.sessionId.length() + 32 + 3;
        int tail = head + 1 + 12;
        if (this.cookie != null) {
            tail += this.cookie.length;
        }
        hmac.update(rawMessage, 12, head);
        hmac.update(rawMessage, tail, rawMessage.length - tail);
    }

    public List<CipherSuite> getCipherSuites() {
        return Collections.unmodifiableList(this.supportedCipherSuites);
    }

    public List<CipherSuite> getCommonCipherSuites(List<CipherSuite> serverCipherSuite) {
        ArrayList<CipherSuite> common = new ArrayList<CipherSuite>();
        for (CipherSuite cipherSuite : this.supportedCipherSuites) {
            if (!cipherSuite.isValidForNegotiation() || !serverCipherSuite.contains((Object)cipherSuite)) continue;
            common.add(cipherSuite);
        }
        return common;
    }

    public List<CompressionMethod> getCompressionMethods() {
        return Collections.unmodifiableList(this.compressionMethods);
    }

    public void setCompressionMethods(List<CompressionMethod> compressionMethods) {
        ListUtils.addIfAbsent(this.compressionMethods, compressionMethods);
    }

    public void addCompressionMethod(CompressionMethod compressionMethod) {
        ListUtils.addIfAbsent(this.compressionMethods, compressionMethod);
    }

    public ServerNames getServerNames() {
        ServerNameExtension extension = this.getServerNameExtension();
        return extension == null ? null : extension.getServerNames();
    }

    public SupportedEllipticCurvesExtension getSupportedEllipticCurvesExtension() {
        return (SupportedEllipticCurvesExtension)this.extensions.getExtension(HelloExtension.ExtensionType.ELLIPTIC_CURVES);
    }
}

