/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.unixhealth;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.util.CounterStatisticManager;
import org.eclipse.californium.elements.util.NotForAndroid;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotForAndroid
public class NetStatLogger
extends CounterStatisticManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger(NetStatLogger.class);
    protected final SimpleCounterStatistic sent;
    protected final SimpleCounterStatistic received;
    protected final SimpleCounterStatistic sendBufferErrors;
    protected final SimpleCounterStatistic receiveBufferErrors;
    protected final SimpleCounterStatistic inErrors;
    protected final SimpleCounterStatistic inChecksumErrors;
    protected final SimpleCounterStatistic noPorts;
    private final File file;
    private final Parser parser;

    public NetStatLogger(String tag) {
        this(tag, false);
    }

    public NetStatLogger(String tag, boolean ipv6) {
        super(tag);
        this.sent = new SimpleCounterStatistic("OutDatagrams", this.align);
        this.received = new SimpleCounterStatistic("InDatagrams", this.align);
        this.sendBufferErrors = new SimpleCounterStatistic("SndbufErrors", this.align);
        this.receiveBufferErrors = new SimpleCounterStatistic("RcvbufErrors", this.align);
        this.inErrors = new SimpleCounterStatistic("InErrors", this.align);
        this.inChecksumErrors = new SimpleCounterStatistic("InCsumErrors", this.align);
        this.noPorts = new SimpleCounterStatistic("NoPorts", this.align);
        this.parser = ipv6 ? new SnmpIPv6Parser() : new SnmpIPv4Parser();
        this.file = NetStatLogger.getFile(ipv6);
        if (this.isEnabled()) {
            this.init();
        }
    }

    public NetStatLogger(String tag, int interval, TimeUnit unit, ScheduledExecutorService executor) {
        super(tag, interval, unit, executor);
        this.sent = new SimpleCounterStatistic("OutDatagrams", this.align);
        this.received = new SimpleCounterStatistic("InDatagrams", this.align);
        this.sendBufferErrors = new SimpleCounterStatistic("SndbufErrors", this.align);
        this.receiveBufferErrors = new SimpleCounterStatistic("RcvbufErrors", this.align);
        this.inErrors = new SimpleCounterStatistic("InErrors", this.align);
        this.inChecksumErrors = new SimpleCounterStatistic("InCsumErrors", this.align);
        this.noPorts = new SimpleCounterStatistic("NoPorts", this.align);
        this.parser = new SnmpIPv4Parser();
        this.file = NetStatLogger.getFile(false);
        if (this.isEnabled()) {
            this.init();
        }
    }

    private void init() {
        this.add(this.sent);
        this.add(this.received);
        this.add(this.sendBufferErrors);
        this.add(this.receiveBufferErrors);
        this.add(this.inErrors);
        this.add(this.inChecksumErrors);
        this.add(this.noPorts);
        this.read();
        this.reset();
    }

    @Override
    public boolean isEnabled() {
        return LOGGER.isInfoEnabled() && this.file.canRead();
    }

    @Override
    public void dump() {
        if (this.isEnabled()) {
            this.read();
            if (LOGGER.isDebugEnabled()) {
                try {
                    if (this.sent.isUsed() || this.received.isUsed() || this.sendBufferErrors.isUsed() || this.receiveBufferErrors.isUsed()) {
                        String eol = StringUtil.lineSeparator();
                        String head = "   " + this.tag;
                        StringBuilder log = new StringBuilder();
                        log.append(this.tag).append("network statistic:").append(eol);
                        log.append(head).append(this.sent).append(eol);
                        log.append(head).append(this.received).append(eol);
                        log.append(head).append(this.sendBufferErrors).append(eol);
                        log.append(head).append(this.receiveBufferErrors).append(eol);
                        log.append(head).append(this.inErrors).append(eol);
                        log.append(head).append(this.inChecksumErrors).append(eol);
                        log.append(head).append(this.noPorts);
                        LOGGER.debug("{}", (Object)log);
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("{}", (Object)this.tag, (Object)e);
                }
            }
            this.transferCounter();
        }
    }

    private void read() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.file));){
            String line;
            this.parser.start();
            while ((line = reader.readLine()) != null && !this.parser.parse(line.trim())) {
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("{} missing!", (Object)this.file.getAbsolutePath(), (Object)e);
        }
        catch (IOException e) {
            LOGGER.warn("{} error!", (Object)this.file.getAbsolutePath(), (Object)e);
        }
    }

    private static File getFile(boolean ipv6) {
        String path = "/proc/net/snmp";
        if (ipv6) {
            path = path + "6";
        }
        LOGGER.info("File: {}", (Object)path);
        return new File(path);
    }

    private class SnmpIPv6Parser
    implements Parser {
        private SnmpIPv6Parser() {
        }

        @Override
        public void start() {
        }

        @Override
        public boolean parse(String line) {
            String name;
            SimpleCounterStatistic statistic;
            String[] fields;
            if (line.startsWith("Udp6") && (fields = line.split("\\s+")).length == 2 && (statistic = NetStatLogger.this.getByKey(name = fields[0].substring(4))) != null) {
                try {
                    long current = Long.parseLong(fields[1].trim());
                    statistic.set(current);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private class SnmpIPv4Parser
    implements Parser {
        String heads;

        private SnmpIPv4Parser() {
        }

        @Override
        public void start() {
            this.heads = null;
        }

        @Override
        public boolean parse(String line) {
            if (this.heads == null) {
                if (line.startsWith("Udp: ")) {
                    this.heads = line;
                }
                return false;
            }
            String[] headFields = this.heads.split("\\s+");
            String[] valueFields = line.split("\\s+");
            for (int index = 1; index < headFields.length; ++index) {
                SimpleCounterStatistic statistic = NetStatLogger.this.getByKey(headFields[index]);
                if (statistic == null) continue;
                try {
                    long current = Long.parseLong(valueFields[index]);
                    statistic.set(current);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    private static interface Parser {
        public void start();

        public boolean parse(String var1);
    }
}

