/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServersSerializationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServersSerializationUtil.class);
    private List<CoapServer> servers = new CopyOnWriteArrayList<CoapServer>();

    public void add(CoapServer server) {
        this.servers.add(server);
    }

    public void loadServers(InputStream in) {
        ServersSerializationUtil.loadServers(in, this.servers);
    }

    public void saveServers(OutputStream out, long maxQuietPeriodInSeconds) throws IOException {
        ServersSerializationUtil.saveServers(out, maxQuietPeriodInSeconds, this.servers);
    }

    public void start() {
        for (CoapServer server : this.servers) {
            server.start();
        }
    }

    public void stop() {
        for (CoapServer server : this.servers) {
            server.stop();
        }
    }

    public void destroy() {
        for (CoapServer server : this.servers) {
            server.destroy();
        }
    }

    public static int loadServers(InputStream in, CoapServer ... servers) {
        return ServersSerializationUtil.loadServers(in, Arrays.asList(servers));
    }

    public static int loadServers(InputStream in, List<CoapServer> servers) {
        int count = 0;
        long time = System.nanoTime();
        try {
            CoapServer.ConnectorIdentifier id;
            DataStreamReader reader = new DataStreamReader(in);
            long delta = SerializationUtil.readNanotimeSynchronizationMark(reader);
            while ((id = CoapServer.readConnectorIdentifier(in)) != null) {
                boolean foundTag = false;
                int loaded = -1;
                for (CoapServer server : servers) {
                    if (!id.tag.equals(server.getTag())) continue;
                    foundTag = true;
                    loaded = server.loadConnector(id, in, delta);
                    if (loaded < 0) continue;
                    count += loaded;
                    break;
                }
                if (foundTag) {
                    if (loaded < 0) {
                        LOGGER.warn("{}loading {} failed, no connector in {} servers!", id.tag, id.uri, servers.size());
                        SerializationUtil.skipItems(in, 16);
                        continue;
                    }
                    LOGGER.info("{}loading {}, {} connections, {} servers.", id.tag, id.uri, loaded, servers.size());
                    continue;
                }
                SerializationUtil.skipItems(in, 16);
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("loading failed:", e);
        }
        catch (IOException e) {
            LOGGER.warn("loading failed:", e);
        }
        time = System.nanoTime() - time;
        LOGGER.info("load: {} ms, {} connections", (Object)TimeUnit.NANOSECONDS.toMillis(time), (Object)count);
        return count;
    }

    public static int saveServers(OutputStream out, long maxQuietPeriodInSeconds, CoapServer ... servers) throws IOException {
        return ServersSerializationUtil.saveServers(out, maxQuietPeriodInSeconds, Arrays.asList(servers));
    }

    public static int saveServers(OutputStream out, long maxQuietPeriodInSeconds, List<CoapServer> servers) throws IOException {
        int count = 0;
        for (CoapServer server : servers) {
            server.stop();
        }
        long start = System.nanoTime();
        DatagramWriter writer = new DatagramWriter();
        SerializationUtil.writeNanotimeSynchronizationMark(writer);
        writer.writeTo(out);
        for (CoapServer server : servers) {
            count += server.saveAllConnectors(out, maxQuietPeriodInSeconds);
        }
        SerializationUtil.write(writer, null, 8);
        writer.writeTo(out);
        long time = System.nanoTime() - start;
        LOGGER.info("save: {} ms, {} connections", (Object)TimeUnit.NANOSECONDS.toMillis(time), (Object)count);
        return count;
    }
}

