/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpAdaptionLayer
extends AbstractLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpAdaptionLayer.class);

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        if (message.isConfirmable()) {
            this.lower().sendEmptyMessage(exchange, message);
        } else if (exchange != null) {
            LOGGER.warn("attempting to send empty message ({}) in TCP mode {}", message, exchange, new Throwable());
        } else {
            LOGGER.warn("attempting to send empty message ({}) in TCP mode.", (Object)message, (Object)new Throwable());
        }
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        request.setAcknowledged(true);
        this.upper().receiveRequest(exchange, request);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        response.setAcknowledged(true);
        this.upper().receiveResponse(exchange, response);
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        LOGGER.info("discarding empty message received in TCP mode: {}", (Object)message);
    }
}

