/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.io.ByteArrayInputStream;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.serialization.UdpDataParser;
import org.eclipse.californium.cose.Encrypt0Message;
import org.eclipse.californium.cose.HeaderKeys;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.oscore.CoapOSException;
import org.eclipse.californium.oscore.ContextRederivation;
import org.eclipse.californium.oscore.Decryptor;
import org.eclipse.californium.oscore.OSCoreCtx;
import org.eclipse.californium.oscore.OSCoreCtxDB;
import org.eclipse.californium.oscore.OSCoreEndpointContextInfo;
import org.eclipse.californium.oscore.OSException;
import org.eclipse.californium.oscore.OptionJuggle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDecryptor
extends Decryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestDecryptor.class);

    public static Request decrypt(OSCoreCtxDB db, Request request, OSCoreCtx ctx) throws CoapOSException {
        byte[] plaintext;
        Encrypt0Message enc;
        RequestDecryptor.discardEOptions(request);
        byte[] protectedData = request.getPayload();
        OptionSet uOptions = request.getOptions();
        try {
            enc = RequestDecryptor.decompression(protectedData, request);
        }
        catch (OSException e) {
            LOGGER.error("Failed to decode COSE");
            throw new CoapOSException("Failed to decode COSE", CoAP.ResponseCode.BAD_OPTION);
        }
        CBORObject kid = enc.findAttribute(HeaderKeys.KID);
        if (kid == null || !kid.getType().equals((Object)CBORType.ByteString)) {
            LOGGER.error("KID is missing");
            throw new CoapOSException("Failed to decode COSE", CoAP.ResponseCode.BAD_OPTION);
        }
        byte[] rid = kid.GetByteString();
        CBORObject kidContext = enc.findAttribute(CBORObject.FromObject(10));
        byte[] contextID = null;
        if (kidContext != null) {
            contextID = kidContext.GetByteString();
        }
        try {
            ctx = ContextRederivation.incomingRequest(db, ctx, contextID, rid);
        }
        catch (OSException e) {
            LOGGER.error("Security context re-generation failed");
            throw new CoapOSException("Security context re-generation failed", CoAP.ResponseCode.BAD_REQUEST);
        }
        if (ctx == null) {
            LOGGER.error("Security context not found");
            throw new CoapOSException("Security context not found", CoAP.ResponseCode.UNAUTHORIZED);
        }
        try {
            plaintext = RequestDecryptor.decryptAndDecode(enc, request, ctx, null);
        }
        catch (OSException e) {
            if (e.getMessage().equals("Replay detected")) {
                LOGGER.error("Replay detected");
                throw new CoapOSException("Replay detected", CoAP.ResponseCode.UNAUTHORIZED);
            }
            LOGGER.error("Decryption failed");
            throw new CoapOSException("Decryption failed", CoAP.ResponseCode.BAD_REQUEST);
        }
        try {
            DatagramReader reader = new DatagramReader(new ByteArrayInputStream(plaintext));
            ctx.setCoAPCode(CoAP.Code.valueOf(reader.read(8)));
            request.setOptions(EMPTY);
            new UdpDataParser().parseOptionsAndPayload(reader, request);
        }
        catch (Exception e) {
            LOGGER.error("Decryption failed");
            throw new CoapOSException("Decryption failed", CoAP.ResponseCode.BAD_REQUEST);
        }
        OptionSet eOptions = request.getOptions();
        eOptions = OptionJuggle.merge(eOptions, uOptions);
        request.setOptions(eOptions);
        request.getOptions().setOscore(rid);
        db.addContext(request.getToken(), ctx);
        OSCoreEndpointContextInfo.receivingRequest(ctx, request);
        return OptionJuggle.setRealCodeRequest(request, ctx.getCoAPCode());
    }
}

