/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import com.upokecenter.cbor.CBORObject;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.cose.AlgorithmID;
import org.eclipse.californium.cose.CoseException;
import org.eclipse.californium.cose.EncryptCommon;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.oscore.ContextRederivation;
import org.eclipse.californium.oscore.OSException;
import org.eclipse.californium.scandium.dtls.cipher.CCMBlockCipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSCoreCtx {
    private static final Logger LOGGER;
    private static final byte ZERO = 0;
    private static final byte ONE = 1;
    private AlgorithmID common_alg;
    private byte[] common_master_secret;
    private byte[] common_master_salt;
    private byte[] common_iv;
    private byte[] context_id;
    private byte[] sender_id;
    private byte[] sender_key;
    private int sender_seq;
    private byte[] recipient_id;
    private byte[] recipient_key;
    private int lowest_recipient_seq;
    private int recipient_replay_window_size;
    private int recipient_replay_window;
    private AlgorithmID kdf;
    private int seqMax = Integer.MAX_VALUE;
    private int id_length;
    private int iv_length;
    private int key_length;
    private CoAP.Code CoAPCode = null;
    private boolean includeContextId;
    private boolean responsesIncludePartialIV;
    private boolean contextRederivationEnabled;
    private int maxUnfragmentedSize;
    private String uri;
    private final String contextIdString;
    private final String senderIdString;
    private final String recipientIdString;
    private byte[] contextRederivationKey;
    private byte[] overrideContextId;
    private ContextRederivation.PHASE contextRederivationPhase;
    private byte[] nonceHandover;

    public OSCoreCtx(byte[] master_secret, boolean client) throws OSException {
        this(master_secret, client, Configuration.getStandard());
    }

    public OSCoreCtx(byte[] master_secret, boolean client, Configuration configuration) throws OSException {
        this(master_secret, client, null, null, null, null, null, null, null, configuration.get(CoapConfig.MAX_RESOURCE_BODY_SIZE));
    }

    public OSCoreCtx(byte[] master_secret, boolean client, AlgorithmID alg, byte[] sender_id, byte[] recipient_id, AlgorithmID kdf, Integer replay_size, byte[] master_salt, byte[] contextId, int maxUnfragmentedSize) throws OSException {
        this.common_alg = alg == null ? AlgorithmID.AES_CCM_16_64_128 : alg;
        this.setLengths();
        this.sender_seq = 0;
        this.lowest_recipient_seq = 0;
        if (master_secret == null) {
            LOGGER.error("Input master secret is null");
            throw new NullPointerException("Input master secret is null");
        }
        this.common_master_secret = (byte[])master_secret.clone();
        this.sender_id = sender_id == null || sender_id.length > this.id_length ? OSCoreCtx.createByteArray(client ? (byte)0 : 1) : (byte[])sender_id.clone();
        this.recipient_id = recipient_id == null || recipient_id.length > this.id_length ? OSCoreCtx.createByteArray(client ? (byte)1 : 0) : (byte[])recipient_id.clone();
        this.kdf = kdf == null ? AlgorithmID.HKDF_HMAC_SHA_256 : kdf;
        if (replay_size == null) {
            this.recipient_replay_window_size = 32;
        } else if (replay_size > 32) {
            LOGGER.warn("Maximum size of replay window is 32. Setting to 32.");
            this.recipient_replay_window_size = 32;
        } else {
            this.recipient_replay_window_size = replay_size;
        }
        this.recipient_replay_window = 0;
        this.common_master_salt = master_salt == null ? new byte[this.kdf.getKeySize() / 8] : (byte[])master_salt.clone();
        this.context_id = (byte[])(contextId != null ? (byte[])contextId.clone() : null);
        this.includeContextId = false;
        this.responsesIncludePartialIV = false;
        this.contextRederivationEnabled = false;
        this.contextIdString = this.toHex(this.context_id);
        this.senderIdString = this.toHex(this.sender_id);
        this.recipientIdString = this.toHex(this.recipient_id);
        this.uri = "";
        this.overrideContextId = null;
        this.contextRederivationPhase = ContextRederivation.PHASE.INACTIVE;
        this.maxUnfragmentedSize = maxUnfragmentedSize;
        String digest = null;
        switch (this.kdf) {
            case HKDF_HMAC_SHA_256: {
                digest = "SHA256";
                break;
            }
            case HKDF_HMAC_SHA_512: {
                digest = "SHA512";
                break;
            }
            default: {
                LOGGER.error("Requested HKDF algorithm is not supported: {}", (Object)this.kdf);
                throw new OSException("HKDF algorithm not supported");
            }
        }
        CBORObject info = CBORObject.NewArray();
        info.Add(this.sender_id);
        info.Add(this.context_id);
        info.Add(this.common_alg.AsCBOR());
        info.Add(CBORObject.FromObject("Key"));
        info.Add(this.key_length);
        try {
            this.sender_key = OSCoreCtx.deriveKey(this.common_master_secret, this.common_master_salt, this.key_length, digest, info.EncodeToBytes());
        }
        catch (CoseException e) {
            String details = e.getMessage();
            LOGGER.error(details);
            throw new OSException(details);
        }
        info = CBORObject.NewArray();
        info.Add(this.recipient_id);
        info.Add(this.context_id);
        info.Add(this.common_alg.AsCBOR());
        info.Add(CBORObject.FromObject("Key"));
        info.Add(this.key_length);
        try {
            this.recipient_key = OSCoreCtx.deriveKey(this.common_master_secret, this.common_master_salt, this.key_length, digest, info.EncodeToBytes());
        }
        catch (CoseException e) {
            String details = e.getMessage();
            LOGGER.error(details);
            throw new OSException(details);
        }
        info = CBORObject.NewArray();
        info.Add(Bytes.EMPTY);
        info.Add(this.context_id);
        info.Add(this.common_alg.AsCBOR());
        info.Add(CBORObject.FromObject("IV"));
        info.Add(this.iv_length);
        try {
            this.common_iv = OSCoreCtx.deriveKey(this.common_master_secret, this.common_master_salt, this.iv_length, digest, info.EncodeToBytes());
        }
        catch (CoseException e) {
            String details = e.getMessage();
            LOGGER.error(details);
            throw new OSException(details);
        }
        this.initializeCipher(this.common_alg);
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.sender_id) + Arrays.hashCode(this.recipient_id);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OSCoreCtx)) {
            return false;
        }
        OSCoreCtx other = (OSCoreCtx)o;
        return Arrays.equals(other.sender_id, this.sender_id) && Arrays.equals(other.recipient_id, this.recipient_id);
    }

    public byte[] getSenderKey() {
        return this.sender_key;
    }

    public byte[] getRecipientKey() {
        return this.recipient_key;
    }

    public AlgorithmID getAlg() {
        return this.common_alg;
    }

    public synchronized int getSenderSeq() {
        return this.sender_seq;
    }

    public synchronized int getLowestRecipientSeq() {
        return this.lowest_recipient_seq;
    }

    public byte[] getSenderId() {
        return this.sender_id;
    }

    public byte[] getRecipientId() {
        return this.recipient_id;
    }

    public byte[] getCommonIV() {
        return this.common_iv;
    }

    public int getIVLength() {
        return this.iv_length;
    }

    public int getRecipientReplaySize() {
        return this.recipient_replay_window_size;
    }

    public int getRecipientReplayWindow() {
        return this.recipient_replay_window;
    }

    public byte[] getMasterSecret() {
        return this.common_master_secret;
    }

    public byte[] getSalt() {
        return this.common_master_salt;
    }

    public AlgorithmID getKdf() {
        return this.kdf;
    }

    public byte[] getIdContext() {
        return this.context_id;
    }

    public byte[] getMessageIdContext() {
        if (this.overrideContextId != null) {
            return this.overrideContextId;
        }
        return this.context_id;
    }

    public boolean getIncludeContextId() {
        return this.includeContextId;
    }

    public void setIncludeContextId(boolean includeContextId) {
        if (this.context_id == null && this.overrideContextId == null) {
            LOGGER.error("Context ID cannot be included for a context without one set.");
            throw new IllegalStateException("Context ID cannot be included for a context without one set.");
        }
        if (!includeContextId) {
            this.overrideContextId = null;
        }
        this.includeContextId = includeContextId;
    }

    public void setIncludeContextId(byte[] overrideContextId) {
        this.overrideContextId = (byte[])overrideContextId.clone();
        this.setIncludeContextId(true);
    }

    public boolean getResponsesIncludePartialIV() {
        return this.responsesIncludePartialIV;
    }

    public void setResponsesIncludePartialIV(boolean responsesIncludePartialIV) {
        this.responsesIncludePartialIV = responsesIncludePartialIV;
    }

    public boolean getContextRederivationEnabled() {
        return this.contextRederivationEnabled;
    }

    public void setContextRederivationEnabled(boolean contextRederivationEnabled) {
        this.contextRederivationEnabled = contextRederivationEnabled;
    }

    public int getMaxUnfragmentedSize() {
        return this.maxUnfragmentedSize;
    }

    public void setMaxUnfragmentedSize(int maxUnfragmentedSize) {
        this.maxUnfragmentedSize = maxUnfragmentedSize;
    }

    public String getContextIdString() {
        return this.contextIdString;
    }

    public String getSenderIdString() {
        return this.senderIdString;
    }

    public String getRecipientIdString() {
        return this.recipientIdString;
    }

    public synchronized void setSenderSeq(int seq) {
        this.sender_seq = seq;
    }

    public synchronized void setRecipientSeq(int seq) {
        this.lowest_recipient_seq = seq;
    }

    public synchronized void setRecipientReplayWindow(int window) {
        this.recipient_replay_window = window;
    }

    public void setSenderKey(byte[] senderKey) {
        this.sender_key = (byte[])senderKey.clone();
    }

    public void setRecipientKey(byte[] recipientKey) {
        this.recipient_key = (byte[])recipientKey.clone();
    }

    public void setSeqMax(int seqMax) {
        this.seqMax = seqMax;
    }

    private void setLengths() {
        if (this.common_alg != null) {
            this.iv_length = EncryptCommon.ivLength(this.common_alg);
            if (this.iv_length <= 0) {
                LOGGER.error("Unable to set lengths, since algorithm");
                throw new RuntimeException("Unable to set lengths, since algorithm");
            }
        } else {
            LOGGER.error("Common_alg has not yet been initiated.");
            throw new RuntimeException("Common_alg has not yet been initiated.");
        }
        this.id_length = this.iv_length - 6;
        this.key_length = this.common_alg.getKeySize() / 8;
    }

    public String getUri() {
        return this.uri;
    }

    protected void setUri(String uri) {
        this.uri = uri;
    }

    protected byte[] getContextRederivationKey() {
        return this.contextRederivationKey;
    }

    protected void setContextRederivationKey(byte[] contextRederivationKey) {
        this.contextRederivationKey = contextRederivationKey;
    }

    public ContextRederivation.PHASE getContextRederivationPhase() {
        return this.contextRederivationPhase;
    }

    public void setContextRederivationPhase(ContextRederivation.PHASE contextRederivationPhase) {
        this.contextRederivationPhase = contextRederivationPhase;
    }

    public synchronized void increaseSenderSeq() throws OSException {
        if (this.sender_seq >= this.seqMax) {
            LOGGER.error("Sequence number wrapped, get a new OSCore context");
            throw new OSException("Sequence number wrapped");
        }
        ++this.sender_seq;
    }

    public synchronized void checkIncomingSeq(int seq) throws OSException {
        if (seq >= this.seqMax) {
            LOGGER.error("Sequence number wrapped, get new OSCore context");
            throw new OSException("Replay detected");
        }
        if (seq < this.lowest_recipient_seq) {
            LOGGER.error("Message too old");
            throw new OSException("Replay detected");
        }
        boolean valid = false;
        if (seq >= this.lowest_recipient_seq + this.recipient_replay_window_size) {
            valid = true;
        } else {
            boolean bl = valid = (this.recipient_replay_window >> seq - this.lowest_recipient_seq & 1) == 0;
        }
        if (!valid) {
            LOGGER.error("Replayed message detected");
            throw new OSException("Replay detected");
        }
        int shift = seq - (this.lowest_recipient_seq + this.recipient_replay_window_size - 1);
        if (shift > 0) {
            this.recipient_replay_window >>= shift;
            this.lowest_recipient_seq += shift;
        }
        this.recipient_replay_window |= 1 << seq - this.lowest_recipient_seq;
    }

    protected static byte[] deriveKey(byte[] secret, byte[] salt, int cbitKey, String digest, byte[] rgbContext) throws CoseException {
        String HMAC_ALG_NAME = "Hmac" + digest;
        try {
            Mac hmac = Mac.getInstance(HMAC_ALG_NAME);
            int hashLen = hmac.getMacLength();
            hmac.init(new SecretKeySpec(salt, HMAC_ALG_NAME));
            byte[] rgbExtract = hmac.doFinal(secret);
            hmac.init(new SecretKeySpec(rgbExtract, HMAC_ALG_NAME));
            int c = ((cbitKey + 7) / 8 + hashLen - 1) / hashLen;
            byte[] rgbOut = new byte[cbitKey];
            byte[] T = new byte[hashLen * c];
            byte[] last = new byte[]{};
            for (int i = 0; i < c; ++i) {
                hmac.reset();
                hmac.update(last);
                hmac.update(rgbContext);
                hmac.update((byte)(i + 1));
                last = hmac.doFinal();
                System.arraycopy(last, 0, T, i * hashLen, hashLen);
            }
            System.arraycopy(T, 0, rgbOut, 0, cbitKey);
            return rgbOut;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Derivation failure", ex);
        }
    }

    private String toHex(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        return StringUtil.byteArray2Hex(bytes);
    }

    public CoAP.Code getCoAPCode() {
        return this.CoAPCode;
    }

    public void setCoAPCode(CoAP.Code coapCode) {
        if (coapCode != null) {
            this.CoAPCode = coapCode;
        }
    }

    private void initializeCipher(AlgorithmID alg) {
        switch (alg) {
            case AES_CCM_16_64_128: 
            case AES_CCM_16_128_128: 
            case AES_CCM_64_64_128: 
            case AES_CCM_64_128_128: {
                byte[] key = new byte[]{-21, -34, -68, 81, -15, 3, 121, 20, 20, 79, -61, -84, 64, 20, -46, 76};
                byte[] nonce = new byte[]{0, 0, 0, 0, 0, 0, 0};
                try {
                    CCMBlockCipher.encrypt(new SecretKeySpec(key, "AES"), nonce, Bytes.EMPTY, Bytes.EMPTY, 0);
                    break;
                }
                catch (GeneralSecurityException e) {
                    LOGGER.error("Failed to initialize cipher.");
                    throw new RuntimeException("Failed to initialize cipher.");
                }
            }
        }
    }

    private static byte[] createByteArray(byte ... values) {
        return values;
    }

    protected void setNonceHandover(byte[] nonce) {
        this.nonceHandover = nonce;
    }

    protected byte[] getNonceHandover() {
        return this.nonceHandover;
    }

    static {
        CoapConfig.register();
        UdpConfig.register();
        LOGGER = LoggerFactory.getLogger(OSCoreCtx.class);
    }
}

