/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.ValueException;

public class LongDefinition
extends BasicDefinition<Long> {
    private final Long minimumValue;

    public LongDefinition(String key, String documentation) {
        super(key, documentation, Long.class);
        this.minimumValue = null;
    }

    public LongDefinition(String key, String documentation, Long defaultValue) {
        super(key, documentation, Long.class, defaultValue);
        this.minimumValue = null;
    }

    public LongDefinition(String key, String documentation, Long defaultValue, Long minimumValue) {
        super(key, documentation, Long.class, defaultValue);
        this.minimumValue = minimumValue;
    }

    @Override
    public String getTypeName() {
        return "Long";
    }

    @Override
    public String writeValue(Long value) {
        return value.toString();
    }

    @Override
    public Long checkValue(Long value) throws ValueException {
        if (this.minimumValue != null && value != null && value < this.minimumValue) {
            throw new ValueException("Value " + value + " must be not less than " + this.minimumValue + "!");
        }
        return value;
    }

    @Override
    protected Long parseValue(String value) {
        return Long.parseLong(value);
    }
}

