/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.DTLSConnectionState;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.cipher.AeadBlockCipher;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.SecretIvParameterSpec;
import org.eclipse.californium.scandium.util.SecretSerializationUtil;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtlsAeadConnectionState
extends DTLSConnectionState {
    private static final Logger LOGGER = LoggerFactory.getLogger(DtlsAeadConnectionState.class);
    private final SecretKey encryptionKey;
    private final SecretIvParameterSpec iv;

    DtlsAeadConnectionState(CipherSuite cipherSuite, CompressionMethod compressionMethod, SecretKey encryptionKey, SecretIvParameterSpec iv) {
        super(cipherSuite, compressionMethod);
        if (encryptionKey == null) {
            throw new NullPointerException("Encryption key must not be null!");
        }
        if (iv == null) {
            throw new NullPointerException("IV must not be null!");
        }
        this.encryptionKey = SecretUtil.create(encryptionKey);
        this.iv = SecretUtil.createIv(iv);
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.encryptionKey);
        SecretUtil.destroy(this.iv);
    }

    @Override
    public boolean isDestroyed() {
        return SecretUtil.isDestroyed(this.iv) && SecretUtil.isDestroyed(this.encryptionKey);
    }

    @Override
    public byte[] encrypt(Record record, byte[] fragment) throws GeneralSecurityException {
        DatagramWriter writer = new DatagramWriter(12, true);
        this.iv.writeTo(writer);
        record.writeExplicitNonce(writer);
        byte[] nonce = writer.toByteArray();
        byte[] additionalData = record.generateAdditionalData(fragment.length);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("encrypt: {} bytes", (Object)fragment.length);
            LOGGER.trace("nonce: {}", (Object)StringUtil.byteArray2HexString(nonce));
            LOGGER.trace("adata: {}", (Object)StringUtil.byteArray2HexString(additionalData));
        }
        byte[] encryptedFragment = AeadBlockCipher.encrypt(this.cipherSuite, this.encryptionKey, nonce, additionalData, fragment);
        System.arraycopy(nonce, this.cipherSuite.getFixedIvLength(), encryptedFragment, 0, this.cipherSuite.getRecordIvLength());
        Bytes.clear(nonce);
        LOGGER.trace("==> {} bytes", (Object)encryptedFragment.length);
        return encryptedFragment;
    }

    @Override
    public byte[] decrypt(Record record, byte[] ciphertextFragment) throws GeneralSecurityException {
        if (ciphertextFragment == null) {
            throw new NullPointerException("Ciphertext must not be null");
        }
        int recordIvLength = this.cipherSuite.getRecordIvLength();
        int applicationDataLength = ciphertextFragment.length - recordIvLength - this.cipherSuite.getMacLength();
        if (applicationDataLength <= 0) {
            throw new GeneralSecurityException("Ciphertext too short!");
        }
        byte[] additionalData = record.generateAdditionalData(applicationDataLength);
        DatagramWriter writer = new DatagramWriter(12, true);
        this.iv.writeTo(writer);
        writer.writeBytes(ciphertextFragment, 0, recordIvLength);
        byte[] nonce = writer.toByteArray();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("decrypt: {} bytes", (Object)applicationDataLength);
            LOGGER.trace("nonce: {}", (Object)StringUtil.byteArray2HexString(nonce));
            LOGGER.trace("adata: {}", (Object)StringUtil.byteArray2HexString(additionalData));
        }
        if (LOGGER.isDebugEnabled() && "AES/CCM".equals(this.cipherSuite.getTransformation())) {
            byte[] explicitNonceUsed = Arrays.copyOf(ciphertextFragment, recordIvLength);
            record.writeExplicitNonce(writer);
            byte[] explicitNonce = writer.toByteArray();
            if (!Arrays.equals(explicitNonce, explicitNonceUsed)) {
                StringBuilder b = new StringBuilder("The explicit nonce used by the sender does not match the values provided in the DTLS record");
                b.append(StringUtil.lineSeparator()).append("Used    : ").append(StringUtil.byteArray2HexString(explicitNonceUsed));
                b.append(StringUtil.lineSeparator()).append("Expected: ").append(StringUtil.byteArray2HexString(explicitNonce));
                LOGGER.debug(b.toString());
            }
        }
        byte[] payload = AeadBlockCipher.decrypt(this.cipherSuite, this.encryptionKey, nonce, additionalData, ciphertextFragment, recordIvLength, ciphertextFragment.length - recordIvLength);
        Bytes.clear(nonce);
        return payload;
    }

    public final String toString() {
        StringBuilder b = new StringBuilder("DtlsAeadConnectionState:");
        b.append(StringUtil.lineSeparator()).append("\tCipher suite: ").append((Object)this.cipherSuite);
        b.append(StringUtil.lineSeparator()).append("\tCompression method: ").append((Object)this.compressionMethod);
        b.append(StringUtil.lineSeparator()).append("\tIV: ").append(this.iv == null ? "null" : "not null");
        b.append(StringUtil.lineSeparator()).append("\tEncryption key: ").append(this.encryptionKey == null ? "null" : "not null");
        return b.toString();
    }

    @Override
    public void writeTo(DatagramWriter writer) {
        SecretSerializationUtil.write(writer, this.encryptionKey);
        SecretSerializationUtil.write(writer, this.iv);
    }

    DtlsAeadConnectionState(CipherSuite cipherSuite, CompressionMethod compressionMethod, DatagramReader reader) {
        super(cipherSuite, compressionMethod);
        this.encryptionKey = SecretSerializationUtil.readSecretKey(reader);
        this.iv = SecretSerializationUtil.readIv(reader);
    }
}

