/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORCanonical;
import com.upokecenter.cbor.CBOREncodeOptions;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.PropertyMap;
import com.upokecenter.cbor.SharedRefs;
import com.upokecenter.cbor.StringRefs;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.util.DataUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;

class CBORReader {
    private final InputStream stream;
    private final CBOREncodeOptions options;
    private int depth;
    private StringRefs stringRefs;
    private boolean hasSharableObjects;
    private static final byte[] EmptyByteArray = new byte[0];

    public CBORReader(InputStream inStream) {
        this(inStream, CBOREncodeOptions.Default);
    }

    public CBORReader(InputStream inStream, CBOREncodeOptions options) {
        this.stream = inStream;
        this.options = options;
    }

    private static EInteger ToUnsignedEInteger(long val) {
        EInteger lval = EInteger.FromInt64(val & Long.MAX_VALUE);
        if (val >> 63 != 0L) {
            EInteger bigintAdd = EInteger.FromInt32(1).ShiftLeft(63);
            lval = lval.Add(bigintAdd);
        }
        return lval;
    }

    private void HandleItemTag(long uadditional) {
        int uad = uadditional >= 257L ? 257 : (uadditional < 0L ? 0 : (int)uadditional);
        switch (uad) {
            case 256: {
                this.stringRefs = this.stringRefs == null ? new StringRefs() : this.stringRefs;
                this.stringRefs.Push();
                break;
            }
            case 25: {
                if (this.stringRefs != null) break;
                throw new CBORException("No stringref namespace");
            }
            case 28: 
            case 29: {
                this.hasSharableObjects = true;
            }
        }
    }

    private CBORObject ObjectFromByteArray(byte[] data, int lengthHint) {
        CBORObject cbor = CBORObject.FromRaw(data);
        if (this.stringRefs != null) {
            this.stringRefs.AddStringIfNeeded(cbor, lengthHint);
        }
        return cbor;
    }

    private CBORObject ObjectFromUtf8Array(byte[] data, int lengthHint) {
        CBORObject cbor;
        CBORObject cBORObject = cbor = data.length == 0 ? CBORObject.FromObject("") : CBORObject.FromRawUtf8(data);
        if (this.stringRefs != null) {
            this.stringRefs.AddStringIfNeeded(cbor, lengthHint);
        }
        return cbor;
    }

    private static CBORObject ResolveSharedRefs(CBORObject obj, SharedRefs sharedRefs) {
        block7: {
            CBORType type;
            block6: {
                if (obj == null) {
                    return null;
                }
                type = obj.getType();
                boolean hasTag = obj.HasMostOuterTag(29);
                if (hasTag) {
                    CBORObject untagged = obj.UntagOne();
                    if (untagged.isTagged() || untagged.getType() != CBORType.Integer || untagged.AsNumber().IsNegative()) {
                        throw new CBORException("Shared ref index must be an untagged integer 0 or greater");
                    }
                    return sharedRefs.GetObject(untagged.AsEIntegerValue());
                }
                hasTag = obj.HasMostOuterTag(28);
                if (hasTag) {
                    obj = obj.UntagOne();
                    sharedRefs.AddObject(obj);
                }
                if (type != CBORType.Map) break block6;
                for (CBORObject key : obj.getKeys()) {
                    CBORObject newvalue;
                    CBORObject value = obj.get(key);
                    if (value == (newvalue = CBORReader.ResolveSharedRefs(value, sharedRefs))) continue;
                    obj.set(key, newvalue);
                }
                break block7;
            }
            if (type != CBORType.Array) break block7;
            for (int i = 0; i < obj.size(); ++i) {
                obj.set(i, CBORReader.ResolveSharedRefs(obj.get(i), sharedRefs));
            }
        }
        return obj;
    }

    public CBORObject Read() throws IOException {
        CBORObject obj;
        CBORObject cBORObject = obj = this.options.getAllowEmpty() ? this.ReadInternalOrEOF() : this.ReadInternal();
        if (this.options.getResolveReferences() && this.hasSharableObjects) {
            SharedRefs sharedRefs = new SharedRefs();
            return CBORReader.ResolveSharedRefs(obj, sharedRefs);
        }
        return obj;
    }

    private CBORObject ReadInternalOrEOF() throws IOException {
        if (this.depth > 500) {
            throw new CBORException("Too deeply nested");
        }
        int firstbyte = this.stream.read();
        if (firstbyte < 0) {
            return null;
        }
        return this.ReadForFirstByte(firstbyte);
    }

    private CBORObject ReadInternal() throws IOException {
        if (this.depth > 500) {
            throw new CBORException("Too deeply nested");
        }
        int firstbyte = this.stream.read();
        if (firstbyte < 0) {
            throw new CBORException("Premature end of data");
        }
        return this.ReadForFirstByte(firstbyte);
    }

    private CBORObject ReadStringArrayMap(int type, long uadditional) throws IOException {
        boolean canonical = this.options.getCtap2Canonical();
        if (type == 2 || type == 3) {
            if (uadditional >> 31 != 0L) {
                throw new CBORException("Length of " + CBORReader.ToUnsignedEInteger(uadditional).toString() + " is bigger than supported");
            }
            int hint = uadditional > Integer.MAX_VALUE || uadditional >> 63 != 0L ? Integer.MAX_VALUE : (int)uadditional;
            byte[] data = CBORReader.ReadByteData(this.stream, uadditional, null);
            if (type == 3) {
                if (!CBORUtilities.CheckUtf8(data)) {
                    throw new CBORException("Invalid UTF-8");
                }
                return this.ObjectFromUtf8Array(data, hint);
            }
            return this.ObjectFromByteArray(data, hint);
        }
        if (type == 4) {
            if (this.options.getCtap2Canonical() && this.depth >= 4) {
                throw new CBORException("Depth too high in canonical CBOR");
            }
            CBORObject cbor = CBORObject.NewArray();
            if (uadditional >> 31 != 0L) {
                throw new CBORException("Length of " + CBORReader.ToUnsignedEInteger(uadditional).toString() + " is bigger than supported");
            }
            if (PropertyMap.ExceedsKnownLength(this.stream, uadditional)) {
                throw new CBORException("Remaining data too small for array length");
            }
            ++this.depth;
            for (long i = 0L; i < uadditional; ++i) {
                cbor.Add(this.ReadInternal());
            }
            --this.depth;
            return cbor;
        }
        if (type == 5) {
            if (this.options.getCtap2Canonical() && this.depth >= 4) {
                throw new CBORException("Depth too high in canonical CBOR");
            }
            CBORObject cbor = CBORObject.NewMap();
            if (uadditional >> 31 != 0L) {
                throw new CBORException("Length of " + CBORReader.ToUnsignedEInteger(uadditional).toString() + " is bigger than supported");
            }
            if (PropertyMap.ExceedsKnownLength(this.stream, uadditional)) {
                throw new CBORException("Remaining data too small for map length");
            }
            CBORObject lastKey = null;
            Comparator<CBORObject> comparer = CBORCanonical.Comparer;
            for (long i = 0L; i < uadditional; ++i) {
                ++this.depth;
                CBORObject key = this.ReadInternal();
                CBORObject value = this.ReadInternal();
                --this.depth;
                if (this.options.getCtap2Canonical() && lastKey != null) {
                    int cmp = comparer.compare(lastKey, key);
                    if (cmp > 0) {
                        throw new CBORException("Map key not in canonical order");
                    }
                    if (cmp == 0) {
                        throw new CBORException("Duplicate map key");
                    }
                }
                if (!this.options.getAllowDuplicateKeys() && cbor.ContainsKey(key)) {
                    throw new CBORException("Duplicate key already exists");
                }
                lastKey = key;
                cbor.set(key, value);
            }
            return cbor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CBORObject ReadForFirstByte(int firstbyte) throws IOException {
        if (this.depth > 500) {
            throw new CBORException("Too deeply nested");
        }
        if (firstbyte < 0) {
            throw new CBORException("Premature end of data");
        }
        if (firstbyte == 255) {
            throw new CBORException("Unexpected break code encountered");
        }
        int type = firstbyte >> 5 & 7;
        int additional = firstbyte & 0x1F;
        if (this.options.getCtap2Canonical()) {
            if (additional >= 28) {
                throw new CBORException("Invalid canonical CBOR encountered");
            }
            CBORObject fixedObject = CBORObject.GetFixedObject(firstbyte);
            if (fixedObject != null) {
                return fixedObject;
            }
            if (type == 6) {
                throw new CBORException("Tags not allowed in canonical CBOR");
            }
            long uadditional = CBORReader.ReadDataLength(this.stream, firstbyte, type, type == 7);
            if (type == 0) {
                return uadditional >> 63 != 0L ? CBORObject.FromObject(CBORReader.ToUnsignedEInteger(uadditional)) : CBORObject.FromObject(uadditional);
            }
            if (type == 1) {
                return uadditional >> 63 != 0L ? CBORObject.FromObject(CBORReader.ToUnsignedEInteger(uadditional).Add(1).Negate()) : CBORObject.FromObject(-uadditional - 1L);
            }
            if (type == 7) {
                if (additional < 24) {
                    return CBORObject.FromSimpleValue(additional);
                }
                if (additional == 24 && uadditional < 32L) {
                    throw new CBORException("Invalid simple value encoding");
                }
                if (additional == 24) {
                    return CBORObject.FromSimpleValue((int)uadditional);
                }
                if (additional == 25) {
                    return CBORObject.FromFloatingPointBits(uadditional, 2);
                }
                if (additional == 26) {
                    return CBORObject.FromFloatingPointBits(uadditional, 4);
                }
                if (additional != 27) throw new CBORException("Unexpected data encountered");
                return CBORObject.FromFloatingPointBits(uadditional, 8);
            }
            if (type < 2 || type > 5) throw new CBORException("Unexpected data encountered");
            return this.ReadStringArrayMap(type, uadditional);
        }
        int expectedLength = CBORObject.GetExpectedLength(firstbyte);
        if (expectedLength == -1) {
            throw new CBORException("Unexpected data encountered");
        }
        CBORObject fixedObject = CBORObject.GetFixedObject(firstbyte);
        if (fixedObject != null) {
            return fixedObject;
        }
        byte[] data = null;
        if (expectedLength != 0) {
            data = new byte[expectedLength];
            data[0] = (byte)firstbyte;
            if (expectedLength > 1 && this.stream.read(data, 1, expectedLength - 1) != expectedLength - 1) {
                throw new CBORException("Premature end of data");
            }
            CBORObject cbor = CBORObject.GetFixedLengthObject(firstbyte, data);
            if (this.stringRefs == null || type != 2 && type != 3) return cbor;
            this.stringRefs.AddStringIfNeeded(cbor, expectedLength - 1);
            return cbor;
        }
        if (additional == 31) {
            switch (type) {
                case 2: {
                    ByteArrayOutputStream ms = null;
                    try {
                        int nextByte22;
                        ms = new ByteArrayOutputStream();
                        while ((nextByte22 = this.stream.read()) != 255) {
                            long len = CBORReader.ReadDataLength(this.stream, nextByte22, 2);
                            if (len >> 63 != 0L || len > Integer.MAX_VALUE) {
                                throw new CBORException("Length" + CBORReader.ToUnsignedEInteger(len) + " is bigger than supported ");
                            }
                            if (nextByte22 == 64) continue;
                            CBORReader.ReadByteData(this.stream, len, ms);
                        }
                        if (ms.size() > Integer.MAX_VALUE) {
                            throw new CBORException("Length of bytes to be streamed is bigger than supported ");
                        }
                        data = ms.toByteArray();
                        CBORObject nextByte22 = CBORObject.FromRaw(data);
                        return nextByte22;
                    }
                    finally {
                        try {
                            if (ms != null) {
                                ms.close();
                            }
                        }
                        catch (IOException len) {}
                    }
                }
                case 3: {
                    int nextByte;
                    StringBuilder builder = new StringBuilder();
                    while ((nextByte = this.stream.read()) != 255) {
                        long len = CBORReader.ReadDataLength(this.stream, nextByte, 3);
                        if (len >> 63 != 0L || len > Integer.MAX_VALUE) {
                            throw new CBORException("Length" + CBORReader.ToUnsignedEInteger(len) + " is bigger than supported");
                        }
                        if (nextByte == 96) continue;
                        if (PropertyMap.ExceedsKnownLength(this.stream, len)) {
                            throw new CBORException("Premature end of data");
                        }
                        switch (DataUtilities.ReadUtf8(this.stream, (int)len, builder, false)) {
                            case -1: {
                                throw new CBORException("Invalid UTF-8");
                            }
                            case -2: {
                                throw new CBORException("Premature end of data");
                            }
                        }
                    }
                    return CBORObject.FromRaw(builder.toString());
                }
                case 4: {
                    CBORObject cbor = CBORObject.NewArray();
                    int vtindex = 0;
                    while (true) {
                        int headByte;
                        if ((headByte = this.stream.read()) < 0) {
                            throw new CBORException("Premature end of data");
                        }
                        if (headByte == 255) return cbor;
                        ++this.depth;
                        CBORObject o = this.ReadForFirstByte(headByte);
                        --this.depth;
                        cbor.Add(o);
                        ++vtindex;
                    }
                }
                case 5: {
                    int newCount;
                    int oldCount;
                    CBORObject cbor = CBORObject.NewMap();
                    do {
                        int headByte;
                        if ((headByte = this.stream.read()) < 0) {
                            throw new CBORException("Premature end of data");
                        }
                        if (headByte == 255) return cbor;
                        ++this.depth;
                        CBORObject key = this.ReadForFirstByte(headByte);
                        CBORObject value = this.ReadInternal();
                        --this.depth;
                        oldCount = cbor.size();
                        cbor.set(key, value);
                        newCount = cbor.size();
                    } while (this.options.getAllowDuplicateKeys() || oldCount != newCount);
                    throw new CBORException("Duplicate key already exists");
                }
            }
            throw new CBORException("Unexpected data encountered");
        }
        EInteger bigintAdditional = EInteger.FromInt32(0);
        long uadditional = CBORReader.ReadDataLength(this.stream, firstbyte, type);
        if (type >= 2 && type <= 5) {
            return this.ReadStringArrayMap(type, uadditional);
        }
        if (type != 6) throw new CBORException("Unexpected data encountered");
        boolean haveFirstByte = false;
        int newFirstByte = -1;
        if (this.options.getResolveReferences() && uadditional >> 32 == 0L) {
            this.HandleItemTag(uadditional);
        }
        ++this.depth;
        CBORObject o = haveFirstByte ? this.ReadForFirstByte(newFirstByte) : this.ReadInternal();
        --this.depth;
        if (uadditional >> 63 != 0L) {
            return CBORObject.FromObjectAndTag((Object)o, CBORReader.ToUnsignedEInteger(uadditional));
        }
        if (uadditional >= 65536L) return CBORObject.FromObjectAndTag((Object)o, EInteger.FromInt64(uadditional));
        if (!this.options.getResolveReferences()) return CBORObject.FromObjectAndTag((Object)o, (int)uadditional);
        int uaddl = uadditional >= 257L ? 257 : (uadditional < 0L ? 0 : (int)uadditional);
        switch (uaddl) {
            case 256: {
                this.stringRefs.Pop();
                return CBORObject.FromObjectAndTag((Object)o, (int)uadditional);
            }
            case 25: {
                if (!o.isTagged() && o.getType() == CBORType.Integer) return this.stringRefs.GetString(o.AsEIntegerValue());
                throw new CBORException("stringref must be an unsigned integer");
            }
        }
        return CBORObject.FromObjectAndTag((Object)o, (int)uadditional);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] ReadByteData(InputStream stream, long uadditional, OutputStream outputStream) throws IOException {
        int total;
        if (uadditional == 0L) {
            return EmptyByteArray;
        }
        if (uadditional >> 63 != 0L || uadditional > Integer.MAX_VALUE) {
            throw new CBORException("Length" + CBORReader.ToUnsignedEInteger(uadditional) + " is bigger than supported ");
        }
        if (PropertyMap.ExceedsKnownLength(stream, uadditional)) {
            throw new CBORException("Premature end of stream");
        }
        if (uadditional <= 65536L) {
            byte[] data = new byte[(int)uadditional];
            if (stream.read(data, 0, data.length) != data.length) {
                throw new CBORException("Premature end of stream");
            }
            if (outputStream != null) {
                outputStream.write(data, 0, data.length);
                return null;
            }
            return data;
        }
        byte[] tmpdata = new byte[65536];
        if (outputStream != null) {
            int bufsize;
            for (total = (int)uadditional; total > 0; total -= bufsize) {
                bufsize = Math.min(tmpdata.length, total);
                if (stream.read(tmpdata, 0, bufsize) != bufsize) {
                    throw new CBORException("Premature end of stream");
                }
                outputStream.write(tmpdata, 0, bufsize);
            }
            return null;
        }
        ByteArrayOutputStream ms = null;
        try {
            ms = new ByteArrayOutputStream(65536);
            while (total > 0) {
                int bufsize = Math.min(tmpdata.length, total);
                if (stream.read(tmpdata, 0, bufsize) != bufsize) {
                    throw new CBORException("Premature end of stream");
                }
                ms.write(tmpdata, 0, bufsize);
                total -= bufsize;
            }
            byte[] byArray = ms.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (ms != null) {
                    ms.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static long ReadDataLength(InputStream stream, int headByte, int expectedType) throws IOException {
        return CBORReader.ReadDataLength(stream, headByte, expectedType, true);
    }

    private static long ReadDataLength(InputStream stream, int headByte, int expectedType, boolean allowNonShortest) throws IOException {
        if (headByte < 0) {
            throw new CBORException("Unexpected data encountered");
        }
        if ((headByte >> 5 & 7) != expectedType) {
            throw new CBORException("Unexpected data encountered");
        }
        if ((headByte &= 0x1F) < 24) {
            return headByte;
        }
        byte[] data = new byte[8];
        switch (headByte) {
            case 24: {
                int tmp = stream.read();
                if (tmp < 0) {
                    throw new CBORException("Premature end of data");
                }
                if (!allowNonShortest && tmp < 24) {
                    throw new CBORException("Non-shortest CBOR form");
                }
                return tmp;
            }
            case 25: {
                if (stream.read(data, 0, 2) != 2) {
                    throw new CBORException("Premature end of data");
                }
                int lowAdditional = (data[0] & 0xFF) << 8;
                if (!allowNonShortest && (lowAdditional |= data[1] & 0xFF) < 256) {
                    throw new CBORException("Non-shortest CBOR form");
                }
                return lowAdditional;
            }
            case 26: {
                if (stream.read(data, 0, 4) != 4) {
                    throw new CBORException("Premature end of data");
                }
                long uadditional = ((long)data[0] & 0xFFL) << 24;
                uadditional |= ((long)data[1] & 0xFFL) << 16;
                uadditional |= ((long)data[2] & 0xFFL) << 8;
                if (!allowNonShortest && (uadditional |= (long)data[3] & 0xFFL) >> 16 == 0L) {
                    throw new CBORException("Non-shortest CBOR form");
                }
                return uadditional;
            }
            case 27: {
                if (stream.read(data, 0, 8) != 8) {
                    throw new CBORException("Premature end of data");
                }
                long uadditional = ((long)data[0] & 0xFFL) << 56;
                uadditional |= ((long)data[1] & 0xFFL) << 48;
                uadditional |= ((long)data[2] & 0xFFL) << 40;
                uadditional |= ((long)data[3] & 0xFFL) << 32;
                uadditional |= ((long)data[4] & 0xFFL) << 24;
                uadditional |= ((long)data[5] & 0xFFL) << 16;
                uadditional |= ((long)data[6] & 0xFFL) << 8;
                if (!allowNonShortest && (uadditional |= (long)data[7] & 0xFFL) >> 32 == 0L) {
                    throw new CBORException("Non-shortest CBOR form");
                }
                return uadditional;
            }
            case 28: 
            case 29: 
            case 30: {
                throw new CBORException("Unexpected data encountered");
            }
            case 31: {
                throw new CBORException("Indefinite-length data not allowed here");
            }
        }
        return headByte;
    }
}

