/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.x509;

import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.scandium.dtls.CertificateIdentityResult;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.dtls.x509.CertificateConfigurationHelper;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.ConfigurationHelperSetup;
import org.eclipse.californium.scandium.util.ListUtils;
import org.eclipse.californium.scandium.util.ServerName;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagerCertificateProvider
implements CertificateProvider,
ConfigurationHelperSetup {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyManagerCertificateProvider.class);
    private static final String[] KEY_TYPE_EC = new String[]{"EC"};
    private static final String[] KEY_TYPE_EC_EDDSA = new String[]{"EC", "EdDSA"};
    private final String defaultAlias;
    private final X509ExtendedKeyManager keyManager;
    private final List<CertificateType> supportedCertificateTypes;

    public KeyManagerCertificateProvider(X509ExtendedKeyManager keyManager, CertificateType ... supportedCertificateTypes) {
        this(null, keyManager, KeyManagerCertificateProvider.asList(supportedCertificateTypes));
    }

    public KeyManagerCertificateProvider(X509ExtendedKeyManager keyManager, List<CertificateType> supportedCertificateTypes) {
        this(null, keyManager, supportedCertificateTypes);
    }

    public KeyManagerCertificateProvider(String defaultAlias, X509ExtendedKeyManager keyManager, CertificateType ... supportedCertificateTypes) {
        this(defaultAlias, keyManager, KeyManagerCertificateProvider.asList(supportedCertificateTypes));
    }

    public KeyManagerCertificateProvider(String defaultAlias, X509ExtendedKeyManager keyManager, List<CertificateType> supportedCertificateTypes) {
        if (keyManager == null) {
            throw new NullPointerException("KeyManager must not be null!");
        }
        if (supportedCertificateTypes != null) {
            if (supportedCertificateTypes.isEmpty()) {
                throw new IllegalArgumentException("Certificate types must not be empty!");
            }
            for (CertificateType certificateType : supportedCertificateTypes) {
                if (certificateType.isSupported()) continue;
                throw new IllegalArgumentException("Certificate type " + (Object)((Object)certificateType) + " is not supported!");
            }
        }
        this.defaultAlias = defaultAlias;
        this.keyManager = keyManager;
        if (supportedCertificateTypes == null) {
            supportedCertificateTypes = new ArrayList<CertificateType>(1);
            supportedCertificateTypes.add(CertificateType.X_509);
        }
        this.supportedCertificateTypes = Collections.unmodifiableList(supportedCertificateTypes);
    }

    @Override
    public void setupConfigurationHelper(CertificateConfigurationHelper helper) {
        X509Certificate[] certificateChain;
        List<String> aliases = this.getAliases(false, KEY_TYPE_EC_EDDSA, null);
        for (String alias : aliases) {
            certificateChain = this.keyManager.getCertificateChain(alias);
            helper.addConfigurationDefaultsFor(Arrays.asList(certificateChain));
        }
        aliases = this.getAliases(true, KEY_TYPE_EC_EDDSA, null);
        for (String alias : aliases) {
            certificateChain = this.keyManager.getCertificateChain(alias);
            helper.addConfigurationDefaultsFor(Arrays.asList(certificateChain));
        }
    }

    @Override
    public List<CertificateType> getSupportedCertificateTypes() {
        return this.supportedCertificateTypes;
    }

    @Override
    public CertificateIdentityResult requestCertificateIdentity(ConnectionId cid, boolean client, List<X500Principal> issuers, ServerNames serverNames, List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms, List<XECDHECryptography.SupportedGroup> curves) {
        Principal[] principals = issuers == null ? null : issuers.toArray(new Principal[issuers.size()]);
        List<String> alias = signatureAndHashAlgorithms.contains(SignatureAndHashAlgorithm.INTRINSIC_WITH_ED25519) || signatureAndHashAlgorithms.contains(SignatureAndHashAlgorithm.INTRINSIC_WITH_ED448) ? this.getAliases(client, KEY_TYPE_EC_EDDSA, principals) : this.getAliases(client, KEY_TYPE_EC, principals);
        if (!alias.isEmpty()) {
            ArrayList<String> matchingServerNames = new ArrayList<String>();
            ArrayList<String> matchingSignatures = new ArrayList<String>();
            ArrayList<String> matchingCurves = new ArrayList<String>();
            for (String id : alias) {
                LOGGER.debug("try {} of {}", (Object)id, (Object)alias.size());
                X509Certificate[] certificateChain = this.keyManager.getCertificateChain(id);
                List<X509Certificate> chain = Arrays.asList(certificateChain);
                if (serverNames != null && this.matchServerNames(serverNames, certificateChain[0])) {
                    matchingServerNames.add(id);
                }
                if (signatureAndHashAlgorithms != null && this.matchSignatureAndHashAlgorithms(signatureAndHashAlgorithms, chain)) {
                    matchingSignatures.add(id);
                }
                if (curves == null || !this.matchCurves(curves, chain)) continue;
                matchingCurves.add(id);
            }
            if (!matchingServerNames.isEmpty()) {
                LOGGER.debug("{} selected by {}", (Object)matchingServerNames.size(), (Object)serverNames);
                alias.retainAll(matchingServerNames);
            }
            if (signatureAndHashAlgorithms != null) {
                LOGGER.debug("{} selected by signature and hash algorithms", (Object)matchingSignatures.size());
                alias.retainAll(matchingSignatures);
            }
            if (curves != null) {
                LOGGER.debug("{} selected by curves", (Object)matchingCurves.size());
                alias.retainAll(matchingCurves);
            }
            if (alias.size() > 0) {
                String id = null;
                if (alias.size() > 1 && signatureAndHashAlgorithms != null && signatureAndHashAlgorithms.size() > 1) {
                    alias = this.selectPriorized(alias, signatureAndHashAlgorithms);
                }
                id = alias.size() > 1 && this.defaultAlias != null && alias.contains(this.defaultAlias) ? this.defaultAlias : alias.get(0);
                X509Certificate[] certificateChain = this.keyManager.getCertificateChain(id);
                List<X509Certificate> chain = Arrays.asList(certificateChain);
                PrivateKey privateKey = this.keyManager.getPrivateKey(id);
                return new CertificateIdentityResult(cid, privateKey, chain, (Object)id);
            }
        } else {
            LOGGER.debug("no matching credentials");
        }
        return new CertificateIdentityResult(cid, null);
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    private List<String> getAliases(boolean client, String[] keyTypes, Principal[] issuers) {
        ArrayList<String> all = new ArrayList<String>();
        for (String keyType : keyTypes) {
            String[] alias = null;
            alias = client ? this.keyManager.getClientAliases(keyType, issuers) : this.keyManager.getServerAliases(keyType, issuers);
            if (alias == null) continue;
            LOGGER.debug("found {} {} keys", (Object)alias.length, (Object)keyType);
            ListUtils.addIfAbsent(all, Arrays.asList(alias));
        }
        return all;
    }

    private boolean matchServerNames(ServerNames serverNames, X509Certificate node) {
        ServerName serverNname = serverNames.getServerName(ServerName.NameType.HOST_NAME);
        String name = serverNname.getNameAsString();
        X500Principal principal = node.getSubjectX500Principal();
        if (principal.getName().endsWith("CN=" + name)) {
            return true;
        }
        try {
            Collection<List<?>> alternativeNames = node.getSubjectAlternativeNames();
            if (alternativeNames != null) {
                for (List<?> alternativeName : alternativeNames) {
                    Object value = alternativeName.get(1);
                    if (!(value instanceof String) || !value.equals(name)) continue;
                    return true;
                }
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        return false;
    }

    private boolean matchSignatureAndHashAlgorithms(List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms, List<X509Certificate> chain) {
        if (SignatureAndHashAlgorithm.getSupportedSignatureAlgorithm(signatureAndHashAlgorithms, chain.get(0).getPublicKey()) == null) {
            return false;
        }
        return SignatureAndHashAlgorithm.isSignedWithSupportedAlgorithms(signatureAndHashAlgorithms, chain);
    }

    private boolean matchCurves(List<XECDHECryptography.SupportedGroup> curves, List<X509Certificate> chain) {
        for (X509Certificate certificate : chain) {
            PublicKey certPublicKey = certificate.getPublicKey();
            if (!Asn1DerDecoder.isSupported(certPublicKey.getAlgorithm())) continue;
            XECDHECryptography.SupportedGroup group = XECDHECryptography.SupportedGroup.fromPublicKey(certPublicKey);
            if (group == null) {
                return false;
            }
            if (curves.contains((Object)group)) continue;
            return false;
        }
        return true;
    }

    private List<String> selectPriorized(List<String> alias, List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms) {
        ArrayList<String> result = new ArrayList<String>();
        for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : signatureAndHashAlgorithms) {
            for (String id : alias) {
                LOGGER.debug("select sign {} - {}", (Object)id, (Object)signatureAndHashAlgorithm.getJcaName());
                X509Certificate[] certificateChain = this.keyManager.getCertificateChain(id);
                if (!signatureAndHashAlgorithm.isSupported(certificateChain[0].getPublicKey())) continue;
                result.add(id);
            }
            if (result.isEmpty()) continue;
            break;
        }
        return result;
    }

    private static List<CertificateType> asList(CertificateType[] types) {
        if (types == null || types.length == 0) {
            return null;
        }
        return Arrays.asList(types);
    }
}

