/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialExecutor
extends AbstractExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialExecutor.class);
    private final Executor executor;
    private final AtomicReference<Thread> owner = new AtomicReference();
    private final AtomicReference<ExecutionListener> listener = new AtomicReference();
    private final BlockingQueue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition terminated = this.lock.newCondition();
    private Runnable currentlyExecutedJob;
    private boolean shutdown;

    public SerialExecutor(Executor executor) {
        if (executor == null) {
            this.shutdown = true;
        }
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        this.lock.lock();
        try {
            if (this.shutdown) {
                throw new RejectedExecutionException("SerialExecutor already shutdown!");
            }
            this.tasks.offer(command);
            if (this.currentlyExecutedJob == null) {
                this.scheduleNextJob();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void assertOwner() {
        Thread me = Thread.currentThread();
        if (this.owner.get() != me) {
            Thread thread = this.owner.get();
            if (thread == null) {
                throw new ConcurrentModificationException(this + " is not owned!");
            }
            throw new ConcurrentModificationException(this + " owned by " + thread.getName() + "!");
        }
    }

    public boolean checkOwner() {
        return this.owner.get() == Thread.currentThread();
    }

    private void setOwner() {
        Thread thread = this.owner.get();
        if (!this.owner.compareAndSet(null, Thread.currentThread())) {
            if (thread == null) {
                throw new ConcurrentModificationException(this + " was already owned!");
            }
            throw new ConcurrentModificationException(this + " already owned by " + thread.getName() + "!");
        }
    }

    private void clearOwner() {
        if (!this.owner.compareAndSet(Thread.currentThread(), null)) {
            Thread thread = this.owner.get();
            if (thread == null) {
                throw new ConcurrentModificationException(this + " is not owned, clear failed!");
            }
            throw new ConcurrentModificationException(this + " owned by " + thread.getName() + ", clear failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            this.shutdown = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        this.lock.lock();
        try {
            ArrayList<Runnable> pending = new ArrayList<Runnable>(this.tasks.size());
            this.shutdownNow(pending);
            ArrayList<Runnable> arrayList = pending;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int shutdownNow(Collection<Runnable> jobs) {
        this.lock.lock();
        try {
            this.shutdown();
            int n = this.tasks.drainTo(jobs);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        this.lock.lock();
        try {
            boolean bl = this.shutdown;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        this.lock.lock();
        try {
            boolean bl = this.shutdown && this.currentlyExecutedJob == null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            long nanosTimeout = unit.toNanos(timeout);
            while (!(this.shutdown && this.currentlyExecutedJob == null || (nanosTimeout = this.terminated.awaitNanos(nanosTimeout)) <= 0L)) {
            }
            boolean bl = this.shutdown && this.currentlyExecutedJob == null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleNextJob() {
        this.lock.lock();
        try {
            this.currentlyExecutedJob = (Runnable)this.tasks.poll();
            if (this.currentlyExecutedJob != null) {
                final Runnable command = this.currentlyExecutedJob;
                this.executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        try {
                            try {
                                SerialExecutor.this.setOwner();
                                ExecutionListener current = (ExecutionListener)SerialExecutor.this.listener.get();
                                try {
                                    if (current != null) {
                                        current.beforeExecution();
                                    }
                                    command.run();
                                }
                                catch (Throwable t) {
                                    try {
                                        LOGGER.error("unexpected error occurred:", t);
                                        return;
                                    }
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                    finally {
                                        try {
                                            if (current != null) {
                                                current.afterExecution();
                                            }
                                        }
                                        catch (Throwable t2) {
                                            LOGGER.error("unexpected error occurred:", t2);
                                        }
                                        SerialExecutor.this.clearOwner();
                                    }
                                }
                                try {
                                    if (current != null) {
                                        current.afterExecution();
                                    }
                                }
                                catch (Throwable t) {
                                    LOGGER.error("unexpected error occurred:", t);
                                }
                                SerialExecutor.this.clearOwner();
                                return;
                            }
                            finally {
                                SerialExecutor.this.scheduleNextJob();
                            }
                        }
                        catch (RejectedExecutionException ex) {
                            LOGGER.debug("shutdown?", ex);
                        }
                    }
                });
            } else if (this.shutdown) {
                this.terminated.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public static SerialExecutor create(Executor executor) {
        if (executor != null) {
            return new SerialExecutor(executor);
        }
        return null;
    }

    public ExecutionListener setExecutionListener(ExecutionListener listener) {
        return this.listener.getAndSet(listener);
    }

    public static interface ExecutionListener {
        public void beforeExecution();

        public void afterExecution();
    }
}

