/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.californium.elements.util.DataStreamReader;

public final class DatagramReader
extends DataStreamReader {
    public DatagramReader(byte[] byteArray) {
        this(byteArray, true);
    }

    public DatagramReader(byte[] byteArray, boolean copy) {
        this(copy ? Arrays.copyOf(byteArray, byteArray.length) : byteArray, 0, byteArray.length);
    }

    public DatagramReader(byte[] byteArray, int offset, int length) {
        this(new DataStreamReader.RangeInputStream(byteArray, offset, length));
    }

    public DatagramReader(ByteArrayInputStream byteStream) {
        super(byteStream);
    }

    @Override
    public void close() {
        try {
            this.byteStream.skip(this.byteStream.available());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.close();
    }

    @Override
    public byte[] readBytes(int count) {
        int available = this.available();
        int bytesToRead = count;
        if (bytesToRead < 0) {
            bytesToRead = available;
        } else if (bytesToRead > available) {
            throw new IllegalArgumentException("requested " + count + " bytes exceeds available " + available + " bytes.");
        }
        return super.readBytes(bytesToRead);
    }

    public byte[] readBytesLeft() {
        return this.readBytes(-1);
    }

    public void assertFinished(String message) {
        int left = this.bitsLeft();
        if (left > 0) {
            throw new IllegalArgumentException(message + " not finished! " + left + " bits left.");
        }
    }

    public boolean bytesAvailable() {
        return this.available() > 0;
    }

    public boolean bytesAvailable(int expectedBytes) {
        int bytesLeft = this.available();
        return bytesLeft >= expectedBytes;
    }

    public int bitsLeft() {
        return this.available() * 8 + (this.currentBitIndex + 1);
    }

    private int available() {
        try {
            return this.byteStream.available();
        }
        catch (IOException e) {
            return -1;
        }
    }
}

