/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhEcdsaServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskClientKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskServerKeyExchange;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretExtension;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.RecordSizeLimitExtension;
import org.eclipse.californium.scandium.dtls.ServerCertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SignatureAlgorithmsExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedEllipticCurvesExtension;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuiteParameters;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuiteSelector;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoPublicAPI
public class ServerHandshaker
extends Handshaker {
    private static HandshakeState[] CLIENT_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.CERTIFICATE), new HandshakeState(HandshakeType.CLIENT_KEY_EXCHANGE), new HandshakeState(HandshakeType.CERTIFICATE_VERIFY), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private static HandshakeState[] EMPTY_CLIENT_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.CERTIFICATE), new HandshakeState(HandshakeType.CLIENT_KEY_EXCHANGE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    protected static HandshakeState[] NO_CLIENT_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.CLIENT_KEY_EXCHANGE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private final Logger LOGGER_NEGOTIATION;
    private boolean useNoSessionId;
    private boolean clientAuthenticationWanted;
    private boolean clientAuthenticationRequired;
    private PublicKey clientPublicKey;
    private CipherSuiteSelector cipherSuiteSelector;
    private List<CipherSuite> supportedCipherSuites;
    private final List<XECDHECryptography.SupportedGroup> supportedGroups;
    private final List<CertificateType> supportedClientCertificateTypes;
    private final List<CertificateType> supportedServerCertificateTypes;
    private final List<SignatureAndHashAlgorithm> supportedSignatureAndHashAlgorithms;
    private CipherSuiteParameters selectedCipherSuiteParameters;
    private CertificateVerify certificateVerifyMessage;
    private PskPublicInformation preSharedKeyIdentity;
    private XECDHECryptography ecdhe;

    public ServerHandshaker(long initialRecordSequenceNo, int initialMessageSequenceNo, RecordLayer recordLayer, ScheduledExecutorService timer, Connection connection, DtlsConnectorConfig config) {
        this(initialRecordSequenceNo, initialMessageSequenceNo, new DTLSSession(), recordLayer, timer, connection, config);
    }

    protected ServerHandshaker(long initialRecordSequenceNo, int initialMessageSequenceNo, DTLSSession session, RecordLayer recordLayer, ScheduledExecutorService timer, Connection connection, DtlsConnectorConfig config) {
        super(initialRecordSequenceNo, initialMessageSequenceNo, session, recordLayer, timer, connection, config);
        this.LOGGER_NEGOTIATION = LoggerFactory.getLogger(this.LOGGER.getName() + ".negotiation");
        this.useNoSessionId = false;
        this.clientAuthenticationWanted = false;
        this.clientAuthenticationRequired = false;
        this.certificateVerifyMessage = null;
        this.cipherSuiteSelector = config.getCipherSuiteSelector();
        this.supportedCipherSuites = config.getSupportedCipherSuites();
        this.supportedGroups = config.getSupportedGroups();
        this.clientAuthenticationWanted = config.isClientAuthenticationWanted();
        this.clientAuthenticationRequired = config.isClientAuthenticationRequired();
        this.useNoSessionId = config.useNoServerSessionId();
        this.supportedClientCertificateTypes = config.getTrustCertificateTypes();
        this.supportedServerCertificateTypes = config.getIdentityCertificateTypes();
        this.supportedSignatureAndHashAlgorithms = config.getSupportedSignatureAlgorithms();
    }

    @Override
    protected boolean isClient() {
        return false;
    }

    public PskPublicInformation getPreSharedKeyIdentity() {
        return this.preSharedKeyIdentity;
    }

    @Override
    protected void doProcessMessage(HandshakeMessage message) throws HandshakeException {
        block0 : switch (message.getMessageType()) {
            case CLIENT_HELLO: {
                this.receivedClientHello((ClientHello)message);
                break;
            }
            case CERTIFICATE: {
                this.receivedClientCertificate((CertificateMessage)message);
                break;
            }
            case CLIENT_KEY_EXCHANGE: {
                switch (this.getSession().getKeyExchange()) {
                    case PSK: {
                        PskSecretResult masterSecretResult = this.receivedClientKeyExchange((PSKClientKeyExchange)message);
                        if (masterSecretResult == null) break block0;
                        this.processPskSecretResult(masterSecretResult);
                        break;
                    }
                    case ECDHE_PSK: {
                        PskSecretResult masterSecretResult = this.receivedClientKeyExchange((EcdhPskClientKeyExchange)message);
                        if (masterSecretResult == null) break block0;
                        this.processPskSecretResult(masterSecretResult);
                        break;
                    }
                    case EC_DIFFIE_HELLMAN: {
                        SecretKey masterSecret = this.receivedClientKeyExchange((ECDHClientKeyExchange)message);
                        this.processMasterSecret(masterSecret);
                        break;
                    }
                }
                break;
            }
            case CERTIFICATE_VERIFY: {
                this.receivedCertificateVerify((CertificateVerify)message);
                if (this.masterSecret == null || !this.certificateVerfied) break;
                this.expectChangeCipherSpecMessage();
                break;
            }
            case FINISHED: {
                this.receivedClientFinished((Finished)message);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected %s message from peer %s", new Object[]{message.getMessageType(), this.peerToLog}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE));
            }
        }
    }

    @Override
    protected void processMasterSecret(SecretKey masterSecret) {
        this.applyMasterSecret(masterSecret);
        SecretUtil.destroy(masterSecret);
        if (this.states == NO_CLIENT_CERTIFICATE || this.states == EMPTY_CLIENT_CERTIFICATE && this.certificateVerfied) {
            this.expectChangeCipherSpecMessage();
        }
    }

    @Override
    protected void processCertificateVerified() {
        if (this.certificateVerifyMessage != null) {
            if (this.peerCertPath != null) {
                this.getSession().setPeerIdentity(new X509CertPath(this.peerCertPath));
            } else {
                this.getSession().setPeerIdentity(new RawPublicKeyIdentity(this.clientPublicKey));
            }
        }
        if ((this.states == EMPTY_CLIENT_CERTIFICATE || this.certificateVerifyMessage != null) && this.masterSecret != null) {
            this.expectChangeCipherSpecMessage();
        }
    }

    private void receivedClientCertificate(CertificateMessage message) throws HandshakeException {
        this.clientPublicKey = message.getPublicKey();
        if (this.clientAuthenticationRequired && this.clientPublicKey == null) {
            this.LOGGER.debug("Client authentication failed: missing certificate!");
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
            throw new HandshakeException("Client Certificate required!", alert);
        }
        if (this.clientPublicKey == null) {
            this.states = EMPTY_CLIENT_CERTIFICATE;
        }
        this.verifyCertificate(message);
    }

    private void receivedCertificateVerify(CertificateVerify message) throws HandshakeException {
        this.certificateVerifyMessage = message;
        this.handshakeMessages.remove(this.handshakeMessages.size() - 1);
        message.verifySignature(this.clientPublicKey, this.handshakeMessages);
        this.handshakeMessages.add(message);
        if (this.certificateVerfied) {
            if (this.peerCertPath != null) {
                this.getSession().setPeerIdentity(new X509CertPath(this.peerCertPath));
            } else {
                this.getSession().setPeerIdentity(new RawPublicKeyIdentity(this.clientPublicKey));
            }
        }
    }

    private void receivedClientFinished(Finished message) throws HandshakeException {
        MessageDigest mdWithClientFinished;
        if (this.clientAuthenticationRequired && this.states == EMPTY_CLIENT_CERTIFICATE) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
            throw new HandshakeException("Client did not send required authentication messages.", alert);
        }
        this.flightNumber += 2;
        DTLSFlight flight = this.createFlight();
        MessageDigest md = this.getHandshakeMessageDigest();
        try {
            mdWithClientFinished = (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message hash", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR));
        }
        Mac mac = this.getSession().getCipherSuite().getThreadLocalPseudoRandomFunctionMac();
        message.verifyData(mac, this.masterSecret, true, md.digest());
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage();
        this.wrapMessage(flight, changeCipherSpecMessage);
        this.setCurrentWriteState();
        mdWithClientFinished.update(message.toByteArray());
        Finished finished = new Finished(mac, this.masterSecret, false, mdWithClientFinished.digest());
        this.wrapMessage(flight, finished);
        this.sendLastFlight(flight);
        this.contextEstablished();
    }

    private void receivedClientHello(ClientHello clientHello) throws HandshakeException {
        this.handshakeStarted();
        byte[] cookie = clientHello.getCookie();
        this.flightNumber = cookie != null && cookie.length > 0 ? 4 : 2;
        DTLSFlight flight = this.createFlight();
        this.createServerHello(clientHello, flight);
        this.createCertificateMessage(clientHello, flight);
        this.createServerKeyExchange(clientHello, flight);
        boolean clientCertificate = this.createCertificateRequest(clientHello, flight);
        this.states = clientCertificate ? CLIENT_CERTIFICATE : NO_CLIENT_CERTIFICATE;
        this.statesIndex = -1;
        ServerHelloDone serverHelloDone = new ServerHelloDone();
        this.wrapMessage(flight, serverHelloDone);
        this.sendFlight(flight);
    }

    private void createServerHello(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        ProtocolVersion serverVersion = this.negotiateProtocolVersion(clientHello.getClientVersion());
        this.clientRandom = clientHello.getRandom();
        this.serverRandom = new Random();
        DTLSSession session = this.getSession();
        boolean useNoSessionId = this.useNoSessionId;
        if (this.extendedMasterSecretMode.is(ExtendedMasterSecretMode.ENABLED) && !clientHello.hasExtendedMasterSecret()) {
            useNoSessionId = true;
        }
        SessionId sessionId = useNoSessionId ? SessionId.emptySessionId() : new SessionId();
        session.setSessionIdentifier(sessionId);
        session.setProtocolVersion(serverVersion);
        if (!clientHello.getCompressionMethods().contains((Object)CompressionMethod.NULL)) {
            throw new HandshakeException("Client does not support NULL compression method", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        session.setCompressionMethod(CompressionMethod.NULL);
        HelloExtensions serverHelloExtensions = new HelloExtensions();
        this.negotiateCipherSuite(clientHello, serverHelloExtensions);
        this.processHelloExtensions(clientHello, serverHelloExtensions);
        ServerHello serverHello = new ServerHello(serverVersion, this.serverRandom, sessionId, session.getCipherSuite(), session.getCompressionMethod(), serverHelloExtensions);
        if (serverHello.getCipherSuite().isEccBased()) {
            this.expectEcc();
        }
        this.wrapMessage(flight, serverHello);
    }

    private void createCertificateMessage(ClientHello clientHello, DTLSFlight flight) {
        DTLSSession session = this.getSession();
        CertificateMessage certificateMessage = null;
        if (session.getCipherSuite().requiresServerCertificateMessage()) {
            if (CertificateType.RAW_PUBLIC_KEY == session.sendCertificateType()) {
                certificateMessage = new CertificateMessage(this.publicKey);
            } else if (CertificateType.X_509 == session.sendCertificateType()) {
                certificateMessage = new CertificateMessage(this.certificateChain);
            } else {
                throw new IllegalArgumentException("Certificate type " + (Object)((Object)session.sendCertificateType()) + " not supported!");
            }
            this.wrapMessage(flight, certificateMessage);
        }
    }

    private void createServerKeyExchange(ClientHello clientHello, DTLSFlight flight) throws HandshakeException {
        DTLSSession session = this.getSession();
        CipherSuite.KeyExchangeAlgorithm keyExchangeAlgorithm = session.getKeyExchange();
        if (CipherSuite.KeyExchangeAlgorithm.ECDHE_PSK == keyExchangeAlgorithm || CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN == keyExchangeAlgorithm) {
            try {
                XECDHECryptography.SupportedGroup ecGroup = this.selectedCipherSuiteParameters.getSelectedSupportedGroup();
                this.ecdhe = new XECDHECryptography(ecGroup);
                session.setEcGroup(ecGroup);
            }
            catch (GeneralSecurityException ex) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER);
                throw new HandshakeException("Cannot process handshake message, caused by " + ex.getMessage(), alert, ex);
            }
        }
        ECDHServerKeyExchange serverKeyExchange = null;
        switch (keyExchangeAlgorithm) {
            case EC_DIFFIE_HELLMAN: {
                serverKeyExchange = new EcdhEcdsaServerKeyExchange(session.getSignatureAndHashAlgorithm(), this.ecdhe, this.privateKey, this.clientRandom, this.serverRandom);
                break;
            }
            case PSK: {
                break;
            }
            case ECDHE_PSK: {
                serverKeyExchange = new EcdhPskServerKeyExchange(PskPublicInformation.EMPTY, this.ecdhe);
                break;
            }
        }
        if (serverKeyExchange != null) {
            this.wrapMessage(flight, serverKeyExchange);
        }
    }

    private boolean createCertificateRequest(ClientHello clientHello, DTLSFlight flight) {
        DTLSSession session = this.getSession();
        if ((this.clientAuthenticationWanted || this.clientAuthenticationRequired) && session.getCipherSuite().requiresServerCertificateMessage() && this.selectedCipherSuiteParameters.getSelectedClientCertificateType() != null) {
            CertificateRequest certificateRequest = new CertificateRequest();
            certificateRequest.addCertificateType(CertificateRequest.ClientCertificateType.ECDSA_SIGN);
            if (session.receiveCertificateType() == CertificateType.X_509) {
                certificateRequest.addSignatureAlgorithms(this.supportedSignatureAndHashAlgorithms);
                if (this.certificateVerifier != null) {
                    certificateRequest.addCerticiateAuthorities(this.certificateVerifier.getAcceptedIssuers());
                }
            } else if (session.receiveCertificateType() == CertificateType.RAW_PUBLIC_KEY) {
                List<SignatureAndHashAlgorithm> ecdsaSignatures = SignatureAndHashAlgorithm.getEcdsaCompatibleSignatureAlgorithms(this.supportedSignatureAndHashAlgorithms);
                certificateRequest.addSignatureAlgorithms(ecdsaSignatures);
            }
            this.wrapMessage(flight, certificateRequest);
            return true;
        }
        return false;
    }

    private SecretKey receivedClientKeyExchange(ECDHClientKeyExchange message) throws HandshakeException {
        try {
            DTLSSession session = this.getSession();
            SecretKey premasterSecret = this.ecdhe.generateSecret(message.getEncodedPoint());
            byte[] seed = this.generateMasterSecretSeed();
            SecretKey masterSecret = PseudoRandomFunction.generateMasterSecret(session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), premasterSecret, seed, session.useExtendedMasterSecret());
            SecretUtil.destroy(premasterSecret);
            return masterSecret;
        }
        catch (GeneralSecurityException ex) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER);
            throw new HandshakeException("Cannot process handshake message, caused by " + ex.getMessage(), alert, ex);
        }
    }

    private PskSecretResult receivedClientKeyExchange(PSKClientKeyExchange message) {
        this.preSharedKeyIdentity = message.getIdentity();
        byte[] seed = this.generateMasterSecretSeed();
        return this.requestPskSecretResult(this.preSharedKeyIdentity, null, seed);
    }

    private PskSecretResult receivedClientKeyExchange(EcdhPskClientKeyExchange message) throws HandshakeException {
        try {
            this.preSharedKeyIdentity = message.getIdentity();
            SecretKey otherSecret = this.ecdhe.generateSecret(message.getEncodedPoint());
            byte[] seed = this.generateMasterSecretSeed();
            PskSecretResult masterSecretRequest = this.requestPskSecretResult(this.preSharedKeyIdentity, otherSecret, seed);
            SecretUtil.destroy(otherSecret);
            return masterSecretRequest;
        }
        catch (GeneralSecurityException ex) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER);
            throw new HandshakeException("Cannot process handshake message, caused by " + ex.getMessage(), alert, ex);
        }
    }

    protected void processHelloExtensions(ClientHello clientHello, HelloExtensions serverHelloExtensions) throws HandshakeException {
        ConnectionIdExtension connectionIdExtension;
        ServerNameExtension serverNameExt;
        MaxFragmentLengthExtension maxFragmentLengthExt;
        DTLSSession session = this.getSession();
        RecordSizeLimitExtension recordSizeLimitExt = clientHello.getRecordSizeLimitExtension();
        if (recordSizeLimitExt != null) {
            session.setRecordSizeLimit(recordSizeLimitExt.getRecordSizeLimit());
            int limit = this.recordSizeLimit == null ? session.getMaxFragmentLength() : this.recordSizeLimit.intValue();
            serverHelloExtensions.addExtension(new RecordSizeLimitExtension(limit));
            this.LOGGER.debug("Received record size limit [{} bytes] from peer [{}]", (Object)limit, this.peerToLog);
        }
        if (recordSizeLimitExt == null && (maxFragmentLengthExt = clientHello.getMaxFragmentLengthExtension()) != null) {
            session.setMaxFragmentLength(maxFragmentLengthExt.getFragmentLength().length());
            serverHelloExtensions.addExtension(maxFragmentLengthExt);
            this.LOGGER.debug("Negotiated max. fragment length [{} bytes] with peer [{}]", (Object)maxFragmentLengthExt.getFragmentLength().length(), this.peerToLog);
        }
        if ((serverNameExt = clientHello.getServerNameExtension()) != null) {
            if (this.sniEnabled) {
                session.setServerNames(serverNameExt.getServerNames());
                serverHelloExtensions.addExtension(ServerNameExtension.emptyServerNameIndication());
                session.setSniSupported(true);
                this.LOGGER.debug("using server name indication received from peer [{}]", this.peerToLog);
            } else {
                this.LOGGER.debug("client [{}] included SNI in HELLO but SNI support is disabled", this.peerToLog);
            }
        }
        if (this.supportsConnectionId() && (connectionIdExtension = clientHello.getConnectionIdExtension()) != null) {
            this.context.setWriteConnectionId(connectionIdExtension.getConnectionId());
            ConnectionId connectionId = this.getReadConnectionId();
            this.context.setReadConnectionId(connectionId);
            ConnectionIdExtension extension = ConnectionIdExtension.fromConnectionId(connectionId);
            serverHelloExtensions.addExtension(extension);
        }
        if (clientHello.hasExtendedMasterSecret()) {
            if (this.extendedMasterSecretMode != ExtendedMasterSecretMode.NONE) {
                session.setExtendedMasterSecret(true);
                serverHelloExtensions.addExtension(ExtendedMasterSecretExtension.INSTANCE);
            }
        } else if (this.extendedMasterSecretMode == ExtendedMasterSecretMode.REQUIRED) {
            throw new HandshakeException("Extended Master Secret required!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
    }

    private ProtocolVersion negotiateProtocolVersion(ProtocolVersion clientVersion) throws HandshakeException {
        if (clientVersion.compareTo(ProtocolVersion.VERSION_DTLS_1_2) >= 0) {
            return ProtocolVersion.VERSION_DTLS_1_2;
        }
        ProtocolVersion version = clientVersion;
        if (version.compareTo(ProtocolVersion.VERSION_DTLS_1_0) < 0) {
            version = ProtocolVersion.VERSION_DTLS_1_0;
        }
        AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.PROTOCOL_VERSION, version);
        throw new HandshakeException("The server only supports DTLS v1.2, not " + clientVersion + "!", alert);
    }

    protected void negotiateCipherSuite(ClientHello clientHello, HelloExtensions serverHelloExtensions) throws HandshakeException {
        CipherSuite cipherSuite;
        SupportedPointFormatsExtension.ECPointFormat format;
        List<SignatureAndHashAlgorithm> commonSignatures;
        List<XECDHECryptography.SupportedGroup> commonGroups;
        List<CertificateType> commonClientCertTypes;
        List<CertificateType> commonServerCertTypes;
        List<CipherSuite> commonCipherSuites = this.getCommonCipherSuites(clientHello);
        CipherSuiteParameters parameters = new CipherSuiteParameters(this.publicKey, this.certificateChain, this.clientAuthenticationRequired, this.clientAuthenticationWanted, commonCipherSuites, commonServerCertTypes = this.getCommonServerCertificateTypes(clientHello), commonClientCertTypes = this.getCommonClientCertificateTypes(clientHello), commonGroups = this.getCommonSupportedGroups(clientHello), commonSignatures = this.getCommonSignatureAndHashAlgorithms(clientHello), format = this.negotiateECPointFormat(clientHello));
        if (this.cipherSuiteSelector.select(parameters)) {
            DTLSSession session = this.getSession();
            this.selectedCipherSuiteParameters = parameters;
            cipherSuite = parameters.getSelectedCipherSuite();
            session.setCipherSuite(cipherSuite);
            if (cipherSuite.requiresServerCertificateMessage()) {
                session.setSignatureAndHashAlgorithm(parameters.getSelectedSignature());
                session.setSendCertificateType(parameters.getSelectedServerCertificateType());
                CertificateType certificateType = parameters.getSelectedClientCertificateType();
                if (this.clientAuthenticationRequired || this.clientAuthenticationWanted && certificateType != null) {
                    session.setReceiveCertificateType(parameters.getSelectedClientCertificateType());
                }
            }
        } else {
            String summary;
            if (this.LOGGER_NEGOTIATION.isDebugEnabled()) {
                this.LOGGER_NEGOTIATION.debug("{}", (Object)clientHello);
                this.LOGGER_NEGOTIATION.debug("{}", (Object)parameters.getMismatchDescription());
                this.LOGGER_NEGOTIATION.trace("Parameters: {}", (Object)parameters);
            }
            if ((summary = parameters.getMismatchSummary()) == null) {
                summary = "Client proposed unsupported cipher suites or parameters only";
            }
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE);
            throw new HandshakeException(summary, alert);
        }
        this.addServerHelloExtensions(cipherSuite, clientHello, serverHelloExtensions);
        this.LOGGER.debug("Negotiated cipher suite [{}] with peer [{}]", (Object)cipherSuite.name(), this.peerToLog);
    }

    private void addServerHelloExtensions(CipherSuite negotiatedCipherSuite, ClientHello clientHello, HelloExtensions extensions) {
        CertificateTypeExtension ext;
        DTLSSession session = this.getSession();
        CertificateType certificateType = session.receiveCertificateType();
        if (certificateType != null && clientHello.getClientCertificateTypeExtension() != null) {
            ext = new ClientCertificateTypeExtension(certificateType);
            extensions.addExtension(ext);
        }
        if ((certificateType = session.sendCertificateType()) != null && clientHello.getServerCertificateTypeExtension() != null) {
            ext = new ServerCertificateTypeExtension(certificateType);
            extensions.addExtension(ext);
        }
        if (negotiatedCipherSuite.isEccBased() && clientHello.getSupportedPointFormatsExtension() != null) {
            extensions.addExtension(SupportedPointFormatsExtension.DEFAULT_POINT_FORMATS_EXTENSION);
        }
    }

    private List<XECDHECryptography.SupportedGroup> getCommonSupportedGroups(ClientHello clientHello) {
        ArrayList<XECDHECryptography.SupportedGroup> groups = new ArrayList<XECDHECryptography.SupportedGroup>();
        SupportedEllipticCurvesExtension extension = clientHello.getSupportedEllipticCurvesExtension();
        if (extension == null) {
            groups.addAll(this.supportedGroups);
        } else {
            for (XECDHECryptography.SupportedGroup group : extension.getSupportedGroups()) {
                if (!this.supportedGroups.contains((Object)group)) continue;
                groups.add(group);
            }
        }
        return groups;
    }

    private SupportedPointFormatsExtension.ECPointFormat negotiateECPointFormat(ClientHello clientHello) {
        SupportedPointFormatsExtension extension = clientHello.getSupportedPointFormatsExtension();
        if (extension == null) {
            return SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED;
        }
        if (extension.contains(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED)) {
            return SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED;
        }
        return null;
    }

    private List<SignatureAndHashAlgorithm> getCommonSignatureAndHashAlgorithms(ClientHello clientHello) {
        SignatureAlgorithmsExtension extension = clientHello.getSupportedSignatureAlgorithms();
        if (extension == null) {
            ArrayList<SignatureAndHashAlgorithm> signatures = new ArrayList<SignatureAndHashAlgorithm>();
            signatures.addAll(this.supportedSignatureAndHashAlgorithms);
            return signatures;
        }
        return SignatureAndHashAlgorithm.getCommonSignatureAlgorithms(extension.getSupportedSignatureAndHashAlgorithms(), this.supportedSignatureAndHashAlgorithms);
    }

    private List<CipherSuite> getCommonCipherSuites(ClientHello clientHello) {
        List<CipherSuite> supported = this.supportedCipherSuites;
        CipherSuite sessionCipherSuite = this.getSession().getCipherSuite();
        if (!sessionCipherSuite.equals((Object)CipherSuite.TLS_NULL_WITH_NULL_NULL)) {
            supported = Arrays.asList(sessionCipherSuite);
        }
        ArrayList<CipherSuite> common = new ArrayList<CipherSuite>();
        for (CipherSuite cipherSuite : clientHello.getCipherSuites()) {
            if (cipherSuite == CipherSuite.TLS_NULL_WITH_NULL_NULL || !supported.contains((Object)cipherSuite)) continue;
            common.add(cipherSuite);
        }
        return common;
    }

    private List<CertificateType> getCommonClientCertificateTypes(ClientHello clientHello) {
        List<CertificateType> supported = this.supportedClientCertificateTypes;
        Principal principal = this.getSession().getPeerIdentity();
        if (principal != null) {
            supported = new ArrayList<CertificateType>();
            if (principal instanceof RawPublicKeyIdentity) {
                supported.add(CertificateType.RAW_PUBLIC_KEY);
            } else if (principal instanceof X509CertPath) {
                supported.add(CertificateType.X_509);
            }
        }
        return ServerHandshaker.getCommonCertificateTypes(clientHello.getClientCertificateTypeExtension(), supported);
    }

    private List<CertificateType> getCommonServerCertificateTypes(ClientHello clientHello) {
        return ServerHandshaker.getCommonCertificateTypes(clientHello.getServerCertificateTypeExtension(), this.supportedServerCertificateTypes);
    }

    private static List<CertificateType> getCommonCertificateTypes(CertificateTypeExtension certTypeExt, List<CertificateType> supportedCertificateTypes) {
        ArrayList<CertificateType> common = new ArrayList<CertificateType>();
        if (supportedCertificateTypes != null) {
            if (certTypeExt != null) {
                for (CertificateType certType : certTypeExt.getCertificateTypes()) {
                    if (!supportedCertificateTypes.contains((Object)certType)) continue;
                    common.add(certType);
                }
            } else if (supportedCertificateTypes.contains((Object)CertificateType.X_509)) {
                common.add(CertificateType.X_509);
            }
        }
        return common;
    }

    final CipherSuiteParameters getNegotiatedCipherSuiteParameters() {
        return this.selectedCipherSuiteParameters;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.ecdhe);
        this.ecdhe = null;
    }
}

