/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;

@NoPublicAPI
public class MultiHandshakeMessage
extends HandshakeMessage {
    private int count;
    private int length;
    private HandshakeMessage tail = this;

    protected MultiHandshakeMessage() {
    }

    public int getNumberOfHandshakeMessages() {
        return this.count;
    }

    public void add(HandshakeMessage message) {
        this.tail.setNextHandshakeMessage(message);
        this.tail = message;
        this.length += message.size();
        ++this.count;
    }

    @Override
    public HandshakeType getMessageType() {
        HandshakeMessage message = this.getNextHandshakeMessage();
        return message == null ? null : message.getMessageType();
    }

    @Override
    public int getMessageLength() {
        return this.length - 12;
    }

    @Override
    public byte[] fragmentToByteArray() {
        throw new RuntimeException("not supported!");
    }

    @Override
    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter(1500);
        for (HandshakeMessage message = this.getNextHandshakeMessage(); message != null; message = message.getNextHandshakeMessage()) {
            message.writeTo(writer);
        }
        return writer.toByteArray();
    }
}

