/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateRequest;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerify;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ECDHServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhEcdsaServerKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskClientKeyExchange;
import org.eclipse.californium.scandium.dtls.EcdhPskServerKeyExchange;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretExtension;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.HelloVerifyRequest;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.PSKClientKeyExchange;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.RecordSizeLimitExtension;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.ServerHelloDone;
import org.eclipse.californium.scandium.dtls.ServerNameExtension;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;

@NoPublicAPI
public class ClientHandshaker
extends Handshaker {
    protected static HandshakeState[] SEVER_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.HELLO_VERIFY_REQUEST, true), new HandshakeState(HandshakeType.SERVER_HELLO), new HandshakeState(HandshakeType.CERTIFICATE), new HandshakeState(HandshakeType.SERVER_KEY_EXCHANGE), new HandshakeState(HandshakeType.CERTIFICATE_REQUEST, true), new HandshakeState(HandshakeType.SERVER_HELLO_DONE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private static HandshakeState[] NO_SEVER_CERTIFICATE = new HandshakeState[]{new HandshakeState(HandshakeType.HELLO_VERIFY_REQUEST, true), new HandshakeState(HandshakeType.SERVER_HELLO), new HandshakeState(HandshakeType.SERVER_KEY_EXCHANGE, true), new HandshakeState(HandshakeType.SERVER_HELLO_DONE), new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private ProtocolVersion maxProtocolVersion = ProtocolVersion.VERSION_DTLS_1_2;
    private boolean probe;
    private PublicKey serverPublicKey;
    protected ECDHServerKeyExchange serverKeyExchange;
    protected ClientKeyExchange clientKeyExchange;
    protected ClientHello clientHello = null;
    protected DTLSFlight flight5;
    private final List<CipherSuite> supportedCipherSuites;
    protected final List<XECDHECryptography.SupportedGroup> supportedGroups;
    protected final Integer maxFragmentLengthCode;
    protected final boolean truncateCertificatePath;
    protected final List<CertificateType> supportedClientCertificateTypes;
    protected final List<SignatureAndHashAlgorithm> supportedSignatureAlgorithms;
    protected final List<CertificateType> supportedServerCertificateTypes;
    protected CertificateRequest certificateRequest = null;
    protected boolean sentClientCertificate;
    protected byte[] handshakeHash = null;
    protected ServerNames indicatedServerNames;
    protected SignatureAndHashAlgorithm negotiatedSignatureAndHashAlgorithm;

    public ClientHandshaker(String hostname, RecordLayer recordLayer, ScheduledExecutorService timer, Connection connection, DtlsConnectorConfig config, boolean probe) {
        this(probe, new DTLSSession(hostname), recordLayer, timer, connection, config);
    }

    protected ClientHandshaker(boolean probe, DTLSSession session, RecordLayer recordLayer, ScheduledExecutorService timer, Connection connection, DtlsConnectorConfig config) {
        super(0L, 0, session, recordLayer, timer, connection, config);
        this.supportedCipherSuites = config.getSupportedCipherSuites();
        this.supportedGroups = config.getSupportedGroups();
        this.maxFragmentLengthCode = config.getMaxFragmentLengthCode();
        this.truncateCertificatePath = config.useTruncatedCertificatePathForClientsCertificateMessage();
        this.supportedServerCertificateTypes = config.getTrustCertificateTypes();
        this.supportedClientCertificateTypes = config.getIdentityCertificateTypes();
        this.supportedSignatureAlgorithms = config.getSupportedSignatureAlgorithms();
        this.probe = probe;
    }

    @Override
    protected boolean isClient() {
        return true;
    }

    @Override
    protected void doProcessMessage(HandshakeMessage message) throws HandshakeException {
        block0 : switch (message.getMessageType()) {
            case HELLO_VERIFY_REQUEST: {
                this.receivedHelloVerifyRequest((HelloVerifyRequest)message);
                break;
            }
            case SERVER_HELLO: {
                this.receivedServerHello((ServerHello)message);
                break;
            }
            case CERTIFICATE: {
                this.receivedServerCertificate((CertificateMessage)message);
                break;
            }
            case SERVER_KEY_EXCHANGE: {
                switch (this.getSession().getKeyExchange()) {
                    case EC_DIFFIE_HELLMAN: {
                        this.receivedServerKeyExchange((EcdhEcdsaServerKeyExchange)message);
                        break block0;
                    }
                    case PSK: {
                        break block0;
                    }
                    case ECDHE_PSK: {
                        this.serverKeyExchange = (EcdhPskServerKeyExchange)message;
                        break block0;
                    }
                }
                throw new HandshakeException(String.format("Unsupported key exchange algorithm %s", this.getSession().getKeyExchange().name()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
            }
            case CERTIFICATE_REQUEST: {
                this.certificateRequest = (CertificateRequest)message;
                break;
            }
            case SERVER_HELLO_DONE: {
                this.receivedServerHelloDone((ServerHelloDone)message);
                break;
            }
            case FINISHED: {
                this.receivedServerFinished((Finished)message);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected handshake message [%s] from peer %s", new Object[]{message.getMessageType(), this.peerToLog}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE));
            }
        }
    }

    private void receivedServerFinished(Finished message) throws HandshakeException {
        message.verifyData(this.getSession().getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, false, this.handshakeHash);
        this.contextEstablished();
        this.handshakeCompleted();
    }

    protected void receivedHelloVerifyRequest(HelloVerifyRequest message) {
        this.handshakeMessages.clear();
        if (CipherSuite.containsEccBasedCipherSuite(this.clientHello.getCipherSuites())) {
            this.expectEcc();
        }
        this.clientHello.setCookie(message.getCookie());
        this.flightNumber = 3;
        DTLSFlight flight = this.createFlight();
        this.wrapMessage(flight, this.clientHello);
        this.sendFlight(flight);
        --this.statesIndex;
    }

    protected void receivedServerHello(ServerHello message) throws HandshakeException {
        ConnectionIdExtension extension;
        this.usedProtocol = message.getServerVersion();
        if (!this.usedProtocol.equals(ProtocolVersion.VERSION_DTLS_1_2)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.PROTOCOL_VERSION);
            throw new HandshakeException("The client only supports DTLS v1.2, not " + this.usedProtocol + "!", alert);
        }
        this.serverRandom = message.getRandom();
        DTLSSession session = this.getSession();
        session.setSessionIdentifier(message.getSessionId());
        session.setProtocolVersion(this.usedProtocol);
        CipherSuite cipherSuite = message.getCipherSuite();
        if (!this.supportedCipherSuites.contains((Object)cipherSuite)) {
            throw new HandshakeException("Server wants to use not supported cipher suite " + (Object)((Object)cipherSuite), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        session.setCipherSuite(cipherSuite);
        CompressionMethod compressionMethod = message.getCompressionMethod();
        if (compressionMethod != CompressionMethod.NULL) {
            throw new HandshakeException("Server wants to use not supported compression method " + (Object)((Object)compressionMethod), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        session.setCompressionMethod(message.getCompressionMethod());
        this.verifyServerHelloExtensions(message);
        if (this.supportsConnectionId() && (extension = message.getConnectionIdExtension()) != null) {
            ConnectionId connectionId = extension.getConnectionId();
            this.context.setWriteConnectionId(connectionId);
            this.context.setReadConnectionId(this.getReadConnectionId());
        }
        if (message.hasExtendedMasterSecret()) {
            session.setExtendedMasterSecret(true);
        } else if (this.extendedMasterSecretMode == ExtendedMasterSecretMode.REQUIRED) {
            throw new HandshakeException("Extended Master Secret required!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        session.setSendCertificateType(message.getClientCertificateType());
        session.setSniSupported(message.hasServerNameExtension());
        if (!cipherSuite.requiresServerCertificateMessage()) {
            this.states = NO_SEVER_CERTIFICATE;
        }
    }

    protected void verifyServerHelloExtensions(ServerHello message) throws HandshakeException {
        CertificateType serverCertificateType;
        MaxFragmentLengthExtension maxFragmentLengthExtension;
        SupportedPointFormatsExtension pointFormatsExtension;
        HelloExtensions serverExtensions = message.getExtensions();
        if (serverExtensions != null && !serverExtensions.isEmpty()) {
            HelloExtensions clientExtensions = this.clientHello.getExtensions();
            if (clientExtensions == null || clientExtensions.isEmpty()) {
                throw new HandshakeException("Server wants extensions, but client not!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_EXTENSION));
            }
            for (HelloExtension serverExtension : serverExtensions.getExtensions()) {
                if (clientExtensions.getExtension(serverExtension.getType()) != null) continue;
                throw new HandshakeException("Server wants " + (Object)((Object)serverExtension.getType()) + ", but client not!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_EXTENSION));
            }
        }
        if ((pointFormatsExtension = message.getSupportedPointFormatsExtension()) != null && !pointFormatsExtension.contains(SupportedPointFormatsExtension.ECPointFormat.UNCOMPRESSED)) {
            throw new HandshakeException("Server wants to use only not supported EC point formats!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        DTLSSession session = this.getSession();
        RecordSizeLimitExtension recordSizeLimitExt = message.getRecordSizeLimit();
        if (recordSizeLimitExt != null) {
            session.setRecordSizeLimit(recordSizeLimitExt.getRecordSizeLimit());
        }
        if ((maxFragmentLengthExtension = message.getMaxFragmentLength()) != null) {
            if (recordSizeLimitExt != null) {
                throw new HandshakeException("Server wants to use record size limit and max. fragment size", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
            }
            MaxFragmentLengthExtension.Length maxFragmentLength = maxFragmentLengthExtension.getFragmentLength();
            if (maxFragmentLength.code() == this.maxFragmentLengthCode.intValue()) {
                session.setMaxFragmentLength(maxFragmentLength.length());
            } else {
                throw new HandshakeException("Server wants to use other max. fragment size than proposed", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
            }
        }
        if (!ClientHandshaker.isSupportedCertificateType(serverCertificateType = message.getServerCertificateType(), this.supportedServerCertificateTypes)) {
            throw new HandshakeException("Server wants to use not supported server certificate type " + (Object)((Object)serverCertificateType), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER));
        }
        session.setReceiveCertificateType(serverCertificateType);
    }

    private void receivedServerCertificate(CertificateMessage message) throws HandshakeException {
        if (message.isEmpty()) {
            this.LOGGER.debug("Certificate validation failed: empty server certificate!");
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
            throw new HandshakeException("Empty server certificate!", alert);
        }
        this.verifyCertificate(message);
        this.serverPublicKey = message.getPublicKey();
    }

    private void receivedServerKeyExchange(EcdhEcdsaServerKeyExchange message) throws HandshakeException {
        message.verifySignature(this.serverPublicKey, this.clientRandom, this.serverRandom);
        if (this.peerCertPath != null) {
            this.getSession().setPeerIdentity(new X509CertPath(this.peerCertPath));
        } else {
            this.getSession().setPeerIdentity(new RawPublicKeyIdentity(this.serverPublicKey));
        }
        this.serverKeyExchange = message;
    }

    private void receivedServerHelloDone(ServerHelloDone message) throws HandshakeException {
        this.flightNumber += 2;
        this.flight5 = this.createFlight();
        this.createCertificateMessage(this.flight5);
        DTLSSession session = this.getSession();
        CipherSuite.KeyExchangeAlgorithm keyExchangeAlgorithm = session.getKeyExchange();
        XECDHECryptography ecdhe = null;
        SecretKey ecdheSecret = null;
        byte[] encodedPoint = null;
        if (CipherSuite.KeyExchangeAlgorithm.ECDHE_PSK == keyExchangeAlgorithm || CipherSuite.KeyExchangeAlgorithm.EC_DIFFIE_HELLMAN == keyExchangeAlgorithm) {
            try {
                XECDHECryptography.SupportedGroup ecGroup = this.serverKeyExchange.getSupportedGroup();
                if (!this.supportedGroups.contains((Object)ecGroup)) {
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER);
                    throw new HandshakeException("Cannot process handshake message, ec-group not offered! ", alert);
                }
                ecdhe = new XECDHECryptography(ecGroup);
                ecdheSecret = ecdhe.generateSecret(this.serverKeyExchange.getEncodedPoint());
                encodedPoint = ecdhe.getEncodedPoint();
                session.setEcGroup(ecGroup);
            }
            catch (GeneralSecurityException ex) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER);
                throw new HandshakeException("Cannot process handshake message, caused by " + ex.getMessage(), alert, ex);
            }
        }
        switch (keyExchangeAlgorithm) {
            case EC_DIFFIE_HELLMAN: {
                this.clientKeyExchange = new ECDHClientKeyExchange(encodedPoint);
                this.wrapMessage(this.flight5, this.clientKeyExchange);
                byte[] seed = this.generateMasterSecretSeed();
                SecretKey masterSecret = PseudoRandomFunction.generateMasterSecret(session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), ecdheSecret, seed, session.useExtendedMasterSecret());
                this.processMasterSecret(masterSecret);
                break;
            }
            case PSK: {
                PskPublicInformation clientIdentity = this.getPskClientIdentity();
                this.LOGGER.trace("Using PSK identity: {}", (Object)clientIdentity);
                this.clientKeyExchange = new PSKClientKeyExchange(clientIdentity);
                this.wrapMessage(this.flight5, this.clientKeyExchange);
                byte[] seed = this.generateMasterSecretSeed();
                PskSecretResult masterSecretResult = this.requestPskSecretResult(clientIdentity, null, seed);
                if (masterSecretResult == null) break;
                this.processPskSecretResult(masterSecretResult);
                break;
            }
            case ECDHE_PSK: {
                PskPublicInformation clientIdentity = this.getPskClientIdentity();
                this.LOGGER.trace("Using ECDHE PSK identity: {}", (Object)clientIdentity);
                this.clientKeyExchange = new EcdhPskClientKeyExchange(clientIdentity, encodedPoint);
                this.wrapMessage(this.flight5, this.clientKeyExchange);
                byte[] seed = this.generateMasterSecretSeed();
                PskSecretResult masterSecretResult = this.requestPskSecretResult(clientIdentity, ecdheSecret, seed);
                if (masterSecretResult == null) break;
                this.processPskSecretResult(masterSecretResult);
                break;
            }
        }
        SecretUtil.destroy(ecdhe);
        SecretUtil.destroy(ecdheSecret);
    }

    @Override
    protected void processMasterSecret(SecretKey masterSecret) throws HandshakeException {
        this.applyMasterSecret(masterSecret);
        SecretUtil.destroy(masterSecret);
        if (this.states != SEVER_CERTIFICATE || this.certificateVerfied) {
            this.processServerHelloDone();
        }
    }

    @Override
    protected void processCertificateVerified() throws HandshakeException {
        if (this.masterSecret != null) {
            this.processServerHelloDone();
        }
    }

    private void processServerHelloDone() throws HandshakeException {
        MessageDigest mdWithClientFinished;
        DTLSSession session = this.getSession();
        if (session.getCipherSuite().isEccBased()) {
            this.expectEcc();
        }
        if (this.sentClientCertificate && this.certificateRequest != null && this.negotiatedSignatureAndHashAlgorithm != null) {
            CertificateType clientCertificateType = session.sendCertificateType();
            if (!ClientHandshaker.isSupportedCertificateType(clientCertificateType, this.supportedClientCertificateTypes)) {
                throw new HandshakeException("Server wants to use not supported client certificate type " + (Object)((Object)clientCertificateType), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_CERTIFICATE));
            }
            CertificateVerify certificateVerify = new CertificateVerify(this.negotiatedSignatureAndHashAlgorithm, this.privateKey, this.handshakeMessages);
            session.setSignatureAndHashAlgorithm(this.negotiatedSignatureAndHashAlgorithm);
            this.wrapMessage(this.flight5, certificateVerify);
        }
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage();
        this.wrapMessage(this.flight5, changeCipherSpecMessage);
        this.setCurrentWriteState();
        MessageDigest md = this.getHandshakeMessageDigest();
        try {
            mdWithClientFinished = (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HandshakeException("Cannot create FINISHED message", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR));
        }
        Finished finished = new Finished(this.getSession().getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), this.masterSecret, true, md.digest());
        this.wrapMessage(this.flight5, finished);
        mdWithClientFinished.update(finished.toByteArray());
        this.handshakeHash = mdWithClientFinished.digest();
        this.sendFlight(this.flight5);
        this.expectChangeCipherSpecMessage();
    }

    protected void createCertificateMessage(DTLSFlight flight) {
        if (this.certificateRequest != null) {
            CertificateMessage clientCertificate;
            List<SignatureAndHashAlgorithm> supported = this.supportedSignatureAlgorithms;
            if (supported.isEmpty()) {
                supported = SignatureAndHashAlgorithm.DEFAULT;
            }
            this.certificateRequest.selectSignatureAlgorithms(supported);
            if (CertificateType.RAW_PUBLIC_KEY == this.getSession().sendCertificateType()) {
                PublicKey publicKey = this.publicKey;
                if (publicKey != null) {
                    this.negotiatedSignatureAndHashAlgorithm = this.certificateRequest.getSignatureAndHashAlgorithm(publicKey);
                    if (this.negotiatedSignatureAndHashAlgorithm == null) {
                        publicKey = null;
                    }
                }
                if (this.LOGGER.isDebugEnabled()) {
                    byte[] raw = publicKey == null ? Bytes.EMPTY : publicKey.getEncoded();
                    this.LOGGER.debug("sending CERTIFICATE message with client RawPublicKey [{}] to server", (Object)StringUtil.byteArray2HexString(raw));
                }
                clientCertificate = new CertificateMessage(publicKey);
            } else if (CertificateType.X_509 == this.getSession().sendCertificateType()) {
                List clientChain = Collections.emptyList();
                if (this.certificateChain != null) {
                    this.negotiatedSignatureAndHashAlgorithm = this.certificateRequest.getSignatureAndHashAlgorithm(this.certificateChain);
                    if (this.negotiatedSignatureAndHashAlgorithm != null) {
                        clientChain = this.certificateChain;
                    }
                }
                List<X500Principal> authorities = this.truncateCertificatePath ? this.certificateRequest.getCertificateAuthorities() : null;
                clientCertificate = new CertificateMessage(clientChain, authorities);
            } else {
                throw new IllegalArgumentException("Certificate type " + (Object)((Object)this.getSession().sendCertificateType()) + " not supported!");
            }
            this.sentClientCertificate = clientCertificate.getMessageLength() > 3;
            this.wrapMessage(flight, clientCertificate);
        }
    }

    protected static boolean isSupportedCertificateType(CertificateType certType, List<CertificateType> supportedCertificateTypes) {
        if (supportedCertificateTypes != null) {
            return supportedCertificateTypes.contains((Object)certType);
        }
        return certType == CertificateType.X_509;
    }

    public void startHandshake() throws HandshakeException {
        this.handshakeStarted();
        ClientHello startMessage = new ClientHello(this.maxProtocolVersion, this.supportedCipherSuites, this.supportedSignatureAlgorithms, this.supportedClientCertificateTypes, this.supportedServerCertificateTypes, this.supportedGroups);
        if (CipherSuite.containsEccBasedCipherSuite(startMessage.getCipherSuites())) {
            this.expectEcc();
        }
        this.clientRandom = startMessage.getRandom();
        startMessage.addCompressionMethod(CompressionMethod.NULL);
        if (this.extendedMasterSecretMode != ExtendedMasterSecretMode.NONE) {
            startMessage.addExtension(ExtendedMasterSecretExtension.INSTANCE);
        }
        this.addConnectionId(startMessage);
        this.addRecordSizeLimit(startMessage);
        this.addMaxFragmentLength(startMessage);
        this.addServerNameIndication(startMessage);
        this.flightNumber = 1;
        this.clientHello = startMessage;
        DTLSFlight flight = this.createFlight();
        this.wrapMessage(flight, startMessage);
        this.sendFlight(flight);
        this.states = SEVER_CERTIFICATE;
        this.statesIndex = 0;
    }

    protected void addRecordSizeLimit(ClientHello helloMessage) {
        if (this.recordSizeLimit != null) {
            RecordSizeLimitExtension ext = new RecordSizeLimitExtension(this.recordSizeLimit);
            helloMessage.addExtension(ext);
            this.LOGGER.debug("Indicating record size limit [{}] to server [{}]", (Object)this.recordSizeLimit, this.peerToLog);
        }
    }

    protected void addMaxFragmentLength(ClientHello helloMessage) {
        if (this.maxFragmentLengthCode != null) {
            MaxFragmentLengthExtension ext = new MaxFragmentLengthExtension(this.maxFragmentLengthCode);
            helloMessage.addExtension(ext);
            this.LOGGER.debug("Indicating max. fragment length [{}] to server [{}]", (Object)this.maxFragmentLengthCode, this.peerToLog);
        }
    }

    protected void addConnectionId(ClientHello helloMessage) {
        if (this.supportsConnectionId()) {
            ConnectionId connectionId = this.connectionIdGenerator.useConnectionId() ? this.getConnection().getConnectionId() : ConnectionId.EMPTY;
            ConnectionIdExtension extension = ConnectionIdExtension.fromConnectionId(connectionId);
            helloMessage.addExtension(extension);
        }
    }

    protected void addServerNameIndication(ClientHello helloMessage) {
        if (this.sniEnabled && this.getSession().getServerNames() != null) {
            this.LOGGER.debug("adding SNI extension to CLIENT_HELLO message [{}]", (Object)this.getSession().getHostName());
            helloMessage.addExtension(ServerNameExtension.forServerNames(this.getSession().getServerNames()));
        }
    }

    protected PskPublicInformation getPskClientIdentity() throws HandshakeException {
        PskPublicInformation pskIdentity;
        ServerNames serverName;
        ServerNames serverNames = serverName = this.sniEnabled ? this.getSession().getServerNames() : null;
        if (serverName != null && !this.getSession().isSniSupported()) {
            this.LOGGER.warn("client is configured to use SNI but server does not support it, PSK authentication is likely to fail");
        }
        if ((pskIdentity = this.advancedPskStore.getIdentity(this.getPeerAddress(), serverName)) == null) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR);
            if (serverName != null) {
                throw new HandshakeException(String.format("No Identity found for peer [address: %s, virtual host: %s]", this.peerToLog, this.getSession().getHostName()), alert);
            }
            throw new HandshakeException(String.format("No Identity found for peer [address: %s]", this.peerToLog), alert);
        }
        return pskIdentity;
    }

    @Override
    public boolean isProbing() {
        return this.probe;
    }

    @Override
    public void resetProbing() {
        this.probe = false;
    }

    @Override
    public boolean isRemovingConnection() {
        return !this.probe && super.isRemovingConnection();
    }
}

