/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import com.upokecenter.cbor.CBORObject;
import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.elements.util.StringUtil;

public class Context
extends CoapResource {
    public static final String RESOURCE_NAME = "context";

    public Context(String name, boolean visible) {
        super(name, visible);
        this.getAttributes().setTitle("Communication Context");
        this.getAttributes().addContentType(0);
        this.getAttributes().addContentType(60);
        this.getAttributes().addContentType(50);
        this.getAttributes().addContentType(41);
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        Request request = exchange.advanced().getRequest();
        int accept = request.getOptions().getAccept();
        if (accept == -1) {
            accept = 0;
        }
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        response.getOptions().setContentFormat(accept);
        byte[] payload = null;
        switch (accept) {
            case 0: {
                payload = this.handleGet(exchange, new Text());
                break;
            }
            case 60: {
                payload = this.handleGet(exchange, new Cbor());
                break;
            }
            case 50: {
                payload = this.handleGet(exchange, new Json());
                break;
            }
            case 41: {
                payload = this.handleGet(exchange, new Xml(RESOURCE_NAME));
                break;
            }
            default: {
                String ct = MediaTypeRegistry.toString(accept);
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE, "Type \"" + ct + "\" is not supported for this resource!", 0);
                return;
            }
        }
        response.setPayload(payload);
        exchange.respond(response);
    }

    private byte[] handleGet(CoapExchange coapExchange, Formatter formatter) {
        String via;
        String cid;
        String cipherSuite;
        Principal peerIdentity;
        NetworkConfig config;
        String nodeId;
        Exchange exchange = coapExchange.advanced();
        EndpointContext context = exchange.getRequest().getSourceContext();
        InetSocketAddress source = context.getPeerAddress();
        formatter.add("ip", StringUtil.toString(source.getAddress()));
        formatter.add("port", new Long(source.getPort()));
        Endpoint endpoint = exchange.getEndpoint();
        if (endpoint != null && (nodeId = (config = endpoint.getConfig()).getString("DTLS_CONNECTION_ID_NODE_ID")) != null) {
            formatter.add("node-id", nodeId);
        }
        if ((peerIdentity = context.getPeerIdentity()) != null) {
            formatter.add("peer", peerIdentity.getName());
        }
        if ((cipherSuite = context.getString("DTLS_CIPHER")) == null) {
            cipherSuite = context.getString("TLS_CIPHER");
        }
        if (cipherSuite != null) {
            formatter.add("cipher-suite", cipherSuite);
        }
        if ((cid = context.getString("DTLS_READ_CONNECTION_ID")) != null) {
            formatter.add("read-cid", cid);
        }
        if ((cid = context.getString("DTLS_WRITE_CONNECTION_ID")) != null) {
            formatter.add("write-cid", cid);
        }
        if ((via = context.getString("*DTLS_VIA_ROUTER")) != null) {
            formatter.add("via", via);
        }
        if (StringUtil.CALIFORNIUM_VERSION != null) {
            formatter.add("server", "Cf " + StringUtil.CALIFORNIUM_VERSION);
        }
        return formatter.getPayload();
    }

    private static class Xml
    implements Formatter {
        private StringBuilder payload = new StringBuilder();

        Xml(String element) {
            this.payload.append("<").append(element).append(" ");
        }

        @Override
        public void add(String name, String value) {
            this.payload.append(name).append("=\"").append(value).append("\" ");
        }

        @Override
        public void add(String name, Long value) {
            this.payload.append(name).append("=\"").append(value).append("\" ");
        }

        @Override
        public byte[] getPayload() {
            this.payload.append("/>");
            return this.payload.toString().getBytes(StandardCharsets.UTF_8);
        }
    }

    private static class Json
    implements Formatter {
        private StringBuilder payload = new StringBuilder("{\n");

        private Json() {
        }

        @Override
        public void add(String name, String value) {
            this.payload.append("  \"").append(name).append("\": \"").append(value).append("\",\n");
        }

        @Override
        public void add(String name, Long value) {
            this.payload.append("  \"").append(name).append("\": ").append(value).append(",\n");
        }

        @Override
        public byte[] getPayload() {
            if (this.payload.length() > 0) {
                this.payload.setLength(this.payload.length() - 2);
            }
            this.payload.append("\n}");
            return this.payload.toString().getBytes(StandardCharsets.UTF_8);
        }
    }

    private static class Cbor
    implements Formatter {
        CBORObject map = CBORObject.NewMap();

        private Cbor() {
        }

        @Override
        public void add(String name, String value) {
            this.map.set(name, CBORObject.FromObject(value));
        }

        @Override
        public void add(String name, Long value) {
            this.map.set(name, CBORObject.FromObject(value));
        }

        @Override
        public byte[] getPayload() {
            return this.map.EncodeToBytes();
        }
    }

    private static class Text
    implements Formatter {
        private StringBuilder payload = new StringBuilder();

        private Text() {
        }

        @Override
        public void add(String name, String value) {
            this.payload.append(name).append(": ").append(value).append("\n");
        }

        @Override
        public void add(String name, Long value) {
            this.payload.append(name).append(": ").append(value).append("\n");
        }

        @Override
        public byte[] getPayload() {
            if (this.payload.length() > 0) {
                this.payload.setLength(this.payload.length() - 1);
            }
            return this.payload.toString().getBytes(StandardCharsets.UTF_8);
        }
    }

    private static interface Formatter {
        public void add(String var1, String var2);

        public void add(String var1, Long var2);

        public byte[] getPayload();
    }
}

