/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.elements.util.WipAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationUtil.class);
    public static final int NO_VERSION = 0;
    private static final int ADDRESS_VERSION = 1;
    private static final int ADDRESS_LITERAL = 1;
    private static final int ADDRESS_NAME = 2;
    private static final int ATTRIBUTES_VERSION = 1;
    private static final int ATTRIBUTES_STRING = 1;
    private static final int ATTRIBUTES_BYTES = 2;
    private static final int ATTRIBUTES_INTEGER = 3;
    private static final int ATTRIBUTES_LONG = 4;
    private static final int NANOTIME_SNYC_MARK_VERSION = 1;

    public static void writeNoItem(OutputStream out) throws IOException {
        out.write(0);
    }

    public static void writeNoItem(DatagramWriter writer) {
        writer.writeByte((byte)0);
    }

    public static int writeStartItem(DatagramWriter writer, int version, int numBits) {
        if (version == 0) {
            throw new IllegalArgumentException("version must not be 0!");
        }
        writer.writeByte((byte)version);
        return writer.space(numBits);
    }

    public static void writeFinishedItem(DatagramWriter writer, int position, int numBits) {
        writer.writeSize(position, numBits);
    }

    public static int readStartItem(DataStreamReader reader, int version, int numBits) {
        if (version == 0) {
            throw new IllegalArgumentException("version must not be 0!");
        }
        int read = reader.readNextByte() & 0xFF;
        if (read == 0) {
            return -1;
        }
        if (read != version) {
            throw new IllegalArgumentException("Version mismatch! " + version + " is required, not " + read);
        }
        return reader.read(numBits);
    }

    public static void write(DatagramWriter writer, String value, int numBits) {
        writer.writeVarBytes(value == null ? null : value.getBytes(StandardCharsets.UTF_8), numBits);
    }

    public static String readString(DataStreamReader reader, int numBits) {
        byte[] data = reader.readVarBytes(numBits);
        if (data != null) {
            return new String(data, StandardCharsets.UTF_8);
        }
        return null;
    }

    public static void write(DatagramWriter writer, InetSocketAddress address) {
        if (address == null) {
            SerializationUtil.writeNoItem(writer);
        } else {
            int position = SerializationUtil.writeStartItem(writer, 1, 8);
            writer.write(address.getPort(), 16);
            if (address.isUnresolved()) {
                writer.writeByte((byte)2);
                writer.writeBytes(address.getHostName().getBytes(StandardCharsets.US_ASCII));
            } else {
                writer.writeByte((byte)1);
                writer.writeBytes(address.getAddress().getAddress());
            }
            SerializationUtil.writeFinishedItem(writer, position, 8);
        }
    }

    public static InetSocketAddress readAddress(DataStreamReader reader) {
        int length = SerializationUtil.readStartItem(reader, 1, 8);
        if (length <= 0) {
            return null;
        }
        DatagramReader rangeReader = reader.createRangeReader(length);
        int port = rangeReader.read(16);
        int type = rangeReader.readNextByte() & 0xFF;
        byte[] address = rangeReader.readBytesLeft();
        switch (type) {
            case 2: {
                return new InetSocketAddress(new String(address, StandardCharsets.US_ASCII), port);
            }
            case 1: {
                try {
                    return new InetSocketAddress(InetAddress.getByAddress(address), port);
                }
                catch (UnknownHostException unknownHostException) {
                    break;
                }
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public static void write(DatagramWriter writer, Map<String, Object> entries) {
        if (entries == null) {
            SerializationUtil.writeNoItem(writer);
        } else {
            int position = SerializationUtil.writeStartItem(writer, 1, 16);
            for (Map.Entry<String, Object> entry : entries.entrySet()) {
                SerializationUtil.write(writer, entry.getKey(), 8);
                Object value = entry.getValue();
                if (value instanceof String) {
                    writer.writeByte((byte)1);
                    SerializationUtil.write(writer, (String)value, 8);
                    continue;
                }
                if (value instanceof Bytes) {
                    writer.writeByte((byte)2);
                    writer.writeVarBytes((Bytes)value, 8);
                    continue;
                }
                if (value instanceof Integer) {
                    writer.writeByte((byte)3);
                    writer.write((Integer)value, 32);
                    continue;
                }
                if (!(value instanceof Long)) continue;
                writer.writeByte((byte)4);
                writer.writeLong((Long)value, 64);
            }
            SerializationUtil.writeFinishedItem(writer, position, 16);
        }
    }

    public static MapBasedEndpointContext.Attributes readEndpointContexAttributes(DataStreamReader reader) {
        int length = SerializationUtil.readStartItem(reader, 1, 16);
        if (length < 0) {
            return null;
        }
        DatagramReader rangeReader = reader.createRangeReader(length);
        MapBasedEndpointContext.Attributes attributes = new MapBasedEndpointContext.Attributes();
        while (rangeReader.bytesAvailable()) {
            String key = SerializationUtil.readString(rangeReader, 8);
            try {
                int type = rangeReader.readNextByte() & 0xFF;
                switch (type) {
                    case 1: {
                        String stringValue = SerializationUtil.readString(rangeReader, 8);
                        attributes.add(key, stringValue);
                        break;
                    }
                    case 2: {
                        byte[] data = rangeReader.readVarBytes(8);
                        attributes.add(key, new Bytes(data));
                        break;
                    }
                    case 3: {
                        int intValue = rangeReader.read(32);
                        attributes.add(key, intValue);
                        break;
                    }
                    case 4: {
                        long longValue = rangeReader.readLong(64);
                        attributes.add(key, longValue);
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Read attribute {}:", (Object)key, (Object)ex);
            }
        }
        return attributes;
    }

    public static void writeNanotimeSynchronizationMark(DatagramWriter writer) {
        int position = SerializationUtil.writeStartItem(writer, 1, 8);
        long millis = System.currentTimeMillis();
        long nanos = ClockUtil.nanoRealtime();
        writer.writeLong(millis, 64);
        writer.writeLong(nanos, 64);
        SerializationUtil.writeFinishedItem(writer, position, 8);
    }

    public static long readNanotimeSynchronizationMark(DataStreamReader reader) {
        int length = SerializationUtil.readStartItem(reader, 1, 8);
        if (length <= 0) {
            return 0L;
        }
        DatagramReader rangeReader = reader.createRangeReader(length);
        long millis = rangeReader.readLong(64);
        long nanos = rangeReader.readLong(64);
        rangeReader.assertFinished("times");
        long startMillis = System.currentTimeMillis();
        long startNanos = ClockUtil.nanoRealtime();
        long deltaSystemtime = Math.max(TimeUnit.MILLISECONDS.toNanos(startMillis - millis), 0L);
        long deltaUptime = startNanos - nanos;
        long delta = deltaUptime - deltaSystemtime;
        return delta;
    }

    @WipAPI
    public static void skipItems(InputStream in, int numBits) {
        DataStreamReader reader = new DataStreamReader(in);
        while ((reader.readNextByte() & 0xFF) != 0) {
            int len = reader.read(numBits);
            reader.skip(len);
        }
    }
}

