/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.Iterator;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.core.network.stack.Block1BlockwiseStatus;
import org.eclipse.californium.core.network.stack.Block2BlockwiseStatus;
import org.eclipse.californium.core.network.stack.BlockwiseStatus;
import org.eclipse.californium.core.network.stack.BlockwiseTransferException;
import org.eclipse.californium.core.network.stack.CleanupMessageObserver;
import org.eclipse.californium.core.network.stack.KeyUri;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockwiseLayer
extends AbstractLayer {
    private static final int MINIMAL_BLOCK_SIZE = 16;
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockwiseLayer.class);
    private static final Logger HEALTH_LOGGER = LoggerFactory.getLogger(LOGGER.getName() + ".health");
    private final BlockwiseStatus.RemoveHandler removeHandler = new BlockwiseStatus.RemoveHandler(){

        @Override
        public void remove(BlockwiseStatus status) {
            if (status instanceof Block1BlockwiseStatus) {
                BlockwiseLayer.this.clearBlock1Status((Block1BlockwiseStatus)status);
            } else if (status instanceof Block2BlockwiseStatus) {
                BlockwiseLayer.this.clearBlock2Status((Block2BlockwiseStatus)status);
            }
        }
    };
    private final LeastRecentlyUsedCache<KeyUri, Block1BlockwiseStatus> block1Transfers;
    private final LeastRecentlyUsedCache<KeyUri, Block2BlockwiseStatus> block2Transfers;
    private final AtomicInteger ignoredBlock2 = new AtomicInteger();
    private final String tag;
    private volatile boolean enableStatus;
    private ScheduledFuture<?> statusLogger;
    private ScheduledFuture<?> cleanup;
    private final int maxTcpBertBulkBlocks;
    private final int maxMessageSize;
    private final int preferredBlockSzx;
    private final int blockTimeout;
    private final int blockInterval;
    private final int maxResourceBodySize;
    private final boolean strictBlock2Option;
    private final int healthStatusInterval;
    private final boolean enableAutoFailoverOn413;

    public BlockwiseLayer(String tag, boolean enableBert, NetworkConfig config) {
        this.tag = tag;
        int blockSize = config.getInt("PREFERRED_BLOCK_SIZE", 512);
        int szx = BlockOption.size2Szx(blockSize);
        String blockSizeDescription = String.valueOf(blockSize);
        int n = this.maxTcpBertBulkBlocks = enableBert ? config.getInt("TCP_NUMBER_OF_BULK_BLOCKS", 1) : 1;
        if (this.maxTcpBertBulkBlocks > 1) {
            szx = 7;
            blockSizeDescription = "1024(BERT)";
        }
        this.maxMessageSize = config.getInt("MAX_MESSAGE_SIZE", 1024);
        this.preferredBlockSzx = szx;
        this.blockTimeout = config.getInt("BLOCKWISE_STATUS_LIFETIME", 300000);
        this.blockInterval = config.getInt("BLOCKWISE_STATUS_INTERVAL", 5000);
        this.maxResourceBodySize = config.getInt("MAX_RESOURCE_BODY_SIZE", 8192);
        int maxActivePeers = config.getInt("MAX_ACTIVE_PEERS", 150000);
        this.block1Transfers = new LeastRecentlyUsedCache(maxActivePeers / 10, maxActivePeers, this.blockTimeout, TimeUnit.MILLISECONDS);
        this.block1Transfers.setEvictingOnReadAccess(false);
        this.block1Transfers.addEvictionListener(new LeastRecentlyUsedCache.EvictionListener<Block1BlockwiseStatus>(){

            @Override
            public void onEviction(Block1BlockwiseStatus status) {
                if (status.complete()) {
                    LOGGER.debug("{}block1 transfer timed out!", (Object)BlockwiseLayer.this.tag);
                    status.timeoutCurrentTranfer();
                }
            }
        });
        this.block2Transfers = new LeastRecentlyUsedCache(maxActivePeers / 10, maxActivePeers, this.blockTimeout, TimeUnit.MILLISECONDS);
        this.block2Transfers.setEvictingOnReadAccess(false);
        this.block2Transfers.addEvictionListener(new LeastRecentlyUsedCache.EvictionListener<Block2BlockwiseStatus>(){

            @Override
            public void onEviction(Block2BlockwiseStatus status) {
                if (status.complete()) {
                    LOGGER.debug("{}block2 transfer timed out!", (Object)BlockwiseLayer.this.tag);
                    status.timeoutCurrentTranfer();
                }
            }
        });
        this.strictBlock2Option = config.getBoolean("BLOCKWISE_STRICT_BLOCK2_OPTION", false);
        this.healthStatusInterval = config.getInt("HEALTH_STATUS_INTERVAL", 60);
        this.enableAutoFailoverOn413 = config.getBoolean("BLOCKWISE_ENTITY_TOO_LARGE_AUTO_FAILOVER", true);
        LOGGER.info("{}BlockwiseLayer uses MAX_MESSAGE_SIZE={}, PREFERRED_BLOCK_SIZE={}, BLOCKWISE_STATUS_LIFETIME={}, MAX_RESOURCE_BODY_SIZE={}, BLOCKWISE_STRICT_BLOCK2_OPTION={}", tag, this.maxMessageSize, blockSizeDescription, this.blockTimeout, this.maxResourceBodySize, this.strictBlock2Option);
    }

    @Override
    public void start() {
        if (this.healthStatusInterval > 0 && HEALTH_LOGGER.isDebugEnabled() && this.statusLogger == null) {
            this.statusLogger = this.secondaryExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (BlockwiseLayer.this.enableStatus) {
                        HEALTH_LOGGER.debug("{}{} block1 transfers", (Object)BlockwiseLayer.this.tag, (Object)BlockwiseLayer.this.block1Transfers.size());
                        Iterator iterator = BlockwiseLayer.this.block1Transfers.valuesIterator(false);
                        int max = 5;
                        while (iterator.hasNext()) {
                            HEALTH_LOGGER.debug("   block1 {}", iterator.next());
                            if (--max != 0) continue;
                        }
                        HEALTH_LOGGER.debug("{}{} block2 transfers", (Object)BlockwiseLayer.this.tag, (Object)BlockwiseLayer.this.block2Transfers.size());
                        iterator = BlockwiseLayer.this.block2Transfers.valuesIterator(false);
                        max = 5;
                        while (iterator.hasNext()) {
                            HEALTH_LOGGER.debug("   block2 {}", iterator.next());
                            if (--max != 0) continue;
                        }
                        HEALTH_LOGGER.debug("{}{} block2 responses ignored", (Object)BlockwiseLayer.this.tag, (Object)BlockwiseLayer.this.ignoredBlock2.get());
                        BlockwiseLayer.this.cleanupExpiredBlockStatus(true);
                    }
                }
            }, this.healthStatusInterval, this.healthStatusInterval, TimeUnit.SECONDS);
        }
        this.cleanup = this.secondaryExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                BlockwiseLayer.this.cleanupExpiredBlockStatus(false);
            }
        }, this.blockInterval, this.blockInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void destroy() {
        if (this.statusLogger != null) {
            this.statusLogger.cancel(false);
            this.statusLogger = null;
        }
        if (this.cleanup != null) {
            this.cleanup.cancel(false);
            this.cleanup = null;
        }
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        Request requestToSend;
        block5: {
            requestToSend = request;
            if (this.isTransparentBlockwiseHandlingEnabled() && !request.isMulticast() && !this.isRandomAccess(exchange)) {
                KeyUri key = KeyUri.getKey(exchange, request);
                Block2BlockwiseStatus status = this.getBlock2Status(key);
                if (status != null) {
                    this.clearBlock2Status(status);
                    status.completeOldTransfer(null);
                }
                if (this.requiresBlock1wise(request)) {
                    try {
                        requestToSend = this.startBlockwiseUpload(key, exchange, request, this.preferredBlockSzx);
                    }
                    catch (BlockwiseTransferException ex) {
                        LOGGER.debug("{}{} {}", this.tag, key, ex.getMessage());
                        if (ex.isCompleted()) break block5;
                        request.setSendError(ex);
                    }
                }
            }
        }
        exchange.setCurrentRequest(requestToSend);
        this.lower().sendRequest(exchange, requestToSend);
    }

    private Request startBlockwiseUpload(KeyUri key, Exchange exchange, Request request, int blockSzx) throws BlockwiseTransferException {
        Block1BlockwiseStatus status = this.getOutboundBlock1Status(key, exchange, request, true);
        Request block = status.getNextRequestBlock(blockSzx);
        Token token = request.getToken();
        if (token != null) {
            block.setToken(token);
        }
        return block;
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        if (this.isTransparentBlockwiseHandlingEnabled()) {
            if (request.getOptions().hasBlock1()) {
                this.handleInboundBlockwiseUpload(exchange, request);
                return;
            }
            BlockOption block2 = request.getOptions().getBlock2();
            if (block2 != null && block2.getNum() > 0) {
                KeyUri key = KeyUri.getKey(exchange, request);
                Block2BlockwiseStatus status = this.getBlock2Status(key);
                if (status != null) {
                    this.handleInboundRequestForNextBlock(exchange, request, status);
                    return;
                }
                LOGGER.debug("{}peer wants to retrieve individual block2 {} of {}, delivering request to application layer", this.tag, block2, key);
            }
        }
        exchange.setRequest(request);
        this.upper().receiveRequest(exchange, request);
    }

    private void handleInboundBlockwiseUpload(Exchange exchange, Request request) {
        if (this.requestExceedsMaxBodySize(request)) {
            int maxResourceBodySize = this.getMaxResourceBodySize(request);
            Response error = Response.createResponse(request, CoAP.ResponseCode.REQUEST_ENTITY_TOO_LARGE);
            error.setPayload(String.format("body too large, max. %d bytes", maxResourceBodySize));
            error.getOptions().setSize1(maxResourceBodySize);
            exchange.setCurrentResponse(error);
            this.lower().sendResponse(exchange, error);
        } else {
            BlockOption block1 = request.getOptions().getBlock1();
            LOGGER.debug("{}inbound request contains block1 option {}", (Object)this.tag, (Object)block1);
            KeyUri key = KeyUri.getKey(exchange, request);
            Block1BlockwiseStatus status = this.getInboundBlock1Status(key, exchange, request, false);
            int blockOffset = block1.getOffset();
            if (blockOffset == 0 && !status.isStarting()) {
                status = this.getInboundBlock1Status(key, exchange, request, true);
            } else if (!status.hasContentFormat(request.getOptions().getContentFormat())) {
                this.sendBlock1ErrorResponse(status, exchange, request, CoAP.ResponseCode.REQUEST_ENTITY_INCOMPLETE, "unexpected Content-Format");
                return;
            }
            try {
                status.addBlock(request);
                if (block1.isM()) {
                    LOGGER.debug("{}acknowledging incoming block1 [num={}], expecting more blocks to come", (Object)this.tag, (Object)block1.getNum());
                    Response piggybacked = Response.createResponse(request, CoAP.ResponseCode.CONTINUE);
                    block1 = this.getLimitedBlockOption(block1);
                    piggybacked.getOptions().setBlock1(block1.getSzx(), true, block1.getNum());
                    exchange.setCurrentResponse(piggybacked);
                    this.lower().sendResponse(exchange, piggybacked);
                } else {
                    LOGGER.debug("{}peer has sent last block1 [num={}], delivering request to application layer", (Object)this.tag, (Object)block1.getNum());
                    exchange.setBlock1ToAck(block1);
                    Request assembled = new Request(request.getCode());
                    status.assembleReceivedMessage(assembled);
                    assembled.setMID(request.getMID());
                    assembled.setToken(request.getToken());
                    assembled.setScheme(request.getScheme());
                    assembled.getOptions().setBlock2(request.getOptions().getBlock2());
                    this.clearBlock1Status(status);
                    exchange.setRequest(assembled);
                    this.upper().receiveRequest(exchange, assembled);
                }
            }
            catch (BlockwiseTransferException ex) {
                CoAP.ResponseCode code = ex.getResponseCode();
                LOGGER.debug("{}peer {} {}. Responding with {}", new Object[]{this.tag, key, ex.getMessage(), code});
                this.sendBlock1ErrorResponse(status, exchange, request, code, ex.getMessage());
            }
        }
    }

    private void sendBlock1ErrorResponse(Block1BlockwiseStatus status, Exchange exchange, Request request, CoAP.ResponseCode errorCode, String message) {
        BlockOption block1 = request.getOptions().getBlock1();
        Response error = Response.createResponse(request, errorCode);
        error.getOptions().setBlock1(block1.getSzx(), block1.isM(), block1.getNum());
        error.setPayload(message);
        this.clearBlock1Status(status);
        exchange.setCurrentResponse(error);
        this.lower().sendResponse(exchange, error);
    }

    private void handleInboundRequestForNextBlock(Exchange exchange, Request request, Block2BlockwiseStatus status) {
        BlockOption block2 = request.getOptions().getBlock2();
        Response nextBlockResponse = status.getNextResponseBlock(block2 = this.getLimitedBlockOption(block2));
        if (nextBlockResponse.getOptions().getBlock2().isM()) {
            LOGGER.debug("{}peer has requested intermediary block of blockwise transfer: {}", (Object)this.tag, (Object)status);
        } else {
            LOGGER.debug("{}peer has requested last block of blockwise transfer: {}", (Object)this.tag, (Object)status);
            this.clearBlock2Status(status);
        }
        exchange.setCurrentResponse(nextBlockResponse);
        this.lower().sendResponse(exchange, nextBlockResponse);
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        Response responseToSend = response;
        if (this.isTransparentBlockwiseHandlingEnabled()) {
            BlockOption requestBlock2 = exchange.getRequest().getOptions().getBlock2();
            if (this.isRandomAccess(exchange)) {
                BlockOption responseBlock2 = response.getOptions().getBlock2();
                if (responseBlock2 != null) {
                    if (requestBlock2.getOffset() != responseBlock2.getOffset()) {
                        LOGGER.warn("{}resource [{}] implementation error, peer requested block offset {} but resource returned block offest {}", this.tag, exchange.getRequest().getURI(), requestBlock2.getOffset(), responseBlock2.getOffset());
                        responseToSend = Response.createResponse(exchange.getRequest(), CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
                        responseToSend.setType(response.getType());
                        responseToSend.setMID(response.getMID());
                        responseToSend.addMessageObservers(response.getMessageObservers());
                    }
                } else if (response.hasBlock(requestBlock2)) {
                    BlockOption block2 = this.getLimitedBlockOption(requestBlock2);
                    Block2BlockwiseStatus.crop(responseToSend, block2, this.maxTcpBertBulkBlocks);
                } else if (!response.isError()) {
                    responseToSend = Response.createResponse(exchange.getRequest(), CoAP.ResponseCode.BAD_OPTION);
                    responseToSend.setType(response.getType());
                    responseToSend.setMID(response.getMID());
                    responseToSend.addMessageObservers(response.getMessageObservers());
                }
            } else if (this.requiresBlock2wise(response, requestBlock2)) {
                BlockOption block2;
                KeyUri key = KeyUri.getKey(exchange, response);
                Block2BlockwiseStatus status = this.getOutboundBlock2Status(key, exchange, response, true);
                responseToSend = status.getNextResponseBlock(block2 = requestBlock2 != null ? this.getLimitedBlockOption(requestBlock2) : new BlockOption(this.preferredBlockSzx, false, 0));
                if (!responseToSend.getOptions().getBlock2().isM()) {
                    this.clearBlock2Status(status);
                }
            } else if (this.requiresBlock2(requestBlock2)) {
                BlockOption block2 = this.getLimitedBlockOption(requestBlock2);
                Block2BlockwiseStatus.crop(responseToSend, block2, this.maxTcpBertBulkBlocks);
            }
            BlockOption block1 = exchange.getBlock1ToAck();
            if (block1 != null) {
                exchange.setBlock1ToAck(null);
                responseToSend.getOptions().setBlock1(block1);
            }
        }
        exchange.setCurrentResponse(responseToSend);
        this.lower().sendResponse(exchange, responseToSend);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        if (this.isTransparentBlockwiseHandlingEnabled() && !exchange.getRequest().isMulticast()) {
            Block2BlockwiseStatus status;
            KeyUri key;
            if (response.isError()) {
                LOGGER.debug("{} received error {}:", (Object)this.tag, (Object)response);
                switch (response.getCode()) {
                    case REQUEST_ENTITY_INCOMPLETE: 
                    case REQUEST_ENTITY_TOO_LARGE: {
                        if (this.handleEntityTooLarge(exchange, response)) {
                            return;
                        }
                        KeyUri key2 = KeyUri.getKey(exchange, exchange.getCurrentRequest());
                        Block1BlockwiseStatus status2 = this.getBlock1Status(key2);
                        if (status2 == null) break;
                        this.clearBlock1Status(status2);
                    }
                }
                if (exchange.getRequest() != exchange.getCurrentRequest()) {
                    Response resp = new Response(response.getCode());
                    resp.setToken(exchange.getRequest().getToken());
                    if (exchange.getRequest().getType() == CoAP.Type.CON) {
                        resp.setType(CoAP.Type.ACK);
                        resp.setMID(exchange.getRequest().getMID());
                    } else {
                        resp.setType(CoAP.Type.NON);
                    }
                    resp.setSourceContext(response.getSourceContext());
                    resp.setPayload(response.getPayload());
                    resp.setOptions(response.getOptions());
                    resp.setApplicationRttNanos(exchange.calculateApplicationRtt());
                    exchange.setResponse(resp);
                    this.upper().receiveResponse(exchange, resp);
                } else {
                    this.upper().receiveResponse(exchange, response);
                }
                return;
            }
            if (response.getMaxResourceBodySize() == 0) {
                response.setMaxResourceBodySize(exchange.getRequest().getMaxResourceBodySize());
            }
            if (!this.isRandomAccess(exchange) && this.discardBlock2(key = KeyUri.getKey(exchange, response), status = this.getBlock2Status(key), exchange, response)) {
                return;
            }
            if (!response.hasBlockOption()) {
                exchange.setResponse(response);
                this.upper().receiveResponse(exchange, response);
            } else {
                if (response.getOptions().hasBlock1()) {
                    this.handleBlock1Response(exchange, response);
                }
                if (response.getOptions().hasBlock2()) {
                    this.handleBlock2Response(exchange, response);
                }
            }
        } else {
            exchange.setResponse(response);
            this.upper().receiveResponse(exchange, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleEntityTooLarge(Exchange exchange, Response response) {
        block22: {
            if (this.enableAutoFailoverOn413) {
                KeyUri key = KeyUri.getKey(exchange, exchange.getRequest());
                try {
                    Request initialRequest = exchange.getRequest();
                    if (response.getOptions().hasBlock1()) {
                        Block1BlockwiseStatus status;
                        BlockOption block1 = response.getOptions().getBlock1();
                        Request blockRequest = null;
                        boolean start = !initialRequest.isCanceled() && block1.getNum() == 0 && block1.getSize() < initialRequest.getPayloadSize();
                        LeastRecentlyUsedCache<KeyUri, Block1BlockwiseStatus> leastRecentlyUsedCache = this.block1Transfers;
                        synchronized (leastRecentlyUsedCache) {
                            status = this.getBlock1Status(key);
                            if (status == null && start) {
                                blockRequest = this.startBlockwiseUpload(key, exchange, initialRequest, Math.min(block1.getSzx(), this.preferredBlockSzx));
                            }
                        }
                        if (status == null) {
                            if (blockRequest != null) {
                                exchange.setCurrentRequest(blockRequest);
                                this.lower().sendRequest(exchange, blockRequest);
                                return true;
                            }
                        } else {
                            if (!status.hasMatchingToken(response)) {
                                LOGGER.debug("{}discarding obsolete block1 response: {}", (Object)this.tag, (Object)response);
                                return true;
                            }
                            if (initialRequest.isCanceled()) {
                                this.clearBlock1Status(status);
                                return true;
                            }
                            if (status.isStarting() && block1.getSzx() < this.preferredBlockSzx) {
                                status.restart();
                                this.sendNextBlock(exchange, response, status);
                                return true;
                            }
                        }
                        break block22;
                    }
                    if (exchange.getRequest().isCanceled()) break block22;
                    Request requestToSend = null;
                    Integer maxSize = response.getOptions().getSize1();
                    if (maxSize != null && (maxSize < 16 || maxSize >= initialRequest.getPayloadSize())) {
                        maxSize = null;
                    }
                    if (maxSize == null && initialRequest.getPayloadSize() > 16) {
                        maxSize = initialRequest.getPayloadSize() - 1;
                    }
                    if (maxSize != null) {
                        LeastRecentlyUsedCache<KeyUri, Block1BlockwiseStatus> leastRecentlyUsedCache = this.block1Transfers;
                        synchronized (leastRecentlyUsedCache) {
                            if (this.getBlock1Status(key) == null) {
                                int blockszx = BlockOption.size2Szx(maxSize);
                                requestToSend = this.startBlockwiseUpload(key, exchange, initialRequest, Math.min(blockszx, this.preferredBlockSzx));
                            }
                        }
                    }
                    if (requestToSend != null) {
                        exchange.setCurrentRequest(requestToSend);
                        this.lower().sendRequest(exchange, requestToSend);
                        return true;
                    }
                }
                catch (BlockwiseTransferException ex) {
                    LOGGER.debug("{}{} {}", this.tag, key, ex.getMessage());
                }
            }
        }
        return false;
    }

    private void handleBlock1Response(Exchange exchange, Response response) {
        BlockOption block1 = response.getOptions().getBlock1();
        LOGGER.debug("{}received response acknowledging block1 {}", (Object)this.tag, (Object)block1);
        KeyUri key = KeyUri.getKey(exchange, exchange.getRequest());
        Block1BlockwiseStatus status = this.getBlock1Status(key);
        if (status == null) {
            LOGGER.debug("{}discarding unexpected block1 response: {}", (Object)this.tag, (Object)response);
        } else if (!status.hasMatchingToken(response)) {
            LOGGER.debug("{}discarding obsolete block1 response: {}", (Object)this.tag, (Object)response);
        } else if (exchange.getRequest().isCanceled()) {
            this.clearBlock1Status(status);
        } else if (!status.isComplete()) {
            if (block1.isM()) {
                if (response.getCode() == CoAP.ResponseCode.CONTINUE) {
                    this.sendNextBlock(exchange, response, status);
                } else {
                    this.clearBlock1Status(status);
                    exchange.getRequest().setRejected(true);
                }
            } else {
                this.sendNextBlock(exchange, response, status);
            }
        } else {
            this.clearBlock1Status(status);
            if (response.getOptions().hasBlock2()) {
                LOGGER.debug("{}Block1 followed by Block2 transfer", (Object)this.tag);
            } else {
                exchange.setResponse(response);
                this.upper().receiveResponse(exchange, response);
            }
        }
    }

    private void sendNextBlock(Exchange exchange, Response response, Block1BlockwiseStatus status) {
        Request nextBlock = null;
        try {
            if (status.isComplete()) {
                LOGGER.debug("{}stopped block1 transfer, droping request.", (Object)this.tag);
            } else {
                int blockSzx = Math.min(response.getOptions().getBlock1().getSzx(), this.preferredBlockSzx);
                nextBlock = status.getNextRequestBlock(blockSzx);
                nextBlock.setToken(response.getToken());
                nextBlock.setDestinationContext(status.getFollowUpEndpointContext(response.getSourceContext()));
                LOGGER.debug("{}sending (next) Block1 [num={}]: {}", this.tag, nextBlock.getOptions().getBlock1().getNum(), nextBlock);
                exchange.setCurrentRequest(nextBlock);
                this.lower().sendRequest(exchange, nextBlock);
            }
        }
        catch (BlockwiseTransferException ex) {
            LOGGER.warn("{}cannot process next block request, aborting request!", (Object)this.tag, (Object)ex);
            if (!ex.isCompleted()) {
                exchange.getRequest().setSendError(ex);
            }
        }
        catch (RuntimeException ex) {
            LOGGER.warn("{}cannot process next block request, aborting request!", (Object)this.tag, (Object)ex);
            if (nextBlock != null) {
                nextBlock.setSendError(ex);
            }
            exchange.getRequest().setSendError(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean discardBlock2(KeyUri key, Block2BlockwiseStatus status, Exchange exchange, Response response) {
        boolean starting;
        BlockOption block = response.getOptions().getBlock2();
        if (status == null) {
            if (block == null) return false;
            if (block.getNum() == 0) return false;
            LOGGER.debug("{}discarding stale block2 response [{}, {}] received without ongoing block2 transfer for {}", this.tag, exchange.getNotificationNumber(), response, key);
            exchange.setComplete();
            return true;
        }
        boolean bl = starting = block == null || block.getNum() == 0;
        if (!starting) {
            if (status.matchTransfer(exchange)) return false;
            LOGGER.debug("{}discarding outdate block2 response [{}, {}] received during ongoing block2 transfer {}", this.tag, exchange.getNotificationNumber(), response, status.getObserve());
            status.completeNewTranfer(exchange);
            return true;
        }
        if (status.isNew(response)) {
            LOGGER.debug("{}discarding outdated block2 transfer {}, current is [{}]", this.tag, status.getObserve(), response);
            this.clearBlock2Status(status);
            status.completeOldTransfer(exchange);
            return false;
        }
        LOGGER.debug("{}discarding old block2 transfer [{}], received during ongoing block2 transfer {}", this.tag, response, status.getObserve());
        status.completeNewTranfer(exchange);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBlock2Response(Exchange exchange, Response response) {
        block16: {
            BlockOption block2 = response.getOptions().getBlock2();
            KeyUri key = KeyUri.getKey(exchange, response);
            if (exchange.getRequest().isCanceled()) {
                Block2BlockwiseStatus status = this.getBlock2Status(key);
                if (status != null) {
                    this.clearBlock2Status(status);
                }
                if (response.isNotification()) {
                    this.upper().receiveResponse(exchange, response);
                }
            } else if (this.responseExceedsMaxBodySize(response)) {
                String msg = String.format("requested resource body [%d bytes] exceeds max buffer size [%d bytes], aborting request", response.getOptions().getSize2(), this.getMaxResourceBodySize(response));
                LOGGER.debug("{}{}", (Object)this.tag, (Object)msg);
                exchange.getRequest().setOnResponseError(new IllegalStateException(msg));
            } else if (this.isRandomAccess(exchange)) {
                exchange.setResponse(response);
                this.upper().receiveResponse(exchange, response);
            } else {
                Block2BlockwiseStatus status;
                LeastRecentlyUsedCache<KeyUri, Block2BlockwiseStatus> leastRecentlyUsedCache = this.block2Transfers;
                synchronized (leastRecentlyUsedCache) {
                    status = this.getBlock2Status(key);
                    if (this.discardBlock2(key, status, exchange, response)) {
                        return;
                    }
                    status = this.getInboundBlock2Status(key, exchange, response);
                }
                try {
                    status.addBlock(response);
                    if (block2.isM()) {
                        this.requestNextBlock(exchange, response, status);
                    } else {
                        LOGGER.debug("{}all blocks have been retrieved, assembling response and delivering to application layer", (Object)this.tag);
                        Response assembled = new Response(response.getCode());
                        status.assembleReceivedMessage(assembled);
                        assembled.setApplicationRttNanos(exchange.calculateApplicationRtt());
                        this.clearBlock2Status(status);
                        LOGGER.debug("{}assembled response: {}", (Object)this.tag, (Object)assembled);
                        exchange.setCurrentRequest(exchange.getRequest());
                        exchange.setResponse(assembled);
                        this.upper().receiveResponse(exchange, assembled);
                    }
                }
                catch (BlockwiseTransferException ex) {
                    this.ignoredBlock2.incrementAndGet();
                    LOGGER.debug("{}peer {}{}. Ignores response", this.tag, key, ex.getMessage());
                    if (ex.isCompleted()) break block16;
                    exchange.getRequest().setOnResponseError(ex);
                }
            }
        }
    }

    private void requestNextBlock(Exchange exchange, Response response, Block2BlockwiseStatus status) {
        block8: {
            int blockSzx = Math.min(response.getOptions().getBlock2().getSzx(), this.preferredBlockSzx);
            if (response.isNotification() && exchange.isNotification()) {
                exchange.getRequest().addMessageObserver(new CleanupMessageObserver(exchange));
            }
            try {
                Request block = status.getNextRequestBlock(blockSzx);
                block.setDestinationContext(status.getFollowUpEndpointContext(response.getSourceContext()));
                if (!response.isNotification()) {
                    block.setToken(response.getToken());
                }
                if (status.isComplete()) {
                    LOGGER.debug("{}stopped block2 transfer, droping response.", (Object)this.tag);
                } else {
                    LOGGER.debug("{}requesting next Block2 [num={}]: {}", this.tag, block.getOptions().getBlock2().getNum(), block);
                    exchange.setCurrentRequest(block);
                    this.lower().sendRequest(exchange, block);
                }
            }
            catch (BlockwiseTransferException ex) {
                LOGGER.debug("{}{} Stop next block request!", (Object)this.tag, (Object)ex.getMessage());
                if (!ex.isCompleted()) {
                    exchange.getRequest().setSendError(ex);
                }
            }
            catch (RuntimeException ex) {
                LOGGER.debug("{}cannot process next block request, aborting request!", (Object)this.tag, (Object)ex);
                if (exchange.isComplete()) break block8;
                exchange.getRequest().setSendError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block1BlockwiseStatus getOutboundBlock1Status(KeyUri key, Exchange exchange, Request request, boolean reset) {
        Integer size = null;
        Block1BlockwiseStatus previousStatus = null;
        Block1BlockwiseStatus status = null;
        LeastRecentlyUsedCache<KeyUri, Block1BlockwiseStatus> leastRecentlyUsedCache = this.block1Transfers;
        synchronized (leastRecentlyUsedCache) {
            if (reset) {
                previousStatus = this.block1Transfers.remove(key);
            } else {
                status = this.block1Transfers.get(key);
            }
            if (status == null) {
                status = Block1BlockwiseStatus.forOutboundRequest(key, this.removeHandler, exchange, request, this.maxTcpBertBulkBlocks);
                this.block1Transfers.put(key, status);
                this.enableStatus = true;
                size = this.block1Transfers.size();
            }
        }
        if (previousStatus != null && previousStatus.cancelRequest()) {
            LOGGER.debug("{}stop previous block1 transfer {} {} for new {}", this.tag, key, previousStatus, request);
        }
        if (size != null) {
            LOGGER.debug("{}created tracker for outbound block1 transfer {}, transfers in progress: {}", this.tag, status, size);
        } else {
            LOGGER.debug("{}block1 transfer {} for {}", this.tag, key, request);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block1BlockwiseStatus getInboundBlock1Status(KeyUri key, Exchange exchange, Request request, boolean reset) {
        Integer size = null;
        Block1BlockwiseStatus previousStatus = null;
        Block1BlockwiseStatus status = null;
        int maxPayloadSize = this.getMaxResourceBodySize(request);
        LeastRecentlyUsedCache<KeyUri, Block1BlockwiseStatus> leastRecentlyUsedCache = this.block1Transfers;
        synchronized (leastRecentlyUsedCache) {
            if (reset) {
                previousStatus = this.block1Transfers.remove(key);
            } else {
                status = this.block1Transfers.get(key);
            }
            if (status == null) {
                status = Block1BlockwiseStatus.forInboundRequest(key, this.removeHandler, exchange, request, maxPayloadSize, this.maxTcpBertBulkBlocks);
                this.block1Transfers.put(key, status);
                this.enableStatus = true;
                size = this.block1Transfers.size();
            }
        }
        if (previousStatus != null && previousStatus.complete()) {
            LOGGER.debug("{}stop previous block1 transfer {} {} for new {}", this.tag, key, previousStatus, request);
        }
        if (size != null) {
            LOGGER.debug("{}created tracker for inbound block1 transfer {}, transfers in progress: {}", this.tag, status, size);
        } else {
            LOGGER.debug("{}block1 transfer {} for {}", this.tag, key, request);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block2BlockwiseStatus getOutboundBlock2Status(KeyUri key, Exchange exchange, Response response, boolean reset) {
        Integer size = null;
        Block2BlockwiseStatus previousStatus = null;
        Block2BlockwiseStatus status = null;
        LeastRecentlyUsedCache<KeyUri, Block2BlockwiseStatus> leastRecentlyUsedCache = this.block2Transfers;
        synchronized (leastRecentlyUsedCache) {
            if (reset) {
                previousStatus = this.block2Transfers.remove(key);
            } else {
                status = this.block2Transfers.get(key);
            }
            if (status == null) {
                status = Block2BlockwiseStatus.forOutboundResponse(key, this.removeHandler, exchange, response, this.maxTcpBertBulkBlocks);
                this.block2Transfers.put(key, status);
                this.enableStatus = true;
                size = this.block2Transfers.size();
            }
        }
        if (previousStatus != null && previousStatus.completeResponse()) {
            LOGGER.debug("{}stop previous block2 transfer {} {} for new {}", this.tag, key, previousStatus, response);
        }
        if (size != null) {
            LOGGER.debug("{}created tracker for outbound block2 transfer {}, transfers in progress: {}", this.tag, status, size);
        } else {
            LOGGER.debug("{}block2 transfer {} for {}", this.tag, key, response);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block2BlockwiseStatus getInboundBlock2Status(KeyUri key, Exchange exchange, Response response) {
        Block2BlockwiseStatus status;
        Integer size = null;
        int maxPayloadSize = this.getMaxResourceBodySize(response);
        LeastRecentlyUsedCache<KeyUri, Block2BlockwiseStatus> leastRecentlyUsedCache = this.block2Transfers;
        synchronized (leastRecentlyUsedCache) {
            status = this.block2Transfers.get(key);
            if (status == null) {
                status = Block2BlockwiseStatus.forInboundResponse(key, this.removeHandler, exchange, response, maxPayloadSize, this.maxTcpBertBulkBlocks);
                this.block2Transfers.put(key, status);
                this.enableStatus = true;
                size = this.block2Transfers.size();
            }
        }
        if (size != null) {
            LOGGER.debug("{}created tracker for {} inbound block2 transfer {}, transfers in progress: {}, {}", this.tag, key, status, size, response);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block1BlockwiseStatus getBlock1Status(KeyUri key) {
        LeastRecentlyUsedCache<KeyUri, Block1BlockwiseStatus> leastRecentlyUsedCache = this.block1Transfers;
        synchronized (leastRecentlyUsedCache) {
            return this.block1Transfers.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block2BlockwiseStatus getBlock2Status(KeyUri key) {
        LeastRecentlyUsedCache<KeyUri, Block2BlockwiseStatus> leastRecentlyUsedCache = this.block2Transfers;
        synchronized (leastRecentlyUsedCache) {
            return this.block2Transfers.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupExpiredBlockStatus(boolean dump) {
        int count = 0;
        LeastRecentlyUsedCache<KeyUri, BlockwiseStatus> leastRecentlyUsedCache = this.block1Transfers;
        synchronized (leastRecentlyUsedCache) {
            count += this.block1Transfers.removeExpiredEntries(128);
        }
        leastRecentlyUsedCache = this.block2Transfers;
        synchronized (leastRecentlyUsedCache) {
            count += this.block2Transfers.removeExpiredEntries(128);
        }
        if (dump) {
            HEALTH_LOGGER.debug("{}cleaned up {} block transfers!", (Object)this.tag, (Object)count);
        } else if (this.enableStatus && count > 0) {
            LOGGER.info("{}cleaned up {} block transfers!", (Object)this.tag, (Object)count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block1BlockwiseStatus clearBlock1Status(Block1BlockwiseStatus status) {
        int size;
        Block1BlockwiseStatus removedTracker;
        LeastRecentlyUsedCache<KeyUri, Block1BlockwiseStatus> leastRecentlyUsedCache = this.block1Transfers;
        synchronized (leastRecentlyUsedCache) {
            removedTracker = this.block1Transfers.remove(status.getKeyUri(), status);
            size = this.block1Transfers.size();
        }
        if (removedTracker != null && removedTracker.complete()) {
            LOGGER.debug("{}removing block1 tracker [{}], block1 transfers still in progress: {}", this.tag, status.getKeyUri(), size);
        }
        return removedTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block2BlockwiseStatus clearBlock2Status(Block2BlockwiseStatus status) {
        int size;
        Block2BlockwiseStatus removedTracker;
        LeastRecentlyUsedCache<KeyUri, Block2BlockwiseStatus> leastRecentlyUsedCache = this.block2Transfers;
        synchronized (leastRecentlyUsedCache) {
            removedTracker = this.block2Transfers.remove(status.getKeyUri(), status);
            size = this.block2Transfers.size();
        }
        if (removedTracker != null && removedTracker.complete()) {
            LOGGER.debug("{}removing block2 tracker [{}], block2 transfers still in progress: {}", this.tag, status.getKeyUri(), size);
        }
        return removedTracker;
    }

    private boolean requiresBlock1wise(Request request) {
        boolean blockwiseRequired;
        boolean bl = blockwiseRequired = request.getPayloadSize() > this.maxMessageSize;
        if (blockwiseRequired) {
            LOGGER.debug("{}request body [{}/{}] requires blockwise transfer", this.tag, request.getPayloadSize(), this.maxMessageSize);
        }
        return blockwiseRequired;
    }

    private boolean requiresBlock2wise(Response response, BlockOption requestBlock2) {
        boolean blockwiseRequired;
        boolean bl = blockwiseRequired = response.getPayloadSize() > this.maxMessageSize;
        if (!blockwiseRequired && requestBlock2 != null) {
            int szx = Math.min(requestBlock2.getSzx(), this.preferredBlockSzx);
            int size = BlockOption.szx2Size(szx);
            boolean bl2 = blockwiseRequired = response.getPayloadSize() > size;
        }
        if (blockwiseRequired) {
            LOGGER.debug("{}response body [{}/{}] requires blockwise transfer", this.tag, response.getPayloadSize(), this.maxMessageSize);
        }
        return blockwiseRequired;
    }

    private boolean requiresBlock2(BlockOption requestBlock2) {
        boolean block2Required;
        boolean bl = block2Required = this.strictBlock2Option && requestBlock2 != null;
        if (block2Required) {
            LOGGER.debug("{}response requires requested {} blockwise transfer", (Object)this.tag, (Object)requestBlock2);
        }
        return block2Required;
    }

    private boolean isRandomAccess(Exchange exchange) {
        BlockOption block2 = exchange.getRequest().getOptions().getBlock2();
        return block2 != null && block2.getNum() > 0;
    }

    private boolean isTransparentBlockwiseHandlingEnabled() {
        return this.maxResourceBodySize > 0;
    }

    private boolean responseExceedsMaxBodySize(Response response) {
        return response.getOptions().hasSize2() && response.getOptions().getSize2() > this.getMaxResourceBodySize(response);
    }

    private boolean requestExceedsMaxBodySize(Request request) {
        return request.getOptions().hasSize1() && request.getOptions().getSize1() > this.getMaxResourceBodySize(request);
    }

    private int getMaxResourceBodySize(Message message) {
        int maxPayloadSize = message.getMaxResourceBodySize();
        if (maxPayloadSize == 0) {
            maxPayloadSize = this.maxResourceBodySize;
        }
        return maxPayloadSize;
    }

    private BlockOption getLimitedBlockOption(BlockOption block) {
        if (this.preferredBlockSzx < block.getSzx()) {
            int size;
            int offset = block.getOffset();
            if (offset % (size = BlockOption.szx2Size(this.preferredBlockSzx)) != 0) {
                throw new IllegalStateException("Block offset " + offset + " doesn't align with preferred blocksize " + size + "!");
            }
            return new BlockOption(this.preferredBlockSzx, block.isM(), offset / size);
        }
        return block;
    }

    public boolean isEmpty() {
        return this.block1Transfers.size() == 0 && this.block2Transfers.size() == 0;
    }
}

