/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.security.Principal;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.StringUtil;

public final class Utils {
    private Utils() {
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        return "[" + StringUtil.byteArray2Hex(bytes) + "]";
    }

    public static String toHexText(byte[] bytes, int length) {
        if (bytes == null) {
            return "null";
        }
        if (length > bytes.length) {
            length = bytes.length;
        }
        StringBuilder sb = new StringBuilder();
        if (16 < length) {
            sb.append(StringUtil.lineSeparator());
        }
        for (int index = 0; index < length; ++index) {
            sb.append(String.format("%02x", bytes[index] & 0xFF));
            if (31 == (0x1F & index)) {
                sb.append(StringUtil.lineSeparator());
                continue;
            }
            sb.append(' ');
        }
        if (length < bytes.length) {
            sb.append(" .. ").append(bytes.length).append(" bytes");
        }
        return sb.toString();
    }

    public static String prettyPrint(Request r) {
        String nl = StringUtil.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append("==[ CoAP Request ]=============================================").append(nl);
        sb.append(String.format("MID    : %d%n", r.getMID()));
        sb.append(String.format("Token  : %s%n", r.getTokenString()));
        sb.append(String.format("Type   : %s%n", new Object[]{r.getType()}));
        CoAP.Code code = r.getCode();
        if (code == null) {
            sb.append("Method : 0.00 - PING").append(nl);
        } else {
            sb.append(String.format("Method : %s - %s%n", code.text, code.name()));
        }
        if (r.getOffloadMode() != null) {
            sb.append("(offloaded)").append(nl);
        } else {
            sb.append(String.format("Options: %s%n", r.getOptions()));
            sb.append(String.format("Payload: %d Bytes%n", r.getPayloadSize()));
            if (r.getPayloadSize() > 0 && MediaTypeRegistry.isPrintable(r.getOptions().getContentFormat())) {
                sb.append("---------------------------------------------------------------").append(nl);
                sb.append(r.getPayloadString());
                sb.append(nl);
            }
        }
        sb.append("===============================================================");
        return sb.toString();
    }

    public static String prettyPrint(CoapResponse r) {
        return Utils.prettyPrint(r.advanced());
    }

    public static String prettyPrint(Response r) {
        String nl = StringUtil.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append("==[ CoAP Response ]============================================").append(nl);
        sb.append(String.format("MID    : %d%n", r.getMID()));
        sb.append(String.format("Token  : %s%n", r.getTokenString()));
        sb.append(String.format("Type   : %s%n", new Object[]{r.getType()}));
        CoAP.ResponseCode code = r.getCode();
        sb.append(String.format("Status : %s - %s%n", new Object[]{code, code.name()}));
        if (r.getOffloadMode() != null) {
            if (r.getRTT() != null) {
                sb.append(String.format("RTT    : %d ms%n", r.getRTT()));
                sb.append("(offloaded)").append(nl);
            }
        } else {
            sb.append(String.format("Options: %s%n", r.getOptions()));
            if (r.getRTT() != null) {
                sb.append(String.format("RTT    : %d ms%n", r.getRTT()));
            }
            sb.append(String.format("Payload: %d Bytes%n", r.getPayloadSize()));
            if (r.getPayloadSize() > 0 && MediaTypeRegistry.isPrintable(r.getOptions().getContentFormat())) {
                sb.append("---------------------------------------------------------------").append(nl);
                sb.append(r.getPayloadString());
                sb.append(nl);
            }
        }
        sb.append("===============================================================");
        return sb.toString();
    }

    public static String prettyPrint(EndpointContext endpointContext) {
        Principal principal;
        String nl = StringUtil.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(">>> ").append(endpointContext);
        String cipher = endpointContext.get("DTLS_CIPHER");
        if (cipher == null) {
            cipher = endpointContext.get("TLS_CIPHER");
        }
        if (cipher != null) {
            sb.append(nl).append(">>> ").append(cipher);
        }
        if ((principal = endpointContext.getPeerIdentity()) != null) {
            sb.append(nl).append(">>> ").append(principal);
        }
        return sb.toString();
    }
}

