/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.ConnectionExecutionListener;
import org.eclipse.californium.scandium.ConnectionListener;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.slf4j.MDC;

public class MdcConnectionListener
implements ConnectionExecutionListener,
ConnectionListener {
    private static final boolean MDC_SUPPORT;

    @Override
    public void onConnectionEstablished(Connection connection) {
    }

    @Override
    public void onConnectionRemoved(Connection connection) {
    }

    @Override
    public void beforeExecution(Connection connection) {
        if (MDC_SUPPORT) {
            ConnectionId cid;
            InetSocketAddress peerAddress = connection.getPeerAddress();
            if (peerAddress != null) {
                MDC.put("PEER", StringUtil.toString(peerAddress));
            }
            if ((cid = connection.getConnectionId()) != null) {
                MDC.put("CONNECTION_ID", cid.getAsString());
            }
            SessionId sid = connection.getSessionIdentity();
            DTLSSession session = connection.getSession();
            if (session != null) {
                sid = session.getSessionIdentifier();
                ConnectionId writeConnectionId = session.getWriteConnectionId();
                if (writeConnectionId != null && !writeConnectionId.isEmpty()) {
                    MDC.put("WRITE_CONNECTION_ID", writeConnectionId.getAsString());
                }
            }
            if (sid != null) {
                MDC.put("SESSION_ID", sid.toString());
            }
        }
    }

    @Override
    public void updateExecution(Connection connection) {
        this.beforeExecution(connection);
    }

    @Override
    public void afterExecution(Connection connection) {
        if (MDC_SUPPORT) {
            MDC.clear();
        }
    }

    static {
        boolean mdc = false;
        try {
            MDC.clear();
            mdc = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MDC_SUPPORT = mdc;
    }
}

