/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.eclipse.californium.elements.ExtendedConnector;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.elements.UDPConnector;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.DtlsClusterConnector;
import org.eclipse.californium.scandium.config.DtlsClusterConnectorConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.ResumptionSupportingConnectionStore;
import org.eclipse.californium.scandium.dtls.SessionCache;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedSinglePskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtlsManagedClusterConnector
extends DtlsClusterConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DtlsManagedClusterConnector.class);
    public static final String PROTOCOL_MANAGEMENT_UDP = "mgmt-udp";
    public static final String PROTOCOL_MANAGEMENT_DTLS = "mgmt-dtls";
    public static final String PROTOCOL_MANAGEMENT_DTLS_MAC = "mgmt-dtls-mac";
    private final String protocol;
    private final boolean useClusterMac;
    private final ExtendedConnector clusterManagementConnector;

    public DtlsManagedClusterConnector(DtlsConnectorConfig configuration, DtlsClusterConnectorConfig clusterConfiguration) {
        this(configuration, clusterConfiguration, (SessionCache)null);
    }

    public DtlsManagedClusterConnector(DtlsConnectorConfig configuration, DtlsClusterConnectorConfig clusterConfiguration, SessionCache sessionCache) {
        this(configuration, clusterConfiguration, DtlsManagedClusterConnector.createConnectionStore(configuration, sessionCache));
    }

    protected DtlsManagedClusterConnector(DtlsConnectorConfig configuration, DtlsClusterConnectorConfig clusterConfiguration, ResumptionSupportingConnectionStore connectionStore) {
        super(configuration, clusterConfiguration, connectionStore, false);
        String identity = clusterConfiguration.getSecureIdentity();
        Integer mgmtReceiveBuffer = DtlsManagedClusterConnector.addConditionally(this.config.getSocketReceiveBufferSize(), 28);
        Integer mgmtSendBuffer = DtlsManagedClusterConnector.addConditionally(this.config.getSocketSendBufferSize(), 28);
        if (identity != null) {
            SecretKey secretkey = clusterConfiguration.getSecretKey();
            DtlsConnectorConfig.Builder builder = DtlsConnectorConfig.builder().setAddress(clusterConfiguration.getAddress()).setReceiverThreadCount(0).setMaxConnections(1024).setSocketReceiveBufferSize(mgmtReceiveBuffer).setSocketSendBufferSize(mgmtSendBuffer).setAdvancedPskStore(new AdvancedSinglePskStore(identity, secretkey));
            SecretUtil.destroy(secretkey);
            this.clusterManagementConnector = new ClusterManagementDtlsConnector(builder.build());
            this.useClusterMac = clusterConfiguration.useClusterMac();
            this.protocol = this.useClusterMac ? PROTOCOL_MANAGEMENT_DTLS_MAC : PROTOCOL_MANAGEMENT_DTLS;
        } else {
            ClusterManagementUdpConnector udpConnector = new ClusterManagementUdpConnector(clusterConfiguration.getAddress());
            udpConnector.setReceiverThreadCount(0);
            udpConnector.setSenderThreadCount(2);
            if (mgmtReceiveBuffer != null) {
                udpConnector.setReceiveBufferSize(mgmtReceiveBuffer);
            }
            if (mgmtSendBuffer != null) {
                udpConnector.setSendBufferSize(mgmtSendBuffer);
            }
            this.clusterManagementConnector = udpConnector;
            this.useClusterMac = false;
            this.protocol = PROTOCOL_MANAGEMENT_UDP;
        }
        LOGGER.info("cluster-node {} ({}): recv. buffer {}, send buffer {}", this.getNodeID(), this.protocol, mgmtReceiveBuffer, mgmtSendBuffer);
    }

    @Override
    protected void init(InetSocketAddress bindAddress, DatagramSocket socket, Integer mtu) throws IOException {
        super.init(bindAddress, socket, mtu);
        this.clusterManagementConnector.start();
        this.startReceiver();
    }

    @Override
    public void stop() {
        super.stop();
        this.clusterManagementConnector.stop();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.clusterManagementConnector.destroy();
    }

    @Override
    protected int getClusterMacLength() {
        return this.useClusterMac ? 8 : 0;
    }

    public String getManagementProtocol() {
        return this.protocol;
    }

    public ExtendedConnector getClusterManagementConnector() {
        return this.clusterManagementConnector;
    }

    @Override
    protected void processDatagramFromClusterNetwork(Byte type, DatagramPacket clusterPacket) throws IOException {
        if (this.useClusterMac) {
            try {
                DTLSSession session = ((DTLSConnector)((Object)this.clusterManagementConnector)).getSessionByAddress((InetSocketAddress)clusterPacket.getSocketAddress());
                if (session == null) {
                    throw new IOException("Cluster MAC could not be validated! Missing session.");
                }
                Mac mac = session.getThreadLocalClusterReadMac();
                if (mac == null) {
                    throw new IOException("Cluster MAC could not be validated! Missing keys.");
                }
                if (!DtlsManagedClusterConnector.validateClusterMac(mac, clusterPacket)) {
                    if (LOGGER.isInfoEnabled()) {
                        byte[] mac2 = Arrays.copyOf(DtlsManagedClusterConnector.calculateClusterMac(mac, clusterPacket), 8);
                        byte[] data = clusterPacket.getData();
                        int offset = clusterPacket.getOffset();
                        int macOffset = 4 + (data[offset + 3] & 0xFF);
                        byte[] mac3 = Arrays.copyOfRange(data, offset + macOffset, offset + macOffset + 8);
                        LOGGER.info("cluster-node {} ({}): drop internal record, cluster MAC failure! {} != {}", this.getNodeID(), this.protocol, StringUtil.byteArray2Hex(mac2), StringUtil.byteArray2Hex(mac3));
                    }
                    if (this.clusterHealth != null) {
                        if (type == RECORD_TYPE_INCOMING) {
                            this.clusterHealth.badForwardMessage();
                        } else if (type == RECORD_TYPE_OUTGOING) {
                            this.clusterHealth.badBackwardMessage();
                        }
                    }
                    return;
                }
            }
            catch (RuntimeException ex) {
                LOGGER.debug("cluster-node {} ({}): receiving failed!", this.getNodeID(), this.protocol, ex);
                throw new IOException("Cluster MAC could not be validated!", ex);
            }
        }
        super.processDatagramFromClusterNetwork(type, clusterPacket);
    }

    @Override
    protected void sendDatagramToClusterNetwork(DatagramPacket clusterPacket) throws IOException {
        if (this.useClusterMac) {
            try {
                DTLSSession session = ((DTLSConnector)((Object)this.clusterManagementConnector)).getSessionByAddress((InetSocketAddress)clusterPacket.getSocketAddress());
                if (session == null) {
                    throw new IOException("Cluster MAC could not be generated! Missing session.");
                }
                Mac mac = session.getThreadLocalClusterWriteMac();
                if (mac == null) {
                    throw new IOException("Cluster MAC could not be generated! Missing keys.");
                }
                DtlsManagedClusterConnector.setClusterMac(mac, clusterPacket);
            }
            catch (RuntimeException ex) {
                LOGGER.debug("cluster-node {} ({}): sending failed!", this.getNodeID(), this.protocol, ex);
                throw new IOException("Cluster MAC could not be generated!", ex);
            }
        }
        super.sendDatagramToClusterNetwork(clusterPacket);
    }

    public static boolean validateClusterMac(Mac mac, DatagramPacket clusterPacket) {
        byte[] macBytes = DtlsManagedClusterConnector.calculateClusterMac(mac, clusterPacket);
        byte[] data = clusterPacket.getData();
        int offset = clusterPacket.getOffset();
        int macOffset = offset + 4 + (data[offset + 3] & 0xFF);
        int diffs = 0;
        for (int index = 0; index < 8; ++index) {
            if (macBytes[index] == data[macOffset + index]) continue;
            ++diffs;
        }
        return diffs == 0;
    }

    public static void setClusterMac(Mac mac, DatagramPacket clusterPacket) {
        byte[] macBytes = DtlsManagedClusterConnector.calculateClusterMac(mac, clusterPacket);
        byte[] data = clusterPacket.getData();
        int offset = clusterPacket.getOffset();
        int macOffset = 4 + (data[offset + 3] & 0xFF);
        System.arraycopy(macBytes, 0, data, offset + macOffset, 8);
    }

    public static byte[] calculateClusterMac(Mac mac, DatagramPacket clusterPacket) {
        int length;
        int offset;
        byte[] data = clusterPacket.getData();
        int macOffset = 4 + (data[(offset = clusterPacket.getOffset()) + 3] & 0xFF);
        int headerOffset = macOffset + 8;
        if (headerOffset < (length = clusterPacket.getLength())) {
            mac.update(data, offset, macOffset);
            if ((length -= headerOffset) > 0) {
                offset += headerOffset;
                if (length > 64 - macOffset) {
                    mac.update(data, offset, 32);
                    offset += length - 32;
                    length = 32;
                }
                mac.update(data, offset, length);
            }
            return mac.doFinal();
        }
        throw new IllegalArgumentException(length + " bytes is too small for cluster MAC message!");
    }

    @Override
    protected void processManagementDatagramFromClusterNetwork(DatagramPacket clusterPacket) throws IOException {
        LOGGER.trace("cluster-node {} ({}): process datagram from {}, {} bytes", this.getNodeID(), this.protocol, clusterPacket.getAddress(), clusterPacket.getLength());
        this.clusterManagementConnector.processDatagram(clusterPacket);
    }

    private static Integer addConditionally(Integer value, int add) {
        if (value != null && value != 0) {
            return value + add;
        }
        return value;
    }

    private class ClusterManagementDtlsConnector
    extends DTLSConnector
    implements ExtendedConnector {
        public ClusterManagementDtlsConnector(DtlsConnectorConfig configuration) {
            super(configuration);
        }

        @Override
        protected void onInitializeHandshaker(Handshaker handshaker) {
            if (DtlsManagedClusterConnector.this.useClusterMac) {
                handshaker.setGenerateClusterMacKeys(DtlsManagedClusterConnector.this.useClusterMac);
            }
        }

        @Override
        protected void start(InetSocketAddress bindAddress) throws IOException {
            if (this.isRunning()) {
                return;
            }
            this.init(bindAddress, DtlsManagedClusterConnector.this.clusterInternalSocket, this.config.getMaxTransmissionUnit());
        }

        @Override
        public void setRawDataReceiver(final RawDataChannel messageHandler) {
            super.setRawDataReceiver(new RawDataChannel(){

                @Override
                public void receiveData(RawData raw) {
                    messageHandler.receiveData(raw);
                    if (DtlsManagedClusterConnector.this.clusterHealth != null) {
                        DtlsManagedClusterConnector.this.clusterHealth.receivingClusterManagementMessage();
                    }
                }
            });
        }

        @Override
        public void processDatagram(DatagramPacket datagram) {
            super.processDatagram(datagram, null);
        }

        @Override
        public void send(RawData msg) {
            super.send(msg);
            if (DtlsManagedClusterConnector.this.clusterHealth != null) {
                DtlsManagedClusterConnector.this.clusterHealth.sendingClusterManagementMessage();
            }
        }
    }

    private class ClusterManagementUdpConnector
    extends UDPConnector
    implements ExtendedConnector {
        public ClusterManagementUdpConnector(InetSocketAddress bindAddress) {
            super(bindAddress);
        }

        @Override
        public synchronized void start() throws IOException {
            if (this.isRunning()) {
                return;
            }
            this.init(DtlsManagedClusterConnector.this.clusterInternalSocket);
        }

        @Override
        public boolean isRunning() {
            return this.running;
        }

        @Override
        public void processDatagram(DatagramPacket datagram) {
            super.processDatagram(datagram);
            if (DtlsManagedClusterConnector.this.clusterHealth != null) {
                DtlsManagedClusterConnector.this.clusterHealth.receivingClusterManagementMessage();
            }
        }

        @Override
        public void send(RawData msg) {
            super.send(msg);
            if (DtlsManagedClusterConnector.this.clusterHealth != null) {
                DtlsManagedClusterConnector.this.clusterHealth.sendingClusterManagementMessage();
            }
        }
    }
}

