/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import com.upokecenter.cbor.CBORObject;
import java.net.InetSocketAddress;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.elements.util.StringUtil;

public class MyIp
extends CoapResource {
    public static final String RESOURCE_NAME = "myip";

    public MyIp(String name, boolean visible) {
        super(name, visible);
        this.getAttributes().setTitle("MyIp");
        this.getAttributes().addContentType(0);
        this.getAttributes().addContentType(60);
        this.getAttributes().addContentType(50);
        this.getAttributes().addContentType(41);
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        Request request = exchange.advanced().getRequest();
        int accept = request.getOptions().getAccept();
        if (accept == -1) {
            accept = 0;
        }
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        response.getOptions().setContentFormat(accept);
        byte[] payload = null;
        switch (accept) {
            case 0: {
                payload = this.handleGetFormat(exchange, "ip:%s\nport:%d");
                break;
            }
            case 60: {
                payload = this.handleGetCbor(exchange);
                break;
            }
            case 50: {
                payload = this.handleGetFormat(exchange, "{ \"ip\" : \"%s\",\n \"port\" : %d }");
                break;
            }
            case 41: {
                payload = this.handleGetFormat(exchange, "<ip host=\"%s\" port=\"%d\" />");
                break;
            }
            default: {
                String ct = MediaTypeRegistry.toString(accept);
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE, "Type \"" + ct + "\" is not supported for this resource!", 0);
                return;
            }
        }
        response.setPayload(payload);
        exchange.respond(response);
    }

    private byte[] handleGetCbor(CoapExchange exchange) {
        InetSocketAddress source = exchange.advanced().getRequest().getSourceContext().getPeerAddress();
        CBORObject map = CBORObject.NewMap();
        map.set("ip", CBORObject.FromObject(StringUtil.toString(source.getAddress())));
        map.set("port", CBORObject.FromObject(source.getPort()));
        return map.EncodeToBytes();
    }

    private byte[] handleGetFormat(CoapExchange exchange, String format) {
        InetSocketAddress source = exchange.advanced().getRequest().getSourceContext().getPeerAddress();
        String host = StringUtil.toString(source.getAddress());
        return String.format(format, host, source.getPort()).getBytes();
    }
}

