/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.auth.AdditionalInfo;
import org.eclipse.californium.elements.auth.ExtensiblePrincipal;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.SerialExecutor;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.auth.AdvancedApplicationLevelInfoSupplier;
import org.eclipse.californium.scandium.auth.ApplicationLevelInfoSupplier;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSConnectionState;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.DtlsException;
import org.eclipse.californium.scandium.dtls.DtlsHandshakeTimeoutException;
import org.eclipse.californium.scandium.dtls.FragmentedHandshakeMessage;
import org.eclipse.californium.scandium.dtls.GenericHandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeParameter;
import org.eclipse.californium.scandium.dtls.HandshakeResult;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.ReassemblingHandshakeMessage;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.cipher.PseudoRandomFunction;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.SecretIvParameterSpec;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Handshaker
implements Destroyable {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final boolean isClient;
    protected ProtocolVersion usedProtocol;
    protected Random clientRandom;
    protected Random serverRandom;
    protected SecretKey masterSecret;
    private SecretKey clientWriteMACKey;
    private SecretKey serverWriteMACKey;
    private SecretKey clientWriteKey;
    private SecretKey serverWriteKey;
    private SecretIvParameterSpec clientWriteIV;
    private SecretIvParameterSpec serverWriteIV;
    private volatile boolean generateClusterMacKeys;
    private boolean destroyed;
    private final ReentrantLock recursionProtection = new ReentrantLock();
    private final boolean ipv6;
    protected final DTLSSession session;
    protected final NewAdvancedCertificateVerifier certificateVerifier;
    protected final AdvancedPskStore advancedPskStore;
    protected final ConnectionIdGenerator connectionIdGenerator;
    private int sendMessageSequence = 0;
    private int nextReceiveMessageSequence = 0;
    private boolean lastFlight;
    private long flightSendNanos;
    private long nanosExpireTime;
    private final long nanosExpireTimeout;
    protected int flightNumber = 0;
    protected Integer recordSizeLimit;
    private int deferredRecordsSize;
    private final int maxFragmentedHandshakeMessageLength;
    private final int maxDeferredProcessedOutgoingApplicationDataMessages;
    private final int maxDeferredProcessedIncomingRecordsSize;
    private final List<RawData> deferredApplicationData = new ArrayList<RawData>();
    private final List<Record> deferredRecords = new ArrayList<Record>();
    private final AtomicReference<DTLSFlight> pendingFlight = new AtomicReference();
    private Runnable retransmitFlight;
    private final ScheduledExecutorService timer;
    private final RecordLayer recordLayer;
    private final Connection connection;
    private InboundMessageBuffer inboundMessageBuffer;
    protected final List<HandshakeMessage> handshakeMessages = new ArrayList<HandshakeMessage>();
    protected ReassemblingHandshakeMessage reassembledMessage;
    protected final PrivateKey privateKey;
    protected final PublicKey publicKey;
    protected final List<X509Certificate> certificateChain;
    protected CertPath peerCertPath;
    protected boolean certificateVerfied;
    protected boolean sniEnabled;
    protected boolean useStateValidation;
    protected final boolean useKeyUsageVerification;
    protected final boolean useTruncatedCertificatePathForVerification;
    private final boolean useEarlyStopRetransmission;
    private Boolean useMultiRecordMessages;
    private Boolean useMultiHandshakeMessagesRecord;
    private final int backOffRetransmission;
    private final int maxRetransmissions;
    private final int retransmissionTimeout;
    private final Set<SessionListener> sessionListeners = new LinkedHashSet<SessionListener>();
    protected int statesIndex;
    protected HandshakeState[] states;
    private boolean changeCipherSuiteMessageExpected = false;
    private boolean sessionEstablished = false;
    private boolean handshakeAborted = false;
    private boolean handshakeFailed = false;
    private boolean pskRequestPending = false;
    private boolean certificateVerificationPending = false;
    private SecretKey otherSecret;
    private Throwable cause;
    private Object customArgument;
    private ApplicationLevelInfoSupplier applicationLevelInfoSupplier;

    @NoPublicAPI
    protected Handshaker(boolean isClient, int initialMessageSeq, DTLSSession session, RecordLayer recordLayer, ScheduledExecutorService timer, Connection connection, DtlsConnectorConfig config) {
        if (session == null) {
            throw new NullPointerException("DTLS Session must not be null");
        }
        if (recordLayer == null) {
            throw new NullPointerException("Record layer must not be null");
        }
        if (timer == null) {
            throw new NullPointerException("Timer must not be null");
        }
        if (connection == null) {
            throw new NullPointerException("Connection must not be null");
        }
        if (config == null) {
            throw new NullPointerException("Dtls Connector Config must not be null");
        }
        if (initialMessageSeq < 0) {
            throw new IllegalArgumentException("Initial message sequence number must not be negative");
        }
        this.isClient = isClient;
        this.sendMessageSequence = initialMessageSeq;
        this.nextReceiveMessageSequence = initialMessageSeq;
        this.session = session;
        this.recordLayer = recordLayer;
        this.timer = timer;
        this.connection = connection;
        this.connectionIdGenerator = config.getConnectionIdGenerator();
        this.retransmissionTimeout = config.getRetransmissionTimeout();
        this.backOffRetransmission = config.getBackOffRetransmission();
        this.maxRetransmissions = config.getMaxRetransmissions();
        this.recordSizeLimit = config.getRecordSizeLimit();
        this.maxFragmentedHandshakeMessageLength = config.getMaxFragmentedHandshakeMessageLength();
        this.useMultiRecordMessages = config.useMultiRecordMessages();
        this.useMultiHandshakeMessagesRecord = config.useMultiHandshakeMessageRecords();
        this.maxDeferredProcessedOutgoingApplicationDataMessages = config.getMaxDeferredProcessedOutgoingApplicationDataMessages();
        this.maxDeferredProcessedIncomingRecordsSize = config.getMaxDeferredProcessedIncomingRecordsSize();
        this.sniEnabled = config.isSniEnabled();
        this.useStateValidation = config.useHandshakeStateValidation();
        this.useKeyUsageVerification = config.useKeyUsageVerification();
        this.useTruncatedCertificatePathForVerification = config.useTruncatedCertificatePathForValidation();
        this.useEarlyStopRetransmission = config.isEarlyStopRetransmission();
        this.privateKey = config.getPrivateKey();
        this.publicKey = config.getPublicKey();
        this.certificateChain = config.getCertificateChain();
        this.certificateVerifier = config.getAdvancedCertificateVerifier();
        this.advancedPskStore = config.getAdvancedPskStore();
        this.applicationLevelInfoSupplier = config.getApplicationLevelInfoSupplier();
        this.inboundMessageBuffer = new InboundMessageBuffer();
        this.ipv6 = connection.getPeerAddress().getAddress() instanceof Inet6Address;
        int timeoutMillis = this.retransmissionTimeout;
        int expireTimeoutMillis = timeoutMillis * 2;
        for (int retry = 0; retry < this.maxRetransmissions; ++retry) {
            timeoutMillis = DTLSFlight.incrementTimeout(timeoutMillis);
            expireTimeoutMillis += timeoutMillis;
        }
        this.nanosExpireTimeout = TimeUnit.MILLISECONDS.toNanos(expireTimeoutMillis);
        this.addSessionListener(connection.getSessionListener());
    }

    private static int compareRecords(Record r1, Record r2) {
        if (r1.getEpoch() != r2.getEpoch()) {
            throw new IllegalArgumentException("records with different epoch! " + r1.getEpoch() + " != " + r2.getEpoch());
        }
        HandshakeMessage h1 = (HandshakeMessage)r1.getFragment();
        HandshakeMessage h2 = (HandshakeMessage)r2.getFragment();
        if (h1.getMessageSeq() < h2.getMessageSeq()) {
            return -1;
        }
        if (h1.getMessageSeq() > h2.getMessageSeq()) {
            return 1;
        }
        if (r1.getSequenceNumber() < r2.getSequenceNumber()) {
            return -1;
        }
        if (r1.getSequenceNumber() > r2.getSequenceNumber()) {
            return 1;
        }
        return 0;
    }

    public boolean isInboundMessageProcessed() {
        return this.inboundMessageBuffer.isEmpty();
    }

    public final void processMessage(Record record) throws HandshakeException {
        int epoch = this.session.getReadEpoch();
        if (epoch != record.getEpoch()) {
            this.LOGGER.debug("Discarding {} message with wrong epoch received from peer [{}]:{}{}", new Object[]{record.getType(), record.getPeerAddress(), StringUtil.lineSeparator(), record});
            throw new IllegalArgumentException("processing record with wrong epoch! " + record.getEpoch() + " expected " + epoch);
        }
        if (record.getReceiveNanos() < this.flightSendNanos) {
            this.LOGGER.debug("Discarding {} message received from peer [{}] before last flight was sent:{}{}", new Object[]{record.getType(), record.getPeerAddress(), StringUtil.lineSeparator(), record});
            return;
        }
        Record recordToProcess = this.inboundMessageBuffer.getNextRecord(record);
        if (recordToProcess != null) {
            this.processNextMessages(recordToProcess);
        }
    }

    private void processNextMessages(Record record) throws HandshakeException {
        if (this.recursionProtection.isHeldByCurrentThread()) {
            this.LOGGER.warn("Called from doProcessMessage, return immediately to process next message!", new Throwable("recursion-protection"));
            return;
        }
        try {
            Record recordToProcess;
            int epoch = this.session.getReadEpoch();
            int bufferIndex = 0;
            Record record2 = recordToProcess = record != null ? record : this.inboundMessageBuffer.getNextRecord();
            while (recordToProcess != null) {
                DTLSMessage messageToProcess;
                if (this.useMultiRecordMessages == null && recordToProcess.isFollowUpRecord()) {
                    this.useMultiRecordMessages = true;
                }
                if ((messageToProcess = recordToProcess.getFragment()).getContentType() == ContentType.CHANGE_CIPHER_SPEC) {
                    this.expectMessage(messageToProcess);
                    this.LOGGER.debug("Processing {} message from peer [{}]", (Object)messageToProcess.getContentType(), (Object)messageToProcess.getPeer());
                    this.setCurrentReadState();
                    ++this.statesIndex;
                    this.LOGGER.debug("Processed {} message from peer [{}]", (Object)messageToProcess.getContentType(), (Object)messageToProcess.getPeer());
                } else if (messageToProcess.getContentType() == ContentType.HANDSHAKE) {
                    if (!this.processNextHandshakeMessages(epoch, bufferIndex, (HandshakeMessage)messageToProcess)) {
                        break;
                    }
                } else {
                    throw new HandshakeException(String.format("Received unexpected message [%s] from peer %s", new Object[]{messageToProcess.getContentType(), messageToProcess.getPeer()}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, messageToProcess.getPeer()));
                }
                this.session.markRecordAsRead(epoch, recordToProcess.getSequenceNumber());
                this.inboundMessageBuffer.clean(recordToProcess.getSequenceNumber());
                recordToProcess = this.inboundMessageBuffer.getNextRecord();
                ++bufferIndex;
            }
            if (this.session.getReadEpoch() > epoch) {
                SerialExecutor serialExecutor = this.connection.getExecutor();
                List<Record> records = this.takeDeferredRecords();
                if (this.deferredRecordsSize > 0) {
                    throw new HandshakeException(String.format("Received unexpected message left from peer %s", record.getPeerAddress()), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, record.getPeerAddress()));
                }
                for (Record deferredRecord : records) {
                    if (serialExecutor != null && !serialExecutor.isShutdown()) {
                        final Record dRecord = deferredRecord;
                        try {
                            serialExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    Handshaker.this.recordLayer.processRecord(dRecord, Handshaker.this.connection);
                                }
                            });
                            continue;
                        }
                        catch (RejectedExecutionException ex) {
                            this.LOGGER.debug("Execution rejected while processing record [type: {}, peer: {}]", new Object[]{record.getType(), record.getPeerAddress(), ex});
                        }
                    }
                    this.recordLayer.processRecord(deferredRecord, this.connection);
                }
            }
        }
        catch (GeneralSecurityException e) {
            this.LOGGER.warn("Cannot process handshake message from peer [{}] due to [{}]", this.getSession().getPeer(), e.getMessage(), e);
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer());
            throw new HandshakeException("Cannot process handshake message, caused by " + e.getMessage(), alert, e);
        }
        catch (RuntimeException e) {
            this.LOGGER.warn("Cannot process handshake message from peer [{}] due to [{}]", this.getSession().getPeer(), e.getMessage(), e);
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer());
            throw new HandshakeException("Cannot process handshake message, caused by " + e.getMessage(), alert, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processNextHandshakeMessages(int epoch, int bufferIndex, HandshakeMessage handshakeMessage) throws HandshakeException, GeneralSecurityException {
        if (this.recursionProtection.isHeldByCurrentThread()) {
            this.LOGGER.warn("Called from doProcessMessage, return immediately to process next message!", new Throwable("recursion-protection"));
            return false;
        }
        DTLSFlight flight = this.pendingFlight.get();
        if (flight != null) {
            this.LOGGER.debug("response for flight {} started", (Object)flight.getFlightNumber());
            flight.setResponseStarted();
        }
        while (handshakeMessage != null) {
            this.expectMessage(handshakeMessage);
            if (handshakeMessage.getMessageType() == HandshakeType.FINISHED && epoch == 0) {
                this.LOGGER.debug("FINISH with epoch 0 from peer [{}]!", (Object)this.getSession().getPeer());
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, this.getSession().getPeer());
                throw new HandshakeException("FINISH with epoch 0!", alert);
            }
            if (handshakeMessage instanceof FragmentedHandshakeMessage && (handshakeMessage = this.reassembleFragment((FragmentedHandshakeMessage)handshakeMessage)) == null) break;
            if (handshakeMessage instanceof GenericHandshakeMessage) {
                GenericHandshakeMessage genericMessage = (GenericHandshakeMessage)handshakeMessage;
                HandshakeParameter parameter = this.session.getParameter();
                handshakeMessage = HandshakeMessage.fromGenericHandshakeMessage(genericMessage, parameter);
            }
            if (this.lastFlight) {
                if (flight == null) {
                    if (this.cause != null) {
                        this.LOGGER.error("last flight missing, handshake already failed! {}", (Object)handshakeMessage, (Object)this.cause);
                    } else if (bufferIndex == 0) {
                        this.LOGGER.error("last flight missing, resend failed! {}", (Object)handshakeMessage);
                    } else {
                        this.LOGGER.error("last flight missing, resend for buffered message {} failed! {}", (Object)bufferIndex, (Object)handshakeMessage);
                    }
                    return false;
                }
                this.LOGGER.debug("Received ({}) FINISHED message again, retransmitting last flight...", (Object)this.getPeerAddress());
                flight.incrementTries();
                this.sendFlight(flight);
                return false;
            }
            if (this.LOGGER.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append(String.format("Processing %s message from peer [%s], seqn: [%d]", new Object[]{handshakeMessage.getMessageType(), handshakeMessage.getPeer(), handshakeMessage.getMessageSeq()}));
                if (this.LOGGER.isTraceEnabled()) {
                    msg.append(":").append(StringUtil.lineSeparator()).append(handshakeMessage);
                }
                this.LOGGER.debug(msg.toString());
            }
            if (epoch == 0) {
                this.handshakeMessages.add(handshakeMessage);
            }
            this.recursionProtection.lock();
            try {
                this.doProcessMessage(handshakeMessage);
            }
            finally {
                this.recursionProtection.unlock();
            }
            this.LOGGER.debug("Processed {} message from peer [{}]", (Object)handshakeMessage.getMessageType(), (Object)handshakeMessage.getPeer());
            if (!this.lastFlight) {
                ++this.nextReceiveMessageSequence;
                ++this.statesIndex;
            }
            handshakeMessage = handshakeMessage.getNextHandshakeMessage();
            if (this.useMultiHandshakeMessagesRecord != null || handshakeMessage == null) continue;
            this.useMultiHandshakeMessagesRecord = true;
        }
        return true;
    }

    protected void expectMessage(DTLSMessage message) throws HandshakeException {
        if (this.useStateValidation && this.states != null) {
            HandshakeState nextExpectedState;
            if (this.statesIndex >= this.states.length) {
                this.LOGGER.warn("Cannot process {} message from peer [{}], no more expected!", (Object)HandshakeState.toString(message), (Object)this.getSession().getPeer());
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer());
                throw new HandshakeException("Cannot process " + HandshakeState.toString(message) + " handshake message, no more expected!", alert);
            }
            HandshakeState expectedState = this.states[this.statesIndex];
            boolean expected = expectedState.expect(message);
            if (!expected && expectedState.isOptional() && this.statesIndex + 1 < this.states.length && (nextExpectedState = this.states[this.statesIndex + 1]).expect(message)) {
                ++this.statesIndex;
                expected = true;
            }
            if (!expected) {
                DTLSFlight flight = this.pendingFlight.get();
                if (flight != null && flight.contains(message)) {
                    this.LOGGER.debug("Cannot process {} message from itself [{}]!", (Object)HandshakeState.toString(message), (Object)this.getSession().getPeer());
                } else {
                    this.LOGGER.debug("Cannot process {} message from peer [{}], {} expected!", HandshakeState.toString(message), this.getSession().getPeer(), expectedState);
                }
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer());
                throw new HandshakeException("Cannot process " + HandshakeState.toString(message) + " handshake message, " + expectedState + " expected!", alert);
            }
        }
    }

    protected abstract void doProcessMessage(HandshakeMessage var1) throws HandshakeException, GeneralSecurityException;

    public abstract void startHandshake() throws HandshakeException;

    public void processAsyncHandshakeResult(HandshakeResult handshakeResult) throws HandshakeException {
        if (handshakeResult instanceof PskSecretResult) {
            this.processAsyncPskSecretResult((PskSecretResult)handshakeResult);
        } else if (handshakeResult instanceof CertificateVerificationResult) {
            this.processCertificateVerificationResult((CertificateVerificationResult)handshakeResult);
            if (this.changeCipherSuiteMessageExpected) {
                this.processNextMessages(null);
            }
        }
    }

    @Deprecated
    public void processAsyncPskSecretResult(PskSecretResult pskSecretResult) throws HandshakeException {
        this.processPskSecretResult(pskSecretResult);
        if (this.changeCipherSuiteMessageExpected) {
            this.processNextMessages(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPskSecretResult(PskSecretResult pskSecretResult) throws HandshakeException {
        block9: {
            if (!this.pskRequestPending) {
                throw new IllegalStateException("psk secret not pending!");
            }
            this.pskRequestPending = false;
            try {
                this.ensureUndestroyed();
                String hostName = this.sniEnabled ? this.session.getHostName() : null;
                PskPublicInformation pskIdentity = pskSecretResult.getPskPublicInformation();
                SecretKey newPskSecret = pskSecretResult.getSecret();
                if (newPskSecret != null) {
                    if (hostName != null) {
                        this.LOGGER.trace("client [{}] uses PSK identity [{}] for server [{}]", this.session.getPeer(), pskIdentity, hostName);
                    } else {
                        this.LOGGER.trace("client [{}] uses PSK identity [{}]", (Object)this.session.getPeer(), (Object)pskIdentity);
                    }
                    PreSharedKeyIdentity pskPrincipal = this.sniEnabled ? new PreSharedKeyIdentity(hostName, pskIdentity.getPublicInfoAsString()) : new PreSharedKeyIdentity(pskIdentity.getPublicInfoAsString());
                    this.session.setPeerIdentity(pskPrincipal);
                    if ("PSK".equals(newPskSecret.getAlgorithm())) {
                        Mac hmac = this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac();
                        SecretKey premasterSecret = PseudoRandomFunction.generatePremasterSecretFromPSK(this.otherSecret, newPskSecret);
                        SecretKey masterSecret = PseudoRandomFunction.generateMasterSecret(hmac, premasterSecret, this.generateRandomSeed());
                        SecretUtil.destroy(premasterSecret);
                        SecretUtil.destroy(newPskSecret);
                        newPskSecret = masterSecret;
                    }
                    this.customArgument = pskSecretResult.getCustomArgument();
                    this.processMasterSecret(newPskSecret);
                    break block9;
                }
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNKNOWN_PSK_IDENTITY, this.session.getPeer());
                if (hostName != null) {
                    throw new HandshakeException(String.format("No pre-shared key found for [virtual host: %s, identity: %s]", hostName, pskIdentity), alert);
                }
                throw new HandshakeException(String.format("No pre-shared key found for [identity: %s]", pskIdentity), alert);
            }
            finally {
                SecretUtil.destroy(this.otherSecret);
                this.otherSecret = null;
            }
        }
    }

    protected abstract void processMasterSecret(SecretKey var1) throws HandshakeException;

    protected void processCertificateVerificationResult(CertificateVerificationResult certificateVerificationResult) throws HandshakeException {
        if (!this.certificateVerificationPending) {
            throw new IllegalStateException("certificate verification not pending!");
        }
        this.ensureUndestroyed();
        this.certificateVerificationPending = false;
        this.LOGGER.info("Process result of certificate verification.");
        if (certificateVerificationResult.getCertificatePath() != null) {
            this.peerCertPath = certificateVerificationResult.getCertificatePath();
            this.certificateVerfied = true;
            this.customArgument = certificateVerificationResult.getCustomArgument();
            this.processCertificateVerified();
        } else if (certificateVerificationResult.getPublicKey() != null) {
            this.certificateVerfied = true;
            this.customArgument = certificateVerificationResult.getCustomArgument();
            this.processCertificateVerified();
        } else {
            if (certificateVerificationResult.getException() != null) {
                throw certificateVerificationResult.getException();
            }
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE, this.session.getPeer());
            throw new HandshakeException("Bad Certificate", alert);
        }
    }

    protected abstract void processCertificateVerified() throws HandshakeException;

    protected final MessageDigest getHandshakeMessageDigest() {
        MessageDigest md = this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMessageDigest();
        int index = 0;
        for (HandshakeMessage handshakeMessage : this.handshakeMessages) {
            md.update(handshakeMessage.toByteArray());
            this.LOGGER.trace("  [{}] - {}", (Object)index, (Object)handshakeMessage.getMessageType());
            ++index;
        }
        return md;
    }

    protected void applyMasterSecret(SecretKey masterSecret) {
        this.ensureUndestroyed();
        this.masterSecret = SecretUtil.create(masterSecret);
        this.calculateKeys(masterSecret);
        this.session.setMasterSecret(masterSecret);
    }

    protected void calculateKeys(SecretKey masterSecret) {
        this.ensureUndestroyed();
        int macKeyLength = this.session.getCipherSuite().getMacKeyLength();
        int encKeyLength = this.session.getCipherSuite().getEncKeyLength();
        int fixedIvLength = this.session.getCipherSuite().getFixedIvLength();
        int clusterMacKeyLength = this.generateClusterMacKeys ? encKeyLength : 0;
        int totalLength = (macKeyLength + encKeyLength + fixedIvLength + clusterMacKeyLength) * 2;
        byte[] seed = Bytes.concatenate(this.serverRandom, this.clientRandom);
        byte[] data = PseudoRandomFunction.doPRF(this.session.getCipherSuite().getThreadLocalPseudoRandomFunctionMac(), masterSecret, PseudoRandomFunction.Label.KEY_EXPANSION_LABEL, seed, totalLength);
        int index = 0;
        int length = macKeyLength;
        this.clientWriteMACKey = SecretUtil.create(data, index, length, "Mac");
        this.serverWriteMACKey = SecretUtil.create(data, index += length, length, "Mac");
        index += length;
        length = encKeyLength;
        this.clientWriteKey = SecretUtil.create(data, index, length, "AES");
        this.serverWriteKey = SecretUtil.create(data, index += length, length, "AES");
        index += length;
        length = fixedIvLength;
        this.clientWriteIV = SecretUtil.createIv(data, index, length);
        this.serverWriteIV = SecretUtil.createIv(data, index += length, length);
        if (this.generateClusterMacKeys) {
            length = clusterMacKeyLength;
            SecretKey clusterClientMacKey = SecretUtil.create(data, index, length, "Mac");
            SecretKey clusterServerMacKey = SecretUtil.create(data, index += length, length, "Mac");
            index += length;
            if (this.isClient) {
                this.session.setClusterMacKeys(clusterClientMacKey, clusterServerMacKey);
            } else {
                this.session.setClusterMacKeys(clusterServerMacKey, clusterClientMacKey);
            }
            SecretUtil.destroy(clusterClientMacKey);
            SecretUtil.destroy(clusterServerMacKey);
        }
        Bytes.clear(data);
    }

    protected byte[] generateRandomSeed() {
        return Bytes.concatenate(this.clientRandom, this.serverRandom);
    }

    protected PskSecretResult requestPskSecretResult(PskPublicInformation pskIdentity, SecretKey otherSecret) {
        ServerNames serverNames = this.sniEnabled ? this.session.getServerNames() : null;
        String hmacAlgorithm = this.session.getCipherSuite().getPseudoRandomFunctionMacName();
        this.pskRequestPending = true;
        this.otherSecret = SecretUtil.create(otherSecret);
        return this.advancedPskStore.requestPskSecretResult(this.connection.getConnectionId(), serverNames, pskIdentity, hmacAlgorithm, otherSecret, this.generateRandomSeed());
    }

    protected final void setCurrentReadState() {
        DTLSConnectionState connectionState = this.isClient ? DTLSConnectionState.create(this.session.getCipherSuite(), this.session.getCompressionMethod(), this.serverWriteKey, this.serverWriteIV, this.serverWriteMACKey) : DTLSConnectionState.create(this.session.getCipherSuite(), this.session.getCompressionMethod(), this.clientWriteKey, this.clientWriteIV, this.clientWriteMACKey);
        this.session.setReadState(connectionState);
    }

    protected final void setCurrentWriteState() {
        DTLSConnectionState connectionState = this.isClient ? DTLSConnectionState.create(this.session.getCipherSuite(), this.session.getCompressionMethod(), this.clientWriteKey, this.clientWriteIV, this.clientWriteMACKey) : DTLSConnectionState.create(this.session.getCipherSuite(), this.session.getCompressionMethod(), this.serverWriteKey, this.serverWriteIV, this.serverWriteMACKey);
        this.session.setWriteState(connectionState);
    }

    protected final void wrapMessage(DTLSFlight flight, DTLSMessage fragment) throws HandshakeException {
        switch (fragment.getContentType()) {
            case HANDSHAKE: {
                HandshakeMessage handshakeMessage = (HandshakeMessage)fragment;
                this.applySendMessageSequenceNumber(handshakeMessage);
                if (this.session.getWriteEpoch() == 0) {
                    this.handshakeMessages.add(handshakeMessage);
                }
                flight.addDtlsMessage(this.session.getWriteEpoch(), fragment);
                break;
            }
            case CHANGE_CIPHER_SPEC: {
                flight.addDtlsMessage(this.session.getWriteEpoch(), fragment);
                break;
            }
            default: {
                throw new HandshakeException("Cannot create " + (Object)((Object)fragment.getContentType()) + " record for flight", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.INTERNAL_ERROR, this.session.getPeer()));
            }
        }
    }

    protected GenericHandshakeMessage reassembleFragment(FragmentedHandshakeMessage fragment) throws HandshakeException {
        this.LOGGER.debug("Processing {} message fragment ...", (Object)fragment.getMessageType());
        try {
            if (fragment.getMessageLength() > this.maxFragmentedHandshakeMessageLength) {
                throw new IllegalArgumentException("Fragmented message length exceeded (" + fragment.getMessageLength() + " > " + this.maxFragmentedHandshakeMessageLength + ")!");
            }
            int messageSeq = fragment.getMessageSeq();
            if (this.reassembledMessage == null) {
                this.reassembledMessage = new ReassemblingHandshakeMessage(fragment);
            } else {
                if (this.reassembledMessage.getMessageSeq() != messageSeq) {
                    throw new IllegalArgumentException("Current reassemble message has different seqn " + this.reassembledMessage.getMessageSeq() + " != " + messageSeq);
                }
                this.reassembledMessage.add(fragment);
            }
            if (this.reassembledMessage.isComplete()) {
                ReassemblingHandshakeMessage message = this.reassembledMessage;
                this.LOGGER.debug("Successfully re-assembled {} message", (Object)((GenericHandshakeMessage)message).getMessageType());
                this.reassembledMessage = null;
                return message;
            }
        }
        catch (IllegalArgumentException ex) {
            throw new HandshakeException(ex.getMessage(), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.ILLEGAL_PARAMETER, fragment.getPeer()));
        }
        return null;
    }

    public final DTLSSession getSession() {
        return this.session;
    }

    public final InetSocketAddress getPeerAddress() {
        return this.session.getPeer();
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public DTLSFlight createFlight() {
        return new DTLSFlight(this.session, this.flightNumber);
    }

    public ConnectionId getReadConnectionId() {
        if (this.connectionIdGenerator == null) {
            return null;
        }
        if (this.connectionIdGenerator.useConnectionId()) {
            return this.connection.getConnectionId();
        }
        return ConnectionId.EMPTY;
    }

    public Random getClientRandom() {
        return this.clientRandom;
    }

    public Random getServerRandom() {
        return this.serverRandom;
    }

    private void applySendMessageSequenceNumber(HandshakeMessage message) {
        message.setMessageSeq(this.sendMessageSequence);
        ++this.sendMessageSequence;
    }

    final int getNextReceiveMessageSequenceNumber() {
        return this.nextReceiveMessageSequence;
    }

    public void addApplicationDataForDeferredProcessing(RawData outgoingMessage) {
        if (this.deferredApplicationData.size() < this.maxDeferredProcessedOutgoingApplicationDataMessages) {
            this.deferredApplicationData.add(outgoingMessage);
        }
    }

    public void addRecordsForDeferredProcessing(Record incomingMessage) {
        this.addDeferredProcessedRecord(incomingMessage, this.deferredRecords);
    }

    private boolean addDeferredProcessedRecord(Record incomingMessage, Collection<Record> collection) {
        int size = incomingMessage.size();
        if (this.deferredRecordsSize + size < this.maxDeferredProcessedIncomingRecordsSize) {
            this.deferredRecordsSize += size;
            collection.add(incomingMessage);
            return true;
        }
        this.LOGGER.debug("Dropped incoming record from peer [{}], limit of {} bytes exceeded by {}+{} bytes!", incomingMessage.getPeerAddress(), this.maxDeferredProcessedIncomingRecordsSize, this.deferredRecordsSize, size);
        this.recordLayer.dropReceivedRecord(incomingMessage);
        return false;
    }

    private void removeDeferredProcessedRecord(Record incomingMessage, Collection<Record> collection) {
        if (collection.remove(incomingMessage)) {
            int size = incomingMessage.size();
            if (this.deferredRecordsSize < size) {
                this.LOGGER.warn("deferred processed incoming records corrupted for peer [{}]! Removing {} bytes exceeds available {} bytes!", incomingMessage.getPeerAddress(), size, this.deferredRecordsSize);
                throw new IllegalArgumentException("deferred processing of incoming records corrupted!");
            }
            this.deferredRecordsSize -= size;
        }
    }

    public List<RawData> takeDeferredApplicationData() {
        ArrayList<RawData> applicationData = new ArrayList<RawData>(this.deferredApplicationData);
        this.deferredApplicationData.clear();
        return applicationData;
    }

    public List<Record> takeDeferredRecords() {
        ArrayList<Record> records = new ArrayList<Record>(this.deferredRecords);
        for (Record record : records) {
            this.removeDeferredProcessedRecord(record, this.deferredRecords);
        }
        if (!this.deferredRecords.isEmpty()) {
            this.LOGGER.warn("{} left deferred records", (Object)this.deferredRecords.size());
            this.deferredRecords.clear();
        }
        return records;
    }

    public void takeDeferredApplicationData(Handshaker replacedHandshaker) {
        this.deferredApplicationData.addAll(replacedHandshaker.takeDeferredApplicationData());
    }

    public void completePendingFlight() {
        this.retransmitFlight = null;
        DTLSFlight flight = this.pendingFlight.get();
        if (flight != null) {
            flight.setResponseCompleted();
        }
    }

    public void sendLastFlight(DTLSFlight flight) {
        this.lastFlight = true;
        flight.setRetransmissionNeeded(false);
        this.sendFlight(flight);
    }

    public void sendFlight(DTLSFlight flight) {
        this.completePendingFlight();
        try {
            flight.setTimeout(this.retransmissionTimeout);
            this.flightSendNanos = ClockUtil.nanoRealtime();
            this.nanosExpireTime = this.nanosExpireTimeout + this.flightSendNanos;
            int maxDatagramSize = this.recordLayer.getMaxDatagramSize(this.ipv6);
            int maxFragmentSize = this.session.getEffectiveFragmentLimit();
            List<DatagramPacket> datagrams = flight.getDatagrams(maxDatagramSize, maxFragmentSize, this.useMultiHandshakeMessagesRecord, this.useMultiRecordMessages, false);
            this.LOGGER.trace("Sending flight of {} message(s) to peer [{}] using {} datagram(s) of max. {} bytes", flight.getNumberOfMessages(), this.session.getPeer(), datagrams.size(), maxDatagramSize);
            this.recordLayer.sendFlight(datagrams);
            this.pendingFlight.set(flight);
            if (flight.isRetransmissionNeeded()) {
                this.retransmitFlight = new TimeoutPeerTask(flight);
                flight.scheduleRetransmission(this.timer, this.retransmitFlight);
            }
        }
        catch (HandshakeException e) {
            this.handshakeFailed(new Exception("handshake flight " + flight.getFlightNumber() + " failed!", e));
        }
        catch (IOException e) {
            this.handshakeFailed(new Exception("handshake flight " + flight.getFlightNumber() + " failed!", e));
        }
    }

    private void handleTimeout(DTLSFlight flight) {
        Handshaker handshaker;
        if (!flight.isResponseCompleted() && null != (handshaker = this.connection.getOngoingHandshake())) {
            if (!handshaker.isProbing() && this.connection.hasEstablishedSession()) {
                return;
            }
            Exception cause = null;
            String message = "";
            boolean timeout = false;
            InetSocketAddress peer = this.session.getPeer();
            if (!this.connection.isExecuting() || !this.recordLayer.isRunning()) {
                message = " Stopped by shutdown!";
            } else {
                int tries = flight.getTries();
                if (tries < this.maxRetransmissions && handshaker.isExpired()) {
                    message = " Stopped by expired realtime!";
                    timeout = true;
                } else if (tries < this.maxRetransmissions) {
                    if (this.useEarlyStopRetransmission && flight.isResponseStarted()) {
                        while (tries < this.maxRetransmissions) {
                            ++tries;
                            flight.incrementTries();
                            flight.incrementTimeout();
                        }
                        flight.incrementTries();
                        this.LOGGER.trace("schedule handshake timeout {}ms after flight {}", (Object)flight.getTimeout(), (Object)flight.getFlightNumber());
                        Runnable retransmit = this.retransmitFlight;
                        if (retransmit != null) {
                            flight.scheduleRetransmission(this.timer, retransmit);
                        }
                        return;
                    }
                    this.LOGGER.trace("Re-transmitting flight for [{}], [{}] retransmissions left", (Object)this.session.getPeer(), (Object)(this.maxRetransmissions - tries - 1));
                    try {
                        flight.incrementTries();
                        flight.incrementTimeout();
                        int maxDatagramSize = this.recordLayer.getMaxDatagramSize(this.ipv6);
                        int maxFragmentSize = this.session.getEffectiveFragmentLimit();
                        boolean backOff = this.backOffRetransmission > 0 && tries + 1 > this.backOffRetransmission;
                        List<DatagramPacket> datagrams = flight.getDatagrams(maxDatagramSize, maxFragmentSize, this.useMultiHandshakeMessagesRecord, this.useMultiRecordMessages, backOff);
                        this.LOGGER.debug("Resending flight {} of {} message(s) to peer [{}] using {} datagram(s) of max. {} bytes. Retransmission {} of {}.", flight.getFlightNumber(), flight.getNumberOfMessages(), peer, datagrams.size(), maxDatagramSize, tries + 1, this.maxRetransmissions);
                        this.recordLayer.sendFlight(datagrams);
                        Runnable retransmit = this.retransmitFlight;
                        if (retransmit != null) {
                            flight.scheduleRetransmission(this.timer, retransmit);
                        }
                        handshaker.handshakeFlightRetransmitted(flight.getFlightNumber());
                        return;
                    }
                    catch (IOException e) {
                        cause = e;
                        message = " " + e.getMessage();
                        this.LOGGER.warn("Cannot retransmit flight to peer [{}]", (Object)peer, (Object)e);
                    }
                    catch (HandshakeException e) {
                        this.LOGGER.warn("Cannot retransmit flight to peer [{}]", (Object)peer, (Object)e);
                        cause = e;
                        message = " " + e.getMessage();
                    }
                } else if (tries > this.maxRetransmissions) {
                    this.LOGGER.debug("Flight for [{}] has reached timeout, discarding ...", (Object)peer);
                    message = " Stopped by timeout!";
                    timeout = true;
                } else {
                    this.LOGGER.debug("Flight for [{}] has reached maximum no. [{}] of retransmissions, discarding ...", (Object)peer, (Object)this.maxRetransmissions);
                    message = " Stopped by timeout after " + this.maxRetransmissions + " retransmissions!";
                    timeout = true;
                }
            }
            this.LOGGER.debug("Flight {} of {} message(s) to peer [{}] failed, {}. Retransmission {} of {}.", flight.getFlightNumber(), flight.getNumberOfMessages(), peer, message, flight.getTries(), this.maxRetransmissions);
            if (timeout) {
                handshaker.handshakeFailed(new DtlsHandshakeTimeoutException("Handshake flight " + flight.getFlightNumber() + " failed!" + message, peer, flight.getFlightNumber()));
            } else {
                handshaker.handshakeFailed(new DtlsException("Handshake flight " + flight.getFlightNumber() + " failed!" + message, peer, cause));
            }
        }
    }

    public final void addSessionListener(SessionListener listener) {
        if (listener != null) {
            this.sessionListeners.add(listener);
        }
    }

    public final void removeSessionListener(SessionListener listener) {
        if (listener != null) {
            this.sessionListeners.remove(listener);
        }
    }

    protected final void handshakeStarted() throws HandshakeException {
        this.LOGGER.debug("handshake started {}", (Object)this.connection);
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.handshakeStarted(this);
        }
    }

    protected final void sessionEstablished() throws HandshakeException {
        if (!this.sessionEstablished) {
            if (this.getSession().getWriteState().hasValidCipherSuite()) {
                this.LOGGER.debug("session established {}", (Object)this.connection);
                this.amendPeerPrincipal();
                this.sessionEstablished = true;
                for (SessionListener sessionListener : this.sessionListeners) {
                    sessionListener.sessionEstablished(this, this.getSession());
                }
            } else {
                this.handshakeFailed(new DtlsException("Failed establishing a incomplete session.", this.connection.getPeerAddress()));
            }
        }
    }

    public final void handshakeCompleted() {
        this.completePendingFlight();
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.handshakeCompleted(this);
        }
        SecretUtil.destroy(this);
        this.LOGGER.debug("handshake completed {}", (Object)this.connection);
    }

    public final void handshakeFailed(Throwable cause) {
        if (this.cause == null) {
            this.cause = cause;
        }
        if (!this.handshakeFailed && this.cause == cause) {
            this.LOGGER.debug("handshake failed {}", (Object)this.connection, (Object)cause);
            this.handshakeFailed = true;
            this.completePendingFlight();
            for (SessionListener sessionListener : this.sessionListeners) {
                sessionListener.handshakeFailed(this, cause);
            }
            SecretUtil.destroy(this.session);
            SecretUtil.destroy(this);
        }
    }

    public final void handshakeAborted(Throwable cause) {
        this.handshakeAborted = true;
        this.handshakeFailed(cause);
    }

    public boolean hasSessionEstablished() {
        return this.sessionEstablished;
    }

    public boolean isProbing() {
        return false;
    }

    public void resetProbing() {
    }

    public boolean isExpired() {
        return !this.sessionEstablished && this.pendingFlight.get() != null && this.nanosExpireTime < ClockUtil.nanoRealtime();
    }

    public boolean isPskRequestPending() {
        return this.pskRequestPending;
    }

    public boolean isRemovingConnection() {
        return !this.handshakeAborted && !this.connection.hasEstablishedSession();
    }

    public Throwable getFailureCause() {
        return this.cause;
    }

    public void setFailureCause(Throwable cause) {
        this.completePendingFlight();
        this.cause = cause;
    }

    public void setGenerateClusterMacKeys(boolean enable) {
        this.generateClusterMacKeys = enable;
    }

    public final void handshakeFlightRetransmitted(int flight) {
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.handshakeFlightRetransmitted(this, flight);
        }
        for (RawData message : this.deferredApplicationData) {
            message.onDtlsRetransmission(flight);
        }
    }

    public final boolean isChangeCipherSpecMessageExpected() {
        return this.changeCipherSuiteMessageExpected;
    }

    protected final void expectChangeCipherSpecMessage() {
        this.changeCipherSuiteMessageExpected = true;
    }

    public void verifyCertificate(CertificateMessage message) throws HandshakeException {
        if (this.certificateVerifier == null) {
            this.LOGGER.debug("Certificate validation failed: no verifier available!");
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE, this.session.getPeer());
            throw new HandshakeException("Trust is not possible!", alert);
        }
        Boolean clientUsage = this.useKeyUsageVerification ? Boolean.valueOf(!this.isClient) : null;
        this.LOGGER.info("Start certificate verification.");
        this.certificateVerificationPending = true;
        CertificateVerificationResult verificationResult = this.certificateVerifier.verifyCertificate(this.connection.getConnectionId(), null, clientUsage, this.useTruncatedCertificatePathForVerification, message, this.session);
        if (verificationResult != null) {
            this.processCertificateVerificationResult(verificationResult);
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.otherSecret);
        this.otherSecret = null;
        SecretUtil.destroy(this.masterSecret);
        this.masterSecret = null;
        SecretUtil.destroy(this.clientWriteKey);
        this.clientWriteKey = null;
        SecretUtil.destroy(this.clientWriteMACKey);
        this.clientWriteMACKey = null;
        SecretUtil.destroy(this.clientWriteIV);
        this.clientWriteIV = null;
        SecretUtil.destroy(this.serverWriteKey);
        this.serverWriteKey = null;
        SecretUtil.destroy(this.serverWriteMACKey);
        this.serverWriteMACKey = null;
        SecretUtil.destroy(this.serverWriteIV);
        this.serverWriteIV = null;
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    protected void ensureUndestroyed() {
        if (this.destroyed) {
            if (this.handshakeFailed) {
                throw new IllegalStateException("secrets destroyed after failure!", this.cause);
            }
            if (this.sessionEstablished) {
                throw new IllegalStateException("secrets destroyed after success!");
            }
            throw new IllegalStateException("secrets destroyed ???");
        }
    }

    private void amendPeerPrincipal() {
        Principal peerIdentity = this.session.getPeerIdentity();
        if (peerIdentity instanceof ExtensiblePrincipal) {
            ExtensiblePrincipal extensibleClientIdentity = (ExtensiblePrincipal)peerIdentity;
            AdditionalInfo additionalInfo = this.getAdditionalPeerInfo(peerIdentity);
            this.session.setPeerIdentity((Principal)extensibleClientIdentity.amend(additionalInfo));
        }
    }

    private AdditionalInfo getAdditionalPeerInfo(Principal peerIdentity) {
        if (this.applicationLevelInfoSupplier == null || peerIdentity == null) {
            return AdditionalInfo.empty();
        }
        if (this.applicationLevelInfoSupplier instanceof AdvancedApplicationLevelInfoSupplier) {
            return ((AdvancedApplicationLevelInfoSupplier)((Object)this.applicationLevelInfoSupplier)).getInfo(peerIdentity, this.customArgument);
        }
        return this.applicationLevelInfoSupplier.getInfo(peerIdentity);
    }

    private class TimeoutPeerTask
    extends ConnectionTask {
        private TimeoutPeerTask(final DTLSFlight flight) {
            super(new Runnable(){

                @Override
                public void run() {
                    Handshaker.this.handleTimeout(flight);
                }
            }, true);
        }
    }

    private class ConnectionTask
    implements Runnable {
        private final Runnable task;
        private final boolean force;

        private ConnectionTask(Runnable task, boolean force) {
            this.task = task;
            this.force = force;
        }

        @Override
        public void run() {
            block2: {
                SerialExecutor serialExecutor = Handshaker.this.connection.getExecutor();
                try {
                    serialExecutor.execute(this.task);
                }
                catch (RejectedExecutionException e) {
                    Handshaker.this.LOGGER.debug("Execution rejected while execute task of peer: {}", (Object)Handshaker.this.connection.getPeerAddress(), (Object)e);
                    if (!this.force) break block2;
                    this.task.run();
                }
            }
        }
    }

    private class InboundMessageBuffer {
        private Record changeCipherSpec = null;
        private SortedSet<Record> queue = new TreeSet<Record>(new Comparator<Record>(){

            @Override
            public int compare(Record r1, Record r2) {
                return Handshaker.compareRecords(r1, r2);
            }
        });

        private InboundMessageBuffer() {
        }

        boolean isEmpty() {
            return this.queue.isEmpty();
        }

        Record getNextRecord() {
            Record result = null;
            if (Handshaker.this.isChangeCipherSpecMessageExpected() && this.changeCipherSpec != null) {
                result = this.changeCipherSpec;
                this.changeCipherSpec = null;
            } else {
                Record record;
                int messageSeq;
                Iterator i$ = this.queue.iterator();
                while (i$.hasNext() && (messageSeq = ((HandshakeMessage)(record = (Record)i$.next()).getFragment()).getMessageSeq()) <= Handshaker.this.nextReceiveMessageSequence) {
                    Handshaker.this.removeDeferredProcessedRecord(record, this.queue);
                    if (messageSeq != Handshaker.this.nextReceiveMessageSequence) continue;
                    result = record;
                    break;
                }
            }
            return result;
        }

        Record getNextRecord(Record candidate) {
            int sessionEpoch;
            int recordEpoch = candidate.getEpoch();
            if (recordEpoch == (sessionEpoch = Handshaker.this.session.getReadEpoch())) {
                DTLSMessage fragment = candidate.getFragment();
                switch (fragment.getContentType()) {
                    case CHANGE_CIPHER_SPEC: {
                        if (Handshaker.this.isChangeCipherSpecMessageExpected()) {
                            return candidate;
                        }
                        if (this.changeCipherSpec == null) {
                            Handshaker.this.LOGGER.debug("Change Cipher Spec is not expected and therefore kept for later processing!");
                            this.changeCipherSpec = candidate;
                            return null;
                        }
                        Handshaker.this.LOGGER.debug("Change Cipher Spec is received again!");
                        return null;
                    }
                    case HANDSHAKE: {
                        HandshakeMessage handshakeMessage = (HandshakeMessage)fragment;
                        int messageSeq = handshakeMessage.getMessageSeq();
                        if (messageSeq == Handshaker.this.nextReceiveMessageSequence) {
                            return candidate;
                        }
                        if (messageSeq > Handshaker.this.nextReceiveMessageSequence) {
                            Handshaker.this.LOGGER.debug("Queued newer {} message from current epoch, message_seq [{}] > next_receive_seq [{}]", new Object[]{handshakeMessage.getMessageType(), messageSeq, Handshaker.this.nextReceiveMessageSequence});
                            Handshaker.this.addDeferredProcessedRecord(candidate, this.queue);
                            return null;
                        }
                        Handshaker.this.LOGGER.debug("Discarding old {} message_seq [{}] < next_receive_seq [{}]", new Object[]{handshakeMessage.getMessageType(), messageSeq, Handshaker.this.nextReceiveMessageSequence});
                        return null;
                    }
                }
                Handshaker.this.LOGGER.warn("Cannot process message of type [{}], discarding...", (Object)fragment.getContentType());
                return null;
            }
            throw new IllegalArgumentException("record epoch " + recordEpoch + " doesn't match session " + sessionEpoch);
        }

        public void clean(long recordSequenceNumber) {
            if (this.changeCipherSpec != null && this.changeCipherSpec.getSequenceNumber() == recordSequenceNumber) {
                this.changeCipherSpec = null;
            }
            for (Record record : this.queue) {
                if (record.getSequenceNumber() != recordSequenceNumber) continue;
                Handshaker.this.removeDeferredProcessedRecord(record, this.queue);
            }
        }
    }
}

