/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.DTLSConnectionState;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.cipher.CbcBlockCipher;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.SecretUtil;

public class DtlsBlockConnectionState
extends DTLSConnectionState {
    private final SecretKey encryptionKey;
    private final SecretKey macKey;

    DtlsBlockConnectionState(CipherSuite cipherSuite, CompressionMethod compressionMethod, SecretKey encryptionKey, SecretKey macKey) {
        super(cipherSuite, compressionMethod);
        if (encryptionKey == null) {
            throw new NullPointerException("Encryption key must not be null!");
        }
        if (macKey == null) {
            throw new NullPointerException("MAC key must not be null!");
        }
        this.encryptionKey = SecretUtil.create(encryptionKey);
        this.macKey = SecretUtil.create(macKey);
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.encryptionKey);
        SecretUtil.destroy(this.macKey);
    }

    @Override
    public boolean isDestroyed() {
        return SecretUtil.isDestroyed(this.macKey) && SecretUtil.isDestroyed(this.encryptionKey);
    }

    @Override
    public byte[] encrypt(Record record, byte[] fragment) throws GeneralSecurityException {
        byte[] additionalData = record.generateAdditionalData(fragment.length);
        return CbcBlockCipher.encrypt(this.cipherSuite, this.encryptionKey, this.macKey, additionalData, fragment);
    }

    @Override
    public byte[] decrypt(Record record, byte[] ciphertextFragment) throws GeneralSecurityException {
        if (ciphertextFragment == null) {
            throw new NullPointerException("Ciphertext must not be null");
        }
        if (ciphertextFragment.length % this.getRecordIvLength() != 0) {
            throw new GeneralSecurityException("Ciphertext doesn't fit block size!");
        }
        if (ciphertextFragment.length < this.getRecordIvLength() + this.getMacLength() + 1) {
            throw new GeneralSecurityException("Ciphertext too short!");
        }
        byte[] additionalData = record.generateAdditionalData(0);
        return CbcBlockCipher.decrypt(this.cipherSuite, this.encryptionKey, this.macKey, additionalData, ciphertextFragment);
    }

    SecretKey getMacKey() {
        return SecretUtil.create(this.macKey);
    }

    public final String toString() {
        StringBuilder b = new StringBuilder("DtlsBlockConnectionState:");
        b.append(StringUtil.lineSeparator()).append("\tCipher suite: ").append((Object)this.cipherSuite);
        b.append(StringUtil.lineSeparator()).append("\tCompression method: ").append((Object)this.compressionMethod);
        b.append(StringUtil.lineSeparator()).append("\tMAC key: ").append(this.macKey == null ? "null" : "not null");
        b.append(StringUtil.lineSeparator()).append("\tEncryption key: ").append(this.encryptionKey == null ? "null" : "not null");
        return b.toString();
    }
}

