/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.security.KeyPairGenerator;
import java.security.Provider;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCrypto;

public class ThreadLocalKeyPairGenerator
extends ThreadLocalCrypto<KeyPairGenerator> {
    public ThreadLocalKeyPairGenerator(final String algorithm) {
        super(new ThreadLocalCrypto.Factory<KeyPairGenerator>(){

            @Override
            public KeyPairGenerator getInstance() throws GeneralSecurityException {
                Provider provider;
                String oid = Asn1DerDecoder.getEdDsaStandardAlgorithmName(algorithm, null);
                if (oid != null && (provider = Asn1DerDecoder.getEdDsaProvider()) != null) {
                    return KeyPairGenerator.getInstance(oid, provider);
                }
                return KeyPairGenerator.getInstance(algorithm);
            }
        });
    }
}

