/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;

@NoPublicAPI
public class ECDHClientKeyExchange
extends ClientKeyExchange {
    private static final int LENGTH_BITS = 8;
    private final byte[] encodedPoint;

    public ECDHClientKeyExchange(byte[] encodedPoint, InetSocketAddress peerAddress) {
        super(peerAddress);
        if (encodedPoint == null) {
            throw new NullPointerException("encoded point cannot be null");
        }
        this.encodedPoint = encodedPoint;
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        this.writeFragment(writer);
        return writer.toByteArray();
    }

    protected void writeFragment(DatagramWriter writer) {
        writer.write(this.encodedPoint.length, 8);
        writer.writeBytes(this.encodedPoint);
    }

    protected static byte[] readEncodedPoint(DatagramReader reader) {
        int length = reader.read(8);
        return reader.readBytes(length);
    }

    public static HandshakeMessage fromReader(DatagramReader reader, InetSocketAddress peerAddress) {
        byte[] pointEncoded = ECDHClientKeyExchange.readEncodedPoint(reader);
        return new ECDHClientKeyExchange(pointEncoded, peerAddress);
    }

    @Override
    public int getMessageLength() {
        return 1 + this.encodedPoint.length;
    }

    public byte[] getEncodedPoint() {
        return Arrays.copyOf(this.encodedPoint, this.encodedPoint.length);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\tDiffie-Hellman public value: ");
        sb.append(StringUtil.byteArray2HexString(this.encodedPoint));
        sb.append(StringUtil.lineSeparator());
        return sb.toString();
    }
}

