/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.observe.ObserveManager;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.core.observe.ObservingEndpoint;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.core.server.resources.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerMessageDeliverer
implements MessageDeliverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerMessageDeliverer.class);
    private final Resource root;
    private final ObserveManager observeManager = new ObserveManager();

    public ServerMessageDeliverer(Resource root) {
        this.root = root;
    }

    @Override
    public final void deliverRequest(final Exchange exchange) {
        if (exchange == null) {
            throw new NullPointerException("exchange must not be null");
        }
        boolean processed = this.preDeliverRequest(exchange);
        if (!processed) {
            final Resource resource = this.findResource(exchange);
            if (resource != null) {
                this.checkForObserveOption(exchange, resource);
                ExecutorService executor = resource.getExecutor();
                if (executor != null) {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            resource.handleRequest(exchange);
                        }
                    });
                } else {
                    resource.handleRequest(exchange);
                }
            } else {
                if (LOGGER.isInfoEnabled()) {
                    Request request = exchange.getRequest();
                    LOGGER.info("did not find resource /{} requested by {}", (Object)request.getOptions().getUriPathString(), (Object)request.getSourceContext().getPeerAddress());
                }
                exchange.sendResponse(new Response(CoAP.ResponseCode.NOT_FOUND));
            }
        }
    }

    protected boolean preDeliverRequest(Exchange exchange) {
        return false;
    }

    protected final void checkForObserveOption(Exchange exchange, Resource resource) {
        Request request = exchange.getRequest();
        if (CoAP.isObservable(request.getCode()) && request.getOptions().hasObserve() && resource.isObservable()) {
            ObserveRelation relation;
            InetSocketAddress source = request.getSourceContext().getPeerAddress();
            if (request.isObserve()) {
                LOGGER.debug("initiating an observe relation between {} and resource {}, {}", source, resource.getURI(), exchange);
                ObservingEndpoint remote = this.observeManager.findObservingEndpoint(source);
                ObserveRelation relation2 = new ObserveRelation(remote, resource, exchange);
                remote.addObserveRelation(relation2);
                exchange.setRelation(relation2);
                request.setProtectFromOffload();
            } else if (request.isObserveCancel() && (relation = this.observeManager.getRelation(source, request.getToken())) != null) {
                relation.cancel();
            }
        }
    }

    protected Resource getRootResource() {
        return this.root;
    }

    protected Resource findResource(Exchange exchange) {
        return this.findResource(exchange.getRequest().getOptions().getUriPath());
    }

    protected Resource findResource(List<String> list) {
        String name;
        Resource current;
        LinkedList<String> path = new LinkedList<String>(list);
        for (current = this.getRootResource(); !path.isEmpty() && current != null; current = current.getChild(name)) {
            name = (String)path.removeFirst();
        }
        return current;
    }

    @Override
    public final void deliverResponse(Exchange exchange, Response response) {
        if (response == null) {
            throw new NullPointerException("Response must not be null");
        }
        if (exchange == null) {
            throw new NullPointerException("Exchange must not be null");
        }
        if (exchange.getRequest() == null) {
            throw new IllegalArgumentException("Exchange does not contain request");
        }
        boolean processed = this.preDeliverResponse(exchange, response);
        if (!processed) {
            exchange.getRequest().setResponse(response);
        }
    }

    protected boolean preDeliverResponse(Exchange exchange, Response response) {
        return false;
    }
}

