/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCrypto;

public class ThreadLocalCryptoMap<TL extends ThreadLocalCrypto<?>> {
    private final ConcurrentMap<String, TL> FUNCTIONS = new ConcurrentHashMap<String, TL>();
    private final Factory<TL> factory;

    public ThreadLocalCryptoMap(Factory<TL> factory) {
        this.factory = factory;
    }

    public TL get(String algorithm) {
        ThreadLocalCrypto threadLocalSignature = (ThreadLocalCrypto)this.FUNCTIONS.get(algorithm);
        if (threadLocalSignature == null) {
            ThreadLocalCrypto function = (ThreadLocalCrypto)this.factory.getInstance(algorithm);
            this.FUNCTIONS.putIfAbsent(algorithm, function);
            threadLocalSignature = (ThreadLocalCrypto)this.FUNCTIONS.get(algorithm);
        }
        return (TL)threadLocalSignature;
    }

    public static interface Factory<T> {
        public T getInstance(String var1);
    }
}

