/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.nio.Buffer;
import java.util.Arrays;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.BlockwiseStatus;
import org.eclipse.californium.core.observe.NotificationOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Block2BlockwiseStatus
extends BlockwiseStatus {
    private static final Logger LOGGER = LoggerFactory.getLogger(Block2BlockwiseStatus.class);
    private NotificationOrder order;
    private Response response;
    private byte[] etag;

    private Block2BlockwiseStatus(int bufferSize, int contentFormat) {
        super(bufferSize, contentFormat);
    }

    public static Block2BlockwiseStatus forOutboundResponse(Exchange exchange, Response response, int preferredBlockSize) {
        Block2BlockwiseStatus status = new Block2BlockwiseStatus(response.getPayloadSize(), response.getOptions().getContentFormat());
        status.response = response;
        status.exchange = exchange;
        if (response.getPayload() != null) {
            status.buf.put(response.getPayload());
            ((Buffer)status.buf).flip();
        }
        status.setCurrentSzx(Block2BlockwiseStatus.determineResponseBlock2Szx(exchange, preferredBlockSize));
        return status;
    }

    public static Block2BlockwiseStatus forInboundResponse(Exchange exchange, Response block, int maxBodySize) {
        int contentFormat = block.getOptions().getContentFormat();
        int bufferSize = maxBodySize;
        if (block.getOptions().hasSize2()) {
            bufferSize = block.getOptions().getSize2();
        }
        Block2BlockwiseStatus status = new Block2BlockwiseStatus(bufferSize, contentFormat);
        status.setFirst(block);
        status.exchange = exchange;
        Integer observeCount = block.getOptions().getObserve();
        if (observeCount != null && OptionSet.isValidObserveOption(observeCount)) {
            status.order = new NotificationOrder(observeCount);
            exchange.setNotificationNumber(observeCount);
        }
        if (block.getOptions().getETagCount() > 0) {
            status.etag = block.getOptions().getETags().get(0);
        }
        return status;
    }

    public static Block2BlockwiseStatus forRandomAccessRequest(Exchange exchange, Request request) {
        BlockOption block2 = request.getOptions().getBlock2();
        if (block2 == null) {
            throw new IllegalArgumentException("request must contain block2 option");
        }
        int contentFormat = request.getOptions().getContentFormat();
        Block2BlockwiseStatus status = new Block2BlockwiseStatus(0, contentFormat);
        status.randomAccess = true;
        status.exchange = exchange;
        status.setCurrentNum(block2.getNum());
        status.setCurrentSzx(block2.getSzx());
        return status;
    }

    private static int determineResponseBlock2Szx(Exchange exchange, int preferredBlockSize) {
        BlockOption block2;
        if (exchange.getRequest() != null && (block2 = exchange.getRequest().getOptions().getBlock2()) != null) {
            LOGGER.debug("using block2 szx from early negotiation in request: {}", (Object)block2.getSize());
            return block2.getSzx();
        }
        LOGGER.debug("using default preferred block size for response: {}", (Object)preferredBlockSize);
        return BlockOption.size2Szx(preferredBlockSize);
    }

    public final synchronized boolean isNotification() {
        return this.order != null;
    }

    final synchronized Integer getObserve() {
        return this.order == null ? null : this.order.getObserve();
    }

    public final synchronized boolean isNew(Response response) {
        if (response == null) {
            throw new NullPointerException("response block must not be null");
        }
        if (!response.getOptions().hasObserve()) {
            return false;
        }
        return this.order == null || this.order.isNew(response);
    }

    public final synchronized boolean matchTransfer(Exchange exchange) {
        Integer notification = exchange.getNotificationNumber();
        if (notification != null && this.order != null) {
            return this.order.getObserve().equals(notification);
        }
        return notification == null && this.order == null;
    }

    public synchronized boolean addBlock(Response responseBlock) {
        boolean succeeded;
        if (responseBlock == null) {
            throw new NullPointerException("response block must not be null");
        }
        BlockOption block2 = responseBlock.getOptions().getBlock2();
        if (block2 == null) {
            throw new IllegalArgumentException("response block has no block2 option");
        }
        if (this.etag != null) {
            if (responseBlock.getOptions().getETagCount() != 1) {
                LOGGER.debug("response does not contain a single ETag");
                return false;
            }
            if (!Arrays.equals(this.etag, responseBlock.getOptions().getETags().get(0))) {
                LOGGER.debug("response does not contain expected ETag");
                return false;
            }
        }
        if (succeeded = this.addBlock(responseBlock.getPayload())) {
            this.setCurrentNum(block2.getNum());
            this.setCurrentSzx(block2.getSzx());
        }
        return succeeded;
    }

    public synchronized Response getNextResponseBlock(BlockOption block2) {
        if (this.response == null) {
            throw new IllegalStateException("no response to track");
        }
        this.setCurrentNum(block2.getNum());
        this.setCurrentSzx(block2.getSzx());
        return this.getNextResponseBlock();
    }

    synchronized Response getNextResponseBlock() {
        if (this.response == null) {
            throw new IllegalStateException("no response to track");
        }
        final Response block = new Response(this.response.getCode());
        block.setDestinationContext(this.response.getDestinationContext());
        block.setOptions(new OptionSet(this.response.getOptions()));
        block.addMessageObservers(this.response.getMessageObservers());
        if (this.getCurrentNum() != 0) {
            block.getOptions().removeObserve();
        } else {
            block.addMessageObserver(new MessageObserverAdapter(){

                @Override
                public void onReadyToSend() {
                    if (Block2BlockwiseStatus.this.response.getToken() == null) {
                        Block2BlockwiseStatus.this.response.setToken(block.getToken());
                    }
                    if (!Block2BlockwiseStatus.this.response.hasMID()) {
                        Block2BlockwiseStatus.this.response.setMID(block.getMID());
                    }
                }
            });
            block.setType(this.response.getType());
            if (this.response.getOptions().getSize2() == null) {
                block.getOptions().setSize2(this.response.getPayloadSize());
            }
        }
        int bodySize = this.getBufferSize();
        int currentSize = BlockOption.szx2Size(this.getCurrentSzx());
        int from = this.getCurrentNum() * currentSize;
        boolean m = false;
        if (0 < bodySize && from < bodySize) {
            int to = Math.min((this.getCurrentNum() + 1) * currentSize, bodySize);
            int length = to - from;
            byte[] blockPayload = new byte[length];
            m = to < bodySize;
            ((Buffer)this.buf).position(from);
            this.buf.get(blockPayload, 0, length);
            block.setPayload(blockPayload);
        }
        this.setComplete(!m);
        block.getOptions().setBlock2(this.getCurrentSzx(), m, this.getCurrentNum());
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void completeOldTransfer(Exchange newExchange) {
        Exchange oldExchange;
        Block2BlockwiseStatus block2BlockwiseStatus = this;
        synchronized (block2BlockwiseStatus) {
            oldExchange = this.exchange;
            this.setBlockCleanupHandle(null);
            this.exchange = null;
            this.followUpEndpointContext = null;
        }
        if (oldExchange != null) {
            if (newExchange != oldExchange) {
                if (oldExchange.isNotification()) {
                    oldExchange.executeComplete();
                } else {
                    oldExchange.getRequest().setCanceled(true);
                }
            } else {
                oldExchange.setCurrentRequest(oldExchange.getRequest());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void completeNewTranfer(Exchange newExchange) {
        Exchange oldExchange;
        Block2BlockwiseStatus block2BlockwiseStatus = this;
        synchronized (block2BlockwiseStatus) {
            oldExchange = this.exchange;
        }
        if (newExchange != oldExchange) {
            if (newExchange.isNotification()) {
                newExchange.setComplete();
            } else {
                newExchange.getRequest().setCanceled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean completeResponse() {
        Response response;
        Block2BlockwiseStatus block2BlockwiseStatus = this;
        synchronized (block2BlockwiseStatus) {
            response = this.response;
        }
        if (response != null) {
            this.setComplete(true);
            response.onComplete();
            return true;
        }
        return false;
    }

    @Override
    public synchronized String toString() {
        String result = super.toString();
        if (this.order != null || this.response != null) {
            StringBuilder builder = new StringBuilder(result);
            if (this.order != null) {
                builder.setLength(result.length() - 1);
                builder.append(", observe=").append(this.order.getObserve()).append("]");
            }
            if (this.response != null) {
                builder.append(", ").append(this.response);
            }
            result = builder.toString();
        }
        return result;
    }

    public static final void crop(Response responseToCrop, BlockOption requestedBlock) {
        if (responseToCrop == null) {
            throw new NullPointerException("response message must not be null");
        }
        if (requestedBlock == null) {
            throw new NullPointerException("block option must not be null");
        }
        if (!responseToCrop.hasBlock(requestedBlock)) {
            throw new IllegalArgumentException("given response does not contain block");
        }
        int bodySize = responseToCrop.getPayloadSize();
        int from = requestedBlock.getOffset();
        int to = Math.min((requestedBlock.getNum() + 1) * requestedBlock.getSize(), bodySize);
        int length = to - from;
        LOGGER.debug("cropping response body [size={}] to block {}", (Object)bodySize, (Object)requestedBlock);
        byte[] blockPayload = new byte[length];
        boolean m = to < bodySize;
        responseToCrop.getOptions().setBlock2(requestedBlock.getSzx(), m, requestedBlock.getNum());
        System.arraycopy(responseToCrop.getPayload(), from, blockPayload, 0, length);
        responseToCrop.setPayload(blockPayload);
    }
}

