/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.DigitShiftAccumulator;
import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;
import com.upokecenter.numbers.ExtendedOrSimpleRadixMath;
import com.upokecenter.numbers.Extras;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.FastIntegerFixed;
import com.upokecenter.numbers.IRadixMath;
import com.upokecenter.numbers.IRadixMathHelper;
import com.upokecenter.numbers.IShiftAccumulator;
import com.upokecenter.numbers.NumberUtility;
import com.upokecenter.numbers.RadixMath;
import com.upokecenter.numbers.TrappableRadixMath;

public final class EDecimal
implements Comparable<EDecimal> {
    public static final EDecimal NaN = EDecimal.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 4);
    public static final EDecimal NegativeInfinity = EDecimal.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 3);
    public static final EDecimal NegativeZero = EDecimal.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 1);
    public static final EDecimal One = EDecimal.Create(EInteger.FromInt32(1), EInteger.FromInt32(0));
    public static final EDecimal PositiveInfinity = EDecimal.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 2);
    public static final EDecimal SignalingNaN = EDecimal.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 8);
    public static final EDecimal Ten = EDecimal.Create(EInteger.FromInt32(10), EInteger.FromInt32(0));
    public static final EDecimal Zero = EDecimal.Create(EInteger.FromInt32(0), EInteger.FromInt32(0));
    private static final int MaxSafeInt = 0xCCCCCCB;
    private static final IRadixMath<EDecimal> ExtendedMathValue = new RadixMath<EDecimal>(new DecimalMathHelper());
    private static final FastIntegerFixed FastIntZero = new FastIntegerFixed(0);
    private static final IRadixMath<EDecimal> MathValue = new TrappableRadixMath<EDecimal>(new ExtendedOrSimpleRadixMath<EDecimal>(new DecimalMathHelper()));
    private static final int[] ValueTenPowers = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private final FastIntegerFixed exponent;
    private final int flags;
    private final FastIntegerFixed unsignedMantissa;
    private static final double[] ExactDoublePowersOfTen = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final float[] ExactSinglePowersOfTen = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};

    private EDecimal(FastIntegerFixed unsignedMantissa, FastIntegerFixed exponent, int flags) {
        this.unsignedMantissa = unsignedMantissa;
        this.exponent = exponent;
        this.flags = flags;
    }

    public EDecimal Copy() {
        return new EDecimal(this.unsignedMantissa.Copy(), this.exponent.Copy(), this.flags);
    }

    public final EInteger getExponent() {
        return this.exponent.ToEInteger();
    }

    public final boolean isFinite() {
        return (this.flags & 0xE) == 0;
    }

    public final boolean isNegative() {
        return (this.flags & 1) != 0;
    }

    public final boolean isZero() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.isValueZero();
    }

    public final EInteger getMantissa() {
        return this.isNegative() ? this.unsignedMantissa.ToEInteger().Negate() : this.unsignedMantissa.ToEInteger();
    }

    public final int signum() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.isValueZero() ? 0 : ((this.flags & 1) != 0 ? -1 : 1);
    }

    public final EInteger getUnsignedMantissa() {
        return this.unsignedMantissa.ToEInteger();
    }

    public static EDecimal Create(int mantissaSmall, int exponentSmall) {
        if (mantissaSmall == Integer.MIN_VALUE) {
            return EDecimal.Create(EInteger.FromInt32(mantissaSmall), EInteger.FromInt32(exponentSmall));
        }
        if (mantissaSmall < 0) {
            return new EDecimal(new FastIntegerFixed(mantissaSmall).Negate(), new FastIntegerFixed(exponentSmall), 1);
        }
        if (mantissaSmall == 0) {
            return new EDecimal(FastIntZero, new FastIntegerFixed(exponentSmall), 0);
        }
        return new EDecimal(new FastIntegerFixed(mantissaSmall), new FastIntegerFixed(exponentSmall), 0);
    }

    public static EDecimal Create(EInteger mantissa, EInteger exponent) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        FastIntegerFixed fi = FastIntegerFixed.FromBig(mantissa);
        int sign = fi.signum();
        return new EDecimal(sign < 0 ? fi.Negate() : fi, FastIntegerFixed.FromBig(exponent), sign < 0 ? 1 : 0);
    }

    public static EDecimal CreateNaN(EInteger diag) {
        return EDecimal.CreateNaN(diag, false, false, null);
    }

    public static EDecimal CreateNaN(EInteger diag, boolean signaling, boolean negative, EContext ctx) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        if (diag.signum() < 0) {
            throw new IllegalArgumentException("Diagnostic information must be 0 or greater, was: " + diag);
        }
        if (diag.isZero() && !negative) {
            return signaling ? SignalingNaN : NaN;
        }
        int flags = 0;
        if (negative) {
            flags |= 1;
        }
        if (ctx != null && ctx.getHasMaxPrecision()) {
            EDecimal ef = new EDecimal(FastIntegerFixed.FromBig(diag), FastIntZero, flags |= 4).RoundToPrecision(ctx);
            int newFlags = ef.flags;
            newFlags &= 0xFFFFFFFB;
            return new EDecimal(ef.unsignedMantissa, ef.exponent, newFlags |= signaling ? 8 : 4);
        }
        return new EDecimal(FastIntegerFixed.FromBig(diag), FastIntZero, flags |= signaling ? 8 : 4);
    }

    public static EDecimal FromDouble(double dbl) {
        boolean neg;
        int[] value = Extras.DoubleToIntegers(dbl);
        int floatExponent = value[1] >> 20 & 0x7FF;
        boolean bl = neg = value[1] >> 31 != 0;
        if (floatExponent == 2047) {
            if ((value[1] & 0xFFFFF) == 0 && value[0] == 0) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (value[1] & 0x80000) != 0;
            value[1] = value[1] & 0x7FFFF;
            long lvalue = (long)value[0] & 0xFFFFFFFFL | (long)value[1] << 32;
            int flags = (neg ? 1 : 0) | (quiet ? 4 : 8);
            return lvalue == 0L ? (quiet ? NaN : SignalingNaN) : new EDecimal(FastIntegerFixed.FromLong(lvalue), FastIntZero, flags);
        }
        value[1] = value[1] & 0xFFFFF;
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            value[1] = value[1] | 0x100000;
        }
        if ((value[1] | value[0]) != 0) {
            floatExponent += NumberUtility.ShiftAwayTrailingZerosTwoElements(value);
        } else {
            return neg ? NegativeZero : Zero;
        }
        long lvalue = (long)value[0] & 0xFFFFFFFFL | (long)value[1] << 32;
        if ((floatExponent -= 1075) == 0) {
            if (neg) {
                lvalue = -lvalue;
            }
            return EDecimal.FromInt64(lvalue);
        }
        if (floatExponent > 0) {
            EInteger bigmantissa = EInteger.FromInt64(lvalue);
            bigmantissa = bigmantissa.ShiftLeft(floatExponent);
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return EDecimal.FromEInteger(bigmantissa);
        }
        EInteger bigmantissa = EInteger.FromInt64(lvalue);
        EInteger bigexp = NumberUtility.FindPowerOfFive(-floatExponent);
        bigmantissa = bigmantissa.Multiply(bigexp);
        if (neg) {
            bigmantissa = bigmantissa.Negate();
        }
        return EDecimal.Create(bigmantissa, EInteger.FromInt32(floatExponent));
    }

    public static EDecimal FromEInteger(EInteger bigint) {
        return EDecimal.Create(bigint, EInteger.FromInt32(0));
    }

    @Deprecated
    public static EDecimal FromExtendedFloat(EFloat ef) {
        return EDecimal.FromEFloat(ef);
    }

    public static EDecimal FromEFloat(EFloat bigfloat) {
        if (bigfloat == null) {
            throw new NullPointerException("bigfloat");
        }
        if (bigfloat.IsNaN() || bigfloat.IsInfinity()) {
            int flags = (bigfloat.isNegative() ? 1 : 0) | (bigfloat.IsInfinity() ? 2 : 0) | (bigfloat.IsQuietNaN() ? 4 : 0) | (bigfloat.IsSignalingNaN() ? 8 : 0);
            return EDecimal.CreateWithFlags(bigfloat.getUnsignedMantissa(), bigfloat.getExponent(), flags);
        }
        EInteger bigintExp = bigfloat.getExponent();
        EInteger bigintMant = bigfloat.getMantissa();
        if (bigintMant.isZero()) {
            return bigfloat.isNegative() ? NegativeZero : Zero;
        }
        if (bigintExp.isZero()) {
            return EDecimal.FromEInteger(bigintMant);
        }
        if (bigintExp.signum() > 0) {
            boolean neg;
            FastInteger intcurexp = FastInteger.FromBig(bigintExp);
            EInteger bigmantissa = bigintMant;
            boolean bl = neg = bigmantissa.signum() < 0;
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            while (intcurexp.signum() > 0) {
                int shift = 1000000;
                if (intcurexp.CompareToInt(1000000) < 0) {
                    shift = intcurexp.AsInt32();
                }
                bigmantissa = bigmantissa.ShiftLeft(shift);
                intcurexp.AddInt(-shift);
            }
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return EDecimal.FromEInteger(bigmantissa);
        }
        EInteger bigmantissa = bigintMant;
        EInteger negbigintExp = bigintExp.Negate();
        negbigintExp = NumberUtility.FindPowerOfFiveFromBig(negbigintExp);
        bigmantissa = bigmantissa.Multiply(negbigintExp);
        return EDecimal.Create(bigmantissa, bigintExp);
    }

    public static EDecimal FromBoolean(boolean boolValue) {
        return boolValue ? One : Zero;
    }

    public static EDecimal FromInt32(int valueSmaller) {
        if (valueSmaller == 0) {
            return Zero;
        }
        if (valueSmaller == Integer.MIN_VALUE) {
            return EDecimal.Create(EInteger.FromInt32(valueSmaller), EInteger.FromInt32(0));
        }
        if (valueSmaller < 0) {
            return new EDecimal(new FastIntegerFixed(valueSmaller).Negate(), FastIntZero, 1);
        }
        return new EDecimal(new FastIntegerFixed(valueSmaller), FastIntZero, 0);
    }

    public static EDecimal FromInt64(long valueSmall) {
        if (valueSmall == 0L) {
            return Zero;
        }
        if (valueSmall > Integer.MIN_VALUE && valueSmall <= Integer.MAX_VALUE) {
            if (valueSmall < 0L) {
                return new EDecimal(new FastIntegerFixed((int)valueSmall).Negate(), FastIntZero, 1);
            }
            return new EDecimal(new FastIntegerFixed((int)valueSmall), FastIntZero, 0);
        }
        EInteger bigint = EInteger.FromInt64(valueSmall);
        return EDecimal.Create(bigint, EInteger.FromInt32(0));
    }

    public static EDecimal FromSingle(float flt) {
        int value = Float.floatToRawIntBits(flt);
        boolean neg = value >> 31 != 0;
        int floatExponent = value >> 23 & 0xFF;
        int valueFpMantissa = value & 0x7FFFFF;
        if (floatExponent == 255) {
            if (valueFpMantissa == 0) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (valueFpMantissa & 0x400000) != 0;
            value = (neg ? 1 : 0) | (quiet ? 4 : 8);
            return (valueFpMantissa &= 0x3FFFFF) == 0 ? (quiet ? NaN : SignalingNaN) : new EDecimal(new FastIntegerFixed(valueFpMantissa), FastIntZero, value);
        }
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            valueFpMantissa |= 0x800000;
        }
        if (valueFpMantissa == 0) {
            return neg ? NegativeZero : Zero;
        }
        floatExponent -= 150;
        while ((valueFpMantissa & 1) == 0) {
            ++floatExponent;
            valueFpMantissa >>= 1;
        }
        if (floatExponent == 0) {
            if (neg) {
                valueFpMantissa = -valueFpMantissa;
            }
            return EDecimal.FromInt64(valueFpMantissa);
        }
        if (floatExponent > 0) {
            EInteger bigmantissa = EInteger.FromInt32(valueFpMantissa);
            bigmantissa = bigmantissa.ShiftLeft(floatExponent);
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return EDecimal.FromEInteger(bigmantissa);
        }
        EInteger bigmantissa = EInteger.FromInt32(valueFpMantissa);
        EInteger bigexponent = NumberUtility.FindPowerOfFive(-floatExponent);
        bigmantissa = bigmantissa.Multiply(bigexponent);
        if (neg) {
            bigmantissa = bigmantissa.Negate();
        }
        return EDecimal.Create(bigmantissa, EInteger.FromInt32(floatExponent));
    }

    public static EDecimal FromString(String str) {
        return EDecimal.FromString(str, 0, str == null ? 0 : str.length(), null);
    }

    public static EDecimal FromString(String str, EContext ctx) {
        return EDecimal.FromString(str, 0, str == null ? 0 : str.length(), ctx);
    }

    public static EDecimal FromString(String str, int offset, int length) {
        return EDecimal.FromString(str, offset, length, null);
    }

    public static EDecimal FromString(String str, int offset, int length, EContext ctx) {
        FastIntegerFixed fastIntMant;
        int sign;
        int tmpoffset = offset;
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (tmpoffset < 0) {
            throw new NumberFormatException("offset (" + tmpoffset + ") is less than 0");
        }
        if (tmpoffset > str.length()) {
            throw new NumberFormatException("offset (" + tmpoffset + ") is more than " + str.length());
        }
        if (length < 0) {
            throw new NumberFormatException("length (" + length + ") is less than 0");
        }
        if (length > str.length()) {
            throw new NumberFormatException("length (" + length + ") is more than " + str.length());
        }
        if (str.length() - tmpoffset < length) {
            throw new NumberFormatException("str's length minus " + tmpoffset + " (" + (str.length() - tmpoffset) + ") is less than " + length);
        }
        if (length == 0) {
            throw new NumberFormatException();
        }
        boolean negative = false;
        int endStr = tmpoffset + length;
        if (str.charAt(0) == '+' || str.charAt(0) == '-') {
            negative = str.charAt(0) == '-';
            ++tmpoffset;
        }
        int mantInt = 0;
        FastInteger mant = null;
        int mantBuffer = 0;
        int mantBufferMult = 1;
        int expBuffer = 0;
        int expBufferMult = 1;
        boolean haveDecimalPoint = false;
        boolean haveDigits = false;
        boolean haveExponent = false;
        int newScaleInt = 0;
        FastInteger newScale = null;
        int i = tmpoffset;
        if (!(i + 8 != endStr || str.charAt(i) != 'I' && str.charAt(i) != 'i' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'F' && str.charAt(i + 2) != 'f' || str.charAt(i + 3) != 'I' && str.charAt(i + 3) != 'i' || str.charAt(i + 4) != 'N' && str.charAt(i + 4) != 'n' || str.charAt(i + 5) != 'I' && str.charAt(i + 5) != 'i' || str.charAt(i + 6) != 'T' && str.charAt(i + 6) != 't' || str.charAt(i + 7) != 'Y' && str.charAt(i + 7) != 'y')) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                throw new NumberFormatException("Infinity not allowed");
            }
            return negative ? NegativeInfinity : PositiveInfinity;
        }
        if (!(i + 3 != endStr || str.charAt(i) != 'I' && str.charAt(i) != 'i' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'F' && str.charAt(i + 2) != 'f')) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                throw new NumberFormatException("Infinity not allowed");
            }
            return negative ? NegativeInfinity : PositiveInfinity;
        }
        if (!(i + 3 > endStr || str.charAt(i) != 'N' && str.charAt(i) != 'n' || str.charAt(i + 1) != 'A' && str.charAt(i + 1) != 'a' || str.charAt(i + 2) != 'N' && str.charAt(i + 2) != 'n')) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                throw new NumberFormatException("NaN not allowed");
            }
            int flags2 = (negative ? 1 : 0) | 4;
            if (i + 3 == endStr) {
                return !negative ? NaN : new EDecimal(FastIntZero, FastIntZero, flags2);
            }
            i += 3;
            FastInteger digitCount = new FastInteger(0);
            FastInteger maxDigits = null;
            haveDigits = false;
            if (ctx != null && ctx.getHasMaxPrecision()) {
                maxDigits = FastInteger.FromBig(ctx.getPrecision());
                if (ctx.getClampNormalExponents()) {
                    maxDigits.Decrement();
                }
            }
            while (i < endStr) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                    int thisdigit = str.charAt(i) - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (mantInt > 0xCCCCCCB) {
                        if (mant == null) {
                            mant = new FastInteger(mantInt);
                            mantBuffer = thisdigit;
                            mantBufferMult = 10;
                        } else if (mantBufferMult >= 1000000000) {
                            mant.Multiply(mantBufferMult).AddInt(mantBuffer);
                            mantBuffer = thisdigit;
                            mantBufferMult = 10;
                        } else {
                            mantBufferMult = (mantBufferMult << 3) + (mantBufferMult << 1);
                            mantBuffer = (mantBuffer << 3) + (mantBuffer << 1);
                            mantBuffer += thisdigit;
                        }
                    } else {
                        mantInt = (mantInt << 3) + (mantInt << 1);
                        mantInt += thisdigit;
                    }
                    if (haveDigits && maxDigits != null) {
                        digitCount.Increment();
                        if (digitCount.compareTo(maxDigits) > 0) {
                            throw new NumberFormatException();
                        }
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (mant != null && (mantBufferMult != 1 || mantBuffer != 0)) {
                mant.Multiply(mantBufferMult).AddInt(mantBuffer);
            }
            EInteger bigmant = mant == null ? EInteger.FromInt32(mantInt) : mant.AsEInteger();
            flags2 = (negative ? 1 : 0) | 4;
            return EDecimal.CreateWithFlags(FastIntegerFixed.FromBig(bigmant), FastIntZero, flags2);
        }
        if (!(i + 4 > endStr || str.charAt(i) != 'S' && str.charAt(i) != 's' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'A' && str.charAt(i + 2) != 'a' || str.charAt(i + 3) != 'N' && str.charAt(i + 3) != 'n')) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                throw new NumberFormatException("NaN not allowed");
            }
            if (i + 4 == endStr) {
                int flags2 = (negative ? 1 : 0) | 8;
                return !negative ? SignalingNaN : new EDecimal(FastIntZero, FastIntZero, flags2);
            }
            i += 4;
            FastInteger digitCount = new FastInteger(0);
            FastInteger maxDigits = null;
            haveDigits = false;
            if (ctx != null && ctx.getHasMaxPrecision()) {
                maxDigits = FastInteger.FromBig(ctx.getPrecision());
                if (ctx.getClampNormalExponents()) {
                    maxDigits.Decrement();
                }
            }
            while (i < endStr) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                    int thisdigit = str.charAt(i) - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (mantInt > 0xCCCCCCB) {
                        if (mant == null) {
                            mant = new FastInteger(mantInt);
                            mantBuffer = thisdigit;
                            mantBufferMult = 10;
                        } else if (mantBufferMult >= 1000000000) {
                            mant.Multiply(mantBufferMult).AddInt(mantBuffer);
                            mantBuffer = thisdigit;
                            mantBufferMult = 10;
                        } else {
                            mantBufferMult = (mantBufferMult << 3) + (mantBufferMult << 1);
                            mantBuffer = (mantBuffer << 3) + (mantBuffer << 1);
                            mantBuffer += thisdigit;
                        }
                    } else {
                        mantInt = (mantInt << 3) + (mantInt << 1);
                        mantInt += thisdigit;
                    }
                    if (haveDigits && maxDigits != null) {
                        digitCount.Increment();
                        if (digitCount.compareTo(maxDigits) > 0) {
                            throw new NumberFormatException();
                        }
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (mant != null && (mantBufferMult != 1 || mantBuffer != 0)) {
                mant.Multiply(mantBufferMult).AddInt(mantBuffer);
            }
            int flags3 = (negative ? 1 : 0) | 8;
            EInteger bigmant = mant == null ? EInteger.FromInt32(mantInt) : mant.AsEInteger();
            return EDecimal.CreateWithFlags(bigmant, EInteger.FromInt32(0), flags3);
        }
        while (i < endStr) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') {
                int thisdigit = ch - 48;
                if (mantInt > 0xCCCCCCB) {
                    if (mant == null) {
                        mant = new FastInteger(mantInt);
                        mantBuffer = thisdigit;
                        mantBufferMult = 10;
                    } else if (mantBufferMult >= 1000000000) {
                        mant.Multiply(mantBufferMult).AddInt(mantBuffer);
                        mantBuffer = thisdigit;
                        mantBufferMult = 10;
                    } else {
                        mantBufferMult = (mantBufferMult << 3) + (mantBufferMult << 1);
                        mantBuffer = (mantBuffer << 3) + (mantBuffer << 1);
                        mantBuffer += thisdigit;
                    }
                } else {
                    mantInt = (mantInt << 3) + (mantInt << 1);
                    mantInt += thisdigit;
                }
                haveDigits = true;
                if (haveDecimalPoint) {
                    if (newScaleInt == Integer.MIN_VALUE) {
                        newScale = newScale == null ? new FastInteger(newScaleInt) : newScale;
                        newScale.Decrement();
                    } else {
                        --newScaleInt;
                    }
                }
            } else if (ch == '.') {
                if (haveDecimalPoint) {
                    throw new NumberFormatException();
                }
                haveDecimalPoint = true;
            } else {
                if (ch == 'E' || ch == 'e') {
                    haveExponent = true;
                    ++i;
                    break;
                }
                throw new NumberFormatException();
            }
            ++i;
        }
        if (!haveDigits) {
            throw new NumberFormatException();
        }
        if (mant != null && (mantBufferMult != 1 || mantBuffer != 0)) {
            mant.Multiply(mantBufferMult).AddInt(mantBuffer);
        }
        if (haveExponent) {
            FastInteger exp = null;
            int expInt = 0;
            tmpoffset = 1;
            haveDigits = false;
            if (i == endStr) {
                throw new NumberFormatException();
            }
            if (str.charAt(i) == '+' || str.charAt(i) == '-') {
                if (str.charAt(i) == '-') {
                    tmpoffset = -1;
                }
                ++i;
            }
            while (i < endStr) {
                char ch = str.charAt(i);
                if (ch >= '0' && ch <= '9') {
                    haveDigits = true;
                    int thisdigit = ch - 48;
                    if (expInt > 0xCCCCCCB) {
                        if (exp == null) {
                            exp = new FastInteger(expInt);
                            expBuffer = thisdigit;
                            expBufferMult = 10;
                        } else if (expBufferMult >= 1000000000) {
                            exp.Multiply(expBufferMult).AddInt(expBuffer);
                            expBuffer = thisdigit;
                            expBufferMult = 10;
                        } else {
                            expBufferMult = (expBufferMult << 3) + (expBufferMult << 1);
                            expBuffer = (expBuffer << 3) + (expBuffer << 1);
                            expBuffer += thisdigit;
                        }
                    } else {
                        expInt *= 10;
                        expInt += thisdigit;
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (!haveDigits) {
                throw new NumberFormatException();
            }
            if (exp != null && (expBufferMult != 1 || expBuffer != 0)) {
                exp.Multiply(expBufferMult).AddInt(expBuffer);
            }
            if (tmpoffset >= 0 && newScaleInt == 0 && newScale == null && exp == null) {
                newScaleInt = expInt;
            } else if (exp == null) {
                FastInteger fastInteger = newScale = newScale == null ? new FastInteger(newScaleInt) : newScale;
                if (tmpoffset < 0) {
                    newScale.SubtractInt(expInt);
                } else if (expInt != 0) {
                    newScale.AddInt(expInt);
                }
            } else {
                FastInteger fastInteger = newScale = newScale == null ? new FastInteger(newScaleInt) : newScale;
                if (tmpoffset < 0) {
                    newScale.Subtract(exp);
                } else {
                    newScale.Add(exp);
                }
            }
        }
        if (i != endStr) {
            throw new NumberFormatException();
        }
        FastIntegerFixed fastIntScale = newScale == null ? new FastIntegerFixed(newScaleInt) : FastIntegerFixed.FromFastInteger(newScale);
        int n = sign = negative ? -1 : 1;
        if (mant == null) {
            fastIntMant = new FastIntegerFixed(mantInt);
            if (mantInt == 0) {
                sign = 0;
            }
        } else if (mant.CanFitInInt32()) {
            mantInt = mant.AsInt32();
            fastIntMant = new FastIntegerFixed(mantInt);
            if (mantInt == 0) {
                sign = 0;
            }
        } else {
            fastIntMant = FastIntegerFixed.FromFastInteger(mant);
        }
        EDecimal ret = new EDecimal(fastIntMant, fastIntScale, negative ? 1 : 0);
        if (ctx != null) {
            ret = EDecimal.GetMathValue(ctx).RoundAfterConversion(ret, ctx);
        }
        return ret;
    }

    public static EDecimal Max(EDecimal first, EDecimal second, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Max(first, second, ctx);
    }

    public static EDecimal Max(EDecimal first, EDecimal second) {
        return EDecimal.Max(first, second, null);
    }

    public static EDecimal MaxMagnitude(EDecimal first, EDecimal second, EContext ctx) {
        return EDecimal.GetMathValue(ctx).MaxMagnitude(first, second, ctx);
    }

    public static EDecimal MaxMagnitude(EDecimal first, EDecimal second) {
        return EDecimal.MaxMagnitude(first, second, null);
    }

    public static EDecimal Min(EDecimal first, EDecimal second, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Min(first, second, ctx);
    }

    public static EDecimal Min(EDecimal first, EDecimal second) {
        return EDecimal.Min(first, second, null);
    }

    public static EDecimal MinMagnitude(EDecimal first, EDecimal second, EContext ctx) {
        return EDecimal.GetMathValue(ctx).MinMagnitude(first, second, ctx);
    }

    public static EDecimal MinMagnitude(EDecimal first, EDecimal second) {
        return EDecimal.MinMagnitude(first, second, null);
    }

    public static EDecimal PI(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Pi(ctx);
    }

    public EDecimal Abs() {
        if (this.isNegative()) {
            EDecimal er = new EDecimal(this.unsignedMantissa, this.exponent, this.flags & 0xFFFFFFFE);
            return er;
        }
        return this;
    }

    public EDecimal CopySign(EDecimal other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        if (this.isNegative()) {
            return other.isNegative() ? this : this.Negate();
        }
        return other.isNegative() ? this.Negate() : this;
    }

    public EDecimal Abs(EContext context) {
        return (context == null || context == EContext.UnlimitedHalfEven ? ExtendedMathValue : MathValue).Abs(this, context);
    }

    public EDecimal Add(EDecimal otherValue) {
        if (this.isFinite() && otherValue != null && otherValue.isFinite() && ((this.flags | otherValue.flags) & 1) == 0 && this.exponent.compareTo(otherValue.exponent) == 0) {
            FastIntegerFixed result = FastIntegerFixed.Add(this.unsignedMantissa, otherValue.unsignedMantissa);
            return new EDecimal(result, this.exponent, 0);
        }
        return this.Add(otherValue, EContext.UnlimitedHalfEven);
    }

    public EDecimal Add(EDecimal otherValue, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Add(this, otherValue, ctx);
    }

    @Override
    public int compareTo(EDecimal other) {
        return ExtendedMathValue.compareTo(this, other);
    }

    public int CompareToBinary(EFloat other) {
        return EDecimal.CompareEDecimalToEFloat(this, other);
    }

    private static int CompareEDecimalToEFloat(EDecimal ed, EFloat ef) {
        int signB;
        if (ef == null) {
            return 1;
        }
        if (ed.IsNaN()) {
            return ef.IsNaN() ? 0 : 1;
        }
        int signA = ed.signum();
        if (signA != (signB = ef.signum())) {
            return signA < signB ? -1 : 1;
        }
        if (signB == 0 || signA == 0) {
            return 0;
        }
        if (ed.IsInfinity()) {
            if (ef.IsInfinity()) {
                return 0;
            }
            return ed.isNegative() ? -1 : 1;
        }
        if (ef.IsInfinity()) {
            return ef.isNegative() ? 1 : -1;
        }
        if (ef.getExponent().compareTo(EInteger.FromInt64(-1000L)) < 0) {
            if (ef.Abs(null).compareTo(EFloat.One) < 0 && ed.Abs(null).compareTo(One) >= 0) {
                return signA > 0 ? 1 : -1;
            }
            EInteger bitCount = ef.getMantissa().GetUnsignedBitLengthAsEInteger();
            EInteger absexp = ef.getExponent().Abs();
            if (absexp.compareTo(bitCount) > 0) {
                EFloat trial = EFloat.Create(ef.getMantissa(), EInteger.FromInt32(-1000));
                int trialcmp = EDecimal.CompareEDecimalToEFloat(ed, trial);
                if (ef.signum() < 0 && trialcmp < 0) {
                    return -1;
                }
                if (ef.signum() > 0 && trialcmp > 0) {
                    return 1;
                }
            }
            EInteger thisAdjExp = EDecimal.GetAdjustedExponent(ed);
            EInteger otherAdjExp = EDecimal.GetAdjustedExponentBinary(ef);
            if (thisAdjExp.signum() < 0 && thisAdjExp.compareTo(EInteger.FromInt64(-1000L)) >= 0 && otherAdjExp.compareTo(EInteger.FromInt64(-4000L)) < 0) {
                return signA > 0 ? 1 : -1;
            }
            if (thisAdjExp.signum() < 0 && thisAdjExp.compareTo(EInteger.FromInt64(-1000L)) < 0 && otherAdjExp.compareTo(EInteger.FromInt64(-1000L)) < 0) {
                thisAdjExp = thisAdjExp.Add(EInteger.FromInt32(1)).Abs();
                EInteger ratio = (otherAdjExp = otherAdjExp.Add(EInteger.FromInt32(1)).Abs()).Multiply(1000).Divide(thisAdjExp);
                if (ratio.compareTo(EInteger.FromInt64(3321L)) < 0) {
                    return signA > 0 ? -1 : 1;
                }
                if (ratio.compareTo(EInteger.FromInt64(3322L)) >= 0) {
                    return signA > 0 ? 1 : -1;
                }
            }
        }
        if (ef.getExponent().compareTo(EInteger.FromInt64(1000L)) > 0) {
            EInteger bignum = EInteger.FromInt32(1).ShiftLeft(999);
            if (ed.Abs(null).compareTo(EDecimal.FromEInteger(bignum)) <= 0) {
                return signA > 0 ? -1 : 1;
            }
            EInteger thisAdjExp = EDecimal.GetAdjustedExponent(ed);
            EInteger otherAdjExp = EDecimal.GetAdjustedExponentBinary(ef);
            if (thisAdjExp.signum() > 0 && thisAdjExp.compareTo(otherAdjExp) >= 0) {
                return signA > 0 ? 1 : -1;
            }
            if (thisAdjExp.signum() > 0 && thisAdjExp.compareTo(1000) < 0 && otherAdjExp.compareTo(4000) >= 0) {
                return signA > 0 ? -1 : 1;
            }
            if (thisAdjExp.signum() > 0 && thisAdjExp.compareTo(EInteger.FromInt64(1000L)) >= 0 && otherAdjExp.compareTo(EInteger.FromInt64(1000L)) >= 0) {
                thisAdjExp = thisAdjExp.Add(EInteger.FromInt32(1));
                EInteger ratio = (otherAdjExp = otherAdjExp.Add(EInteger.FromInt32(1))).Multiply(1000).Divide(thisAdjExp);
                if (ratio.compareTo(EInteger.FromInt64(3321L)) < 0) {
                    return signA > 0 ? 1 : -1;
                }
                if (ratio.compareTo(EInteger.FromInt64(3322L)) >= 0) {
                    return signA > 0 ? -1 : 1;
                }
            }
        }
        EDecimal otherDec = EDecimal.FromEFloat(ef);
        return ed.compareTo(otherDec);
    }

    public EDecimal CompareToSignal(EDecimal other, EContext ctx) {
        return EDecimal.GetMathValue(ctx).CompareToWithContext(this, other, true, ctx);
    }

    public int CompareToTotalMagnitude(EDecimal other) {
        if (other == null) {
            return -1;
        }
        int valueIThis = 0;
        int valueIOther = 0;
        if (this.IsSignalingNaN()) {
            valueIThis = 2;
        } else if (this.IsNaN()) {
            valueIThis = 3;
        } else if (this.IsInfinity()) {
            valueIThis = 1;
        }
        if (other.IsSignalingNaN()) {
            valueIOther = 2;
        } else if (other.IsNaN()) {
            valueIOther = 3;
        } else if (other.IsInfinity()) {
            valueIOther = 1;
        }
        if (valueIThis > valueIOther) {
            return 1;
        }
        if (valueIThis < valueIOther) {
            return -1;
        }
        if (valueIThis >= 2) {
            int cmp = this.unsignedMantissa.compareTo(other.unsignedMantissa);
            return cmp;
        }
        if (valueIThis == 1) {
            return 0;
        }
        int cmp = this.Abs().compareTo(other.Abs());
        if (cmp == 0) {
            cmp = this.exponent.compareTo(other.exponent);
            return cmp;
        }
        return cmp;
    }

    public int CompareToTotal(EDecimal other, EContext ctx) {
        if (other == null) {
            return -1;
        }
        if (this.IsSignalingNaN() || other.IsSignalingNaN()) {
            return this.CompareToTotal(other);
        }
        if (ctx != null && ctx.isSimplified()) {
            return this.RoundToPrecision(ctx).CompareToTotal(other.RoundToPrecision(ctx));
        }
        return this.CompareToTotal(other);
    }

    public int CompareToTotalMagnitude(EDecimal other, EContext ctx) {
        if (other == null) {
            return -1;
        }
        if (this.IsSignalingNaN() || other.IsSignalingNaN()) {
            return this.CompareToTotalMagnitude(other);
        }
        if (ctx != null && ctx.isSimplified()) {
            return this.RoundToPrecision(ctx).CompareToTotalMagnitude(other.RoundToPrecision(ctx));
        }
        return this.CompareToTotalMagnitude(other);
    }

    public int CompareToTotal(EDecimal other) {
        boolean neg2;
        if (other == null) {
            return -1;
        }
        boolean neg1 = this.isNegative();
        if (neg1 != (neg2 = other.isNegative())) {
            return neg1 ? -1 : 1;
        }
        int valueIThis = 0;
        int valueIOther = 0;
        if (this.IsSignalingNaN()) {
            valueIThis = 2;
        } else if (this.IsNaN()) {
            valueIThis = 3;
        } else if (this.IsInfinity()) {
            valueIThis = 1;
        }
        if (other.IsSignalingNaN()) {
            valueIOther = 2;
        } else if (other.IsNaN()) {
            valueIOther = 3;
        } else if (other.IsInfinity()) {
            valueIOther = 1;
        }
        if (valueIThis > valueIOther) {
            return neg1 ? -1 : 1;
        }
        if (valueIThis < valueIOther) {
            return neg1 ? 1 : -1;
        }
        if (valueIThis >= 2) {
            int cmp = this.unsignedMantissa.compareTo(other.unsignedMantissa);
            return neg1 ? -cmp : cmp;
        }
        if (valueIThis == 1) {
            return 0;
        }
        int cmp = this.compareTo(other);
        if (cmp == 0) {
            cmp = this.exponent.compareTo(other.exponent);
            return neg1 ? -cmp : cmp;
        }
        return cmp;
    }

    public EDecimal CompareToWithContext(EDecimal other, EContext ctx) {
        return EDecimal.GetMathValue(ctx).CompareToWithContext(this, other, false, ctx);
    }

    public EDecimal Divide(EDecimal divisor) {
        return this.Divide(divisor, EContext.ForRounding(ERounding.None));
    }

    public EDecimal Divide(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Divide(this, divisor, ctx);
    }

    @Deprecated
    public EDecimal[] DivideAndRemainderNaturalScale(EDecimal divisor) {
        return this.DivRemNaturalScale(divisor, null);
    }

    @Deprecated
    public EDecimal[] DivideAndRemainderNaturalScale(EDecimal divisor, EContext ctx) {
        return this.DivRemNaturalScale(divisor, ctx);
    }

    public EDecimal[] DivRemNaturalScale(EDecimal divisor) {
        return this.DivRemNaturalScale(divisor, null);
    }

    public EDecimal[] DivRemNaturalScale(EDecimal divisor, EContext ctx) {
        EDecimal[] result;
        result = new EDecimal[]{this.DivideToIntegerNaturalScale(divisor, null), this.Subtract(result[0].Multiply(divisor, null), ctx)};
        result[0] = result[0].RoundToPrecision(ctx);
        return result;
    }

    public EDecimal DivideToExponent(EDecimal divisor, long desiredExponentSmall, EContext ctx) {
        return this.DivideToExponent(divisor, EInteger.FromInt64(desiredExponentSmall), ctx);
    }

    public EDecimal DivideToExponent(EDecimal divisor, int desiredExponentInt, EContext ctx) {
        return this.DivideToExponent(divisor, EInteger.FromInt32(desiredExponentInt), ctx);
    }

    public EDecimal DivideToExponent(EDecimal divisor, long desiredExponentSmall, ERounding rounding) {
        return this.DivideToExponent(divisor, EInteger.FromInt64(desiredExponentSmall), EContext.ForRounding(rounding));
    }

    public EDecimal DivideToExponent(EDecimal divisor, int desiredExponentInt, ERounding rounding) {
        return this.DivideToExponent(divisor, EInteger.FromInt32(desiredExponentInt), EContext.ForRounding(rounding));
    }

    public EDecimal DivideToExponent(EDecimal divisor, EInteger exponent, EContext ctx) {
        return EDecimal.GetMathValue(ctx).DivideToExponent(this, divisor, exponent, ctx);
    }

    public EDecimal DivideToExponent(EDecimal divisor, EInteger exponent) {
        return this.DivideToExponent(divisor, exponent, ERounding.HalfEven);
    }

    public EDecimal DivideToExponent(EDecimal divisor, long desiredExponentSmall) {
        return this.DivideToExponent(divisor, desiredExponentSmall, ERounding.HalfEven);
    }

    public EDecimal DivideToExponent(EDecimal divisor, int desiredExponentInt) {
        return this.DivideToExponent(divisor, desiredExponentInt, ERounding.HalfEven);
    }

    public EDecimal DivideToExponent(EDecimal divisor, EInteger desiredExponent, ERounding rounding) {
        return this.DivideToExponent(divisor, desiredExponent, EContext.ForRounding(rounding));
    }

    public EDecimal DivideToIntegerNaturalScale(EDecimal divisor) {
        return this.DivideToIntegerNaturalScale(divisor, EContext.ForRounding(ERounding.Down));
    }

    public EDecimal DivideToIntegerNaturalScale(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).DivideToIntegerNaturalScale(this, divisor, ctx);
    }

    public EDecimal DivideToIntegerZeroScale(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).DivideToIntegerZeroScale(this, divisor, ctx);
    }

    public EDecimal DivideToSameExponent(EDecimal divisor, ERounding rounding) {
        return this.DivideToExponent(divisor, this.exponent.ToEInteger(), EContext.ForRounding(rounding));
    }

    public boolean equals(EDecimal other) {
        return this.EqualsInternal(other);
    }

    public boolean equals(Object obj) {
        return this.EqualsInternal(obj instanceof EDecimal ? (EDecimal)obj : null);
    }

    public EDecimal Exp(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Exp(this, ctx);
    }

    public int hashCode() {
        int valueHashCode = 964453631;
        valueHashCode += 964453723 * this.exponent.hashCode();
        valueHashCode += 964453939 * this.unsignedMantissa.hashCode();
        return valueHashCode += 964453967 * this.flags;
    }

    public boolean IsInfinity() {
        return (this.flags & 2) != 0;
    }

    public boolean IsNaN() {
        return (this.flags & 0xC) != 0;
    }

    public boolean IsNegativeInfinity() {
        return (this.flags & 3) == 3;
    }

    public boolean IsPositiveInfinity() {
        return (this.flags & 3) == 2;
    }

    public boolean IsQuietNaN() {
        return (this.flags & 4) != 0;
    }

    public boolean IsSignalingNaN() {
        return (this.flags & 8) != 0;
    }

    public EDecimal Log(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Ln(this, ctx);
    }

    public EDecimal Log10(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Log10(this, ctx);
    }

    public EDecimal MovePointLeft(int places) {
        return this.MovePointLeft(EInteger.FromInt32(places), null);
    }

    public EDecimal MovePointLeft(int places, EContext ctx) {
        return this.MovePointLeft(EInteger.FromInt32(places), ctx);
    }

    public EDecimal MovePointLeft(EInteger bigPlaces) {
        return this.MovePointLeft(bigPlaces, null);
    }

    public EDecimal MovePointLeft(EInteger bigPlaces, EContext ctx) {
        return !this.isFinite() ? this.RoundToPrecision(ctx) : this.MovePointRight(bigPlaces.Negate(), ctx);
    }

    public EDecimal MovePointRight(int places) {
        return this.MovePointRight(EInteger.FromInt32(places), null);
    }

    public EDecimal MovePointRight(int places, EContext ctx) {
        return this.MovePointRight(EInteger.FromInt32(places), ctx);
    }

    public EDecimal MovePointRight(EInteger bigPlaces) {
        return this.MovePointRight(bigPlaces, null);
    }

    public EDecimal MovePointRight(EInteger bigPlaces, EContext ctx) {
        if (!this.isFinite()) {
            return this.RoundToPrecision(ctx);
        }
        EInteger bigExp = this.getExponent();
        if ((bigExp = bigExp.Add(bigPlaces)).signum() > 0) {
            EInteger mant = this.unsignedMantissa.ToEInteger();
            EInteger bigPower = NumberUtility.FindPowerOfTenFromBig(bigExp);
            mant = mant.Multiply(bigPower);
            return EDecimal.CreateWithFlags(mant, EInteger.FromInt32(0), this.flags).RoundToPrecision(ctx);
        }
        return EDecimal.CreateWithFlags(this.unsignedMantissa, FastIntegerFixed.FromBig(bigExp), this.flags).RoundToPrecision(ctx);
    }

    public EDecimal Multiply(EDecimal otherValue) {
        if (this.isFinite() && otherValue.isFinite()) {
            int newflags = otherValue.flags ^ this.flags;
            if (this.unsignedMantissa.CanFitInInt32() && otherValue.unsignedMantissa.CanFitInInt32()) {
                int integerA = this.unsignedMantissa.AsInt32();
                int integerB = otherValue.unsignedMantissa.AsInt32();
                long longA = (long)integerA * (long)integerB;
                FastIntegerFixed exp = FastIntegerFixed.Add(this.exponent, otherValue.exponent);
                if (longA >> 31 == 0L) {
                    return new EDecimal(new FastIntegerFixed((int)longA), exp, newflags);
                }
                return new EDecimal(FastIntegerFixed.FromBig(EInteger.FromInt64(longA)), exp, newflags);
            }
            EInteger eintA = this.unsignedMantissa.ToEInteger().Multiply(otherValue.unsignedMantissa.ToEInteger());
            return new EDecimal(FastIntegerFixed.FromBig(eintA), FastIntegerFixed.Add(this.exponent, otherValue.exponent), newflags);
        }
        return this.Multiply(otherValue, EContext.UnlimitedHalfEven);
    }

    public EDecimal Multiply(EDecimal op, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Multiply(this, op, ctx);
    }

    public EDecimal Add(int intValue) {
        return this.Add(EDecimal.FromInt32(intValue));
    }

    public EDecimal Subtract(int intValue) {
        return intValue == Integer.MIN_VALUE ? this.Subtract(EDecimal.FromInt32(intValue)) : this.Add(-intValue);
    }

    public EDecimal Multiply(int intValue) {
        return this.Multiply(EDecimal.FromInt32(intValue));
    }

    public EDecimal Divide(int intValue) {
        return this.Divide(EDecimal.FromInt32(intValue));
    }

    public EDecimal MultiplyAndAdd(EDecimal multiplicand, EDecimal augend) {
        return this.MultiplyAndAdd(multiplicand, augend, null);
    }

    public EDecimal MultiplyAndAdd(EDecimal op, EDecimal augend, EContext ctx) {
        return EDecimal.GetMathValue(ctx).MultiplyAndAdd(this, op, augend, ctx);
    }

    public EDecimal MultiplyAndSubtract(EDecimal op, EDecimal subtrahend, EContext ctx) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (subtrahend == null) {
            throw new NullPointerException("subtrahend");
        }
        EDecimal negated = subtrahend;
        if ((subtrahend.flags & 0xC) == 0) {
            int newflags = subtrahend.flags ^ 1;
            negated = EDecimal.CreateWithFlags(subtrahend.unsignedMantissa, subtrahend.exponent, newflags);
        }
        return EDecimal.GetMathValue(ctx).MultiplyAndAdd(this, op, negated, ctx);
    }

    public EDecimal Negate() {
        return new EDecimal(this.unsignedMantissa, this.exponent, this.flags ^ 1);
    }

    public EDecimal Negate(EContext context) {
        return (context == null || context == EContext.UnlimitedHalfEven ? ExtendedMathValue : MathValue).Negate(this, context);
    }

    public EDecimal NextMinus(EContext ctx) {
        return EDecimal.GetMathValue(ctx).NextMinus(this, ctx);
    }

    public EDecimal NextPlus(EContext ctx) {
        return EDecimal.GetMathValue(ctx).NextPlus(this, ctx);
    }

    public EDecimal NextToward(EDecimal otherValue, EContext ctx) {
        return EDecimal.GetMathValue(ctx).NextToward(this, otherValue, ctx);
    }

    public EDecimal Plus(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Plus(this, ctx);
    }

    public EDecimal Pow(EDecimal exponent, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Power(this, exponent, ctx);
    }

    public EDecimal Pow(int exponentSmall, EContext ctx) {
        return this.Pow(EDecimal.FromInt64(exponentSmall), ctx);
    }

    public EDecimal Pow(int exponentSmall) {
        return this.Pow(EDecimal.FromInt64(exponentSmall), null);
    }

    public EInteger Precision() {
        if (!this.isFinite()) {
            return EInteger.FromInt32(0);
        }
        return this.isZero() ? EInteger.FromInt32(1) : this.unsignedMantissa.ToEInteger().GetDigitCountAsEInteger();
    }

    public EDecimal Quantize(EInteger desiredExponent, EContext ctx) {
        return this.Quantize(EDecimal.Create(EInteger.FromInt32(1), desiredExponent), ctx);
    }

    public EDecimal Quantize(int desiredExponentInt, ERounding rounding) {
        EDecimal ret = this.RoundToExponentFast(desiredExponentInt, rounding);
        if (ret != null) {
            return ret;
        }
        return this.Quantize(EDecimal.Create(EInteger.FromInt32(1), EInteger.FromInt32(desiredExponentInt)), EContext.ForRounding(rounding));
    }

    public EDecimal Quantize(int desiredExponentInt, EContext ctx) {
        EDecimal ret;
        if (!(ctx != null && (ctx.getHasExponentRange() || ctx.getHasFlags() || ctx.getTraps() != 0 || ctx.getHasMaxPrecision() || ctx.isSimplified()) || (ret = this.RoundToExponentFast(desiredExponentInt, ctx == null ? ERounding.HalfEven : ctx.getRounding())) == null)) {
            return ret;
        }
        return this.Quantize(EDecimal.Create(EInteger.FromInt32(1), EInteger.FromInt32(desiredExponentInt)), ctx);
    }

    public EDecimal Quantize(EDecimal otherValue, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Quantize(this, otherValue, ctx);
    }

    public EDecimal Reduce(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Reduce(this, ctx);
    }

    public EDecimal Remainder(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Remainder(this, divisor, ctx, true);
    }

    public EDecimal RemainderNoRoundAfterDivide(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Remainder(this, divisor, ctx, false);
    }

    public EDecimal RemainderNaturalScale(EDecimal divisor) {
        return this.RemainderNaturalScale(divisor, null);
    }

    public EDecimal RemainderNaturalScale(EDecimal divisor, EContext ctx) {
        return this.Subtract(this.DivideToIntegerNaturalScale(divisor, null).Multiply(divisor, null), ctx);
    }

    public EDecimal RemainderNear(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).RemainderNear(this, divisor, ctx);
    }

    public EDecimal RoundToExponent(EInteger exponent, EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentSimple(this, exponent, ctx);
    }

    public EDecimal RoundToExponent(EInteger exponent) {
        return this.RoundToExponent(exponent, EContext.ForRounding(ERounding.HalfEven));
    }

    public EDecimal RoundToExponent(EInteger exponent, ERounding rounding) {
        return this.RoundToExponent(exponent, EContext.ForRounding(rounding));
    }

    public EDecimal RoundToExponent(int exponentSmall) {
        return this.RoundToExponent(exponentSmall, ERounding.HalfEven);
    }

    public EDecimal RoundToExponent(int exponentSmall, EContext ctx) {
        EDecimal ret;
        if (!(ctx != null && (ctx.getHasExponentRange() || ctx.getHasFlags() || ctx.getTraps() != 0 || ctx.getHasMaxPrecision() || ctx.isSimplified()) || (ret = this.RoundToExponentFast(exponentSmall, ctx == null ? ERounding.HalfEven : ctx.getRounding())) == null)) {
            return ret;
        }
        return this.RoundToExponent(EInteger.FromInt32(exponentSmall), ctx);
    }

    public EDecimal RoundToExponent(int exponentSmall, ERounding rounding) {
        EDecimal ret = this.RoundToExponentFast(exponentSmall, rounding);
        if (ret != null) {
            return ret;
        }
        return this.RoundToExponent(exponentSmall, EContext.ForRounding(rounding));
    }

    public EDecimal RoundToExponentExact(EInteger exponent, EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentExact(this, exponent, ctx);
    }

    public EDecimal RoundToExponentExact(int exponentSmall, EContext ctx) {
        return this.RoundToExponentExact(EInteger.FromInt32(exponentSmall), ctx);
    }

    public EDecimal RoundToExponentExact(int exponentSmall, ERounding rounding) {
        return this.RoundToExponentExact(EInteger.FromInt32(exponentSmall), EContext.Unlimited.WithRounding(rounding));
    }

    public EDecimal RoundToIntegerExact(EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentExact(this, EInteger.FromInt32(0), ctx);
    }

    public EDecimal RoundToIntegerNoRoundedFlag(EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentNoRoundedFlag(this, EInteger.FromInt32(0), ctx);
    }

    @Deprecated
    public EDecimal RoundToIntegralExact(EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentExact(this, EInteger.FromInt32(0), ctx);
    }

    @Deprecated
    public EDecimal RoundToIntegralNoRoundedFlag(EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentNoRoundedFlag(this, EInteger.FromInt32(0), ctx);
    }

    public EDecimal RoundToPrecision(EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToPrecision(this, ctx);
    }

    public EDecimal ScaleByPowerOfTen(int places) {
        return this.ScaleByPowerOfTen(EInteger.FromInt32(places), null);
    }

    public EDecimal ScaleByPowerOfTen(int places, EContext ctx) {
        return this.ScaleByPowerOfTen(EInteger.FromInt32(places), ctx);
    }

    public EDecimal ScaleByPowerOfTen(EInteger bigPlaces) {
        return this.ScaleByPowerOfTen(bigPlaces, null);
    }

    public EDecimal ScaleByPowerOfTen(EInteger bigPlaces, EContext ctx) {
        if (bigPlaces.isZero()) {
            return this.RoundToPrecision(ctx);
        }
        if (!this.isFinite()) {
            return this.RoundToPrecision(ctx);
        }
        EInteger bigExp = this.getExponent();
        bigExp = bigExp.Add(bigPlaces);
        return EDecimal.CreateWithFlags(this.unsignedMantissa, FastIntegerFixed.FromBig(bigExp), this.flags).RoundToPrecision(ctx);
    }

    public EDecimal Sqrt(EContext ctx) {
        return EDecimal.GetMathValue(ctx).SquareRoot(this, ctx);
    }

    @Deprecated
    public EDecimal SquareRoot(EContext ctx) {
        return EDecimal.GetMathValue(ctx).SquareRoot(this, ctx);
    }

    public EDecimal Subtract(EDecimal otherValue) {
        return this.Subtract(otherValue, EContext.UnlimitedHalfEven);
    }

    public EDecimal Subtract(EDecimal otherValue, EContext ctx) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        EDecimal negated = otherValue;
        if ((otherValue.flags & 0xC) == 0) {
            int newflags = otherValue.flags ^ 1;
            negated = EDecimal.CreateWithFlags(otherValue.unsignedMantissa, otherValue.exponent, newflags);
        }
        return this.Add(negated, ctx);
    }

    public double ToDouble() {
        if (this.IsPositiveInfinity()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.IsNegativeInfinity()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.isNegative() && this.isZero()) {
            return Extras.IntegersToDouble(new int[]{0, Integer.MIN_VALUE});
        }
        if (this.isZero()) {
            return 0.0;
        }
        if (this.isFinite()) {
            EInteger adjExp;
            if (this.exponent.CompareToInt(309) > 0) {
                return this.isNegative() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.exponent.CompareToInt(-22) >= 0 && this.exponent.CompareToInt(44) <= 0 && this.unsignedMantissa.CanFitInInt64()) {
                int iexp;
                long ml = this.unsignedMantissa.AsInt64();
                for (iexp = this.exponent.AsInt32(); ml <= 0x3333333333333L && iexp > 22; ml *= 10L, --iexp) {
                }
                int iabsexp = Math.abs(iexp);
                if (ml < 0x20000000000000L && iabsexp <= 22) {
                    double dml;
                    double d = ExactDoublePowersOfTen[iabsexp];
                    double d2 = dml = this.isNegative() ? (double)(-ml) : (double)ml;
                    if (iexp < 0) {
                        return dml / d;
                    }
                    return dml * d;
                }
            }
            if ((adjExp = EDecimal.GetAdjustedExponent(this)).compareTo(EInteger.FromInt64(-326L)) < 0) {
                return this.isNegative() ? Extras.IntegersToDouble(new int[]{0, Integer.MIN_VALUE}) : 0.0;
            }
            if (adjExp.compareTo(EInteger.FromInt64(309L)) > 0) {
                return this.isNegative() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        }
        return this.ToEFloat(EContext.Binary64).ToDouble();
    }

    public EInteger ToEInteger() {
        return this.ToEIntegerInternal(false);
    }

    @Deprecated
    public EInteger ToEIntegerExact() {
        return this.ToEIntegerInternal(true);
    }

    public EInteger ToEIntegerIfExact() {
        return this.ToEIntegerInternal(true);
    }

    public String ToEngineeringString() {
        return this.ToStringInternal(1);
    }

    @Deprecated
    public EFloat ToExtendedFloat() {
        return this.ToEFloat(EContext.UnlimitedHalfEven);
    }

    public EFloat ToEFloat() {
        return this.ToEFloat(EContext.UnlimitedHalfEven);
    }

    public String ToPlainString() {
        return this.ToStringInternal(2);
    }

    public float ToSingle() {
        if (this.IsPositiveInfinity()) {
            return Float.POSITIVE_INFINITY;
        }
        if (this.IsNegativeInfinity()) {
            return Float.NEGATIVE_INFINITY;
        }
        if (this.isNegative() && this.isZero()) {
            return Float.intBitsToFloat(Integer.MIN_VALUE);
        }
        if (this.isZero()) {
            return 0.0f;
        }
        if (this.isFinite()) {
            EInteger adjExp;
            if (this.exponent.CompareToInt(-10) >= 0 && this.exponent.CompareToInt(20) <= 0 && this.unsignedMantissa.CanFitInInt32()) {
                int iexp;
                int iml = this.unsignedMantissa.AsInt32();
                for (iexp = this.exponent.AsInt32(); iml <= 0x199999 && iexp > 10; iml *= 10, --iexp) {
                }
                int iabsexp = Math.abs(iexp);
                if (iml < 0x1000000 && iabsexp <= 10) {
                    float fml;
                    float fd = ExactSinglePowersOfTen[iabsexp];
                    float f = fml = this.isNegative() ? (float)(-iml) : (float)iml;
                    if (iexp < 0) {
                        return fml / fd;
                    }
                    return fml * fd;
                }
            }
            if ((adjExp = EDecimal.GetAdjustedExponent(this)).compareTo(-47) < 0) {
                return this.isNegative() ? Float.intBitsToFloat(Integer.MIN_VALUE) : 0.0f;
            }
            if (adjExp.compareTo(39) > 0) {
                return this.isNegative() ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
        }
        return this.ToEFloat(EContext.Binary32).ToSingle();
    }

    public String toString() {
        return this.ToStringInternal(0);
    }

    public EDecimal Ulp() {
        return !this.isFinite() ? One : EDecimal.Create(EInteger.FromInt32(1), this.getExponent());
    }

    static EDecimal CreateWithFlags(FastIntegerFixed mantissa, FastIntegerFixed exponent, int flags) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        return new EDecimal(mantissa, exponent, flags);
    }

    static EDecimal CreateWithFlags(EInteger mantissa, EInteger exponent, int flags) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        return new EDecimal(FastIntegerFixed.FromBig(mantissa), FastIntegerFixed.FromBig(exponent), flags);
    }

    private static boolean AppendString(StringBuilder builder, char c, FastInteger count) {
        if (count.CompareToInt(Integer.MAX_VALUE) > 0 || count.signum() < 0) {
            throw new UnsupportedOperationException();
        }
        int icount = count.AsInt32();
        for (int i = icount - 1; i >= 0; --i) {
            builder.append(c);
        }
        return true;
    }

    private static IRadixMath<EDecimal> GetMathValue(EContext ctx) {
        if (ctx == null || ctx == EContext.UnlimitedHalfEven) {
            return ExtendedMathValue;
        }
        return !ctx.isSimplified() && ctx.getTraps() == 0 ? ExtendedMathValue : MathValue;
    }

    private boolean EqualsInternal(EDecimal otherValue) {
        return otherValue != null && this.flags == otherValue.flags && this.unsignedMantissa.equals(otherValue.unsignedMantissa) && this.exponent.equals(otherValue.exponent);
    }

    private static EInteger GetAdjustedExponent(EDecimal ed) {
        if (!ed.isFinite()) {
            return EInteger.FromInt32(0);
        }
        if (ed.isZero()) {
            return EInteger.FromInt32(0);
        }
        EInteger retEInt = ed.getExponent();
        EInteger valueEiPrecision = ed.getUnsignedMantissa().GetDigitCountAsEInteger();
        retEInt = retEInt.Add(valueEiPrecision.Subtract(1));
        return retEInt;
    }

    private static EInteger GetAdjustedExponentBinary(EFloat ef) {
        if (!ef.isFinite()) {
            return EInteger.FromInt32(0);
        }
        if (ef.isZero()) {
            return EInteger.FromInt32(0);
        }
        EInteger retEInt = ef.getExponent();
        EInteger valueEiPrecision = ef.getUnsignedMantissa().GetSignedBitLengthAsEInteger();
        retEInt = retEInt.Add(valueEiPrecision.Subtract(1));
        return retEInt;
    }

    private EDecimal RoundToExponentFast(int exponentSmall, ERounding rounding) {
        if (this.isFinite() && this.exponent.CanFitInInt32() && this.unsignedMantissa.CanFitInInt32()) {
            int thisExponentSmall = this.exponent.AsInt32();
            if (thisExponentSmall == exponentSmall) {
                return this;
            }
            int thisMantissaSmall = this.unsignedMantissa.AsInt32();
            if (thisExponentSmall >= -100 && thisExponentSmall <= 100 && exponentSmall >= -100 && exponentSmall <= 100) {
                int diff;
                if (rounding == ERounding.Down) {
                    int diff2 = exponentSmall - thisExponentSmall;
                    if (diff2 >= 1 && diff2 <= 9) {
                        return new EDecimal(new FastIntegerFixed(thisMantissaSmall /= ValueTenPowers[diff2]), new FastIntegerFixed(exponentSmall), this.flags);
                    }
                } else if (rounding == ERounding.HalfEven && thisMantissaSmall != Integer.MAX_VALUE && (diff = exponentSmall - thisExponentSmall) >= 1 && diff <= 9) {
                    int div;
                    int pwr = ValueTenPowers[diff - 1];
                    int div2 = (div = thisMantissaSmall / pwr) > 43698 ? div / 10 : div * 26215 >> 18;
                    int rem = div - div2 * 10;
                    if (rem > 5) {
                        ++div2;
                    } else if (rem == 5 && thisMantissaSmall - div * pwr != 0) {
                        ++div2;
                    } else if (rem == 5 && (div2 & 1) == 1) {
                        ++div2;
                    }
                    return new EDecimal(new FastIntegerFixed(div2), new FastIntegerFixed(exponentSmall), this.flags);
                }
            }
        }
        return null;
    }

    private boolean IsIntegerPartZero() {
        if (!this.isFinite()) {
            return false;
        }
        if (this.unsignedMantissa.isValueZero()) {
            return true;
        }
        int sign = this.getExponent().signum();
        if (sign >= 0) {
            return false;
        }
        EInteger bigexponent = this.getExponent();
        EInteger digitCount = this.getUnsignedMantissa().GetDigitCountAsEInteger();
        return digitCount.compareTo(bigexponent) <= 0;
    }

    private EInteger ToEIntegerInternal(boolean exact) {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        int sign = this.getExponent().signum();
        if (this.isZero()) {
            return EInteger.FromInt32(0);
        }
        if (sign == 0) {
            EInteger bigmantissa = this.getMantissa();
            return bigmantissa;
        }
        if (sign > 0) {
            EInteger bigmantissa = this.getMantissa();
            EInteger bigexponent = NumberUtility.FindPowerOfTenFromBig(this.getExponent());
            bigmantissa = bigmantissa.Multiply(bigexponent);
            return bigmantissa;
        }
        if (exact && !this.unsignedMantissa.isEvenNumber()) {
            throw new ArithmeticException("Not an exact integer");
        }
        FastInteger bigexponent = this.exponent.ToFastInteger().Negate();
        EInteger bigmantissa = this.unsignedMantissa.ToEInteger();
        DigitShiftAccumulator acc = new DigitShiftAccumulator(bigmantissa, 0, 0);
        acc.TruncateOrShiftRight(bigexponent, true);
        if (exact && (acc.getLastDiscardedDigit() != 0 || acc.getOlderDiscardedDigits() != 0)) {
            throw new ArithmeticException("Not an exact integer");
        }
        bigmantissa = acc.getShiftedInt();
        if (this.isNegative()) {
            bigmantissa = bigmantissa.Negate();
        }
        return bigmantissa;
    }

    private static boolean HasTerminatingBinaryExpansion(EInteger den) {
        if (den.isZero()) {
            return false;
        }
        if (den.GetUnsignedBit(0) && den.compareTo(EInteger.FromInt32(1)) != 0) {
            return false;
        }
        return den.GetUnsignedBitLengthAsEInteger().equals(den.GetLowBitAsEInteger().Add(1));
    }

    private EFloat WithThisSign(EFloat ef) {
        return this.isNegative() ? ef.Negate() : ef;
    }

    public EFloat ToEFloat(EContext ec) {
        boolean neg;
        EInteger bigintExp = this.getExponent();
        EInteger bigintMant = this.getUnsignedMantissa();
        if (this.IsNaN()) {
            return EFloat.CreateNaN(this.getUnsignedMantissa(), this.IsSignalingNaN(), this.isNegative(), ec);
        }
        if (this.IsPositiveInfinity()) {
            return EFloat.PositiveInfinity.RoundToPrecision(ec);
        }
        if (this.IsNegativeInfinity()) {
            return EFloat.NegativeInfinity.RoundToPrecision(ec);
        }
        if (bigintMant.isZero()) {
            return this.isNegative() ? EFloat.NegativeZero.RoundToPrecision(ec) : EFloat.Zero.RoundToPrecision(ec);
        }
        if (bigintExp.isZero()) {
            return this.WithThisSign(EFloat.FromEInteger(bigintMant)).RoundToPrecision(ec);
        }
        if (bigintExp.signum() > 0) {
            if (ec == EContext.Binary32 ? bigintExp.compareTo(39) > 0 : ec == EContext.Binary64 && bigintExp.compareTo(309) > 0) {
                return this.isNegative() ? EFloat.NegativeInfinity : EFloat.PositiveInfinity;
            }
            EInteger bigmantissa = bigintMant;
            bigintExp = NumberUtility.FindPowerOfTenFromBig(bigintExp);
            bigmantissa = bigmantissa.Multiply(bigintExp);
            return this.WithThisSign(EFloat.FromEInteger(bigmantissa)).RoundToPrecision(ec);
        }
        EInteger scale = bigintExp;
        EInteger bigmantissa = bigintMant;
        boolean bl = neg = bigmantissa.signum() < 0;
        if (neg) {
            bigmantissa = bigmantissa.Negate();
        }
        EInteger negscale = scale.Negate();
        EInteger divisor = NumberUtility.FindPowerOfTenFromBig(negscale);
        boolean haveCopy = false;
        EContext originalEc = ec = ec == null ? EContext.UnlimitedHalfEven : ec;
        if (!ec.getHasMaxPrecision()) {
            EInteger num = bigmantissa;
            EInteger den = divisor;
            EInteger gcd = num.Gcd(den);
            if (gcd.compareTo(EInteger.FromInt32(1)) != 0) {
                den = den.Divide(gcd);
            }
            if (!EDecimal.HasTerminatingBinaryExpansion(den)) {
                ec = ec.WithPrecision(53).WithBlankFlags();
                haveCopy = true;
            } else {
                bigmantissa = bigmantissa.Divide(gcd);
                divisor = den;
            }
        }
        EInteger valueEcPrec = ec.getHasMaxPrecision() ? ec.getPrecision().Add(2) : ec.getPrecision();
        EInteger desiredHigh = EInteger.FromInt32(1).ShiftLeft(valueEcPrec);
        EInteger desiredLow = EInteger.FromInt32(1).ShiftLeft(valueEcPrec.Subtract(1));
        EInteger[] quorem = ec.getHasMaxPrecision() ? bigmantissa.DivRem(divisor) : null;
        FastInteger adjust = new FastInteger(0);
        if (!ec.getHasMaxPrecision()) {
            EInteger eterm = divisor.GetLowBitAsEInteger();
            bigmantissa = bigmantissa.ShiftLeft(eterm);
            adjust.SubtractBig(eterm);
            quorem = bigmantissa.DivRem(divisor);
        } else if (quorem[0].compareTo(desiredHigh) >= 0) {
            do {
                EInteger divBits;
                EInteger valueBmBits;
                boolean optimized = false;
                if (ec.getClampNormalExponents() && valueEcPrec.signum() > 0) {
                    EInteger vbb;
                    valueBmBits = bigmantissa.GetUnsignedBitLengthAsEInteger();
                    divBits = divisor.GetUnsignedBitLengthAsEInteger();
                    if (divisor.compareTo(bigmantissa) < 0) {
                        EInteger bitdiff;
                        if (divBits.compareTo(valueBmBits) < 0 && (bitdiff = valueBmBits.Subtract(divBits)).compareTo(valueEcPrec.Add(1)) > 0) {
                            bitdiff = bitdiff.Subtract(valueEcPrec).Subtract(1);
                            divisor = divisor.ShiftLeft(bitdiff);
                            adjust.AddBig(bitdiff);
                            optimized = true;
                        }
                    } else if (valueBmBits.compareTo(divBits) >= 0 && valueEcPrec.compareTo(EInteger.FromInt32(Integer.MAX_VALUE).Subtract(divBits)) <= 0 && valueBmBits.compareTo(vbb = divBits.Add(valueEcPrec)) < 0) {
                        valueBmBits = vbb.Subtract(valueBmBits);
                        divisor = divisor.ShiftLeft(valueBmBits);
                        adjust.AddBig(valueBmBits);
                        optimized = true;
                    }
                }
                if (!optimized) {
                    divisor = divisor.ShiftLeft(1);
                    adjust.Increment();
                }
                if (!(quorem = bigmantissa.DivRem(divisor))[1].isZero() || (valueBmBits = quorem[0].GetUnsignedBitLengthAsEInteger()).compareTo(divBits = desiredLow.GetUnsignedBitLengthAsEInteger()) >= 0) continue;
                valueBmBits = divBits.Subtract(valueBmBits);
                quorem[0] = quorem[0].ShiftLeft(valueBmBits);
                adjust.AddBig(valueBmBits);
            } while (quorem[0].compareTo(desiredHigh) >= 0);
        } else if (quorem[0].compareTo(desiredLow) < 0) {
            do {
                EInteger vbb;
                EInteger divBits;
                EInteger valueBmBits;
                boolean optimized = false;
                if (bigmantissa.compareTo(divisor) < 0) {
                    valueBmBits = bigmantissa.GetUnsignedBitLengthAsEInteger();
                    if (valueBmBits.compareTo(divBits = divisor.GetUnsignedBitLengthAsEInteger()) < 0) {
                        valueBmBits = divBits.Subtract(valueBmBits);
                        bigmantissa = bigmantissa.ShiftLeft(valueBmBits);
                        adjust.SubtractBig(valueBmBits);
                        optimized = true;
                    }
                } else if (ec.getClampNormalExponents() && valueEcPrec.signum() > 0 && (valueBmBits = bigmantissa.GetUnsignedBitLengthAsEInteger()).compareTo(divBits = divisor.GetUnsignedBitLengthAsEInteger()) >= 0 && valueEcPrec.compareTo(EInteger.FromInt32(Integer.MAX_VALUE).Subtract(divBits)) <= 0 && valueBmBits.compareTo(vbb = divBits.Add(valueEcPrec)) < 0) {
                    valueBmBits = vbb.Subtract(valueBmBits);
                    bigmantissa = bigmantissa.ShiftLeft(valueBmBits);
                    adjust.SubtractBig(valueBmBits);
                    optimized = true;
                }
                if (!optimized) {
                    bigmantissa = bigmantissa.ShiftLeft(1);
                    adjust.Decrement();
                }
                if (!(quorem = bigmantissa.DivRem(divisor))[1].isZero() || (valueBmBits = quorem[0].GetUnsignedBitLengthAsEInteger()).compareTo(divBits = desiredLow.GetUnsignedBitLengthAsEInteger()) >= 0) continue;
                valueBmBits = divBits.Subtract(valueBmBits);
                quorem[0] = quorem[0].ShiftLeft(valueBmBits);
                adjust.SubtractBig(valueBmBits);
            } while (quorem[0].compareTo(desiredLow) < 0);
        }
        if (!quorem[1].isZero() && quorem[0].isEven()) {
            quorem[0] = quorem[0].Add(EInteger.FromInt32(1));
        }
        EFloat efret = this.WithThisSign(EFloat.Create(quorem[0], adjust.AsEInteger()));
        efret = efret.RoundToPrecision(ec);
        if (haveCopy && originalEc.getHasFlags()) {
            originalEc.setFlags(originalEc.getFlags() | ec.getFlags());
        }
        return efret;
    }

    private String ToStringInternal(int mode) {
        int tmpInt;
        int cmp;
        int intExp;
        boolean negative;
        boolean bl = negative = (this.flags & 1) != 0;
        if (!this.isFinite()) {
            if ((this.flags & 2) != 0) {
                return negative ? "-Infinity" : "Infinity";
            }
            if ((this.flags & 8) != 0) {
                return this.unsignedMantissa.isValueZero() ? (negative ? "-sNaN" : "sNaN") : (negative ? "-sNaN" + this.unsignedMantissa : "sNaN" + this.unsignedMantissa);
            }
            if ((this.flags & 4) != 0) {
                return this.unsignedMantissa.isValueZero() ? (negative ? "-NaN" : "NaN") : (negative ? "-NaN" + this.unsignedMantissa : "NaN" + this.unsignedMantissa);
            }
        }
        int scaleSign = -this.exponent.signum();
        String mantissaString = this.unsignedMantissa.toString();
        if (scaleSign == 0) {
            return negative ? "-" + mantissaString : mantissaString;
        }
        boolean iszero = this.unsignedMantissa.isValueZero();
        if (mode == 2 && iszero && scaleSign < 0) {
            return negative ? "-" + mantissaString : mantissaString;
        }
        StringBuilder builder = null;
        if (mode == 0 && mantissaString.length() < 100 && this.exponent.CanFitInInt32() && (intExp = this.exponent.AsInt32()) > -100 && intExp < 100) {
            int adj = intExp + mantissaString.length() - 1;
            if (scaleSign >= 0 && adj >= -6 && scaleSign > 0) {
                int dp = intExp + mantissaString.length();
                if (dp < 0) {
                    builder = new StringBuilder(mantissaString.length() + 6);
                    if (negative) {
                        builder.append("-0.");
                    } else {
                        builder.append("0.");
                    }
                    dp = -dp;
                    for (int j = 0; j < dp; ++j) {
                        builder.append('0');
                    }
                    builder.append(mantissaString);
                    return builder.toString();
                }
                if (dp == 0) {
                    builder = new StringBuilder(mantissaString.length() + 6);
                    if (negative) {
                        builder.append("-0.");
                    } else {
                        builder.append("0.");
                    }
                    builder.append(mantissaString);
                    return builder.toString();
                }
                if (dp > 0 && dp <= mantissaString.length()) {
                    builder = new StringBuilder(mantissaString.length() + 6);
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append(mantissaString, 0, 0 + dp);
                    builder.append('.');
                    builder.append(mantissaString, dp, dp + (mantissaString.length() - dp));
                    return builder.toString();
                }
            }
        }
        FastInteger adjustedExponent = FastInteger.FromBig(this.getExponent());
        FastInteger builderLength = new FastInteger(mantissaString.length());
        FastInteger thisExponent = adjustedExponent.Copy();
        adjustedExponent.Add(builderLength).Decrement();
        FastInteger decimalPointAdjust = new FastInteger(1);
        FastInteger threshold = new FastInteger(-6);
        if (mode == 1) {
            FastInteger newExponent = adjustedExponent.Copy();
            boolean adjExponentNegative = adjustedExponent.signum() < 0;
            int intphase = adjustedExponent.Copy().Abs().Remainder(3).AsInt32();
            if (iszero && (adjustedExponent.compareTo(threshold) < 0 || scaleSign < 0)) {
                if (intphase == 1) {
                    if (adjExponentNegative) {
                        decimalPointAdjust.Increment();
                        newExponent.Increment();
                    } else {
                        decimalPointAdjust.AddInt(2);
                        newExponent.AddInt(2);
                    }
                } else if (intphase == 2) {
                    if (!adjExponentNegative) {
                        decimalPointAdjust.Increment();
                        newExponent.Increment();
                    } else {
                        decimalPointAdjust.AddInt(2);
                        newExponent.AddInt(2);
                    }
                }
                threshold.Increment();
            } else if (intphase == 1) {
                if (!adjExponentNegative) {
                    decimalPointAdjust.Increment();
                    newExponent.Decrement();
                } else {
                    decimalPointAdjust.AddInt(2);
                    newExponent.AddInt(-2);
                }
            } else if (intphase == 2) {
                if (adjExponentNegative) {
                    decimalPointAdjust.Increment();
                    newExponent.Decrement();
                } else {
                    decimalPointAdjust.AddInt(2);
                    newExponent.AddInt(-2);
                }
            }
            adjustedExponent = newExponent;
        }
        if (mode == 2 || adjustedExponent.compareTo(threshold) >= 0 && scaleSign >= 0) {
            if (scaleSign > 0) {
                FastInteger decimalPoint = thisExponent.Copy().Add(builderLength);
                cmp = decimalPoint.CompareToInt(0);
                builder = null;
                if (cmp < 0) {
                    FastInteger tmpFast = new FastInteger(mantissaString.length()).AddInt(6);
                    builder = new StringBuilder(tmpFast.CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append("0.");
                    EDecimal.AppendString(builder, '0', decimalPoint.Copy().Negate());
                    builder.append(mantissaString);
                } else if (cmp == 0) {
                    FastInteger tmpFast = new FastInteger(mantissaString.length()).AddInt(6);
                    builder = new StringBuilder(tmpFast.CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append("0.");
                    builder.append(mantissaString);
                } else if (decimalPoint.CompareToInt(mantissaString.length()) > 0) {
                    FastInteger tmpFast;
                    FastInteger insertionPoint = builderLength;
                    if (!insertionPoint.CanFitInInt32()) {
                        throw new UnsupportedOperationException();
                    }
                    int tmpInt2 = insertionPoint.AsInt32();
                    if (tmpInt2 < 0) {
                        tmpInt2 = 0;
                    }
                    builder = new StringBuilder((tmpFast = new FastInteger(mantissaString.length()).AddInt(6)).CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append(mantissaString, 0, 0 + tmpInt2);
                    EDecimal.AppendString(builder, '0', decimalPoint.Copy().SubtractInt(builder.length()));
                    builder.append('.');
                    builder.append(mantissaString, tmpInt2, tmpInt2 + (mantissaString.length() - tmpInt2));
                } else {
                    FastInteger tmpFast;
                    if (!decimalPoint.CanFitInInt32()) {
                        throw new UnsupportedOperationException();
                    }
                    tmpInt = decimalPoint.AsInt32();
                    if (tmpInt < 0) {
                        tmpInt = 0;
                    }
                    builder = new StringBuilder((tmpFast = new FastInteger(mantissaString.length()).AddInt(6)).CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append(mantissaString, 0, 0 + tmpInt);
                    builder.append('.');
                    builder.append(mantissaString, tmpInt, tmpInt + (mantissaString.length() - tmpInt));
                }
                return builder.toString();
            }
            if (mode == 2 && scaleSign < 0) {
                FastInteger negscale = thisExponent.Copy();
                builder = new StringBuilder();
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString);
                EDecimal.AppendString(builder, '0', negscale);
                return builder.toString();
            }
            return !negative ? mantissaString : "-" + mantissaString;
        }
        if (mode == 1 && iszero && decimalPointAdjust.CompareToInt(1) > 0) {
            builder = new StringBuilder();
            if (negative) {
                builder.append('-');
            }
            builder.append(mantissaString);
            builder.append('.');
            EDecimal.AppendString(builder, '0', decimalPointAdjust.Copy().Decrement());
        } else {
            FastInteger tmp = decimalPointAdjust.Copy();
            cmp = tmp.CompareToInt(mantissaString.length());
            if (cmp > 0) {
                tmp.SubtractInt(mantissaString.length());
                builder = new StringBuilder();
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString);
                EDecimal.AppendString(builder, '0', tmp);
            } else if (cmp < 0) {
                FastInteger tmpFast;
                if (!tmp.CanFitInInt32()) {
                    throw new UnsupportedOperationException();
                }
                tmpInt = tmp.AsInt32();
                if (tmp.signum() < 0) {
                    tmpInt = 0;
                }
                builder = new StringBuilder((tmpFast = new FastInteger(mantissaString.length()).AddInt(6)).CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString, 0, 0 + tmpInt);
                builder.append('.');
                builder.append(mantissaString, tmpInt, tmpInt + (mantissaString.length() - tmpInt));
            } else {
                if (adjustedExponent.signum() == 0 && !negative) {
                    return mantissaString;
                }
                if (adjustedExponent.signum() == 0 && negative) {
                    return "-" + mantissaString;
                }
                builder = new StringBuilder();
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString);
            }
        }
        if (adjustedExponent.signum() != 0) {
            builder.append(adjustedExponent.signum() < 0 ? "E-" : "E+");
            adjustedExponent.Abs();
            StringBuilder builderReversed = new StringBuilder();
            while (adjustedExponent.signum() != 0) {
                int digit = adjustedExponent.Copy().Remainder(10).AsInt32();
                builderReversed.append((char)(48 + digit));
                adjustedExponent.Divide(10);
            }
            int count = builderReversed.length();
            String builderReversedString = builderReversed.toString();
            for (int i = 0; i < count; ++i) {
                builder.append(builderReversedString.charAt(count - 1 - i));
            }
        }
        return builder.toString();
    }

    public byte ToByteChecked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.IsIntegerPartZero()) {
            return 0;
        }
        if (this.exponent.CompareToInt(3) >= 0) {
            throw new ArithmeticException("Value out of range");
        }
        return this.ToEInteger().ToByteChecked();
    }

    public byte ToByteUnchecked() {
        return this.isFinite() ? this.ToEInteger().ToByteUnchecked() : (byte)0;
    }

    public byte ToByteIfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.isZero()) {
            return 0;
        }
        if (this.isNegative()) {
            throw new ArithmeticException("Value out of range");
        }
        if (this.exponent.CompareToInt(3) >= 0) {
            throw new ArithmeticException("Value out of range");
        }
        return this.ToEIntegerIfExact().ToByteChecked();
    }

    public static EDecimal FromByte(byte inputByte) {
        int val = inputByte & 0xFF;
        return EDecimal.FromInt32(val);
    }

    public short ToInt16Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.IsIntegerPartZero()) {
            return 0;
        }
        if (this.exponent.CompareToInt(5) >= 0) {
            throw new ArithmeticException("Value out of range: ");
        }
        return this.ToEInteger().ToInt16Checked();
    }

    public short ToInt16Unchecked() {
        return this.isFinite() ? this.ToEInteger().ToInt16Unchecked() : (short)0;
    }

    public short ToInt16IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.isZero()) {
            return 0;
        }
        if (this.exponent.CompareToInt(5) >= 0) {
            throw new ArithmeticException("Value out of range");
        }
        return this.ToEIntegerIfExact().ToInt16Checked();
    }

    public static EDecimal FromInt16(short inputInt16) {
        short val = inputInt16;
        return EDecimal.FromInt32(val);
    }

    public int ToInt32Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.IsIntegerPartZero()) {
            return 0;
        }
        if (this.exponent.CompareToInt(10) >= 0) {
            throw new ArithmeticException("Value out of range: ");
        }
        return this.ToEInteger().ToInt32Checked();
    }

    public int ToInt32Unchecked() {
        return this.isFinite() ? this.ToEInteger().ToInt32Unchecked() : 0;
    }

    public int ToInt32IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.isZero()) {
            return 0;
        }
        if (this.exponent.CompareToInt(10) >= 0) {
            throw new ArithmeticException("Value out of range");
        }
        return this.ToEIntegerIfExact().ToInt32Checked();
    }

    public long ToInt64Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.IsIntegerPartZero()) {
            return 0L;
        }
        if (this.exponent.CompareToInt(19) >= 0) {
            throw new ArithmeticException("Value out of range: ");
        }
        return this.ToEInteger().ToInt64Checked();
    }

    public long ToInt64Unchecked() {
        return this.isFinite() ? this.ToEInteger().ToInt64Unchecked() : 0L;
    }

    public long ToInt64IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.isZero()) {
            return 0L;
        }
        if (this.exponent.CompareToInt(19) >= 0) {
            throw new ArithmeticException("Value out of range");
        }
        return this.ToEIntegerIfExact().ToInt64Checked();
    }

    private static final class DecimalMathHelper
    implements IRadixMathHelper<EDecimal> {
        private DecimalMathHelper() {
        }

        @Override
        public int GetRadix() {
            return 10;
        }

        @Override
        public int GetSign(EDecimal value) {
            return value.signum();
        }

        @Override
        public EInteger GetMantissa(EDecimal value) {
            return value.unsignedMantissa.ToEInteger();
        }

        @Override
        public EInteger GetExponent(EDecimal value) {
            return value.exponent.ToEInteger();
        }

        @Override
        public FastIntegerFixed GetMantissaFastInt(EDecimal value) {
            return value.unsignedMantissa;
        }

        @Override
        public FastIntegerFixed GetExponentFastInt(EDecimal value) {
            return value.exponent;
        }

        @Override
        public FastInteger GetDigitLength(EInteger ei) {
            return FastInteger.FromBig(ei.GetDigitCountAsEInteger());
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulatorWithDigits(EInteger bigint, int lastDigit, int olderDigits) {
            return new DigitShiftAccumulator(bigint, lastDigit, olderDigits);
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulatorWithDigitsFastInt(FastIntegerFixed fastInt, int lastDigit, int olderDigits) {
            if (fastInt.CanFitInInt32()) {
                return new DigitShiftAccumulator(fastInt.AsInt32(), lastDigit, olderDigits);
            }
            return new DigitShiftAccumulator(fastInt.ToEInteger(), lastDigit, olderDigits);
        }

        @Override
        public FastInteger DivisionShift(EInteger num, EInteger den) {
            if (den.isZero()) {
                return null;
            }
            EInteger gcd = den.Gcd(EInteger.FromInt32(10));
            if (gcd.compareTo(EInteger.FromInt32(1)) == 0) {
                return null;
            }
            if (den.isZero()) {
                return null;
            }
            EInteger elowbit = den.GetLowBitAsEInteger();
            den = den.ShiftRight(elowbit);
            FastInteger fiveShift = new FastInteger(0);
            while (true) {
                EInteger[] divrem = den.DivRem(EInteger.FromInt64(5L));
                EInteger bigquo = divrem[0];
                EInteger bigrem = divrem[1];
                if (!bigrem.isZero()) break;
                fiveShift.Increment();
                den = bigquo;
            }
            if (den.compareTo(EInteger.FromInt32(1)) != 0) {
                return null;
            }
            FastInteger fastlowbit = FastInteger.FromBig(elowbit);
            if (fiveShift.compareTo(fastlowbit) > 0) {
                return fiveShift;
            }
            return fastlowbit;
        }

        @Override
        public EInteger MultiplyByRadixPower(EInteger bigint, FastInteger power) {
            int powerInt;
            EInteger tmpbigint = bigint;
            if (tmpbigint.isZero()) {
                return tmpbigint;
            }
            boolean fitsInInt32 = power.CanFitInInt32();
            int n = powerInt = fitsInInt32 ? power.AsInt32() : 0;
            if (fitsInInt32 && powerInt == 0) {
                return tmpbigint;
            }
            EInteger bigtmp = null;
            if (tmpbigint.compareTo(EInteger.FromInt32(1)) != 0) {
                if (fitsInInt32) {
                    if (powerInt <= 10) {
                        bigtmp = NumberUtility.FindPowerOfTen(powerInt);
                        tmpbigint = tmpbigint.Multiply(bigtmp);
                    } else {
                        bigtmp = NumberUtility.FindPowerOfFive(powerInt);
                        tmpbigint = tmpbigint.Multiply(bigtmp);
                        tmpbigint = tmpbigint.ShiftLeft(powerInt);
                    }
                } else {
                    bigtmp = NumberUtility.FindPowerOfTenFromBig(power.AsEInteger());
                    tmpbigint = tmpbigint.Multiply(bigtmp);
                }
                return tmpbigint;
            }
            return fitsInInt32 ? NumberUtility.FindPowerOfTen(powerInt) : NumberUtility.FindPowerOfTenFromBig(power.AsEInteger());
        }

        @Override
        public int GetFlags(EDecimal value) {
            return value.flags;
        }

        @Override
        public EDecimal CreateNewWithFlags(EInteger mantissa, EInteger exponent, int flags) {
            return EDecimal.CreateWithFlags(FastIntegerFixed.FromBig(mantissa), FastIntegerFixed.FromBig(exponent), flags);
        }

        @Override
        public EDecimal CreateNewWithFlagsFastInt(FastIntegerFixed fmantissa, FastIntegerFixed fexponent, int flags) {
            return EDecimal.CreateWithFlags(fmantissa, fexponent, flags);
        }

        @Override
        public int GetArithmeticSupport() {
            return 1;
        }

        @Override
        public EDecimal ValueOf(int val) {
            return val == 0 ? Zero : (val == 1 ? One : EDecimal.FromInt64(val));
        }
    }
}

