/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.Base64;
import com.upokecenter.cbor.CBORDataUtilities;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORNumber;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CharacterInputWithCount;
import com.upokecenter.cbor.JSONOptions;
import com.upokecenter.cbor.StringOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class CBORJson {
    private static final String Hex16 = "0123456789ABCDEF";
    private CharacterInputWithCount reader;
    private StringBuilder sb;
    private boolean noDuplicates;

    private static int SkipWhitespaceJSON(CharacterInputWithCount reader) {
        int c;
        while ((c = reader.ReadChar()) != -1 && (c == 32 || c == 10 || c == 13 || c == 9)) {
        }
        return c;
    }

    private String NextJSONString() {
        this.sb = this.sb == null ? new StringBuilder() : this.sb;
        this.sb.delete(0, this.sb.length());
        block15: while (true) {
            int c;
            if ((c = this.reader.ReadChar()) == -1 || c < 32) {
                this.reader.RaiseError("Unterminated String");
            }
            switch (c) {
                case 92: {
                    c = this.reader.ReadChar();
                    switch (c) {
                        case 92: {
                            this.sb.append('\\');
                            continue block15;
                        }
                        case 47: {
                            this.sb.append('/');
                            continue block15;
                        }
                        case 34: {
                            this.sb.append('\"');
                            continue block15;
                        }
                        case 98: {
                            this.sb.append('\b');
                            continue block15;
                        }
                        case 102: {
                            this.sb.append('\f');
                            continue block15;
                        }
                        case 110: {
                            this.sb.append('\n');
                            continue block15;
                        }
                        case 114: {
                            this.sb.append('\r');
                            continue block15;
                        }
                        case 116: {
                            this.sb.append('\t');
                            continue block15;
                        }
                        case 117: {
                            c = 0;
                            for (int i = 0; i < 4; ++i) {
                                int ch = this.reader.ReadChar();
                                if (ch >= 48 && ch <= 57) {
                                    c <<= 4;
                                    c |= ch - 48;
                                    continue;
                                }
                                if (ch >= 65 && ch <= 70) {
                                    c <<= 4;
                                    c |= ch + 10 - 65;
                                    continue;
                                }
                                if (ch >= 97 && ch <= 102) {
                                    c <<= 4;
                                    c |= ch + 10 - 97;
                                    continue;
                                }
                                this.reader.RaiseError("Invalid Unicode escaped character");
                            }
                            if ((c & 0xF800) != 55296) {
                                this.sb.append((char)c);
                                continue block15;
                            }
                            if ((c & 0xFC00) == 55296) {
                                int ch = this.reader.ReadChar();
                                if (ch != 92 || this.reader.ReadChar() != 117) {
                                    this.reader.RaiseError("Invalid escaped character");
                                }
                                int c2 = 0;
                                for (int i = 0; i < 4; ++i) {
                                    ch = this.reader.ReadChar();
                                    if (ch >= 48 && ch <= 57) {
                                        c2 <<= 4;
                                        c2 |= ch - 48;
                                        continue;
                                    }
                                    if (ch >= 65 && ch <= 70) {
                                        c2 <<= 4;
                                        c2 |= ch + 10 - 65;
                                        continue;
                                    }
                                    if (ch >= 97 && ch <= 102) {
                                        c2 <<= 4;
                                        c2 |= ch + 10 - 97;
                                        continue;
                                    }
                                    this.reader.RaiseError("Invalid Unicode escaped character");
                                }
                                if ((c2 & 0xFC00) != 56320) {
                                    this.reader.RaiseError("Unpaired surrogate code point");
                                    continue block15;
                                }
                                this.sb.append((char)c);
                                this.sb.append((char)c2);
                                continue block15;
                            }
                            this.reader.RaiseError("Unpaired surrogate code point");
                            continue block15;
                        }
                    }
                    this.reader.RaiseError("Invalid escaped character");
                    continue block15;
                }
                case 34: {
                    return this.sb.toString();
                }
            }
            if (c >> 16 == 0) {
                this.sb.append((char)c);
                continue;
            }
            this.sb.append((char)(c - 65536 >> 10 & 0x3FF | 0xD800));
            this.sb.append((char)(c - 65536 & 0x3FF | 0xDC00));
        }
    }

    private CBORObject NextJSONValue(int firstChar, int[] nextChar, int depth) {
        int c = firstChar;
        CBORObject obj = null;
        if (c < 0) {
            this.reader.RaiseError("Unexpected end of data");
        }
        switch (c) {
            case 34: {
                obj = CBORObject.FromRaw(this.NextJSONString());
                nextChar[0] = CBORJson.SkipWhitespaceJSON(this.reader);
                return obj;
            }
            case 123: {
                obj = this.ParseJSONObject(depth + 1);
                nextChar[0] = CBORJson.SkipWhitespaceJSON(this.reader);
                return obj;
            }
            case 91: {
                obj = this.ParseJSONArray(depth + 1);
                nextChar[0] = CBORJson.SkipWhitespaceJSON(this.reader);
                return obj;
            }
            case 116: {
                if (this.reader.ReadChar() != 114 || this.reader.ReadChar() != 117 || this.reader.ReadChar() != 101) {
                    this.reader.RaiseError("Value can't be parsed.");
                }
                nextChar[0] = CBORJson.SkipWhitespaceJSON(this.reader);
                return CBORObject.True;
            }
            case 102: {
                if (this.reader.ReadChar() != 97 || this.reader.ReadChar() != 108 || this.reader.ReadChar() != 115 || this.reader.ReadChar() != 101) {
                    this.reader.RaiseError("Value can't be parsed.");
                }
                nextChar[0] = CBORJson.SkipWhitespaceJSON(this.reader);
                return CBORObject.False;
            }
            case 110: {
                if (this.reader.ReadChar() != 117 || this.reader.ReadChar() != 108 || this.reader.ReadChar() != 108) {
                    this.reader.RaiseError("Value can't be parsed.");
                }
                nextChar[0] = CBORJson.SkipWhitespaceJSON(this.reader);
                return CBORObject.Null;
            }
            case 45: {
                boolean lengthTwo = true;
                c = this.reader.ReadChar();
                if (c < 48 || c > 57) {
                    this.reader.RaiseError("JSON number can't be parsed.");
                }
                int cval = -(c - 48);
                int cstart = c;
                StringBuilder sb = null;
                c = this.reader.ReadChar();
                while (c == 45 || c == 43 || c == 46 || c >= 48 && c <= 57 || c == 101 || c == 69) {
                    if (lengthTwo) {
                        sb = new StringBuilder();
                        sb.append('-');
                        sb.append((char)cstart);
                        lengthTwo = false;
                    }
                    sb.append((char)c);
                    c = this.reader.ReadChar();
                }
                if (lengthTwo) {
                    obj = cval == 0 ? CBORDataUtilities.ParseJSONNumber("-0", true, false, true) : CBORObject.FromObject(cval);
                } else {
                    String str = sb.toString();
                    obj = CBORDataUtilities.ParseJSONNumber(str);
                    if (obj == null) {
                        this.reader.RaiseError("JSON number can't be parsed. " + str);
                    }
                }
                nextChar[0] = c == -1 || c != 32 && c != 10 && c != 13 && c != 9 ? c : CBORJson.SkipWhitespaceJSON(this.reader);
                return obj;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                boolean lengthOne = true;
                int cval = c - 48;
                int cstart = c;
                StringBuilder sb = null;
                c = this.reader.ReadChar();
                while (c == 45 || c == 43 || c == 46 || c >= 48 && c <= 57 || c == 101 || c == 69) {
                    if (lengthOne) {
                        sb = new StringBuilder();
                        sb.append((char)cstart);
                        lengthOne = false;
                    }
                    sb.append((char)c);
                    c = this.reader.ReadChar();
                }
                if (lengthOne) {
                    obj = CBORObject.FromObject(cval);
                } else {
                    String str = sb.toString();
                    obj = CBORDataUtilities.ParseJSONNumber(str);
                    if (obj == null) {
                        this.reader.RaiseError("JSON number can't be parsed. " + str);
                    }
                }
                nextChar[0] = c == -1 || c != 32 && c != 10 && c != 13 && c != 9 ? c : CBORJson.SkipWhitespaceJSON(this.reader);
                return obj;
            }
        }
        this.reader.RaiseError("Value can't be parsed.");
        return null;
    }

    public CBORJson(CharacterInputWithCount reader, boolean noDuplicates) {
        this.reader = reader;
        this.sb = null;
        this.noDuplicates = noDuplicates;
    }

    public CBORObject ParseJSON(boolean objectOrArrayOnly, int[] nextchar) {
        int c = CBORJson.SkipWhitespaceJSON(this.reader);
        if (c == 91) {
            CBORObject ret = this.ParseJSONArray(0);
            nextchar[0] = CBORJson.SkipWhitespaceJSON(this.reader);
            return ret;
        }
        if (c == 123) {
            CBORObject ret = this.ParseJSONObject(0);
            nextchar[0] = CBORJson.SkipWhitespaceJSON(this.reader);
            return ret;
        }
        if (objectOrArrayOnly) {
            this.reader.RaiseError("A JSON Object must begin with '{' or '['");
        }
        return this.NextJSONValue(c, nextchar, 0);
    }

    static CBORObject ParseJSONValue(CharacterInputWithCount reader, boolean noDuplicates, boolean objectOrArrayOnly, int[] nextchar) {
        CBORJson cj = new CBORJson(reader, noDuplicates);
        return cj.ParseJSON(objectOrArrayOnly, nextchar);
    }

    private CBORObject ParseJSONObject(int depth) {
        if (depth > 1000) {
            this.reader.RaiseError("Too deeply nested");
        }
        CBORObject key = null;
        int[] nextchar = new int[1];
        boolean seenComma = false;
        HashMap<CBORObject, CBORObject> myHashMap = new HashMap<CBORObject, CBORObject>();
        block8: while (true) {
            int c = CBORJson.SkipWhitespaceJSON(this.reader);
            switch (c) {
                case -1: {
                    this.reader.RaiseError("A JSON Object must end with '}'");
                    break;
                }
                case 125: {
                    if (seenComma) {
                        this.reader.RaiseError("Trailing comma");
                        return null;
                    }
                    return CBORObject.FromRaw(myHashMap);
                }
                default: {
                    CBORObject obj;
                    if (c < 0) {
                        this.reader.RaiseError("Unexpected end of data");
                        return null;
                    }
                    if (c != 34) {
                        this.reader.RaiseError("Expected a String as a key");
                        return null;
                    }
                    key = obj = CBORObject.FromRaw(this.NextJSONString());
                    if (!this.noDuplicates || !myHashMap.containsKey(obj)) break;
                    this.reader.RaiseError("Key already exists: " + key);
                    return null;
                }
            }
            if (CBORJson.SkipWhitespaceJSON(this.reader) != 58) {
                this.reader.RaiseError("Expected a ':' after a key");
            }
            myHashMap.put(key, this.NextJSONValue(CBORJson.SkipWhitespaceJSON(this.reader), nextchar, depth));
            switch (nextchar[0]) {
                case 44: {
                    seenComma = true;
                    continue block8;
                }
                case 125: {
                    return CBORObject.FromRaw(myHashMap);
                }
            }
            this.reader.RaiseError("Expected a ',' or '}'");
        }
    }

    CBORObject ParseJSONArray(int depth) {
        if (depth > 1000) {
            this.reader.RaiseError("Too deeply nested");
        }
        ArrayList<CBORObject> myArrayList = new ArrayList<CBORObject>();
        boolean seenComma = false;
        int[] nextchar = new int[1];
        block4: while (true) {
            int c;
            if ((c = CBORJson.SkipWhitespaceJSON(this.reader)) == 93) {
                if (seenComma) {
                    this.reader.RaiseError("Trailing comma");
                }
                return CBORObject.FromRaw(myArrayList);
            }
            if (c == 44) {
                this.reader.RaiseError("Empty array element");
            }
            myArrayList.add(this.NextJSONValue(c, nextchar, depth));
            c = nextchar[0];
            switch (c) {
                case 44: {
                    seenComma = true;
                    continue block4;
                }
                case 93: {
                    return CBORObject.FromRaw(myArrayList);
                }
            }
            this.reader.RaiseError("Expected a ',' or ']'");
        }
    }

    static void WriteJSONStringUnquoted(String str, StringOutput sb, JSONOptions options) throws IOException {
        boolean first = true;
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i);
            if (c == 92 || c == 34) {
                if (first) {
                    first = false;
                    sb.WriteString(str, 0, i);
                }
                sb.WriteCodePoint(92);
                sb.WriteCodePoint(c);
                continue;
            }
            if (c < 32 || c >= 127 && (c == 8232 || c == 8233 || c >= 127 && c <= 160 || c == 65279 || c == 65534 || c == 65535)) {
                if (first) {
                    first = false;
                    sb.WriteString(str, 0, i);
                }
                if (c == 13) {
                    sb.WriteString("\\r");
                    continue;
                }
                if (c == 10) {
                    sb.WriteString("\\n");
                    continue;
                }
                if (c == 8) {
                    sb.WriteString("\\b");
                    continue;
                }
                if (c == 12) {
                    sb.WriteString("\\f");
                    continue;
                }
                if (c == 9) {
                    sb.WriteString("\\t");
                    continue;
                }
                if (c == 133) {
                    sb.WriteString("\\u0085");
                    continue;
                }
                if (c >= 256) {
                    sb.WriteString("\\u");
                    sb.WriteCodePoint(Hex16.charAt(c >> 12 & 0xF));
                    sb.WriteCodePoint(Hex16.charAt(c >> 8 & 0xF));
                    sb.WriteCodePoint(Hex16.charAt(c >> 4 & 0xF));
                    sb.WriteCodePoint(Hex16.charAt(c & 0xF));
                    continue;
                }
                sb.WriteString("\\u00");
                sb.WriteCodePoint(Hex16.charAt(c >> 4));
                sb.WriteCodePoint(Hex16.charAt(c & 0xF));
                continue;
            }
            if ((c & 0xFC00) == 55296 && (i >= str.length() - 1 || (str.charAt(i + 1) & 0xFC00) != 56320)) {
                if (options.getReplaceSurrogates()) {
                    if (first) {
                        first = false;
                        sb.WriteString(str, 0, i);
                    }
                    c = 65533;
                } else {
                    throw new CBORException("Unpaired surrogate in String");
                }
            }
            if (first) continue;
            if ((c & 0xFC00) == 55296) {
                sb.WriteString(str, i, 2);
                ++i;
                continue;
            }
            sb.WriteCodePoint(c);
        }
        if (first) {
            sb.WriteString(str);
        }
    }

    static void WriteJSONToInternal(CBORObject obj, StringOutput writer, JSONOptions options) throws IOException {
        if (obj.isNumber()) {
            writer.WriteString(CBORNumber.FromCBORObject(obj).ToJSONString());
            return;
        }
        switch (obj.getType()) {
            case Integer: 
            case FloatingPoint: {
                CBORObject untaggedObj = obj.Untag();
                writer.WriteString(CBORNumber.FromCBORObject(untaggedObj).ToJSONString());
                break;
            }
            case Boolean: {
                if (obj.isTrue()) {
                    writer.WriteString("true");
                    return;
                }
                if (obj.isFalse()) {
                    writer.WriteString("false");
                    return;
                }
                return;
            }
            case SimpleValue: {
                writer.WriteString("null");
                return;
            }
            case ByteString: {
                byte[] byteArray = obj.GetByteString();
                if (byteArray.length == 0) {
                    writer.WriteString("\"\"");
                    return;
                }
                writer.WriteCodePoint(34);
                if (obj.HasTag(22)) {
                    Base64.WriteBase64(writer, byteArray, 0, byteArray.length, true);
                } else if (obj.HasTag(23)) {
                    for (int i = 0; i < byteArray.length; ++i) {
                        writer.WriteCodePoint(Hex16.charAt(byteArray[i] >> 4 & 0xF));
                        writer.WriteCodePoint(Hex16.charAt(byteArray[i] & 0xF));
                    }
                } else {
                    Base64.WriteBase64URL(writer, byteArray, 0, byteArray.length, false);
                }
                writer.WriteCodePoint(34);
                break;
            }
            case TextString: {
                String thisString = obj.AsString();
                if (thisString.length() == 0) {
                    writer.WriteString("\"\"");
                    return;
                }
                writer.WriteCodePoint(34);
                CBORJson.WriteJSONStringUnquoted(thisString, writer, options);
                writer.WriteCodePoint(34);
                break;
            }
            case Array: {
                boolean first = true;
                writer.WriteCodePoint(91);
                for (CBORObject i : obj.AsList()) {
                    if (!first) {
                        writer.WriteCodePoint(44);
                    }
                    CBORJson.WriteJSONToInternal(i, writer, options);
                    first = false;
                }
                writer.WriteCodePoint(93);
                break;
            }
            case Map: {
                CBORObject value;
                Object key;
                boolean first = true;
                boolean hasNonStringKeys = false;
                Map<CBORObject, CBORObject> objMap = obj.AsMap();
                for (Map.Entry<CBORObject, CBORObject> entry : objMap.entrySet()) {
                    CBORObject cBORObject = entry.getKey();
                    if (cBORObject.getType() == CBORType.TextString && !cBORObject.isTagged()) continue;
                    hasNonStringKeys = true;
                    break;
                }
                if (!hasNonStringKeys) {
                    writer.WriteCodePoint(123);
                    for (Map.Entry<CBORObject, CBORObject> entry : objMap.entrySet()) {
                        CBORObject cBORObject = entry.getKey();
                        CBORObject value2 = entry.getValue();
                        if (!first) {
                            writer.WriteCodePoint(44);
                        }
                        writer.WriteCodePoint(34);
                        CBORJson.WriteJSONStringUnquoted(cBORObject.AsString(), writer, options);
                        writer.WriteCodePoint(34);
                        writer.WriteCodePoint(58);
                        CBORJson.WriteJSONToInternal(value2, writer, options);
                        first = false;
                    }
                    writer.WriteCodePoint(125);
                    break;
                }
                HashMap<String, CBORObject> stringMap = new HashMap<String, CBORObject>();
                for (Map.Entry<CBORObject, CBORObject> entry : objMap.entrySet()) {
                    String str;
                    key = entry.getKey();
                    value = entry.getValue();
                    String string = str = ((CBORObject)key).getType() == CBORType.TextString ? ((CBORObject)key).AsString() : ((CBORObject)key).ToJSONString();
                    if (stringMap.containsKey(str)) {
                        throw new CBORException("Duplicate JSON String equivalents of map keys");
                    }
                    stringMap.put(str, value);
                }
                first = true;
                writer.WriteCodePoint(123);
                for (Map.Entry<CBORObject, CBORObject> entry : stringMap.entrySet()) {
                    key = (String)((Object)entry.getKey());
                    value = entry.getValue();
                    if (!first) {
                        writer.WriteCodePoint(44);
                    }
                    writer.WriteCodePoint(34);
                    CBORJson.WriteJSONStringUnquoted((String)key, writer, options);
                    writer.WriteCodePoint(34);
                    writer.WriteCodePoint(58);
                    CBORJson.WriteJSONToInternal(value, writer, options);
                    first = false;
                }
                writer.WriteCodePoint(125);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected item type");
            }
        }
    }
}

