/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupMessageObserver
extends MessageObserverAdapter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CleanupMessageObserver.class);
    protected final Exchange exchange;

    protected CleanupMessageObserver(Exchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void onCancel() {
        this.complete("canceled");
    }

    @Override
    public void failed() {
        this.complete("failed");
    }

    protected void complete(String action) {
        if (this.exchange.executeComplete()) {
            if (this.exchange.isOfLocalOrigin()) {
                Request request = this.exchange.getCurrentRequest();
                LOGGER.debug("{}, {} request [MID={}, {}]", action, this.exchange, request.getMID(), request.getToken());
            } else {
                Response response = this.exchange.getCurrentResponse();
                LOGGER.debug("{}, {} response [MID={}, {}]", action, this.exchange, response.getMID(), response.getToken());
            }
        }
    }
}

