/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class MtuUtil {
    public static final int MAX_MTU = 65535;
    private static int anyMtu;

    public static synchronized int getAnyMtu() throws SocketException {
        if (anyMtu == 0) {
            int mtu = 65535;
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                int ifaceMtu = iface.getMTU();
                if (ifaceMtu <= 0 || ifaceMtu >= mtu) continue;
                mtu = ifaceMtu;
            }
            anyMtu = mtu;
        }
        return anyMtu;
    }
}

