/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests;

import java.io.File;
import java.net.SocketException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.config.NetworkConfigDefaultHandler;
import org.eclipse.californium.core.network.interceptors.AnonymizedOriginTracer;
import org.eclipse.californium.core.network.interceptors.MessageTracer;
import org.eclipse.californium.plugtests.AbstractTestServer;
import org.eclipse.californium.plugtests.resources.Create;
import org.eclipse.californium.plugtests.resources.DefaultTest;
import org.eclipse.californium.plugtests.resources.Large;
import org.eclipse.californium.plugtests.resources.LargeCreate;
import org.eclipse.californium.plugtests.resources.LargePost;
import org.eclipse.californium.plugtests.resources.LargeSeparate;
import org.eclipse.californium.plugtests.resources.LargeUpdate;
import org.eclipse.californium.plugtests.resources.Link1;
import org.eclipse.californium.plugtests.resources.Link2;
import org.eclipse.californium.plugtests.resources.Link3;
import org.eclipse.californium.plugtests.resources.LocationQuery;
import org.eclipse.californium.plugtests.resources.LongPath;
import org.eclipse.californium.plugtests.resources.MultiFormat;
import org.eclipse.californium.plugtests.resources.Observe;
import org.eclipse.californium.plugtests.resources.ObserveLarge;
import org.eclipse.californium.plugtests.resources.ObserveNon;
import org.eclipse.californium.plugtests.resources.ObservePumping;
import org.eclipse.californium.plugtests.resources.ObserveReset;
import org.eclipse.californium.plugtests.resources.Path;
import org.eclipse.californium.plugtests.resources.Query;
import org.eclipse.californium.plugtests.resources.Separate;
import org.eclipse.californium.plugtests.resources.Shutdown;
import org.eclipse.californium.plugtests.resources.Validate;

public class PlugtestServer
extends AbstractTestServer {
    private static final File CONFIG_FILE = new File("CaliforniumPlugtest.properties");
    private static final String CONFIG_HEADER = "Californium CoAP Properties file for Plugtest Server";
    private static final int DEFAULT_MAX_RESOURCE_SIZE = 8192;
    private static final int DEFAULT_BLOCK_SIZE = 64;
    public static final int ERR_INIT_FAILED = 1;
    private static NetworkConfigDefaultHandler DEFAULTS = new NetworkConfigDefaultHandler(){

        @Override
        public void applyDefaults(NetworkConfig config) {
            config.setInt("DTLS_AUTO_RESUME_TIMEOUT", 0);
            config.setInt("DTLS_CONNECTION_ID_LENGTH", 6);
            config.setInt("MAX_RESOURCE_BODY_SIZE", 8192);
            config.setInt("MAX_MESSAGE_SIZE", 64);
            config.setInt("PREFERRED_BLOCK_SIZE", 64);
            config.setInt("NOTIFICATION_CHECK_INTERVAL_COUNT", 4);
            config.setInt("NOTIFICATION_CHECK_INTERVAL", 30000);
            config.setInt("HEALTH_STATUS_INTERVAL", 300);
            config.setInt("UDP_CONNECTOR_RECEIVE_BUFFER", 0);
            config.setInt("UDP_CONNECTOR_SEND_BUFFER", 0);
        }
    };

    public static void main(String[] args) {
        System.out.println("\nCalifornium (Cf) Plugtest Server");
        System.out.println("(c) 2014, Institute for Pervasive Computing, ETH Zurich");
        System.out.println();
        System.out.println("Usage: " + PlugtestServer.class.getSimpleName() + " [-noLoopback]");
        System.out.println("  -noLoopback : no endpoints for loopback/localhost interfaces");
        PlugtestServer.start(args);
    }

    public static void start(String[] args) {
        NetworkConfig config = NetworkConfig.createWithFile(CONFIG_FILE, CONFIG_HEADER, DEFAULTS);
        try {
            boolean noLoopback = args.length > 0 ? args[0].equalsIgnoreCase("-noLoopback") : false;
            List<AbstractTestServer.InterfaceType> types = noLoopback ? Arrays.asList(AbstractTestServer.InterfaceType.EXTERNAL, AbstractTestServer.InterfaceType.IPV4, AbstractTestServer.InterfaceType.IPV6) : null;
            PlugtestServer server = new PlugtestServer(config);
            server.addEndpoints(null, types, Arrays.asList(AbstractTestServer.Protocol.UDP, AbstractTestServer.Protocol.DTLS, AbstractTestServer.Protocol.TCP, AbstractTestServer.Protocol.TLS));
            server.start();
            for (Endpoint ep : server.getEndpoints()) {
                URI uri = ep.getUri();
                ep.addInterceptor(new MessageTracer());
                ep.addInterceptor(new AnonymizedOriginTracer(uri.getPort() + "-" + uri.getScheme()));
            }
            System.out.println(PlugtestServer.class.getSimpleName() + " started ...");
        }
        catch (Exception e) {
            System.err.printf("Failed to create " + PlugtestServer.class.getSimpleName() + ": %s\n", e.getMessage());
            e.printStackTrace(System.err);
            System.err.println("Exiting");
            System.exit(1);
        }
    }

    public PlugtestServer(NetworkConfig config) throws SocketException {
        super(config, null);
        this.add(new DefaultTest());
        this.add(new LongPath());
        this.add(new Query());
        this.add(new Separate());
        this.add(new Large());
        this.add(new LargeUpdate());
        this.add(new LargeCreate());
        this.add(new LargePost());
        this.add(new LargeSeparate());
        this.add(new Observe());
        this.add(new ObserveNon());
        this.add(new ObserveReset());
        this.add(new ObserveLarge());
        this.add(new ObservePumping());
        this.add(new ObservePumping(CoAP.Type.NON));
        this.add(new LocationQuery());
        this.add(new MultiFormat());
        this.add(new Link1());
        this.add(new Link2());
        this.add(new Link3());
        this.add(new Path());
        this.add(new Validate());
        this.add(new Create());
        this.add(new Shutdown());
    }
}

