/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

public final class SignatureAndHashAlgorithm {
    private final HashAlgorithm hash;
    private final SignatureAlgorithm signature;

    public SignatureAndHashAlgorithm(HashAlgorithm hashAlgorithm, SignatureAlgorithm signatureAlgorithm) {
        this.signature = signatureAlgorithm;
        this.hash = hashAlgorithm;
    }

    public SignatureAndHashAlgorithm(int hashAlgorithmCode, int signatureAlgorithmCode) {
        this.signature = SignatureAlgorithm.getAlgorithmByCode(signatureAlgorithmCode);
        this.hash = HashAlgorithm.getAlgorithmByCode(hashAlgorithmCode);
    }

    public SignatureAlgorithm getSignature() {
        return this.signature;
    }

    public HashAlgorithm getHash() {
        return this.hash;
    }

    public String jcaName() {
        return this.hash.toString() + "with" + this.signature.toString();
    }

    public static enum SignatureAlgorithm {
        ANONYMOUS(0),
        RSA(1),
        DSA(2),
        ECDSA(3);

        private int code;

        private SignatureAlgorithm(int code) {
            this.code = code;
        }

        public static SignatureAlgorithm getAlgorithmByCode(int code) {
            switch (code) {
                case 0: {
                    return ANONYMOUS;
                }
                case 1: {
                    return RSA;
                }
                case 2: {
                    return DSA;
                }
                case 3: {
                    return ECDSA;
                }
            }
            return null;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum HashAlgorithm {
        NONE(0),
        MD5(1),
        SHA1(2),
        SHA224(3),
        SHA256(4),
        SHA384(5),
        SHA512(6);

        private int code;

        private HashAlgorithm(int code) {
            this.code = code;
        }

        public static HashAlgorithm getAlgorithmByCode(int code) {
            for (HashAlgorithm algorithm : HashAlgorithm.values()) {
                if (algorithm.code != code) continue;
                return algorithm;
            }
            return null;
        }

        public int getCode() {
            return this.code;
        }
    }
}

